/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.internal.cmdline;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xapi.XCompilationFactory;
import com.ibm.xml.xapi.XCompilationParameters;
import com.ibm.xml.xapi.XProcessException;
import com.ibm.xml.xapi.XStaticContext;
import com.ibm.xml.xci.internal.cmdline.CLIParseException;
import com.ibm.xml.xci.internal.cmdline.Contract;
import com.ibm.xml.xci.res.XCIMessages;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.stream.StreamSource;

public class CLICompilerFacade {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String cn = CLICompilerFacade.class.getName();
    private static Logger logger = LoggerUtil.getLogger(CLICompilerFacade.class);
    public static final String WARNING_MSG = XCIMessages.createXCIMessage("WARN_CMD_LINE_TOOL_WARNING", new String[0]);

    public static void Compile(int n2, Contract contract) throws CLIParseException {
        block25: {
            XCompilationFactory xCompilationFactory = contract.cFactory;
            XStaticContext xStaticContext = contract.xStaticContext;
            XCompilationParameters xCompilationParameters = contract.params;
            try {
                if (contract.isUseStdIn()) {
                    switch (n2) {
                        case 0: {
                            xCompilationFactory.compileXSLT(new StreamSource(System.in), xStaticContext, xCompilationParameters);
                            break block25;
                        }
                        case 1: {
                            xCompilationFactory.compileXPath(new StreamSource(System.in), xStaticContext, xCompilationParameters);
                            break block25;
                        }
                        case 2: {
                            xCompilationFactory.compileXQuery(new StreamSource(System.in), xStaticContext, xCompilationParameters);
                            break block25;
                        }
                        default: {
                            throw new CLIParseException(XCIMessages.createXCIMessage("ER_CMD_LINE_UNKNOWN_COMPILE_TYPE", new String[]{String.valueOf(n2)}));
                        }
                    }
                }
                Boolean bl = false;
                ArrayList<String> arrayList = contract.getExpressionFiles();
                if (arrayList.size() > 1) {
                    bl = true;
                    if (LoggerUtil.isFineLoggable(logger)) {
                        logger.logp(Level.FINE, cn, "Compile", "multiple input documents detected");
                    }
                }
                block15: for (String string2 : arrayList) {
                    Object object2;
                    if (bl.booleanValue()) {
                        contract.params.setClassName(string2);
                        if (LoggerUtil.isFineLoggable(logger)) {
                            logger.logp(Level.FINE, cn, "Compile", "Processing file: " + string2);
                        }
                    }
                    if (LoggerUtil.isFineLoggable(logger)) {
                        logger.logp(Level.FINE, cn, "Compile", "calling compile with new StreamSource(" + string2 + ")");
                    }
                    StreamSource streamSource = null;
                    try {
                        object2 = new FileInputStream(new File(string2));
                        streamSource = new StreamSource((InputStream)object2);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        throw new XProcessException(fileNotFoundException.getMessage(), fileNotFoundException);
                    }
                    object2 = xStaticContext.getBaseURI();
                    if (object2 == null || ((String)object2).length() == 0) {
                        streamSource.setSystemId(string2);
                    }
                    switch (n2) {
                        case 0: {
                            xCompilationFactory.compileXSLT(streamSource, xStaticContext, xCompilationParameters);
                            continue block15;
                        }
                        case 1: {
                            xCompilationFactory.compileXPath(streamSource, xStaticContext, xCompilationParameters);
                            continue block15;
                        }
                        case 2: {
                            xCompilationFactory.compileXQuery(streamSource, xStaticContext, xCompilationParameters);
                            continue block15;
                        }
                    }
                    throw new CLIParseException(XCIMessages.createXCIMessage("ER_CMD_LINE_UNKNOWN_COMPILE_TYPE", new String[]{String.valueOf(n2)}));
                }
            }
            catch (NullPointerException nullPointerException) {
                System.err.println(nullPointerException.getLocalizedMessage());
                if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, cn, "Compile", "", nullPointerException);
                }
                return;
            }
            catch (XProcessException xProcessException) {
                System.err.println(xProcessException.getLocalizedMessage());
                if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, cn, "Compile", "", xProcessException);
                }
                return;
            }
        }
    }
}

