/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.internal.equality;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.CData;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.type.TypeHelper;
import com.ibm.xml.xci.dp.util.XCIErrorHelper;
import com.ibm.xml.xci.dp.util.misc.Stack;
import com.ibm.xml.xci.errors.XCIDynamicErrorException;
import com.ibm.xml.xci.internal.equality.AcceptAllDiffHandler;
import com.ibm.xml.xci.internal.equality.DiffDispatcher;
import com.ibm.xml.xci.internal.equality.DifferenceHandler;
import com.ibm.xml.xci.internal.equality.RootElementHandler;
import com.ibm.xml.xci.internal.equality.WhitespaceHandler;
import com.ibm.xml.xci.internal.equality.XSIAttributeHandler;
import com.ibm.xml.xci.type.TypeRegistry;
import com.ibm.xml.xml4j.api.s1.xs.XSSimpleTypeDefinition;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EqualityHelper {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2008. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = LoggerUtil.getLogger(EqualityHelper.class);

    public static boolean isEquals(Cursor cursor2, Cursor cursor3, Map<String, Object> map2) {
        Object object2;
        DifferenceHandler differenceHandler = EqualityHelper.getDifferenceHandler(map2);
        boolean bl = EqualityHelper.getBoolean("equal-ignore-whitespace", map2);
        boolean bl2 = EqualityHelper.getBoolean("equal-ignore-comments", map2);
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, logger.getName(), "isEquals", "Parameters: " + String.valueOf(map2) + "\nStack trace= " + XCIErrorHelper.getStackTrace(30));
        }
        if (cursor2 == null || cursor3 == null) {
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST) && cursor2 != cursor3) {
                logger.logp(Level.FINEST, logger.getName(), "isEquals", "Equality failed when comparing 2 cursors\n  Reason: One of the cursors is null\n  Diagnosis: " + (cursor2 == null ? "cursor1 is null" : "cursor2 is null"));
            }
            return cursor2 == cursor3;
        }
        Stack<Cursor> stack = new Stack<Cursor>(500);
        Stack<Cursor> stack2 = new Stack<Cursor>(500);
        stack.push(cursor2.fork(false, Cursor.Profile.MINIMAL_SKIP_STREAMING_NAVIGATION, Cursor.Profile.MINIMAL_SKIP_STREAMING_NAVIGATION));
        stack2.push(cursor3.fork(false, Cursor.Profile.MINIMAL_SKIP_STREAMING_NAVIGATION, Cursor.Profile.MINIMAL_SKIP_STREAMING_NAVIGATION));
        boolean bl3 = true;
        boolean bl4 = true;
        block9: do {
            Object object3;
            cursor2 = (Cursor)stack.peek();
            cursor3 = (Cursor)stack2.peek();
            if (bl2) {
                while (cursor2.itemKind() == 8 || cursor3.itemKind() == 8) {
                    if (cursor2.itemKind() == 8) {
                        cursor2.toNext();
                    }
                    if (cursor3.itemKind() != 8) continue;
                    cursor3.toNext();
                }
            }
            if (cursor2.itemKind() != cursor3.itemKind() && differenceHandler.differenceFound(2, cursor2, cursor3)) {
                if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("Equality failed when comparing 2 nodes\n  Reason: Item kind mismatch\n  Diagnosis: In sequence 1 we have ");
                    ((StringBuilder)object2).append(EqualityHelper.itemKindString(cursor2));
                    ((StringBuilder)object2).append(", while in sequence 2 we have ");
                    ((StringBuilder)object2).append(EqualityHelper.itemKindString(cursor3));
                    logger.logp(Level.FINEST, logger.getName(), "isEquals", ((StringBuilder)object2).toString());
                }
                return EqualityHelper.fail(stack, stack2);
            }
            switch (cursor2.itemKind()) {
                case 1: {
                    VolatileCData volatileCData;
                    if (!EqualityHelper.qnameEquals(cursor2.itemName(), cursor3.itemName()) && differenceHandler.differenceFound(bl4 ? 0 : 1, cursor2, cursor3)) {
                        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                            object2 = new StringBuilder();
                            ((StringBuilder)object2).append("Equality failed when comparing 2 element nodes\n  Reason: Name mismatch\n  Diagnosis: In sequence 1, the element's name is '");
                            ((StringBuilder)object2).append(EqualityHelper.getQualifiedName(cursor2.itemName(), 1));
                            ((StringBuilder)object2).append("', while in sequence 2 the element's name is '");
                            ((StringBuilder)object2).append(EqualityHelper.getQualifiedName(cursor3.itemName(), 1));
                            ((StringBuilder)object2).append("'");
                            logger.logp(Level.FINEST, logger.getName(), "isEquals", ((StringBuilder)object2).toString());
                        }
                        return EqualityHelper.fail(stack, stack2);
                    }
                    if (cursor2.itemXSType() != cursor3.itemXSType()) {
                        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                            object2 = new StringBuilder();
                            ((StringBuilder)object2).append("Equality failed when comparing 2 element nodes\n  Reason: Type mismatch\n  Diagnosis: In sequence 1, element '");
                            ((StringBuilder)object2).append(EqualityHelper.getQualifiedName(cursor2.itemName(), 1));
                            ((StringBuilder)object2).append("' has a type name '");
                            ((StringBuilder)object2).append(TypeHelper.prettyPrint(cursor2.itemXSType()));
                            ((StringBuilder)object2).append("', while the same element in sequence 2 has a type name '");
                            ((StringBuilder)object2).append(TypeHelper.prettyPrint(cursor3.itemXSType()));
                            ((StringBuilder)object2).append("'");
                            logger.logp(Level.FINEST, logger.getName(), "isEquals", ((StringBuilder)object2).toString());
                        }
                        return EqualityHelper.fail(stack, stack2);
                    }
                    if (!EqualityHelper.isAttrEquals(stack, stack2, cursor2, cursor3, differenceHandler, bl4)) {
                        return EqualityHelper.fail(stack, stack2);
                    }
                    bl4 = false;
                    if (cursor2.itemXSType() == null || cursor2.itemXSType().getTypeCategory() == 15) {
                        object2 = cursor2.fork(true);
                        if (object2.toChildren(null)) {
                            object3 = cursor3.fork(true);
                            if (!object3.toChildren(null)) {
                                object3.release();
                                if (bl && object2.itemKind() == 3 && object2.itemStringValueAsChars().isSpace() && !object2.toNext()) {
                                    object2.release();
                                    bl3 = true;
                                    break;
                                }
                                if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                                    StringBuilder stringBuilder = new StringBuilder();
                                    stringBuilder.append("Equality failed when comparing 2 element nodes\n  Reason: Missing content\n  Diagnosis: In sequence 1, element '");
                                    stringBuilder.append(EqualityHelper.getQualifiedName(cursor2.itemName(), 1));
                                    stringBuilder.append("' has children content but the same element in sequence 2 is empty");
                                    logger.logp(Level.FINEST, logger.getName(), "isEquals", stringBuilder.toString());
                                }
                                object2.release();
                                return EqualityHelper.fail(stack, stack2);
                            }
                            stack.push((Cursor)object2);
                            stack2.push((Cursor)object3);
                            bl3 = false;
                            break;
                        }
                        object3 = cursor3.fork(true);
                        object2.release();
                        if (object3.toChildren(null) && (!bl || object3.itemKind() != 3 || !object3.itemStringValueAsChars().isSpace() || object3.toNext())) {
                            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                                StringBuilder stringBuilder = new StringBuilder();
                                stringBuilder.append("Equality failed when comparing 2 element nodes\n  Reason: Missing content\n  Diagnosis: In sequence 2, element '");
                                stringBuilder.append(EqualityHelper.getQualifiedName(cursor2.itemName(), 1));
                                stringBuilder.append("' has children content but the same element in sequence 1 is empty");
                                logger.logp(Level.FINEST, logger.getName(), "isEquals", stringBuilder.toString());
                            }
                            object3.release();
                            return EqualityHelper.fail(stack, stack2);
                        }
                        object3.release();
                        bl3 = true;
                        break;
                    }
                    VolatileCData volatileCData2 = cursor2.itemTypedValue();
                    if (!EqualityHelper.typedValueEquals(volatileCData2, volatileCData = cursor3.itemTypedValue()) && differenceHandler.differenceFound(4, cursor2, cursor3)) {
                        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                            object2 = new StringBuilder();
                            ((StringBuilder)object2).append("Equality failed when comparing 2 element nodes\n  Reason: Value mismatch\n  Diagnosis: In sequence 1, element '");
                            ((StringBuilder)object2).append(EqualityHelper.getQualifiedName(cursor2.itemName(), 1));
                            ((StringBuilder)object2).append("' has a value '");
                            ((StringBuilder)object2).append(EqualityHelper.stringValue(volatileCData2));
                            ((StringBuilder)object2).append("', while the same element in sequence 2 has a value '");
                            ((StringBuilder)object2).append(EqualityHelper.stringValue(volatileCData));
                            ((StringBuilder)object2).append("'");
                            logger.logp(Level.FINEST, logger.getName(), "isEquals", ((StringBuilder)object2).toString());
                        }
                        return EqualityHelper.fail(stack, stack2);
                    }
                    bl3 = true;
                    break;
                }
                case 9: {
                    object2 = cursor2.fork(true);
                    if (object2.toChildren(null)) {
                        object3 = cursor3.fork(true);
                        if (!object3.toChildren(null)) {
                            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                                logger.logp(Level.FINEST, logger.getName(), "isEquals", "Equality failed when comparing 2 document nodes\n  Reason: One document is empty\n  Diagnosis: Document 1 has children but document 2 is empty");
                            }
                            object2.release();
                            object3.release();
                            return EqualityHelper.fail(stack, stack2);
                        }
                        stack.push((Cursor)object2);
                        stack2.push((Cursor)object3);
                        bl3 = false;
                        break;
                    }
                    object3 = cursor3.fork(true);
                    if (object3.toChildren(null)) {
                        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                            logger.logp(Level.FINEST, logger.getName(), "isEquals", "Equality failed when comparing 2 document nodes\n  Reason: One document is empty\n  Diagnosis: Document 2 has children but document 1 is empty");
                        }
                        object2.release();
                        object3.release();
                        return EqualityHelper.fail(stack, stack2);
                    }
                    object2.release();
                    object3.release();
                    bl3 = true;
                    break;
                }
                case 2: {
                    VolatileCData volatileCData;
                    if (!EqualityHelper.qnameEquals(cursor2.itemName(), cursor3.itemName())) {
                        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                            object2 = new StringBuilder();
                            ((StringBuilder)object2).append("Equality failed when comparing 2 attribute nodes\n  Reason: Name mismatch\n  Diagnosis: In sequence 1, the attribute's name is '");
                            ((StringBuilder)object2).append(EqualityHelper.getQualifiedName(cursor2.itemName(), 1));
                            ((StringBuilder)object2).append("', while in sequence 2 the attribute's name is '");
                            ((StringBuilder)object2).append(EqualityHelper.getQualifiedName(cursor3.itemName(), 1));
                            ((StringBuilder)object2).append("'");
                            logger.logp(Level.FINEST, logger.getName(), "isEquals", ((StringBuilder)object2).toString());
                        }
                        return EqualityHelper.fail(stack, stack2);
                    }
                    VolatileCData volatileCData2 = cursor2.itemTypedValue();
                    if (EqualityHelper.typedValueEquals(volatileCData2, volatileCData = cursor3.itemTypedValue())) break;
                    if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                        object2 = new StringBuilder();
                        ((StringBuilder)object2).append("Equality failed when comparing 2 attribute nodes\n");
                        if (!TypeHelper.isEqual(volatileCData2.getXSTypeDefinition(), volatileCData.getXSTypeDefinition())) {
                            ((StringBuilder)object2).append("  Reason: Type mismatch\n  Diagnosis: In sequence 1, attribute '");
                            ((StringBuilder)object2).append(EqualityHelper.getQualifiedName(cursor2.itemName(), 1));
                            ((StringBuilder)object2).append("' has a type name '");
                            ((StringBuilder)object2).append(TypeHelper.prettyPrint(volatileCData2.getXSTypeDefinition()));
                            ((StringBuilder)object2).append("', while the same attribute in sequence 2 has a type name '");
                            ((StringBuilder)object2).append(TypeHelper.prettyPrint(volatileCData.getXSTypeDefinition()));
                            ((StringBuilder)object2).append("'");
                        } else {
                            ((StringBuilder)object2).append("  Reason: Value mismatch\n  Diagnosis: In sequence 1, attribute '");
                            ((StringBuilder)object2).append(EqualityHelper.getQualifiedName(cursor2.itemName(), 1));
                            ((StringBuilder)object2).append("' has a value '");
                            ((StringBuilder)object2).append(EqualityHelper.stringValue(volatileCData2));
                            ((StringBuilder)object2).append("', while the same attribute in sequence 2 has a value '");
                            ((StringBuilder)object2).append(EqualityHelper.stringValue(volatileCData));
                            ((StringBuilder)object2).append("'");
                        }
                        logger.logp(Level.FINEST, logger.getName(), "isEquals", ((StringBuilder)object2).toString());
                    }
                    return EqualityHelper.fail(stack, stack2);
                }
                case 3: {
                    VolatileCData volatileCData2 = cursor2.itemTypedValue();
                    VolatileCData volatileCData = cursor3.itemTypedValue();
                    if (!EqualityHelper.typedValueEquals(volatileCData2, volatileCData) && differenceHandler.differenceFound(4, cursor2, cursor3)) {
                        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                            object2 = new StringBuilder();
                            ((StringBuilder)object2).append("Equality failed when comparing 2 text nodes\n");
                            if (!TypeHelper.isEqual(volatileCData2.getXSTypeDefinition(), volatileCData.getXSTypeDefinition())) {
                                ((StringBuilder)object2).append("  Reason: Type mismatch\n  Diagnosis: In sequence 1, text with value '");
                                ((StringBuilder)object2).append(EqualityHelper.stringValue(volatileCData2));
                                ((StringBuilder)object2).append("' has a type name '");
                                ((StringBuilder)object2).append(TypeHelper.prettyPrint(volatileCData2.getXSTypeDefinition()));
                                ((StringBuilder)object2).append("', while in sequence 2, text with value '");
                                ((StringBuilder)object2).append(EqualityHelper.stringValue(volatileCData));
                                ((StringBuilder)object2).append("' has a type name '");
                                ((StringBuilder)object2).append(TypeHelper.prettyPrint(volatileCData.getXSTypeDefinition()));
                                ((StringBuilder)object2).append("'");
                            } else {
                                ((StringBuilder)object2).append("  Reason: Value mismatch\n  Diagnosis: In sequence 1, the value of text node is '");
                                ((StringBuilder)object2).append(EqualityHelper.stringValue(volatileCData2));
                                ((StringBuilder)object2).append("', while in sequence 2, the value of text node is '");
                                ((StringBuilder)object2).append(EqualityHelper.stringValue(volatileCData));
                                ((StringBuilder)object2).append("'");
                            }
                            logger.logp(Level.FINEST, logger.getName(), "isEquals", ((StringBuilder)object2).toString());
                        }
                        return EqualityHelper.fail(stack, stack2);
                    }
                    bl3 = true;
                    break;
                }
                case 4: {
                    VolatileCData volatileCData;
                    if (!cursor2.itemName().equals(cursor3.itemName())) {
                        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                            object2 = new StringBuilder();
                            ((StringBuilder)object2).append("Equality failed when comparing 2 namespace declaration nodes\n  Reason: Name mismatch\n  Diagnosis: In sequence 1, the namespace declaration's is '");
                            ((StringBuilder)object2).append(cursor2.itemName().getString(1));
                            ((StringBuilder)object2).append("', while in sequence 2 the namespace declaration's is '");
                            ((StringBuilder)object2).append(cursor3.itemName().getString(1));
                            ((StringBuilder)object2).append("'");
                            logger.logp(Level.FINEST, logger.getName(), "isEquals", ((StringBuilder)object2).toString());
                        }
                        return EqualityHelper.fail(stack, stack2);
                    }
                    VolatileCData volatileCData2 = cursor2.itemTypedValue();
                    if (!EqualityHelper.typedValueEquals(volatileCData2, volatileCData = cursor3.itemTypedValue())) {
                        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                            object2 = new StringBuilder();
                            ((StringBuilder)object2).append("Equality failed when comparing 2 namespace declaration nodes\n");
                            if (!TypeHelper.isEqual(volatileCData2.getXSTypeDefinition(), volatileCData.getXSTypeDefinition())) {
                                ((StringBuilder)object2).append("  Reason: Type mismatch\n  Diagnosis: In sequence 1, namespace declaration '");
                                ((StringBuilder)object2).append(cursor2.itemName().getString(1));
                                ((StringBuilder)object2).append("' has a type name '");
                                ((StringBuilder)object2).append(TypeHelper.prettyPrint(volatileCData2.getXSTypeDefinition()));
                                ((StringBuilder)object2).append("', while the same namespace declaration has a type name '");
                                ((StringBuilder)object2).append(TypeHelper.prettyPrint(volatileCData.getXSTypeDefinition()));
                                ((StringBuilder)object2).append("'");
                            } else {
                                ((StringBuilder)object2).append("  Reason: Value mismatch\n  Diagnosis: In sequence 1, namespace declaration '");
                                ((StringBuilder)object2).append(cursor2.itemName().getString(1));
                                ((StringBuilder)object2).append("' has a value '");
                                ((StringBuilder)object2).append(EqualityHelper.stringValue(volatileCData2));
                                ((StringBuilder)object2).append("', while the same namespace declaration in sequence 2 has a value '");
                                ((StringBuilder)object2).append(EqualityHelper.stringValue(volatileCData));
                                ((StringBuilder)object2).append("'");
                            }
                            logger.logp(Level.FINEST, logger.getName(), "isEquals", ((StringBuilder)object2).toString());
                        }
                        return EqualityHelper.fail(stack, stack2);
                    }
                    bl3 = true;
                    break;
                }
                case 8: {
                    VolatileCData volatileCData2 = cursor2.itemTypedValue();
                    VolatileCData volatileCData = cursor3.itemTypedValue();
                    if (!EqualityHelper.typedValueEquals(volatileCData2, volatileCData)) {
                        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                            object2 = new StringBuilder();
                            ((StringBuilder)object2).append("Equality failed when comparing 2 comment nodes\n");
                            if (!TypeHelper.isEqual(volatileCData2.getXSTypeDefinition(), volatileCData.getXSTypeDefinition())) {
                                ((StringBuilder)object2).append("  Reason: Type mismatch\n  Diagnosis: In sequence 1, a comment with text '");
                                ((StringBuilder)object2).append(volatileCData2.getString(1));
                                ((StringBuilder)object2).append("' has a type name '");
                                ((StringBuilder)object2).append(TypeHelper.prettyPrint(volatileCData2.getXSTypeDefinition()));
                                ((StringBuilder)object2).append("', while in sequence 2, a comment with text '");
                                ((StringBuilder)object2).append(volatileCData.getString(1));
                                ((StringBuilder)object2).append("' has a type name '");
                                ((StringBuilder)object2).append(TypeHelper.prettyPrint(volatileCData.getXSTypeDefinition()));
                                ((StringBuilder)object2).append("'");
                            } else {
                                ((StringBuilder)object2).append("  Reason: Value mismatch\n  Diagnosis: In sequence 1, the value of comment node is '");
                                ((StringBuilder)object2).append(volatileCData2.getString(1));
                                ((StringBuilder)object2).append("', while in sequence 2, the value of comment node is '");
                                ((StringBuilder)object2).append(volatileCData.getString(1));
                                ((StringBuilder)object2).append("'");
                            }
                            logger.logp(Level.FINEST, logger.getName(), "isEquals", ((StringBuilder)object2).toString());
                        }
                        return EqualityHelper.fail(stack, stack2);
                    }
                    bl3 = true;
                    break;
                }
                case 7: {
                    if (!EqualityHelper.qnameEquals(cursor2.itemName(), cursor3.itemName())) {
                        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                            object2 = new StringBuilder();
                            ((StringBuilder)object2).append("Equality failed when comparing 2 pi nodes\n  Reason: Target mismatch\n  Diagnosis: In sequence 1, the target of pi node is '");
                            ((StringBuilder)object2).append(cursor2.itemName().getString(1));
                            ((StringBuilder)object2).append("', while in sequence 2 the target of pi node is '");
                            ((StringBuilder)object2).append(cursor3.itemName().getString(1));
                            ((StringBuilder)object2).append("'");
                            logger.logp(Level.FINEST, logger.getName(), "isEquals", ((StringBuilder)object2).toString());
                        }
                        return EqualityHelper.fail(stack, stack2);
                    }
                    VolatileCData volatileCData2 = cursor2.itemTypedValue();
                    VolatileCData volatileCData = cursor3.itemTypedValue();
                    if (!EqualityHelper.typedValueEquals(cursor2.itemTypedValue(), cursor3.itemTypedValue())) {
                        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                            object2 = new StringBuilder();
                            ((StringBuilder)object2).append("Equality failed when comparing 2 pi nodes\n");
                            if (!TypeHelper.isEqual(volatileCData2.getXSTypeDefinition(), volatileCData.getXSTypeDefinition())) {
                                ((StringBuilder)object2).append("  Reason: Type mismatch\n  Diagnosis: In sequence 1, pi with target '");
                                ((StringBuilder)object2).append(cursor2.itemName().getString(1));
                                ((StringBuilder)object2).append(" has text '");
                                ((StringBuilder)object2).append(volatileCData2.getString(1));
                                ((StringBuilder)object2).append("' with a type name '");
                                ((StringBuilder)object2).append(TypeHelper.prettyPrint(volatileCData2.getXSTypeDefinition()));
                                ((StringBuilder)object2).append("', while the same pi in sequence 2 has text '");
                                ((StringBuilder)object2).append(volatileCData.getString(1));
                                ((StringBuilder)object2).append("' with a type name '");
                                ((StringBuilder)object2).append(TypeHelper.prettyPrint(volatileCData.getXSTypeDefinition()));
                                ((StringBuilder)object2).append("'");
                            } else {
                                ((StringBuilder)object2).append("  Reason: text mismatch\n  Diagnosis: In sequence 1, pi with target '");
                                ((StringBuilder)object2).append(cursor2.itemName().getString(1));
                                ((StringBuilder)object2).append("has a text '");
                                ((StringBuilder)object2).append(volatileCData2.getString(1));
                                ((StringBuilder)object2).append("', while the same pi in sequence 2 has a text '");
                                ((StringBuilder)object2).append(volatileCData.getString(1));
                                ((StringBuilder)object2).append("'");
                            }
                            logger.logp(Level.FINEST, logger.getName(), "isAttrEquals", ((StringBuilder)object2).toString());
                        }
                        return EqualityHelper.fail(stack, stack2);
                    }
                    bl3 = true;
                }
            }
            if (!bl3) continue;
            do {
                if (stack.size() != 1) {
                    object2 = "";
                    if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                        object2 = EqualityHelper.itemKindString(cursor2);
                    }
                    if (cursor2.toNext()) {
                        if (cursor3.toNext()) continue block9;
                        if (differenceHandler.differenceFound(3, cursor3, cursor2)) {
                            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                                object3 = new StringBuilder();
                                ((StringBuilder)object3).append("Equality failed when comparing 2 sequences\n  Reason: Missing sibling\n  Diagnosis: In sequence 1, ");
                                ((StringBuilder)object3).append((String)object2);
                                ((StringBuilder)object3).append(" is follwed by ");
                                ((StringBuilder)object3).append(EqualityHelper.itemKindString(cursor2));
                                ((StringBuilder)object3).append(" , but in sequence 2, ");
                                ((StringBuilder)object3).append((String)object2);
                                ((StringBuilder)object3).append(" is the last sibling");
                                logger.logp(Level.FINEST, logger.getName(), "isEquals", ((StringBuilder)object3).toString());
                            }
                            return EqualityHelper.fail(stack, stack2);
                        }
                    } else if (cursor3.toNext() && differenceHandler.differenceFound(3, cursor2, cursor3)) {
                        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                            object3 = new StringBuilder();
                            ((StringBuilder)object3).append("Equality failed when comparing 2 sequences\n  Reason: Missing sibling\n  Diagnosis: In sequence 2, ");
                            ((StringBuilder)object3).append((String)object2);
                            ((StringBuilder)object3).append(" is follwed by ");
                            ((StringBuilder)object3).append(EqualityHelper.itemKindString(cursor3));
                            ((StringBuilder)object3).append(" , but in sequence 1, ");
                            ((StringBuilder)object3).append((String)object2);
                            ((StringBuilder)object3).append(" is the last sibling");
                            logger.logp(Level.FINEST, logger.getName(), "isEquals", ((StringBuilder)object3).toString());
                        }
                        return EqualityHelper.fail(stack, stack2);
                    }
                }
                cursor2.release();
                cursor3.release();
                stack.pop();
                stack2.pop();
                cursor2 = stack.isEmpty() ? null : stack.peek();
                Cursor cursor4 = cursor3 = stack2.isEmpty() ? null : stack2.peek();
            } while (cursor2 != null && cursor3 != null);
        } while (!stack.isEmpty() && !stack2.isEmpty());
        if (!stack2.isEmpty() || !stack.isEmpty()) {
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("Equality failed when comparing 2 cursors\n  Reason: Unexpected end of sequence\n");
                if (stack.isEmpty()) {
                    ((StringBuilder)object2).append("  Diagnosis: Reached end of sequence for cursor 1, but encountered ");
                    ((StringBuilder)object2).append(EqualityHelper.itemKindString(stack2.peek()));
                    ((StringBuilder)object2).append(" in cursor 2");
                } else {
                    ((StringBuilder)object2).append("  Diagnosis: Reached end of sequence for cursor 2, but encountered ");
                    ((StringBuilder)object2).append(EqualityHelper.itemKindString(stack.peek()));
                    ((StringBuilder)object2).append(" in cursor 1");
                }
                logger.logp(Level.FINEST, logger.getName(), "isEquals", ((StringBuilder)object2).toString());
            }
            return EqualityHelper.fail(stack, stack2);
        }
        return true;
    }

    public static boolean typedValueEquals(VolatileCData volatileCData, VolatileCData volatileCData2) {
        if (!TypeHelper.isEqual(volatileCData.getXSTypeDefinition(), volatileCData2.getXSTypeDefinition())) {
            return false;
        }
        switch (volatileCData.getXSTypeDefinition().getBuiltInKind()) {
            case 3: {
                return volatileCData.getBoolean(1) == volatileCData2.getBoolean(1);
            }
            case 4: {
                return volatileCData.getBigDecimal(1).compareTo(volatileCData2.getBigDecimal(1)) == 0;
            }
            case 5: {
                float f2 = volatileCData.getFloat(1);
                float f3 = volatileCData2.getFloat(1);
                if (Float.isNaN(f2) && Float.isNaN(f3)) {
                    return true;
                }
                return f2 == f3;
            }
            case 6: {
                double d = volatileCData.getDouble(1);
                double d2 = volatileCData2.getDouble(1);
                if (Double.isNaN(d) && Double.isNaN(d2)) {
                    return true;
                }
                return d == d2;
            }
            case 7: 
            case 46: 
            case 47: {
                try {
                    return volatileCData.getDuration(1).equals(volatileCData2.getDuration(1));
                }
                catch (ParseException parseException) {
                    throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{volatileCData.getXSTypeDefinition().toString(), "xs:duration"});
                }
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                try {
                    return volatileCData.getXMLGregorianCalendar(1).equals(volatileCData2.getXMLGregorianCalendar(1));
                }
                catch (ParseException parseException) {
                    throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{volatileCData.getXSTypeDefinition().toString(), volatileCData2.getXSTypeDefinition().toString()});
                }
            }
            case 16: {
                return ((Object)volatileCData.getHexBinary(1)).equals(volatileCData2.getHexBinary(1));
            }
            case 17: {
                return ((Object)volatileCData.getBase64Binary(1)).equals(volatileCData2.getBase64Binary(1));
            }
            case 19: {
                return volatileCData.getQNameLocalPart(1).equals(volatileCData2.getQNameLocalPart(1)) && volatileCData.getQNameNamespaceURI(1).equals(volatileCData2.getQNameNamespaceURI(1));
            }
            case 35: 
            case 41: {
                return volatileCData.getShort(1) == volatileCData2.getShort(1);
            }
            case 30: 
            case 31: 
            case 32: 
            case 37: 
            case 38: 
            case 42: {
                return volatileCData.getBigInteger(1).equals(volatileCData2.getBigInteger(1));
            }
            case 33: 
            case 39: {
                return volatileCData.getLong(1) == volatileCData2.getLong(1);
            }
            case 34: 
            case 40: {
                return volatileCData.getInt(1) == volatileCData2.getInt(1);
            }
            case 36: {
                return volatileCData.getByte(1) == volatileCData2.getByte(1);
            }
        }
        return volatileCData.getString(1).equals(volatileCData2.getString(1));
    }

    private static boolean qnameEquals(VolatileCData volatileCData, VolatileCData volatileCData2) {
        return volatileCData.equals(volatileCData2);
    }

    private static DifferenceHandler getDifferenceHandler(Map<String, Object> map2) {
        if (map2 == null) {
            return AcceptAllDiffHandler.SINGLETON;
        }
        DiffDispatcher diffDispatcher = new DiffDispatcher();
        if (EqualityHelper.getBoolean("equal-ignore-root-element-name", map2)) {
            diffDispatcher.setHandler(0, RootElementHandler.SINGLETON);
        }
        if (EqualityHelper.getBoolean("equal-ignore-whitespace", map2)) {
            diffDispatcher.setHandler(3, new WhitespaceHandler());
            diffDispatcher.setHandler(2, new WhitespaceHandler());
            diffDispatcher.setHandler(4, new WhitespaceHandler());
        }
        boolean bl = EqualityHelper.getBoolean("equal-ignore-root-xsi-type", map2);
        boolean bl2 = EqualityHelper.getBoolean("equal-ignore-default-attribute", map2);
        if (bl || bl2) {
            XSIAttributeHandler xSIAttributeHandler = new XSIAttributeHandler(bl, bl2);
            diffDispatcher.setHandler(5, xSIAttributeHandler);
            diffDispatcher.setHandler(6, xSIAttributeHandler);
        }
        if (EqualityHelper.getBoolean("equal-strict-fn-spec", map2)) {
            throw new XCIDynamicErrorException("ER_EQUALITY_UNSUPPORTED_OPERATION");
        }
        return diffDispatcher;
    }

    private static boolean isAttrEquals(Stack<Cursor> stack, Stack<Cursor> stack2, Cursor cursor2, Cursor cursor3, DifferenceHandler differenceHandler, boolean bl) {
        Cursor cursor4 = cursor2.fork(true);
        Cursor cursor5 = cursor3.fork(true);
        if (cursor4.toAttributes(null)) {
            CharSequence charSequence;
            int n2;
            if (!cursor5.toAttributes(null)) {
                if (!differenceHandler.differenceFound(5, cursor4, cursor5)) {
                    cursor4.release();
                    cursor5.release();
                    return true;
                }
                if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Equality failed when comparing 2 element nodes\n  Reason: One element has no attributes\n  Diagnosis: In sequence 1, element '");
                    stringBuilder.append(EqualityHelper.getQualifiedName(cursor2.itemName(), 1));
                    stringBuilder.append("' has attributes but the same element in sequence 2 has no attributes");
                    logger.logp(Level.FINEST, logger.getName(), "isAttrEquals", stringBuilder.toString());
                }
                cursor4.release();
                cursor5.release();
                return EqualityHelper.fail(stack, stack2);
            }
            ArrayList<CData> arrayList = new ArrayList<CData>();
            ArrayList<CData> arrayList2 = new ArrayList<CData>();
            ArrayList<XSTypeDefinition> arrayList3 = new ArrayList<XSTypeDefinition>();
            ArrayList<Boolean> arrayList4 = new ArrayList<Boolean>();
            do {
                arrayList.add(cursor4.itemName().constant(true));
                arrayList2.add(cursor4.itemTypedValue().constant(true));
                arrayList3.add(cursor4.itemXSType());
                arrayList4.add(differenceHandler.conditionFound(6, cursor4));
            } while (cursor4.toNext());
            do {
                VolatileCData volatileCData;
                if (differenceHandler.conditionFound(6, cursor5)) continue;
                n2 = arrayList.indexOf(cursor5.itemName());
                if (n2 == -1) {
                    if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                        charSequence = new StringBuilder();
                        ((StringBuilder)charSequence).append("Equality failed when comparing 2 element nodes\n  Reason: Attribute not found\n  Diagnosis: In sequence 2, element '");
                        ((StringBuilder)charSequence).append(EqualityHelper.getQualifiedName(cursor2.itemName(), 1));
                        ((StringBuilder)charSequence).append("' has attribute '");
                        ((StringBuilder)charSequence).append(EqualityHelper.getQualifiedName(cursor5.itemName(), 1));
                        ((StringBuilder)charSequence).append("' but that attribute is not found for the same element in sequence 1");
                        logger.logp(Level.FINEST, logger.getName(), "isAttrEquals", ((StringBuilder)charSequence).toString());
                    }
                    cursor4.release();
                    cursor5.release();
                    return EqualityHelper.fail(stack, stack2);
                }
                charSequence = (VolatileCData)arrayList2.get(n2);
                if (!EqualityHelper.typedValueEquals((VolatileCData)charSequence, volatileCData = cursor5.itemTypedValue())) {
                    if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("Equality failed when comparing 2 element nodes\n");
                        if (!TypeHelper.isEqual(charSequence.getXSTypeDefinition(), volatileCData.getXSTypeDefinition())) {
                            stringBuilder.append("  Reason: Attribute type mismatch\n  Diagnosis: In sequence 1, element '");
                            stringBuilder.append(EqualityHelper.getQualifiedName(cursor2.itemName(), 1));
                            stringBuilder.append("' has an attribute '");
                            stringBuilder.append(EqualityHelper.getQualifiedName((VolatileCData)arrayList.get(n2), 1));
                            stringBuilder.append("' with a type name '");
                            stringBuilder.append(TypeHelper.prettyPrint(charSequence.getXSTypeDefinition()));
                            stringBuilder.append("', while in sequence 2 that attribute has a type name '");
                            stringBuilder.append(TypeHelper.prettyPrint(volatileCData.getXSTypeDefinition()));
                            stringBuilder.append("'");
                        } else {
                            stringBuilder.append("  Reason: Attribute value mismatch\n  Diagnosis: In sequence 1, element '");
                            stringBuilder.append(EqualityHelper.getQualifiedName(cursor2.itemName(), 1));
                            stringBuilder.append("' has an attribute '");
                            stringBuilder.append(EqualityHelper.getQualifiedName((VolatileCData)arrayList.get(n2), 1));
                            stringBuilder.append("' with a value '");
                            stringBuilder.append(EqualityHelper.stringValue((VolatileCData)charSequence));
                            stringBuilder.append("', while in sequence 2 that attribute has a value '");
                            stringBuilder.append(EqualityHelper.stringValue(volatileCData));
                            stringBuilder.append("'");
                        }
                        logger.logp(Level.FINEST, logger.getName(), "isAttrEquals", stringBuilder.toString());
                    }
                    cursor4.release();
                    cursor5.release();
                    return EqualityHelper.fail(stack, stack2);
                }
                arrayList4.set(n2, Boolean.TRUE);
            } while (cursor5.toNext());
            cursor4.release();
            cursor5.release();
            for (n2 = 0; n2 < arrayList4.size(); ++n2) {
                if (((Boolean)arrayList4.get(n2)).equals(Boolean.TRUE)) continue;
                if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                    charSequence = new StringBuilder();
                    ((StringBuilder)charSequence).append("Equality failed when comparing 2 element nodes\n  Reason: Attribute not found\n  Diagnosis: In sequence 1, element '");
                    ((StringBuilder)charSequence).append(EqualityHelper.getQualifiedName(cursor2.itemName(), 1));
                    ((StringBuilder)charSequence).append("' has attribute '");
                    ((StringBuilder)charSequence).append(EqualityHelper.getQualifiedName((VolatileCData)arrayList.get(n2), 1));
                    ((StringBuilder)charSequence).append("' but that attribute is not found for the same element in sequence 2");
                    logger.logp(Level.FINEST, logger.getName(), "isAttrEquals", ((StringBuilder)charSequence).toString());
                }
                return EqualityHelper.fail(stack, stack2);
            }
        } else {
            if (cursor5.toAttributes(null) && differenceHandler.differenceFound(5, cursor5, cursor4)) {
                if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Equality failed when comparing 2 element nodes\n  Reason: One element has no attributes\n  Diagnosis: In sequence 2, element '");
                    stringBuilder.append(EqualityHelper.getQualifiedName(cursor2.itemName(), 1));
                    stringBuilder.append("' has attributes, but in sequence 1, the same element has no attributes");
                    logger.logp(Level.FINEST, logger.getName(), "isAttrEquals", stringBuilder.toString());
                }
                cursor4.release();
                cursor5.release();
                return EqualityHelper.fail(stack, stack2);
            }
            cursor4.release();
            cursor5.release();
        }
        return true;
    }

    private static boolean fail(Stack<Cursor> stack, Stack<Cursor> stack2) {
        while (!stack.isEmpty()) {
            stack.pop().release();
        }
        while (!stack2.isEmpty()) {
            stack2.pop().release();
        }
        return false;
    }

    private static boolean getBoolean(String string2, Map<String, Object> map2) {
        Object object2;
        if (map2 != null && (object2 = map2.get(string2)) instanceof Boolean) {
            return (Boolean)object2;
        }
        return false;
    }

    private static String itemKindString(Cursor cursor2) {
        switch (cursor2.itemKind()) {
            case 1: {
                return "element with name '" + EqualityHelper.getQualifiedName(cursor2.itemName(), 1) + "'";
            }
            case 2: {
                return "attribute with name '" + EqualityHelper.getQualifiedName(cursor2.itemName(), 1) + "'";
            }
            case 3: {
                return "text with value '" + EqualityHelper.stringValue(cursor2.itemTypedValue()) + "'";
            }
            case 4: {
                return "namespace decl with name '" + cursor2.itemName().getString(1) + "'";
            }
            case 8: {
                return "comment with value '" + cursor2.itemTypedValue().getString(1) + "'";
            }
            case 7: {
                return "processing instruction with target '" + cursor2.itemName().getString(1) + "'";
            }
            case 9: {
                return "document";
            }
        }
        return "none";
    }

    private static String getQualifiedName(VolatileCData volatileCData, int n2) {
        String string2 = volatileCData.getQNamePrefix(n2);
        String string3 = volatileCData.getQNameLocalPart(n2);
        if (string2 == null || string2.length() == 0) {
            return string3;
        }
        return string2 + ":" + string3;
    }

    private static String stringValue(VolatileCData volatileCData) {
        String string2;
        int n2 = volatileCData.getSize();
        XSSimpleTypeDefinition xSSimpleTypeDefinition = volatileCData.getXSTypeDefinition(1);
        String string3 = string2 = EqualityHelper.isQNameType(xSSimpleTypeDefinition) ? EqualityHelper.getQualifiedName(volatileCData, 1) : volatileCData.getString(1);
        if (n2 == 1) {
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2);
        for (int i = 2; i <= n2; ++i) {
            xSSimpleTypeDefinition = volatileCData.getXSTypeDefinition(i);
            string2 = EqualityHelper.isQNameType(xSSimpleTypeDefinition) ? EqualityHelper.getQualifiedName(volatileCData, i) : volatileCData.getString(i);
            stringBuilder.append(" ");
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    private static final boolean isQNameType(XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        return xSSimpleTypeDefinition != null && xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSQNAME, (short)0);
    }
}

