/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.internal.formal;

import com.ibm.xml.xci.internal.formal.Lattice;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapLattice<K, V extends Lattice<V>> {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    final Map<K, V> map;

    MapLattice(Map<K, V> map2) {
        this.map = map2;
    }

    public Map<K, V> map() {
        return this.map;
    }

    public V extract(K k, V v) {
        Lattice lattice = (Lattice)this.map.get(k);
        if (lattice == null) {
            return v;
        }
        this.map.remove(k);
        return (V)lattice;
    }

    public boolean containedIn(Map<K, V> map2) {
        for (Map.Entry<K, V> entry : this.map.entrySet()) {
            K k = entry.getKey();
            Lattice lattice = (Lattice)entry.getValue();
            Lattice lattice2 = (Lattice)map2.get(k);
            if (lattice2 != null && lattice.containedIn(lattice2)) continue;
            return false;
        }
        return true;
    }

    public void intersectWith(Map<K, V> map2) {
        Set<Map.Entry<K, V>> set2 = this.map.entrySet();
        Iterator<Map.Entry<K, V>> iterator = set2.iterator();
        while (iterator.hasNext()) {
            Map.Entry<K, Lattice> entry = iterator.next();
            K k = entry.getKey();
            Lattice lattice = (Lattice)entry.getValue();
            Lattice lattice2 = (Lattice)map2.get(k);
            if (lattice2 == null) {
                iterator.remove();
                continue;
            }
            entry.setValue(lattice.intersect(lattice2));
        }
    }

    public void union(Map<K, V> map2) {
        for (Map.Entry<K, V> entry : map2.entrySet()) {
            K k = entry.getKey();
            Lattice lattice = (Lattice)entry.getValue();
            this.map.put(k, this.map.containsKey(k) ? this.map.put(k, ((Lattice)this.map.get(k)).union(lattice)) : lattice);
        }
    }
}

