/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.internal.util;

import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.errors.XCIDynamicErrorException;

public class CompareUtil {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2008. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Cursor.Profile ALLOWS_COMPARE = Cursor.Profile.TO_PARENT.union(Cursor.Profile.IS_SAME_NODE.union(Cursor.Profile.MINIMAL_NAVIGATION));
    private static final Cursor.Profile ALLOWS_SEARCH_DOMINANT = Cursor.Profile.TO_PARENT.union(Cursor.Profile.IS_SAME_NODE.union(Cursor.Profile.MINIMAL_NAVIGATION));

    public static int isBeforeOrEquals(Cursor cursor2, Cursor cursor3) {
        if (cursor2.itemIsSameNode(cursor3)) {
            return 0;
        }
        Cursor cursor4 = CompareUtil.searchDominant(cursor2, cursor3);
        Cursor cursor5 = cursor3;
        Cursor cursor6 = cursor3.fork(ALLOWS_COMPARE, false);
        if (cursor6.toParent()) {
            do {
                if (cursor6.itemIsSameNode(cursor2) || CompareUtil.lookInDesc(cursor6, cursor5, cursor2)) {
                    cursor6.release();
                    return -1;
                }
                cursor5 = cursor6;
                if ((cursor6 = cursor6.fork(ALLOWS_COMPARE, false)).toParent()) {
                    if (cursor6.itemIsSameNode(cursor2)) {
                        cursor6.release();
                        return -1;
                    }
                    if (!cursor6.itemIsSameNode(cursor4)) continue;
                    int n2 = CompareUtil.lookInDesc(cursor6, cursor5, cursor2) ? -1 : 1;
                    cursor6.release();
                    return n2;
                }
                cursor6.release();
                cursor6 = null;
            } while (cursor6 != null);
        }
        return 1;
    }

    private static Cursor searchDominant(Cursor cursor2, Cursor cursor3) {
        Cursor cursor4 = cursor2.fork(ALLOWS_SEARCH_DOMINANT, false);
        do {
            Cursor cursor5 = cursor3.fork(ALLOWS_SEARCH_DOMINANT, false);
            do {
                if (!cursor4.itemIsSameNode(cursor5)) continue;
                cursor4.release();
                cursor5.release();
                return cursor4;
            } while (cursor5.toParent());
            cursor5.release();
        } while (cursor4.toParent());
        throw new AssertionError((Object)"Should find a common ancestor");
    }

    protected static boolean lookInDesc(Cursor cursor2, Cursor cursor3, Cursor cursor4) throws XCIDynamicErrorException {
        Cursor cursor5 = cursor2.fork(ALLOWS_COMPARE, false);
        if (cursor5.toChildren(null)) {
            do {
                if (cursor3 != null && cursor5.itemIsSameNode(cursor3)) {
                    cursor5.release();
                    break;
                }
                if (cursor5.itemIsSameNode(cursor4) || CompareUtil.lookInDesc(cursor5, null, cursor4)) {
                    cursor5.release();
                    return true;
                }
                if (cursor5.toNext()) continue;
                cursor5.release();
                cursor5 = null;
            } while (cursor5 != null);
        }
        return false;
    }
}

