/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.internal.util;

import com.ibm.xml.jaxp.util.JAXPFactoryHelper;
import com.ibm.xml.xci.dp.util.misc.URIUtility;
import com.ibm.xml.xci.internal.util.ReusableInputStream;
import com.ibm.xml.xci.type.SchemaResolver;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultResourceResolver
implements LSResourceResolver,
SchemaResolver {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2008. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final DOMImplementationLS cachedDOMImpl;
    private static final DefaultResourceResolver defaultResolver;
    protected final Map<String, Map<String, InputStream>> inputs;
    protected final DOMImplementationLS domImpl;

    public static DefaultResourceResolver getDefaultResourceResolver() {
        return defaultResolver;
    }

    public DefaultResourceResolver() {
        this(cachedDOMImpl);
    }

    public DefaultResourceResolver(DOMImplementationLS dOMImplementationLS) {
        this.domImpl = dOMImplementationLS;
        this.inputs = new HashMap<String, Map<String, InputStream>>();
    }

    public void register(String string2, String string3, InputStream inputStream) {
        Map<String, InputStream> map2 = this.inputs.get(string2);
        if (map2 == null) {
            map2 = new HashMap<String, InputStream>();
            this.inputs.put(string2, map2);
        }
        map2.put(string3, new BufferedInputStream(inputStream));
    }

    protected LSInput resolveResource(String string2, String string3, String string4, URL uRL, String string5) {
        return this.resolveResource(string2, string3, string4, URIUtility.toURI(uRL), string5);
    }

    protected LSInput resolveResource(String string2, String string3, String string4, URI uRI, String string5) {
        if (uRI != null) {
            URI uRI2 = string5 == null ? URIUtility.resolveBaseURI(uRI) : URI.create(string5);
            uRI = URIUtility.resolveURI(uRI2, uRI);
            try {
                InputStream inputStream = uRI.toURL().openStream();
                LSInput lSInput = this.domImpl.createLSInput();
                lSInput.setBaseURI(uRI2.toString());
                lSInput.setSystemId(uRI.toString());
                lSInput.setPublicId(string4);
                lSInput.setByteStream(inputStream);
                return lSInput;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    @Override
    public LSInput resolveResource(String string2, String string3, String string4, String string5, String string6) {
        Object object2;
        Map<String, InputStream> map2 = this.inputs.get(string3);
        if (map2 != null && (object2 = map2.get(string5)) != null) {
            LSInput lSInput = this.domImpl.createLSInput();
            lSInput.setByteStream(new ReusableInputStream((InputStream)object2));
            lSInput.setSystemId(string5);
            return lSInput;
        }
        if (string5 != null) {
            object2 = URI.create(string5);
            return this.resolveResource(string2, string3, string4, (URI)object2, string6);
        }
        return null;
    }

    @Override
    public List<? extends Source> resolve(SchemaResolver.SchemaIdentifier schemaIdentifier) {
        String string2 = schemaIdentifier.getNamespace();
        List<String> list = schemaIdentifier.getLocations();
        String string3 = schemaIdentifier.getBaseURI();
        return this.resolve(string2, list, string3);
    }

    @Deprecated
    public List<? extends Source> resolve(String string2, List<String> list, String string3) {
        Map<String, InputStream> map2 = this.inputs.get(string2);
        if (map2 != null) {
            URI uRI;
            ArrayList<Source> arrayList = new ArrayList<Source>();
            URI uRI2 = uRI = string3 != null ? URI.create(string3) : null;
            if (list.size() != 0) {
                for (String string4 : list) {
                    arrayList.add(this.resolve(string4, uRI, map2.get(string4)));
                }
            } else {
                for (Map.Entry<String, InputStream> entry : map2.entrySet()) {
                    arrayList.add(this.resolve(entry.getKey(), uRI, entry.getValue()));
                }
            }
            return arrayList;
        }
        return null;
    }

    private Source resolve(String string2, URI uRI, InputStream inputStream) {
        if (inputStream != null) {
            inputStream = new ReusableInputStream(inputStream);
        }
        URI uRI2 = URI.create(string2);
        URI uRI3 = uRI != null ? uRI : URIUtility.resolveBaseURI(uRI2);
        uRI2 = URIUtility.resolveURI(uRI3, uRI2);
        StreamSource streamSource = new StreamSource();
        streamSource.setSystemId(uRI2.toString());
        streamSource.setInputStream(inputStream);
        return streamSource;
    }

    static {
        try {
            cachedDOMImpl = (DOMImplementationLS)((Object)JAXPFactoryHelper.getDOMImplementation("LS"));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        defaultResolver = new DefaultResourceResolver();
    }
}

