/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.internal.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public final class IdentityHashMapToLong {
    public static final long NOTFOUND = -1L;
    private static final int CHAIN_SIZE = 3;
    private static final int INITIAL_SIZE = 17;
    private static final float MAX_LOAD = 2.0f;
    private int m_numEntries = 0;
    private MapEntry[][] m_buckets;

    public IdentityHashMapToLong() {
        this.clear();
    }

    private void rehash() {
        MapEntry[][] mapEntryArray = new MapEntry[this.m_buckets.length * 2][];
        for (int i = 0; i < this.m_buckets.length; ++i) {
            if (this.m_buckets[i] == null) continue;
            for (int j = 0; j < this.m_buckets[i].length; ++j) {
                MapEntry mapEntry = this.m_buckets[i][j];
                if (mapEntry == null) continue;
                this.put(mapEntry.getKey(), mapEntry.getValue(), mapEntryArray, true);
            }
        }
        this.m_buckets = mapEntryArray;
    }

    private int whichBucket(int n2, int n3) {
        int n4 = Math.abs(n2 % n3);
        return n4;
    }

    public int size() {
        return this.m_numEntries;
    }

    public boolean isEmpty() {
        return this.m_numEntries == 0;
    }

    public boolean containsKey(Object object2) {
        int n2 = System.identityHashCode(object2);
        MapEntry[] mapEntryArray = this.m_buckets[this.whichBucket(n2, this.m_buckets.length)];
        if (mapEntryArray == null) {
            return false;
        }
        for (int i = 0; i < mapEntryArray.length; ++i) {
            if (mapEntryArray[i] == null || mapEntryArray[i].getKey() != object2) continue;
            return true;
        }
        return false;
    }

    public boolean containsValue(long l) {
        for (int i = 0; i < this.m_buckets.length; ++i) {
            if (this.m_buckets[i] == null) continue;
            for (int j = 0; j < this.m_buckets[i].length; ++j) {
                if (this.m_buckets[i][j] == null || l != this.m_buckets[i][j].getValue()) continue;
                return true;
            }
        }
        return false;
    }

    public long get(Object object2) {
        int n2 = System.identityHashCode(object2);
        MapEntry[] mapEntryArray = this.m_buckets[this.whichBucket(n2, this.m_buckets.length)];
        if (mapEntryArray == null) {
            return -1L;
        }
        for (int i = 0; i < mapEntryArray.length; ++i) {
            if (mapEntryArray[i] == null || mapEntryArray[i].getKey() != object2) continue;
            return mapEntryArray[i].getValue();
        }
        return -1L;
    }

    public Long put(Object object2, long l) {
        if ((float)(this.m_numEntries + 1) >= 2.0f * (float)this.m_buckets.length) {
            this.rehash();
        }
        return this.put(object2, l, this.m_buckets, false);
    }

    private long put(Object object2, long l, MapEntry[][] mapEntryArray, boolean bl) {
        int n2 = System.identityHashCode(object2);
        int n3 = this.whichBucket(n2, mapEntryArray.length);
        MapEntry[] mapEntryArray2 = mapEntryArray[n3];
        if (mapEntryArray2 == null) {
            MapEntry[] mapEntryArray3 = new MapEntry[3];
            mapEntryArray[n3] = mapEntryArray3;
            mapEntryArray2 = mapEntryArray3;
        }
        int n4 = -1;
        for (int i = 0; i < mapEntryArray2.length; ++i) {
            if (mapEntryArray2[i] == null) {
                if (n4 != -1) continue;
                n4 = i;
                continue;
            }
            if (mapEntryArray2[i].getKey() != object2) continue;
            Long l2 = mapEntryArray2[i].getValue();
            mapEntryArray2[i].setValue(l);
            return l2;
        }
        if (n4 == -1) {
            MapEntry[] mapEntryArray4 = new MapEntry[mapEntryArray2.length * 2];
            n4 = mapEntryArray2.length;
            System.arraycopy(mapEntryArray2, 0, mapEntryArray4, 0, n4);
            mapEntryArray[n3] = mapEntryArray4;
            mapEntryArray2 = mapEntryArray4;
        }
        mapEntryArray2[n4] = new MapEntry(object2, l);
        if (!bl) {
            ++this.m_numEntries;
        }
        return -1L;
    }

    private void remove(int n2, int n3) {
        if (this.m_buckets[n2][n3] != null) {
            this.m_buckets[n2][n3] = null;
            --this.m_numEntries;
        }
    }

    public long remove(Object object2) {
        int n2 = System.identityHashCode(object2);
        MapEntry[] mapEntryArray = this.m_buckets[this.whichBucket(n2, this.m_buckets.length)];
        if (mapEntryArray == null) {
            return -1L;
        }
        for (int i = 0; i < mapEntryArray.length; ++i) {
            if (mapEntryArray[i] == null || mapEntryArray[i].getKey() != object2) continue;
            long l = mapEntryArray[i].getValue();
            mapEntryArray[i] = null;
            --this.m_numEntries;
            return l;
        }
        return -1L;
    }

    private void removeValue(long l) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            MapEntry mapEntry = (MapEntry)iterator.next();
            long l2 = mapEntry.getValue();
            if (l2 != l) continue;
            iterator.remove();
            return;
        }
    }

    public void putAll(Map map2) {
        Iterator iterator = map2.keySet().iterator();
        while (iterator.hasNext()) {
            Object k;
            Object v = map2.get(k = iterator.next());
            this.put(k, v == null ? -1L : Long.valueOf(v.toString()));
        }
    }

    public void putAll(IdentityHashMapToLong identityHashMapToLong) {
        for (Object e : identityHashMapToLong.keySet()) {
            this.put(e, identityHashMapToLong.get(e));
        }
    }

    public Object clone() {
        IdentityHashMapToLong identityHashMapToLong = new IdentityHashMapToLong();
        identityHashMapToLong.putAll(this);
        return identityHashMapToLong;
    }

    public void clear() {
        this.m_buckets = new MapEntry[17][];
        this.m_numEntries = 0;
    }

    public Set keySet() {
        return new IdentityKeySet(this);
    }

    public IdentityValueSet values() {
        return new IdentityValueSet(this);
    }

    public Set entrySet() {
        return new IdentityEntrySet(this);
    }

    private Iterator iterator() {
        return new IdentityEntryIterator(this);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[");
        stringBuffer.append("NumEntries:" + this.m_numEntries + "\n");
        for (int i = 0; i < this.m_buckets.length; ++i) {
            stringBuffer.append("\n" + i + ": ");
            MapEntry[] mapEntryArray = this.m_buckets[i];
            if (mapEntryArray == null) {
                stringBuffer.append("NOTFOUND");
                continue;
            }
            stringBuffer.append("[");
            for (int j = 0; j < mapEntryArray.length; ++j) {
                if (mapEntryArray[j] == null) {
                    stringBuffer.append(" (NOTFOUND) ");
                    continue;
                }
                stringBuffer.append(" (" + mapEntryArray[j].getKey() + "," + mapEntryArray[j].getValue() + ") ");
            }
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }

    public void dump() {
        System.out.println("NumEntries:" + this.m_numEntries);
        for (int i = 0; i < this.m_buckets.length; ++i) {
            System.out.print(i + ": ");
            MapEntry[] mapEntryArray = this.m_buckets[i];
            if (mapEntryArray == null) {
                System.out.println("NOTFOUND");
                continue;
            }
            System.out.print("[");
            for (int j = 0; j < mapEntryArray.length; ++j) {
                if (mapEntryArray[j] == null) {
                    System.out.print(" (NOTFOUND) ");
                    continue;
                }
                System.out.print(" (" + mapEntryArray[j].getKey() + "," + mapEntryArray[j].getValue() + ") ");
            }
            System.out.println("]");
        }
    }

    public static void main(String[] stringArray) {
        Iterator iterator;
        int n2;
        IdentityHashMapToLong identityHashMapToLong = new IdentityHashMapToLong();
        IdentityHashMapToLong identityHashMapToLong2 = new IdentityHashMapToLong();
        for (n2 = 0; n2 < 50; ++n2) {
            iterator = new Integer(n2);
            identityHashMapToLong.put(iterator, new Integer(n2 + 1).intValue());
            identityHashMapToLong.dump();
            System.out.println("----------------------");
        }
        identityHashMapToLong.clear();
        for (n2 = 0; n2 < 50; ++n2) {
            iterator = new Integer(n2);
            identityHashMapToLong.put(iterator, ((Integer)((Object)iterator)).intValue());
            identityHashMapToLong2.put(iterator, ((Integer)((Object)iterator)).intValue());
            identityHashMapToLong.dump();
            System.out.println("----------------------");
        }
        IdentityHashMapToLong identityHashMapToLong3 = new IdentityHashMapToLong();
        identityHashMapToLong3.putAll(identityHashMapToLong);
        iterator = identityHashMapToLong3.entrySet().iterator();
        while (iterator.hasNext()) {
            System.out.print(":" + iterator.next() + ":");
        }
        System.out.println();
        iterator = identityHashMapToLong3.keySet().iterator();
        while (iterator.hasNext()) {
            System.out.print(":" + iterator.next() + ":");
        }
        System.out.println();
        IdentityValueIterator identityValueIterator = identityHashMapToLong3.values().iterator();
        while (identityValueIterator.hasNext()) {
            System.out.print(":" + identityValueIterator.next() + ":");
        }
        System.out.println();
        System.out.println();
        IdentityValueSet identityValueSet = identityHashMapToLong.values();
        identityValueSet.retainAll(identityHashMapToLong3.values());
        identityValueSet.removeAll(identityHashMapToLong3.keySet());
        identityValueIterator = identityValueSet.iterator();
        while (identityValueIterator.hasNext()) {
            System.out.print(":" + identityValueIterator.next() + ":");
        }
        System.out.println();
    }

    private class IdentityEntrySet
    extends IdentitySet
    implements Set {
        public IdentityEntrySet(IdentityHashMapToLong identityHashMapToLong2) {
            super(identityHashMapToLong2);
        }

        public boolean contains(Object object2) {
            if (!(object2 instanceof MapEntry)) {
                return false;
            }
            Object object3 = ((MapEntry)object2).getKey();
            return this.store.containsKey(object3);
        }

        public boolean remove(Object object2) {
            if (!(object2 instanceof MapEntry)) {
                return false;
            }
            Object object3 = ((MapEntry)object2).getKey();
            if (!this.store.containsKey(object3)) {
                return false;
            }
            this.store.remove(object3);
            return true;
        }

        public Iterator iterator() {
            return new IdentityEntryIterator(this.store);
        }

        public boolean retainAll(Collection collection2) {
            boolean bl = false;
            for (Object e : this) {
                if (collection2.contains(e)) continue;
                boolean bl2 = this.remove(e);
                bl = bl || bl2;
            }
            return bl;
        }

        public boolean removeAll(Collection collection2) {
            boolean bl = false;
            for (Object e : collection2) {
                boolean bl2 = this.remove(e);
                bl = bl || bl2;
            }
            return bl;
        }
    }

    private class IdentityValueSet
    extends IdentitySet {
        public IdentityValueSet(IdentityHashMapToLong identityHashMapToLong2) {
            super(identityHashMapToLong2);
        }

        public boolean contains(Object object2) {
            return this.store.containsValue(object2 == null ? -1L : Long.valueOf(object2.toString()));
        }

        public boolean remove(Object object2) {
            long l;
            long l2 = l = object2 == null ? -1L : Long.valueOf(object2.toString());
            if (!this.store.containsValue(l)) {
                return false;
            }
            this.store.removeValue(l);
            return true;
        }

        public IdentityValueIterator iterator() {
            return new IdentityValueIterator(this.store);
        }

        public boolean retainAll(IdentityValueSet identityValueSet) {
            boolean bl = false;
            IdentityValueIterator identityValueIterator = this.iterator();
            while (identityValueIterator.hasNext()) {
                Long l = identityValueIterator.next();
                if (identityValueSet.contains(l)) continue;
                boolean bl2 = this.remove(l);
                bl = bl || bl2;
            }
            return bl;
        }

        public boolean removeAll(IdentityValueSet identityValueSet) {
            boolean bl = false;
            IdentityValueIterator identityValueIterator = identityValueSet.iterator();
            while (identityValueIterator.hasNext()) {
                Long l = identityValueIterator.next();
                boolean bl2 = this.remove(l);
                bl = bl || bl2;
            }
            return bl;
        }

        public boolean removeAll(Collection collection2) {
            boolean bl = false;
            for (Object e : collection2) {
                boolean bl2 = this.remove(e);
                bl = bl || bl2;
            }
            return bl;
        }
    }

    private class IdentityKeySet
    extends IdentitySet
    implements Set {
        public IdentityKeySet(IdentityHashMapToLong identityHashMapToLong2) {
            super(identityHashMapToLong2);
        }

        public boolean contains(Object object2) {
            return this.store.containsKey(object2);
        }

        public boolean remove(Object object2) {
            if (!this.store.containsKey(object2)) {
                return false;
            }
            this.store.remove(object2);
            return true;
        }

        public Iterator iterator() {
            return new IdentityKeyIterator(this.store);
        }

        public boolean retainAll(Collection collection2) {
            boolean bl = false;
            for (Object e : this) {
                if (collection2.contains(e)) continue;
                boolean bl2 = this.remove(e);
                bl = bl || bl2;
            }
            return bl;
        }

        public boolean removeAll(Collection collection2) {
            boolean bl = false;
            for (Object e : collection2) {
                boolean bl2 = this.remove(e);
                bl = bl || bl2;
            }
            return bl;
        }
    }

    private abstract class IdentitySet {
        protected IdentityHashMapToLong store;

        public IdentitySet(IdentityHashMapToLong identityHashMapToLong2) {
            this.store = identityHashMapToLong2;
        }

        public int size() {
            return this.store.size();
        }

        public boolean isEmpty() {
            return this.store.isEmpty();
        }

        public abstract boolean contains(Object var1);

        public Object[] toArray() {
            return this.toArray(new Object[0]);
        }

        public Object[] toArray(Object[] objectArray) {
            Object object2;
            if (objectArray.length < this.store.size()) {
                object2 = objectArray.getClass().getComponentType();
                objectArray = (Object[])Array.newInstance(object2, this.store.size());
            }
            object2 = IdentityHashMapToLong.this.iterator();
            int n2 = 0;
            while (object2.hasNext()) {
                objectArray[n2] = object2.next();
                ++n2;
            }
            return objectArray;
        }

        public boolean add(Object object2) {
            throw new UnsupportedOperationException();
        }

        public abstract boolean remove(Object var1);

        public boolean containsAll(Collection collection2) {
            for (Object e : collection2) {
                if (!this.contains(e)) continue;
                return false;
            }
            return true;
        }

        public boolean addAll(Collection collection2) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            this.store.clear();
        }
    }

    public class IdentityValueIterator {
        Iterator keys;
        IdentityHashMapToLong map;

        public IdentityValueIterator(IdentityHashMapToLong identityHashMapToLong2) {
            this.map = identityHashMapToLong2;
            Set set2 = identityHashMapToLong2.keySet();
            this.keys = set2 == null ? null : identityHashMapToLong2.keySet().iterator();
        }

        public boolean hasNext() {
            return this.keys == null ? false : this.keys.hasNext();
        }

        public long next() {
            return this.map.get(this.keys.next());
        }
    }

    private class IdentityKeyIterator
    extends IdentityEntryIterator
    implements Iterator {
        public IdentityKeyIterator(IdentityHashMapToLong identityHashMapToLong2) {
            super(identityHashMapToLong2);
        }

        public Object next() {
            MapEntry mapEntry = (MapEntry)super.next();
            return mapEntry.getKey();
        }
    }

    private class IdentityEntryIterator
    implements Iterator {
        private int i = 0;
        private int j = 0;
        private int numSeen = 0;
        protected IdentityHashMapToLong store;

        public IdentityEntryIterator(IdentityHashMapToLong identityHashMapToLong2) {
            this.store = identityHashMapToLong2;
        }

        public boolean hasNext() {
            return this.numSeen < this.store.size();
        }

        public Object next() {
            MapEntry mapEntry = null;
            block0: while (mapEntry == null) {
                if (this.i >= IdentityHashMapToLong.this.m_buckets.length) {
                    throw new NoSuchElementException();
                }
                MapEntry[] mapEntryArray = this.store.m_buckets[this.i];
                while (mapEntryArray == null) {
                    ++this.i;
                    if (this.i >= IdentityHashMapToLong.this.m_buckets.length) {
                        throw new NoSuchElementException();
                    }
                    mapEntryArray = this.store.m_buckets[this.i];
                }
                mapEntry = this.j >= mapEntryArray.length ? null : mapEntryArray[this.j];
                while (mapEntry == null) {
                    ++this.j;
                    if (this.j >= mapEntryArray.length) {
                        this.j = 0;
                        ++this.i;
                        continue block0;
                    }
                    mapEntry = mapEntryArray[this.j];
                }
            }
            ++this.numSeen;
            ++this.j;
            return mapEntry;
        }

        public void remove() {
            this.store.remove(this.i, this.j - 1);
            --this.numSeen;
        }
    }

    public class MapEntry {
        private Object key;
        private long value;

        public MapEntry(Object object2, long l) {
            this.key = object2;
            this.value = l;
        }

        public final Object getKey() {
            return this.key;
        }

        public final long getValue() {
            return this.value;
        }

        public final long setValue(long l) {
            long l2 = this.value;
            this.value = l;
            return l2;
        }
    }
}

