/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.internal.util;

import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.base.AbstractDelegatingCursor;
import com.ibm.xml.xci.dp.serialize.SerializedCData;
import com.ibm.xml.xci.internal.util.CopyToResultHelper;
import java.util.Map;
import javax.xml.transform.Result;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PermutedCursor
extends AbstractDelegatingCursor {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    static final Cursor.Profile POSITION_FEATURES = Cursor.Profile.POSITION.union(Cursor.Profile.SIZE).union(Cursor.Profile.TO_POSITION);
    private final Cursor delegate;
    private boolean direct;
    private int position;
    private final int[] permutation;
    private int permutationSize;
    private boolean unique;

    public PermutedCursor(Cursor cursor2, boolean bl, int[] nArray, int n2) {
        this.delegate = cursor2;
        assert (cursor2.contextSize() < Integer.MAX_VALUE) : "Cannot permute a cursor with more than 2147483647 members";
        assert (this.isPermutation(nArray)) : "Permutation is badly formed";
        this.position = 1;
        this.permutation = nArray;
        this.permutationSize = n2;
        this.direct = false;
        this.unique = bl;
        this.toPosition(this.position);
    }

    private boolean isPermutation(int[] nArray) {
        int n2;
        int n3 = this.permutationSize;
        boolean[] blArray = new boolean[n3];
        for (n2 = 1; n2 <= n3; ++n2) {
            int n4 = nArray[n2 - 1];
            if (blArray[n4 - 1]) {
                return false;
            }
            blArray[n4 - 1] = true;
        }
        for (n2 = 1; n2 <= n3; ++n2) {
            if (blArray[nArray[n2 - 1] - 1]) continue;
            return false;
        }
        return true;
    }

    @Override
    protected final Cursor getDelegate() {
        return this.delegate;
    }

    @Override
    protected void navigate() {
        this.direct = true;
    }

    @Override
    public VolatileCData serialize(Map<String, Object> map2) {
        return new SerializedCData(this, map2);
    }

    @Override
    public Cursor fork(boolean bl, Cursor.Profile profile, Cursor.Profile profile2) {
        Cursor cursor2 = super.fork(bl, profile, profile2);
        if (this.direct || bl) {
            return cursor2;
        }
        int[] nArray = new int[this.permutationSize];
        System.arraycopy(this.permutation, 0, nArray, 0, this.permutationSize);
        PermutedCursor permutedCursor = new PermutedCursor(cursor2, this.unique, nArray, this.permutationSize);
        permutedCursor.toPosition(this.position);
        return permutedCursor;
    }

    @Override
    public long contextPosition() {
        return this.direct ? super.contextPosition() : (long)this.position;
    }

    @Override
    public long contextSize() {
        return this.direct ? super.contextSize() : (long)this.permutationSize;
    }

    @Override
    public boolean contextIsLive() {
        return this.direct ? super.contextIsLive() : false;
    }

    @Override
    public boolean contextIsSingleton() {
        return this.direct ? super.contextIsSingleton() : this.permutationSize == 1;
    }

    @Override
    public boolean toNext() {
        return this.direct ? super.toNext() : this.toPosition(this.position + 1);
    }

    @Override
    public boolean toPrevious() {
        return this.direct ? super.toPrevious() : this.toPosition(this.position - 1);
    }

    @Override
    public boolean toPosition(long l) {
        if (this.direct) {
            return super.toPosition(l);
        }
        if (1L <= l && l <= (long)this.permutationSize && this.getDelegate().toPosition(this.permutation[(int)l - 1])) {
            this.position = (int)l;
            return true;
        }
        return false;
    }

    @Override
    public boolean contextIsOrdered(boolean bl) {
        return this.direct ? super.contextIsOrdered(bl) : bl == this.unique;
    }

    @Override
    public Cursor documentOrder(Cursor.Profile profile, Cursor.Profile profile2, boolean bl) {
        if (this.direct) {
            return super.documentOrder(profile, profile2, bl);
        }
        PermutedCursor permutedCursor = bl ? this : this.fork(false, profile, profile2);
        return permutedCursor;
    }

    public boolean copyToResult(Result result2, Map map2, boolean bl, boolean bl2) {
        return this.direct ? super.copyToResult(result2, map2, bl, bl2) : CopyToResultHelper.copyToResult(this, result2, map2, bl, bl2);
    }

    @Override
    public void toLast() {
        if (this.direct) {
            this.toLast();
        } else {
            this.toPosition(this.permutationSize);
        }
    }
}

