/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.internal.util;

import java.io.IOException;
import java.io.InputStream;

public class ReusableInputStream
extends InputStream {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2008. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    protected InputStream is;
    protected long position;
    protected long mark;

    public ReusableInputStream(InputStream inputStream) {
        this.is = inputStream;
        if (!inputStream.markSupported()) {
            throw new UnsupportedOperationException("Input stream marking required");
        }
        inputStream.mark(Integer.MAX_VALUE);
    }

    protected void seek(long l) {
        this.position = l;
    }

    public int read() throws IOException {
        this.is.skip(this.position);
        int n2 = this.is.read();
        ++this.position;
        this.is.reset();
        return n2;
    }

    public int available() throws IOException {
        this.is.skip(this.position);
        int n2 = this.is.available();
        this.is.reset();
        return n2;
    }

    public void close() throws IOException {
    }

    public synchronized void mark(int n2) {
        this.mark = this.position;
    }

    public boolean markSupported() {
        return true;
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        this.is.skip(this.position);
        int n4 = this.is.read(byArray, n2, n3);
        this.position += (long)n4;
        this.is.reset();
        return n4;
    }

    public int read(byte[] byArray) throws IOException {
        this.is.skip(this.position);
        int n2 = this.is.read(byArray);
        this.position += (long)n2;
        this.is.reset();
        return n2;
    }

    public synchronized void reset() throws IOException {
        this.position = this.mark;
    }

    public long skip(long l) throws IOException {
        this.is.skip(this.position);
        long l2 = this.is.skip(l);
        this.position += l2;
        this.is.reset();
        return l2;
    }
}

