/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.internal.util;

import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.CursorFactory;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.values.chars.Chars;
import com.ibm.xml.xci.internal.util.PermutedCursor;
import java.io.IOException;
import java.util.HashMap;

public class SortHelper {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00c2\u00a9 Copyright IBM Corp. 2009, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final Cursor.Profile FIXED_FEATURES = Cursor.Profile.NONE;
    public static final Cursor.Profile NEEDED_FEATURES = Cursor.Profile.POSITION.union(Cursor.Profile.SIZE).union(Cursor.Profile.TO_POSITION).union(Cursor.Profile.MAY_USE_WHILE_FORKED).union(Cursor.Profile.MINIMAL_NAVIGATION).union(Cursor.Profile.IS_BEFORE_NODE).union(Cursor.Profile.IS_SAME_NODE);
    static final Cursor.Profile PIVOT_NEEDED_FEATURES = Cursor.Profile.TO_POSITION.union(Cursor.Profile.MINIMAL_NAVIGATION).union(Cursor.Profile.IS_SAME_NODE);
    static final boolean diagnose = false;
    public static final CompareCallback DOC_ORDER_UNIQUE_COMPARE = new DocOrderCompareCallbackUnique();
    public static final CompareCallback DOC_ORDER_COMPARE = new DocOrderCompareCallbackNotUnique();

    public static Cursor documentOrderSortToSequence(Cursor cursor2, boolean bl, Cursor.Profile profile, Cursor.Profile profile2, boolean bl2) {
        CompareCallback compareCallback = bl ? DOC_ORDER_UNIQUE_COMPARE : DOC_ORDER_COMPARE;
        Cursor cursor3 = bl2 ? cursor2 : cursor2.fork(false, cursor2.profile(), profile2);
        Cursor cursor4 = SortHelper.sort(cursor3, bl, profile, profile2, compareCallback);
        return cursor4;
    }

    public static Cursor sort(Cursor cursor2, boolean bl, Cursor.Profile profile, Cursor.Profile profile2, CompareCallback compareCallback) {
        CursorFactory cursorFactory = cursor2.factory();
        cursor2 = cursorFactory.proxy(cursor2, NEEDED_FEATURES, false, null, null);
        Cursor cursor3 = SortHelper.quicksort(cursor2, bl, compareCallback);
        Cursor cursor4 = cursorFactory.proxy(cursor3, profile, false, null, null);
        return cursor4;
    }

    public static Cursor quicksort(Cursor cursor2, boolean bl, CompareCallback compareCallback) {
        assert (NEEDED_FEATURES.containedIn(cursor2.profile())) : "Attempting to support a cursor with insufficient navigation?!?";
        assert (cursor2.contextSize() < Integer.MAX_VALUE) : "Attempting to sort cursor with more than 2147483647 items?!?";
        int n2 = (int)cursor2.contextSize();
        int[] nArray = new int[n2];
        Cursor cursor3 = cursor2.fork(false, PIVOT_NEEDED_FEATURES, Cursor.Profile.NONE);
        int n3 = SortHelper.fillPermutation(cursor2, cursor3, bl, nArray);
        SortHelper.quicksort(nArray, 0, n3 - 1, cursor2, cursor3, compareCallback);
        cursor3.release();
        return new PermutedCursor(cursor2, bl, nArray, n3);
    }

    private static int fillPermutation(Cursor cursor2, Cursor cursor3, boolean bl, int[] nArray) {
        int n2 = 0;
        int n3 = nArray.length;
        for (int i = 1; i <= n3; ++i) {
            if (bl && !SortHelper.isUnique(cursor2, cursor3, nArray, n2, i)) continue;
            nArray[n2] = i;
            ++n2;
        }
        return n2;
    }

    private static boolean isUnique(Cursor cursor2, Cursor cursor3, int[] nArray, int n2, int n3) {
        if (n2 == 0) {
            return true;
        }
        cursor2.toPosition(n3);
        for (int i = 0; i < n2; ++i) {
            cursor3.toPosition(nArray[i]);
            if (!cursor3.itemIsSameNode(cursor2)) continue;
            return false;
        }
        return true;
    }

    static void quicksort(int[] nArray, int n2, int n3, Cursor cursor2, Cursor cursor3, CompareCallback compareCallback) {
        if (n2 < n3) {
            int n4 = n2 + (n3 - n2 >>> 2);
            n4 = SortHelper.partition(nArray, n2, n3, n4, cursor2, cursor3, compareCallback);
            SortHelper.quicksort(nArray, n2, n4 - 1, cursor2, cursor3, compareCallback);
            SortHelper.quicksort(nArray, n4 + 1, n3, cursor2, cursor3, compareCallback);
        }
    }

    static int partition(int[] nArray, int n2, int n3, int n4, Cursor cursor2, Cursor cursor3, CompareCallback compareCallback) {
        cursor3.toPosition(nArray[n4]);
        SortHelper.swap(nArray, n4, n3);
        int n5 = n2;
        for (int i = n2; i < n3; ++i) {
            cursor2.toPosition(nArray[i]);
            if (compareCallback.compare(cursor2, cursor3) > 0) continue;
            SortHelper.swap(nArray, i, n5++);
        }
        SortHelper.swap(nArray, n5, n3);
        return n5;
    }

    private static void swap(int[] nArray, int n2, int n3) {
        int n4 = nArray[n2];
        nArray[n2] = nArray[n3];
        nArray[n3] = n4;
    }

    private static void serialize(Cursor cursor2) {
        try {
            cursor2 = cursor2.fork(false);
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("omit-xml-declaration", "yes");
            do {
                Cursor cursor3 = cursor2.fork(true);
                cursor3.toSelf();
                VolatileCData volatileCData = cursor3.serialize(hashMap);
                volatileCData.writeEncodedBytesTo(System.out, Chars.UTF8, true);
            } while (cursor2.toNext());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        System.out.println();
    }

    private static void printArray(int[] nArray, int n2) {
        for (int i = 0; i < n2; ++i) {
            System.out.print("[" + nArray[i] + "]");
        }
        System.out.println();
    }

    public static class DocOrderCompareCallbackNotUnique
    implements CompareCallback {
        public int compare(Cursor cursor2, Cursor cursor3) {
            return cursor2.itemIsBeforeNode(cursor3) ? -1 : (cursor2.itemIsSameNode(cursor3) ? 0 : 1);
        }
    }

    public static class DocOrderCompareCallbackUnique
    implements CompareCallback {
        public int compare(Cursor cursor2, Cursor cursor3) {
            return cursor2.itemIsBeforeNode(cursor3) ? -1 : 1;
        }
    }

    public static interface CompareCallback {
        public int compare(Cursor var1, Cursor var2);
    }
}

