/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.internal.util.resources;

import com.ibm.xml.xci.CData;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.NodeTest;
import com.ibm.xml.xci.RequestInfo;
import com.ibm.xml.xci.SessionContext;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.util.copy.Copier;
import com.ibm.xml.xci.dp.util.misc.Stack;
import com.ibm.xml.xci.dp.values.chars.ReaderChars;
import com.ibm.xml.xci.internal.util.resources.BaseResource;
import com.ibm.xml.xci.internal.util.resources.Resource;
import com.ibm.xml.xci.internal.util.resources.XSDGrammarResource;
import com.ibm.xml.xci.util.SimpleKindTest;
import com.ibm.xml.xci.util.SimpleNameTest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLResource
extends BaseResource {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final NodeTest SCHEMA_NODE_TEST = SimpleNameTest.element("http://www.w3.org/2001/XMLSchema", "schema");
    private static final NodeTest TARGET_NS_NODE_TEST = SimpleNameTest.attribute("", "targetNamespace");
    protected String chars;
    protected Cursor content;
    protected Resource[] xsdResources;
    protected Map options;
    protected int loaded;

    public WSDLResource(Source source) {
        super(source);
    }

    protected final boolean isLoaded() {
        return (this.loaded & 1) != 0;
    }

    protected final boolean isXSDLLoaded() {
        return (this.loaded & 2) != 0;
    }

    protected final boolean isContentLLoaded() {
        return (this.loaded & 4) != 0;
    }

    private final Resource loadXSDResources(Cursor cursor2) {
        ArrayList<Cursor> arrayList = new ArrayList<Cursor>();
        this.createSchemaSources(cursor2, new Stack<CData>(), new Stack<CData>(), arrayList);
        if (arrayList.size() > 0) {
            this.fixupImports(arrayList);
            List<Source> list = this.serializeXSDs(arrayList);
            XSDGrammarResource xSDGrammarResource = new XSDGrammarResource(new XSDGrammarResource.MultiSchemaSource(list));
            xSDGrammarResource.load((InputStream)null, this.options);
            return xSDGrammarResource;
        }
        return null;
    }

    private final List<Source> serializeXSDs(List<Cursor> list) {
        ArrayList<Source> arrayList = new ArrayList<Source>(list.size());
        for (int i = list.size() - 1; i >= 0; --i) {
            String string2 = list.get(i).serialize(null).getString(1);
            list.get(i).release();
            arrayList.add(new StreamSource(new StringReader(string2), this.getSystemId() + "#" + i));
        }
        return arrayList;
    }

    private final void fixupImports(List<Cursor> list) {
        Cursor cursor2;
        int n2;
        if (list.size() <= 1) {
            return;
        }
        CData[] cDataArray = new CData[list.size()];
        for (n2 = list.size() - 1; n2 >= 0; --n2) {
            cursor2 = list.get(n2);
            if (cursor2.itemKind() == 9) {
                cursor2.toChildren(SimpleKindTest.ELEMENT);
            }
            if (cursor2.toAttributes(TARGET_NS_NODE_TEST)) {
                cDataArray[n2] = cursor2.itemStringValue().constant(true);
            }
            cursor2.toRoot();
        }
        for (n2 = list.size() - 1; n2 >= 0; --n2) {
            cursor2 = list.get(n2);
            if (cursor2.itemKind() == 9) {
                cursor2.toChildren(SimpleKindTest.ELEMENT);
            }
            if (cursor2.openMutation(Cursor.Area.CHILD)) {
                for (int i = list.size() - 1; i >= 0; --i) {
                    if (n2 == i) continue;
                    cursor2.addElement(Cursor.Area.FIRST_CHILD, cursor2.factory().data("http://www.w3.org/2001/XMLSchema", "import", "xsd", null, false), null);
                    cursor2.toChildren(null);
                    cursor2.addAttribute((VolatileCData)cursor2.factory().data("", "namespace", "", null, false), cDataArray[i]);
                    cursor2.toParent();
                }
                cursor2.closeMutation();
            }
            cursor2.toRoot();
        }
    }

    private final void createSchemaSources(Cursor cursor2, Stack<CData> stack, Stack<CData> stack2, List<Cursor> list) {
        if (SCHEMA_NODE_TEST.test(cursor2)) {
            SessionContext sessionContext = cursor2.factory().getSessionContext();
            Cursor cursor3 = sessionContext.document((Result)null, new RequestInfo(Copier.targetProfile(Cursor.Area.FIRST_CHILD, null).union(Cursor.Profile.DATA_MODEL.union(Cursor.Profile.MINIMAL_MUTATION))));
            Cursor cursor4 = cursor2.fork(true, Copier.sourceProfile(null).union(Cursor.Profile.TO_SELF), Copier.sourceProfile(null).union(Cursor.Profile.TO_SELF));
            cursor4.toSelf();
            Copier.copy(cursor4, cursor3, Cursor.Area.FIRST_CHILD, 0, null);
            if (!stack.isEmpty()) {
                cursor3.toRoot();
                if (cursor3.itemKind() == 9) {
                    cursor3.toChildren(SimpleKindTest.ELEMENT);
                }
                ArrayList<CData> arrayList = null;
                if (cursor3.toNamespaceDecls()) {
                    arrayList = new ArrayList<CData>();
                    do {
                        arrayList.add(cursor3.itemName().constant(true));
                    } while (cursor3.toNext());
                    cursor3.toRoot();
                    if (cursor3.itemKind() == 9) {
                        cursor3.toChildren(SimpleKindTest.ELEMENT);
                    }
                }
                if (cursor3.openMutation(Cursor.Area.ATTRIBUTES)) {
                    for (int i = 0; i < stack.size(); ++i) {
                        CData cData = (CData)stack.get(i);
                        if (arrayList != null && arrayList.contains(cData)) continue;
                        cursor3.addNamespaceNode(cData, (VolatileCData)stack2.get(i), false);
                    }
                    cursor3.closeMutation();
                }
            }
            cursor3.toRoot();
            list.add(cursor3);
        } else {
            Cursor cursor5 = cursor2.fork(true, Cursor.Profile.MINIMAL_NAVIGATION, Cursor.Profile.MINIMAL_NAVIGATION);
            Cursor cursor6 = cursor2.fork(true, Cursor.Profile.MINIMAL_NAVIGATION, Cursor.Profile.MINIMAL_NAVIGATION);
            if (cursor6.toChildren(null)) {
                int n2 = 0;
                if (cursor5.toNamespaceDecls()) {
                    do {
                        if (cursor5.itemName() == null) continue;
                        stack.push(cursor5.itemName().constant(true));
                        stack2.push(cursor5.itemTypedValue().constant(true));
                        ++n2;
                    } while (cursor5.toNext());
                }
                do {
                    this.createSchemaSources(cursor6, stack, stack2, list);
                } while (cursor6.toNext());
                while (n2 != 0) {
                    stack.pop();
                    stack2.pop();
                    --n2;
                }
            }
            cursor6.release();
            cursor5.release();
        }
    }

    @Override
    public String getMediaType() {
        return "application/wsdl+xml";
    }

    @Override
    public Object getContent() {
        if (!this.isContentLLoaded()) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("preserve-param-decl", true);
            SessionContext sessionContext = this.content.factory().getSessionContext();
            this.content = sessionContext.document(new StreamSource(new StringReader(this.chars)), new RequestInfo(Cursor.Profile.RANDOM_ACCESS.union(Cursor.Profile.RANDOM_UPDATE), 0, new String[]{"XLXP", "CACHE"}, hashMap));
            this.loaded |= 4;
        }
        return this.content.fork(false, Cursor.Profile.RANDOM_ACCESS, Cursor.Profile.RANDOM_ACCESS);
    }

    @Override
    public Resource[] getResources(String string2) {
        if (this.isLoaded() && string2.equals("application/xsd+xml") && this.chars != null) {
            if (!this.isXSDLLoaded()) {
                Cursor cursor2 = (Cursor)this.getContent();
                if (cursor2 != null) {
                    Resource resource = this.loadXSDResources(cursor2);
                    if (resource != null) {
                        this.xsdResources = new Resource[1];
                        this.xsdResources[0] = resource;
                    }
                    cursor2.release();
                }
                this.loaded |= 2;
            }
            return this.xsdResources;
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return !this.isLoaded() || this.getContent() == null;
    }

    @Override
    public void load(Reader reader, Map map2) {
        if (!this.isLoaded()) {
            StreamSource streamSource;
            Reader reader2 = reader;
            if (reader2 == null && this.source instanceof StreamSource && (reader2 = (streamSource = (StreamSource)this.source).getReader()) == null) {
                InputStream inputStream = streamSource.getInputStream();
                if (inputStream == null) {
                    try {
                        inputStream = new URL(streamSource.getSystemId()).openStream();
                    }
                    catch (IOException iOException) {
                        inputStream = new ByteArrayInputStream(new byte[0]);
                    }
                }
                reader2 = new InputStreamReader(inputStream);
            }
            if (reader2 != null) {
                this.chars = new ReaderChars(reader2).toString();
            }
            this.loaded |= 1;
            this.options = map2;
        }
    }

    @Override
    public void unload() {
        this.loaded = 0;
        if (this.content != null) {
            this.content.release();
            this.content = null;
        }
        if (this.xsdResources != null) {
            for (Resource resource : this.xsdResources) {
                resource.unload();
            }
            this.xsdResources = null;
        }
    }
}

