/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.internal.util.xml;

import com.ibm.xml.xci.ExtendedNamespaceContext;
import com.ibm.xml.xci.internal.util.xml.JoinedIterator;
import com.ibm.xml.xci.internal.util.xml.SingletonIterator;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleNamespaceContext
implements ExtendedNamespaceContext {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2008. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private final ExtendedNamespaceContext parent;
    private final String prefix;
    private final String uri;

    public SimpleNamespaceContext(ExtendedNamespaceContext extendedNamespaceContext, String string2, String string3) {
        this.parent = extendedNamespaceContext;
        this.prefix = string2;
        this.uri = string3;
    }

    @Override
    public String getNamespaceURI(String string2) {
        if (this.prefix == string2 || this.prefix != null && this.prefix.equals(string2)) {
            return this.uri;
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent.getNamespaceURI(string2);
    }

    @Override
    public String getPrefix(String string2) {
        if (this.uri.equals(string2)) {
            return this.prefix;
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent.getPrefix(string2);
    }

    public Iterator getPrefixes(String string2) {
        SingletonIterator<String> singletonIterator = this.uri.equals(string2) ? new SingletonIterator<String>(this.prefix) : null;
        Iterator<String> iterator = this.parent.getPrefixes(string2);
        if (singletonIterator == null) {
            return iterator;
        }
        if (iterator == null) {
            return singletonIterator;
        }
        return new JoinedIterator<String>(singletonIterator, iterator);
    }

    @Override
    public Iterator<String> getInScopeNamespaces() {
        return new Iter();
    }

    @Override
    public ExtendedNamespaceContext constantENS(boolean bl) {
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Iter
    implements Iterator<String> {
        boolean ns;
        boolean onParent;
        Iterator<String> parentIter;

        protected Iter() {
        }

        @Override
        public boolean hasNext() {
            if (this.onParent) {
                return this.parentIter.hasNext();
            }
            return !this.ns;
        }

        @Override
        public String next() {
            if (this.onParent) {
                return this.parentIter.next();
            }
            if (!this.ns) {
                this.ns = true;
                return SimpleNamespaceContext.this.prefix;
            }
            this.parentIter = SimpleNamespaceContext.this.parent.getInScopeNamespaces();
            if (this.parentIter != null) {
                this.onParent = true;
            }
            return SimpleNamespaceContext.this.uri;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

