/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.internal.util.xml;

import com.ibm.xml.xml4j.api.s1.xs.ElementPSVI;
import com.ibm.xml.xml4j.api.s1.xs.ItemPSVI;
import com.ibm.xml.xml4j.api.s1.xs.StringList;
import com.ibm.xml.xml4j.api.s1.xs.XSComplexTypeDefinition;
import com.ibm.xml.xml4j.api.s1.xs.XSSimpleTypeDefinition;
import com.ibm.xml.xml4j.internal.s1.dom.PSVIElementNSImpl;
import com.ibm.xml.xml4j.internal.s1.impl.dv.XSSimpleType;
import com.ibm.xml.xml4j.internal.s1.impl.xs.ElementPSVImpl;

final class XCIElementPSVI
extends ElementPSVImpl {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2008, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    protected StringList errorCodes;
    protected StringList errorMessages = null;
    private boolean generateErrorLists = false;

    public XCIElementPSVI(ElementPSVI elementPSVI, boolean bl) {
        this.fDeclaration = elementPSVI.getElementDeclaration();
        this.fNil = elementPSVI.getNil();
        this.fNotation = elementPSVI.getNotation();
        this.fSpecified = elementPSVI.getIsSchemaSpecified();
        this.fTypeDecl = elementPSVI.getTypeDefinition();
        if (!(this.fTypeDecl instanceof XSComplexTypeDefinition) || ((XSComplexTypeDefinition)this.fTypeDecl).getContentType() == 1) {
            if (elementPSVI instanceof PSVIElementNSImpl) {
                this.fValue.copyFrom(((PSVIElementNSImpl)elementPSVI).getSchemaValue());
            } else if (elementPSVI instanceof ElementPSVImpl) {
                this.fValue.copyFrom(((ElementPSVImpl)elementPSVI).getSchemaValue());
            } else {
                this.fValue.actualType = this.fTypeDecl instanceof XSSimpleTypeDefinition ? (XSSimpleType)this.fTypeDecl : (XSSimpleType)((XSComplexTypeDefinition)this.fTypeDecl).getSimpleType();
                this.fValue.actualValue = elementPSVI.getActualNormalizedValue();
                this.fValue.actualValueType = elementPSVI.getActualNormalizedValueType();
                this.fValue.itemValueTypes = elementPSVI.getItemValueTypes();
                this.fValue.memberType = (XSSimpleType)elementPSVI.getMemberTypeDefinition();
            }
        } else {
            this.fValue.reset();
        }
        this.fValidationAttempted = elementPSVI.getValidationAttempted();
        this.fValidationContext = elementPSVI.getValidationContext();
        this.fValidity = elementPSVI.getValidity();
        this.errorCodes = elementPSVI.getErrorCodes();
        this.errorMessages = elementPSVI.getErrorMessages();
        if (bl) {
            if (elementPSVI instanceof ElementPSVImpl) {
                ((ElementPSVImpl)elementPSVI).copySchemaInformationTo(this);
            } else {
                this.fSchemaInformation = elementPSVI.getSchemaInformation();
            }
        }
    }

    public StringList getErrorCodes() {
        if (this.generateErrorLists) {
            this.errorCodes = super.getErrorCodes();
            this.errorMessages = super.getErrorMessages();
            this.generateErrorLists = false;
        }
        return this.errorCodes;
    }

    public StringList getErrorMessages() {
        if (this.generateErrorLists) {
            this.errorCodes = super.getErrorCodes();
            this.errorMessages = super.getErrorMessages();
            this.generateErrorLists = false;
        }
        return this.errorMessages;
    }

    public void setValidity(short s) {
        this.fValidity = s;
    }

    public void setErrors(String[] stringArray) {
        this.fErrors = stringArray;
        this.generateErrorLists = true;
    }

    public ItemPSVI constant() {
        return this;
    }

    public boolean isConstant() {
        return true;
    }
}

