/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.internal.values;

import com.ibm.xml.xci.bytes.Bytes;
import com.ibm.xml.xci.bytes.BytesUtils;
import com.ibm.xml.xci.dp.values.chars.EncodeContext;
import com.ibm.xml.xci.dp.values.chars.StringChars;
import com.ibm.xml.xci.errors.XCIDynamicErrorException;
import com.ibm.xml.xci.internal.values.SimpleAsciiCData;
import com.ibm.xml.xci.res.XCIMessages;
import com.ibm.xml.xci.serializer.XOutputWriter;
import com.ibm.xml.xci.type.TypeRegistry;
import com.ibm.xml.xml4j.api.s1.xs.XSSimpleTypeDefinition;
import com.ibm.xml.xml4j.internal.s1.impl.dv.util.Base64;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;

public class Base64BinaryCData
extends SimpleAsciiCData {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final char[] DIGIT2CHAR;
    private static final byte[] CHAR2DIGIT;
    private final Bytes bytes;
    private String text;

    public Base64BinaryCData(Bytes bytes2, XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        this(bytes2, null, xSSimpleTypeDefinition);
    }

    public Base64BinaryCData(Bytes bytes2, String string2, XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        super(xSSimpleTypeDefinition);
        this.bytes = bytes2;
        this.text = string2;
    }

    public Base64BinaryCData(CharSequence charSequence, XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        super(xSSimpleTypeDefinition);
        this.text = StringChars.toString(charSequence);
        byte[] byArray = Base64.decode(this.text);
        if (byArray == null) {
            throw new XCIDynamicErrorException("ER_INVALID_BASE64BINARY", new String[]{this.text});
        }
        this.bytes = BytesUtils.make(byArray);
    }

    public String toString() {
        if (this.text == null) {
            this.text = Base64.encode(this.bytes.toByteArray(false));
        }
        return this.text;
    }

    public Bytes getBase64Binary(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        return this.bytes;
    }

    public boolean hasCharAt(int n2) {
        if (this.text != null) {
            return 0 <= n2 && n2 < this.text.length();
        }
        return this.bytes.hasByteAt(n2 / 4 * 3);
    }

    public CharSequence subSequence(int n2) {
        if (this.text != null) {
            return this.text.subSequence(n2, this.text.length());
        }
        if (n2 % 4 == 0) {
            return new Base64BinaryCData(this.bytes.byteSubSequence(n2 / 4 * 3), this.xstype);
        }
        String string2 = this.toString();
        return string2.subSequence(n2, string2.length());
    }

    public int writeTo(Writer writer, boolean bl) throws IOException {
        if (this.text != null) {
            writer.write(this.text);
            return this.text.length();
        }
        this.text = Base64.encode(this.bytes.toByteArray(false));
        writer.write(this.text);
        return this.text.length();
    }

    public char charAt(int n2) {
        if (this.text != null) {
            return this.text.charAt(n2);
        }
        int n3 = n2 / 4;
        int n4 = n2 % 4;
        int n5 = n3 * 3;
        switch (n4) {
            case 0: {
                byte by2 = this.bytes.byteAt(n5);
                return DIGIT2CHAR[(by2 & 0xFC) >> 2];
            }
            case 1: {
                byte by3 = this.bytes.byteAt(n5);
                byte by4 = this.bytes.hasByteAt(n5 + 1) ? this.bytes.byteAt(n5 + 1) : (byte)0;
                return DIGIT2CHAR[(by3 & 3) << 4 | (by4 & 0xF0) >> 4];
            }
            case 2: {
                if (this.bytes.hasByteAt(n5 + 1)) {
                    byte by5 = this.bytes.byteAt(n5 + 1);
                    byte by6 = this.bytes.hasByteAt(n5 + 2) ? this.bytes.byteAt(n5 + 2) : (byte)0;
                    return DIGIT2CHAR[(by5 & 0xF) << 2 | (by6 & 0xC0) >> 6];
                }
                return '=';
            }
            case 3: {
                if (this.bytes.hasByteAt(n5 + 2)) {
                    byte by7 = this.bytes.byteAt(n5 + 2);
                    return DIGIT2CHAR[by7 & 0x3F];
                }
                return '=';
            }
        }
        return '*';
    }

    public int length() {
        if (this.text != null) {
            return this.text.length();
        }
        return ((int)this.bytes.byteLength() + 2) / 3 * 4;
    }

    public CharSequence subSequence(int n2, int n3) {
        if (this.text != null) {
            return this.text.subSequence(n2, n3);
        }
        if (n2 % 4 == 0 && n3 % 4 == 0) {
            return new Base64BinaryCData(this.bytes.byteSubSequence(n2 / 4 * 3, n3 / 4 * 3), this.xstype);
        }
        return this.toString().subSequence(n2, n3);
    }

    public String getString(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        return this.toString();
    }

    public BigDecimal getBigDecimal(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSDECIMAL.toString()});
    }

    public boolean getBoolean(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSBOOLEAN.toString()});
    }

    public byte getByte(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSBYTE.toString()});
    }

    public double getDouble(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSDOUBLE.toString()});
    }

    public Duration getDuration(int n2) throws ParseException {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSDURATION.toString()});
    }

    public float getFloat(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSFLOAT.toString()});
    }

    public int getInt(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSINT.toString()});
    }

    public long getLong(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSLONG.toString()});
    }

    public QName getQName(int n2, NamespaceContext namespaceContext) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSQNAME.toString()});
    }

    public short getShort(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSSHORT.toString()});
    }

    public URI getURI(int n2) throws URISyntaxException {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSANYURI.toString()});
    }

    public String getURIString(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSANYURI.toString()});
    }

    public XMLGregorianCalendar getXMLGregorianCalendar(int n2) throws ParseException {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSQNAME.toString()});
    }

    public Object getObject(int n2) {
        return this.bytes;
    }

    public Bytes getHexBinary(int n2) {
        return this.bytes;
    }

    public BigInteger getBigInteger(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSINTEGER.toString()});
    }

    public String getQNameLocalPart(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSQNAME.toString()});
    }

    public String getQNameNamespaceURI(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSQNAME.toString()});
    }

    public String getQNamePrefix(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSQNAME.toString()});
    }

    public CharSequence sequenceConstructSimpleContent(CharSequence charSequence, boolean bl, boolean bl2) {
        return this.getString(1);
    }

    public boolean isEmpty() {
        return this.length() == 0;
    }

    public void write(XOutputWriter xOutputWriter, EncodeContext encodeContext, boolean bl) throws IOException {
        xOutputWriter.write(this.toString(), encodeContext);
    }

    public void write(XOutputWriter xOutputWriter, int n2, int n3, EncodeContext encodeContext, boolean bl) throws IOException {
        xOutputWriter.write(this.toString(), n2, n3, encodeContext);
    }

    static {
        int n2;
        DIGIT2CHAR = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        CHAR2DIGIT = new byte[128];
        for (n2 = 0; n2 < 128; ++n2) {
            Base64BinaryCData.CHAR2DIGIT[n2] = -1;
        }
        for (n2 = 0; n2 < 64; ++n2) {
            Base64BinaryCData.CHAR2DIGIT[Base64BinaryCData.DIGIT2CHAR[n2]] = (byte)n2;
        }
        Base64BinaryCData.CHAR2DIGIT[61] = 0;
    }
}

