/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.internal.values;

import com.ibm.xml.xci.CData;
import com.ibm.xml.xci.bytes.Bytes;
import com.ibm.xml.xci.dp.values.chars.Chars;
import com.ibm.xml.xci.dp.values.chars.CharsBase;
import com.ibm.xml.xci.errors.XCIDynamicErrorException;
import com.ibm.xml.xci.internal.cast.CastJV2String;
import com.ibm.xml.xci.internal.values.SimpleAsciiCData;
import com.ibm.xml.xci.res.XCIMessages;
import com.ibm.xml.xci.type.TypeRegistry;
import com.ibm.xml.xml4j.api.s1.xs.XSSimpleTypeDefinition;
import com.ibm.xml.xml4j.internal.s1.impl.dv.InvalidDatatypeValueException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;

public class BooleanCData
extends SimpleAsciiCData {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2008. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final CData XSTRUE = new BooleanCData(true, TypeRegistry.XSBOOLEAN);
    public static final CData XSFALSE = new BooleanCData(false, TypeRegistry.XSBOOLEAN);
    private boolean bool;

    public static final CData toxsboolean(boolean bl) {
        return bl ? XSTRUE : XSFALSE;
    }

    public BooleanCData(boolean bl, XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        super(xSSimpleTypeDefinition);
        this.bool = bl;
    }

    public boolean getBoolean(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        return this.bool;
    }

    public byte getByte(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        return this.bool ? (byte)1 : 0;
    }

    public short getShort(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        return this.bool ? (short)1 : 0;
    }

    public int getInt(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        return this.bool ? 1 : 0;
    }

    public long getLong(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        return this.bool ? 1L : 0L;
    }

    public BigInteger getBigInteger(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        return this.bool ? BigInteger.ONE : BigInteger.ZERO;
    }

    public BigDecimal getBigDecimal(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        return this.bool ? BigDecimal.valueOf(1L) : BigDecimal.valueOf(0L);
    }

    public float getFloat(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        return this.bool ? 1.0f : 0.0f;
    }

    public double getDouble(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        return this.bool ? 1.0 : 0.0;
    }

    protected Chars toChars() {
        return this.bool ? CharsBase.toChars("TRUE") : CharsBase.toChars("FALSE");
    }

    public boolean sameAs(CharSequence charSequence) {
        if (charSequence == null) {
            return false;
        }
        if (charSequence instanceof BooleanCData) {
            return ((BooleanCData)charSequence).bool == this.bool;
        }
        if (charSequence instanceof CData) {
            CData cData = (CData)charSequence;
            return cData.getSize() == 1 && cData.getBoolean(1) == this.bool;
        }
        if (charSequence instanceof Chars) {
            return this.bool ? charSequence.equals("1") || charSequence.equals("true") : charSequence.equals("0") || charSequence.equals("false");
        }
        return this.toString().equals(((Object)charSequence).toString());
    }

    public String toString() {
        return this.bool ? "true" : "false";
    }

    public int hashCode() {
        return this.bool ? 1 : 0;
    }

    public String getString(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        try {
            return CastJV2String.jVToString(this.bool, TypeRegistry.XSSTRING, false);
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            throw new XCIDynamicErrorException(invalidDatatypeValueException);
        }
    }

    public Object getObject(int n2) {
        return this.bool;
    }

    public Duration getDuration(int n2) throws ParseException {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSDURATION.toString()});
    }

    public Bytes getHexBinary(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSHEXBINARY.toString()});
    }

    public QName getQName(int n2, NamespaceContext namespaceContext) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSQNAME.toString()});
    }

    public String getQNameLocalPart(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSQNAME.toString()});
    }

    public String getQNameNamespaceURI(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSQNAME.toString()});
    }

    public String getQNamePrefix(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSQNAME.toString()});
    }

    public URI getURI(int n2) throws URISyntaxException {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSANYURI.toString()});
    }

    public String getURIString(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSANYURI.toString()});
    }

    public XMLGregorianCalendar getXMLGregorianCalendar(int n2) throws ParseException {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSDATETIME.toString()});
    }

    public Bytes getBase64Binary(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSBASE64BINARY.toString()});
    }

    public CharSequence sequenceConstructSimpleContent(CharSequence charSequence, boolean bl, boolean bl2) {
        return this.getString(1);
    }

    public boolean isEmpty() {
        return false;
    }
}

