/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.internal.values;

import com.ibm.xml.xci.CData;
import com.ibm.xml.xci.bytes.Bytes;
import com.ibm.xml.xci.dp.values.chars.EncodeContext;
import com.ibm.xml.xci.errors.XCIDynamicErrorException;
import com.ibm.xml.xci.internal.cast.CastJV2Double;
import com.ibm.xml.xci.internal.cast.CastJV2Float;
import com.ibm.xml.xci.internal.values.IntCData;
import com.ibm.xml.xci.internal.values.SimpleAsciiCData;
import com.ibm.xml.xci.serializer.XOutputWriter;
import com.ibm.xml.xci.type.TypeRegistry;
import com.ibm.xml.xml4j.api.s1.xs.XSSimpleTypeDefinition;
import com.ibm.xml.xml4j.internal.s1.impl.dv.InvalidDatatypeValueException;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;

public class BytesCData
extends SimpleAsciiCData {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    protected final Bytes bytes;

    public BytesCData(Bytes bytes2, XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        super(xSSimpleTypeDefinition);
        this.bytes = bytes2;
    }

    public int getSize() {
        return (int)this.bytes.byteLength();
    }

    public CData itemAt(int n2) {
        if (n2 <= 0 || n2 > this.getSize()) {
            throw new IndexOutOfBoundsException();
        }
        return IntCData.toInt(this.getByte(n2), this.getXSTypeDefinition());
    }

    public String getString(int n2) {
        return Byte.toString(this.getByte(n2));
    }

    public boolean getBoolean(int n2) {
        return this.getByte(n2) != 0;
    }

    public byte getByte(int n2) {
        return this.bytes.byteAt(n2 - 1);
    }

    public short getShort(int n2) {
        return this.getByte(n2);
    }

    public int getInt(int n2) {
        return this.getByte(n2);
    }

    public long getLong(int n2) {
        return this.getByte(n2);
    }

    public BigInteger getBigInteger(int n2) {
        return BigInteger.valueOf(this.getByte(n2));
    }

    public float getFloat(int n2) {
        try {
            return CastJV2Float.jVToFloat(this.getByte(n2), TypeRegistry.XSFLOAT, false);
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            throw new XCIDynamicErrorException(invalidDatatypeValueException);
        }
    }

    public double getDouble(int n2) {
        try {
            return CastJV2Double.jVToDouble(this.getByte(n2), TypeRegistry.XSDOUBLE, false);
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            throw new XCIDynamicErrorException(invalidDatatypeValueException);
        }
    }

    public String toString() {
        int n2 = this.getSize();
        if (n2 == 0) {
            return "";
        }
        if (n2 == 1) {
            return this.getString(1);
        }
        StringBuilder stringBuilder = new StringBuilder(this.getString(1));
        for (int i = 2; i <= n2; ++i) {
            stringBuilder.append(" ");
            stringBuilder.append(this.getString(i));
        }
        return stringBuilder.toString();
    }

    public Object getObject(int n2) {
        return this.getByte(n2);
    }

    public BigDecimal getBigDecimal(int n2) {
        return BigDecimal.valueOf(this.getByte(n2));
    }

    public Bytes getBase64Binary(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSBASE64BINARY.toString()});
    }

    public Bytes getHexBinary(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSHEXBINARY.toString()});
    }

    public QName getQName(int n2, NamespaceContext namespaceContext) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSQNAME.toString()});
    }

    public URI getURI(int n2) throws URISyntaxException {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSANYURI.toString()});
    }

    public String getURIString(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSANYURI.toString()});
    }

    public Duration getDuration(int n2) throws ParseException {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSDURATION.toString()});
    }

    public XMLGregorianCalendar getXMLGregorianCalendar(int n2) throws ParseException {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSDATETIME.toString()});
    }

    public CharSequence lexicalValue() {
        return this.getOriginalLexicalValue() != null ? this.getOriginalLexicalValue() : this.toString();
    }

    public XSSimpleTypeDefinition getXSTypeDefinition(int n2) {
        return super.getXSTypeDefinition().getItemType();
    }

    public void write(XOutputWriter xOutputWriter, EncodeContext encodeContext, boolean bl) throws IOException {
        xOutputWriter.write(this.toString(), encodeContext);
    }

    public void write(XOutputWriter xOutputWriter, int n2, int n3, EncodeContext encodeContext, boolean bl) throws IOException {
        xOutputWriter.write(this.toString(), n2, n3, encodeContext);
    }
}

