/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.internal.values;

import com.ibm.xml.xci.CData;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.values.CDataListBase;
import com.ibm.xml.xml4j.api.s1.xs.XSSimpleTypeDefinition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDataList
extends CDataListBase {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    protected List<CData> list;
    protected String string;

    public CDataList(CData[] cDataArray, XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        super(xSSimpleTypeDefinition);
        this.list = new ArrayList<CData>();
        for (int i = 0; i < cDataArray.length; ++i) {
            this.list.add(cDataArray[i]);
        }
    }

    public CDataList(CData cData) {
        super(cData.getXSTypeDefinition());
        int n2 = cData.getSize();
        this.list = new ArrayList<CData>();
        for (int i = 1; i <= n2; ++i) {
            this.list.add(cData.itemAt(i));
        }
    }

    public CDataList() {
        super(null);
        this.list = new ArrayList<CData>();
    }

    public CDataList(CData cData, XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        super(xSSimpleTypeDefinition);
        this.list = new ArrayList<CData>();
        int n2 = cData.getSize();
        for (int i = 1; i <= n2; ++i) {
            this.list.add(cData.itemAt(i));
        }
    }

    public CDataList(CDataList cDataList, boolean bl) {
        super(cDataList.getXSTypeDefinition());
        if (bl) {
            this.list = new ArrayList<CData>();
            this.list.addAll(cDataList.list);
        } else {
            this.list = cDataList.list;
        }
    }

    @Override
    public int getSize() {
        return this.list.size();
    }

    @Override
    public CData itemAt(int n2) {
        return this.list.get(n2 - 1);
    }

    @Override
    public String getString(int n2) {
        return this.itemAt(n2).getString(1);
    }

    @Override
    public String toString() {
        this.string = super.toString();
        return this.string;
    }

    public boolean add(CData cData) {
        this.string = null;
        long l = cData.getSize();
        int n2 = 1;
        while ((long)n2 <= l) {
            this.list.add(cData.itemAt(n2));
            ++n2;
        }
        return l > 0L;
    }

    public boolean add(VolatileCData volatileCData) {
        this.string = null;
        long l = volatileCData.getSize();
        int n2 = 1;
        while ((long)n2 <= l) {
            this.list.add(volatileCData.itemAt(n2).constant(false));
            ++n2;
        }
        return l > 0L;
    }

    public void add(int n2, CData cData) {
        this.string = null;
        long l = cData.getSize();
        int n3 = 0;
        while ((long)n3 < l) {
            this.list.add(n2 + n3, cData.itemAt(n3 + 1));
            ++n3;
        }
    }

    public void add(long l, VolatileCData volatileCData) {
        this.string = null;
        long l2 = volatileCData.getSize();
        int n2 = 0;
        while ((long)n2 < l2) {
            this.list.add((int)l + n2, volatileCData.itemAt(n2 + 1).constant(false));
            ++n2;
        }
    }

    public boolean addAll(Collection<? extends CData> collection2) {
        this.string = null;
        return this.list.addAll(collection2);
    }

    public boolean addAll(CDataList cDataList) {
        this.string = null;
        return this.list.addAll(cDataList.list);
    }

    public boolean addAll(long l, CDataList cDataList) {
        this.string = null;
        return this.list.addAll((int)l, cDataList.list);
    }

    public boolean addAll(int n2, Collection<? extends CData> collection2) {
        this.string = null;
        return this.list.addAll(n2, collection2);
    }

    public boolean contains(CData cData) {
        return this.list.contains(cData);
    }

    public boolean containsAll(Collection<?> collection2) {
        return this.list.containsAll(collection2);
    }

    public boolean equals(CData cData) {
        return ((Object)this.list).equals(cData);
    }

    public CData get(int n2) {
        return this.list.get(n2);
    }

    public int lastIndexOf(Object object2) {
        return this.list.lastIndexOf(object2);
    }

    public CData remove(int n2) {
        this.string = null;
        return this.list.remove(n2);
    }

    public boolean remove(Object object2) {
        this.string = null;
        return this.list.remove(object2);
    }
}

