/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.internal.values;

import com.ibm.xml.xci.bytes.Bytes;
import com.ibm.xml.xci.dp.type.TypeHelper;
import com.ibm.xml.xci.dp.util.XCIErrorHelper;
import com.ibm.xml.xci.errors.XCIDynamicErrorException;
import com.ibm.xml.xci.internal.cast.CastJV2String;
import com.ibm.xml.xci.internal.values.SimpleAsciiCData;
import com.ibm.xml.xci.res.XCIMessages;
import com.ibm.xml.xci.type.TypeRegistry;
import com.ibm.xml.xml4j.api.s1.xs.XSSimpleTypeDefinition;
import com.ibm.xml.xml4j.internal.s1.impl.dv.InvalidDatatypeValueException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;

public class DoubleCData
extends SimpleAsciiCData {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    static final NumberFormat FORMAT_DECIMAL;
    static final NumberFormat FORMAT_SCIENTIFIC;
    private static final DoubleCData[] table;
    private static final DoubleCData MINUSZERO_XSDOUBLE;
    protected double floating;

    public static DoubleCData toDouble(double d, XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        int n2;
        if (d == 0.0 && TypeHelper.isEqualToBuiltInType(xSSimpleTypeDefinition, TypeRegistry.XSDOUBLE) && 0L != Double.doubleToRawLongBits(d)) {
            return MINUSZERO_XSDOUBLE;
        }
        if (d == (double)((long)d) && (n2 = (int)d + 128) >= 0 && n2 < 256 && TypeHelper.isEqualToBuiltInType(xSSimpleTypeDefinition, TypeRegistry.XSDOUBLE)) {
            DoubleCData doubleCData = table[n2];
            if (doubleCData == null) {
                DoubleCData.table[n2] = doubleCData = new DoubleCData(d, xSSimpleTypeDefinition);
            }
            return doubleCData;
        }
        return new DoubleCData(d, xSSimpleTypeDefinition);
    }

    public DoubleCData(double d, XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        super(xSSimpleTypeDefinition);
        this.floating = d;
    }

    public boolean getBoolean(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        return this.floating != 0.0 && !Double.isNaN(this.floating);
    }

    public byte getByte(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        if (Double.isInfinite(this.floating) || Double.isNaN(this.floating)) {
            throw new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_INVALID_CAST_VALUENOTALLOWED", null));
        }
        if (this.floating >= 128.0 || this.floating <= -129.0) {
            throw XCIErrorHelper.createBadTypeValueException(String.valueOf(this.floating), TypeRegistry.XSBYTE.toString(), null);
        }
        return (byte)this.floating;
    }

    public short getShort(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        if (Double.isInfinite(this.floating) || Double.isNaN(this.floating)) {
            throw new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_INVALID_CAST_VALUENOTALLOWED", null));
        }
        if (this.floating >= 32768.0 || this.floating <= -32769.0) {
            throw XCIErrorHelper.createBadTypeValueException(String.valueOf(this.floating), TypeRegistry.XSSHORT.toString(), null);
        }
        return (short)this.floating;
    }

    public int getInt(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        if (Double.isInfinite(this.floating) || Double.isNaN(this.floating)) {
            throw new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_INVALID_CAST_VALUENOTALLOWED", null));
        }
        if (this.floating >= 2.147483648E9 || this.floating <= -2.147483649E9) {
            throw XCIErrorHelper.createBadTypeValueException(String.valueOf(this.floating), TypeRegistry.XSINT.toString(), null);
        }
        return (int)this.floating;
    }

    public long getLong(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        if (Double.isInfinite(this.floating) || Double.isNaN(this.floating)) {
            throw new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_INVALID_CAST_VALUENOTALLOWED", null));
        }
        if (this.floating >= 9.223372036854776E18 || this.floating <= -9.223372036854776E18) {
            throw XCIErrorHelper.createBadTypeValueException(String.valueOf(this.floating), TypeRegistry.XSLONG.toString(), null);
        }
        return (long)this.floating;
    }

    public BigInteger getBigInteger(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        if (Double.isNaN(this.floating) || Double.isInfinite(this.floating)) {
            throw new XCIDynamicErrorException("ER_INVALID_CAST_VALUENOTALLOWED", new String[0]);
        }
        return new BigDecimal(this.floating).toBigInteger();
    }

    public BigDecimal getBigDecimal(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        if (Double.isNaN(this.floating) || Double.isInfinite(this.floating)) {
            throw new XCIDynamicErrorException("ER_INVALID_CAST_VALUENOTALLOWED", new String[0]);
        }
        return new BigDecimal(this.floating);
    }

    public float getFloat(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        if (Double.isNaN(this.floating)) {
            return Float.NaN;
        }
        if (Double.isInfinite(this.floating)) {
            if (String.valueOf(this.floating).equals("Infinity")) {
                return Float.POSITIVE_INFINITY;
            }
            return Float.NEGATIVE_INFINITY;
        }
        return (float)this.floating;
    }

    public double getDouble(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        return this.floating;
    }

    public XMLGregorianCalendar getXMLGregorianCalendar(int n2) throws ParseException {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSDATETIME.toString()});
    }

    public String toString() {
        return this.getString(1);
    }

    public boolean equals(Object object2) {
        if (object2 instanceof DoubleCData) {
            return this.floating == ((DoubleCData)object2).floating;
        }
        return super.equals(object2);
    }

    public String getString(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        try {
            return CastJV2String.jVToString(this.floating, TypeRegistry.XSSTRING, false);
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            throw new XCIDynamicErrorException(invalidDatatypeValueException);
        }
    }

    public Bytes getBase64Binary(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSBASE64BINARY.toString()});
    }

    public Duration getDuration(int n2) throws ParseException {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSDURATION.toString()});
    }

    public Bytes getHexBinary(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSHEXBINARY.toString()});
    }

    public QName getQName(int n2, NamespaceContext namespaceContext) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSQNAME.toString()});
    }

    public URI getURI(int n2) throws URISyntaxException {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSANYURI.toString()});
    }

    public String getURIString(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSANYURI.toString()});
    }

    public Object getObject(int n2) {
        return this.floating;
    }

    public CharSequence sequenceConstructSimpleContent(CharSequence charSequence, boolean bl, boolean bl2) {
        return this.getString(1);
    }

    public boolean isEmpty() {
        return false;
    }

    static {
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(Locale.ENGLISH);
        FORMAT_DECIMAL = new DecimalFormat("0.####################", decimalFormatSymbols);
        FORMAT_SCIENTIFIC = new DecimalFormat("0.0###################E0", decimalFormatSymbols);
        table = new DoubleCData[256];
        MINUSZERO_XSDOUBLE = new DoubleCData(-0.0, TypeRegistry.XSDOUBLE);
    }
}

