/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.internal.values;

import com.ibm.xml.xci.bytes.Bytes;
import com.ibm.xml.xci.errors.XCIDynamicErrorException;
import com.ibm.xml.xci.internal.cast.CastJV2String;
import com.ibm.xml.xci.internal.values.SimpleAsciiCData;
import com.ibm.xml.xci.res.XCIMessages;
import com.ibm.xml.xci.type.TypeRegistry;
import com.ibm.xml.xml4j.api.s1.xs.XSSimpleTypeDefinition;
import com.ibm.xml.xml4j.internal.s1.impl.dv.InvalidDatatypeValueException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;

public class DurationCData
extends SimpleAsciiCData {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private final Duration duration;

    public DurationCData(Duration duration2, XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        super(xSSimpleTypeDefinition);
        this.duration = duration2;
    }

    public String toString() {
        return this.duration.toString();
    }

    public Duration getDuration(int n2) throws ParseException {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        return this.duration;
    }

    public String getString(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        try {
            return CastJV2String.jVToString(this.duration, TypeRegistry.XSSTRING, false);
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            throw new XCIDynamicErrorException(invalidDatatypeValueException);
        }
    }

    public Bytes getBase64Binary(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSBASE64BINARY.toString()});
    }

    public BigDecimal getBigDecimal(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSDECIMAL.toString()});
    }

    public BigInteger getBigInteger(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSINTEGER.toString()});
    }

    public boolean getBoolean(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSBOOLEAN.toString()});
    }

    public byte getByte(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSBYTE.toString()});
    }

    public double getDouble(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSDOUBLE.toString()});
    }

    public float getFloat(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSFLOAT.toString()});
    }

    public Bytes getHexBinary(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSHEXBINARY.toString()});
    }

    public int getInt(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSINT.toString()});
    }

    public long getLong(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSLONG.toString()});
    }

    public QName getQName(int n2, NamespaceContext namespaceContext) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSQNAME.toString()});
    }

    public short getShort(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSSHORT.toString()});
    }

    public URI getURI(int n2) throws URISyntaxException {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSANYURI.toString()});
    }

    public String getURIString(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSANYURI.toString()});
    }

    public XMLGregorianCalendar getXMLGregorianCalendar(int n2) throws ParseException {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSDATETIME.toString()});
    }

    public Object getObject(int n2) {
        return this.duration;
    }

    public CharSequence sequenceConstructSimpleContent(CharSequence charSequence, boolean bl, boolean bl2) {
        return this.getString(1);
    }

    public boolean isEmpty() {
        return false;
    }
}

