/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.internal.values;

import com.ibm.xml.xci.bytes.Bytes;
import com.ibm.xml.xci.dp.type.TypeHelper;
import com.ibm.xml.xci.dp.util.XCIErrorHelper;
import com.ibm.xml.xci.errors.XCIDynamicErrorException;
import com.ibm.xml.xci.internal.cast.CastJV2String;
import com.ibm.xml.xci.internal.values.SimpleAsciiCData;
import com.ibm.xml.xci.res.XCIMessages;
import com.ibm.xml.xci.type.TypeRegistry;
import com.ibm.xml.xml4j.api.s1.xs.XSSimpleTypeDefinition;
import com.ibm.xml.xml4j.internal.s1.impl.dv.InvalidDatatypeValueException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;

public class FloatCData
extends SimpleAsciiCData {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final FloatCData[] table = new FloatCData[256];
    private static final FloatCData MINUSZERO_XSFLOAT = new FloatCData(-0.0f, TypeRegistry.XSFLOAT);
    protected float floating;

    public static FloatCData toFloat(float f2, XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        int n2;
        if (f2 == 0.0f && TypeHelper.isEqualToBuiltInType(xSSimpleTypeDefinition, TypeRegistry.XSFLOAT) && 0 != Float.floatToRawIntBits(f2)) {
            return MINUSZERO_XSFLOAT;
        }
        if (f2 == (float)((int)f2) && (n2 = (int)f2 + 128) >= 0 && n2 < 256 && TypeHelper.isEqualToBuiltInType(xSSimpleTypeDefinition, TypeRegistry.XSFLOAT)) {
            FloatCData floatCData = table[n2];
            if (floatCData == null) {
                FloatCData.table[n2] = floatCData = new FloatCData(f2, xSSimpleTypeDefinition);
            }
            return floatCData;
        }
        return new FloatCData(f2, xSSimpleTypeDefinition);
    }

    public FloatCData(float f2, XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        super(xSSimpleTypeDefinition);
        this.floating = f2;
    }

    public boolean getBoolean(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        return (double)this.floating != 0.0 && !Float.isNaN(this.floating);
    }

    public byte getByte(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        if (Float.isInfinite(this.floating) || Float.isNaN(this.floating)) {
            throw new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_INVALID_CAST_VALUENOTALLOWED", null));
        }
        if (this.floating >= 128.0f || this.floating <= -129.0f) {
            throw XCIErrorHelper.createBadTypeValueException(String.valueOf(this.floating), TypeRegistry.XSBYTE.toString(), null);
        }
        return (byte)this.floating;
    }

    public short getShort(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        if (Float.isInfinite(this.floating) || Float.isNaN(this.floating)) {
            throw new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_INVALID_CAST_VALUENOTALLOWED", null));
        }
        if (this.floating >= 32768.0f || this.floating <= -32769.0f) {
            throw XCIErrorHelper.createBadTypeValueException(String.valueOf(this.floating), TypeRegistry.XSSHORT.toString(), null);
        }
        return (short)this.floating;
    }

    public int getInt(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        if (Float.isInfinite(this.floating) || Float.isNaN(this.floating)) {
            throw new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_INVALID_CAST_VALUENOTALLOWED", null));
        }
        if (this.floating >= 2.1474836E9f || this.floating <= -2.1474836E9f) {
            throw XCIErrorHelper.createBadTypeValueException(String.valueOf(this.floating), TypeRegistry.XSINT.toString(), null);
        }
        return (int)this.floating;
    }

    public long getLong(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        if (Float.isInfinite(this.floating) || Float.isNaN(this.floating)) {
            throw new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_INVALID_CAST_VALUENOTALLOWED", null));
        }
        if (this.floating >= 9.223372E18f || this.floating <= -9.223372E18f) {
            throw XCIErrorHelper.createBadTypeValueException(String.valueOf(this.floating), TypeRegistry.XSLONG.toString(), null);
        }
        return (long)this.floating;
    }

    public BigInteger getBigInteger(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        try {
            return new BigDecimal(this.floating).toBigInteger();
        }
        catch (NumberFormatException numberFormatException) {
            throw new XCIDynamicErrorException("ER_INVALID_CAST_VALUENOTALLOWED", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSINTEGER.toString()});
        }
    }

    public BigDecimal getBigDecimal(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        try {
            return new BigDecimal(this.floating);
        }
        catch (NumberFormatException numberFormatException) {
            throw new XCIDynamicErrorException("ER_INVALID_CAST_VALUENOTALLOWED", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSINTEGER.toString()});
        }
    }

    public float getFloat(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        return this.floating;
    }

    public double getDouble(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        if (Float.isNaN(this.floating)) {
            return Double.NaN;
        }
        if (Float.isInfinite(this.floating)) {
            if (String.valueOf(this.floating).equals("Infinity")) {
                return Double.POSITIVE_INFINITY;
            }
            return Double.NEGATIVE_INFINITY;
        }
        return this.floating;
    }

    public XMLGregorianCalendar getXMLGregorianCalendar(int n2) throws ParseException {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSDATETIME.toString()});
    }

    public String toString() {
        return this.getString(1);
    }

    public boolean equals(Object object2) {
        if (object2 instanceof FloatCData) {
            return this.floating == ((FloatCData)object2).floating;
        }
        return super.equals(object2);
    }

    public String getString(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        try {
            return CastJV2String.jVToString(this.floating, TypeRegistry.XSSTRING, false);
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            throw new XCIDynamicErrorException(invalidDatatypeValueException);
        }
    }

    public Bytes getBase64Binary(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSBASE64BINARY.toString()});
    }

    public Duration getDuration(int n2) throws ParseException {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSDURATION.toString()});
    }

    public Bytes getHexBinary(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSHEXBINARY.toString()});
    }

    public QName getQName(int n2, NamespaceContext namespaceContext) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSQNAME.toString()});
    }

    public URI getURI(int n2) throws URISyntaxException {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSANYURI.toString()});
    }

    public String getURIString(int n2) {
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{this.getXSTypeDefinition().toString(), TypeRegistry.XSANYURI.toString()});
    }

    public Object getObject(int n2) {
        return Float.valueOf(this.floating);
    }

    public CharSequence sequenceConstructSimpleContent(CharSequence charSequence, boolean bl, boolean bl2) {
        return this.getString(1);
    }

    public boolean isEmpty() {
        return false;
    }
}

