/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.internal.values;

import com.ibm.xml.xapi.copyright.Copyright;
import com.ibm.xml.xci.CData;
import com.ibm.xml.xci.bytes.Bytes;
import com.ibm.xml.xci.bytes.BytesUtils;
import com.ibm.xml.xci.dp.values.LazyBaseCData;
import com.ibm.xml.xci.dp.values.TypedValueHelper;
import com.ibm.xml.xci.errors.XCIDynamicErrorException;
import com.ibm.xml.xci.internal.values.Base64BinaryCData;
import com.ibm.xml.xci.res.XCIMessages;
import com.ibm.xml.xci.spi.config.AttachmentContent;
import com.ibm.xml.xci.spi.config.PathComputer;
import com.ibm.xml.xci.spi.config.XMLAttachmentUnmarshaller;
import com.ibm.xml.xml4j.api.s1.xs.XSSimpleTypeDefinition;
import com.ibm.xml.xml4j.internal.s1.impl.dv.util.Base64;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

@Copyright(value="Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2011. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.")
public final class MTOMCData
extends LazyBaseCData {
    private final XSSimpleTypeDefinition xstype;
    private final String contentID;
    private final XMLAttachmentUnmarshaller xmlAU;
    private AttachmentContent ac;
    private byte[] content;
    private String lexical;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final AttachmentContent EMPTY_MTOM = new EMPTY_MTOM();

    public MTOMCData(XMLAttachmentUnmarshaller xMLAttachmentUnmarshaller, String string2, XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        this.contentID = string2;
        this.xmlAU = xMLAttachmentUnmarshaller;
        this.xstype = xSSimpleTypeDefinition;
    }

    private AttachmentContent getMTOM(PathComputer pathComputer) {
        if (this.ac == null) {
            this.ac = this.xmlAU.resolveAttachment(this.contentID, pathComputer);
            if (this.ac == null) {
                this.ac = EMPTY_MTOM;
            }
        }
        return this.ac;
    }

    private byte[] getByteContent() {
        if (this.content == null) {
            this.content = this.getMTOM(null).getContent();
        }
        return this.content;
    }

    private String getLexical() {
        if (this.lexical == null) {
            this.lexical = Base64.encode(this.getByteContent());
        }
        return this.lexical;
    }

    public void resolveMTOM(PathComputer pathComputer) {
        this.getMTOM(pathComputer);
    }

    public AttachmentContent getMTOM() {
        return this.getMTOM(null);
    }

    public XSSimpleTypeDefinition getXSTypeDefinition() {
        return this.xstype;
    }

    protected CData parse() {
        if (this.xstype.getBuiltInKind() == 17) {
            Bytes bytes2 = this.content == null ? new MTOMBytes(this.getMTOM(null)) : BytesUtils.make(this.content);
            this.typedValue = new Base64BinaryCData(bytes2, this.lexical, this.xstype);
            return this.typedValue;
        }
        String string2 = this.getLexical();
        switch (this.xstype.getVariety()) {
            case 1: {
                return TypedValueHelper.parseAtom(string2, this.xstype, null, false);
            }
            case 2: {
                return TypedValueHelper.parseList(string2, this.xstype, null, false);
            }
            case 3: {
                return TypedValueHelper.parseUnion(string2, this.xstype, null, false);
            }
        }
        throw new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_UNRECOGNIZED_VARIETY", null));
    }

    public CharSequence getOriginalLexicalValue() {
        return this.getLexical();
    }

    public boolean isEmpty() {
        return this.getByteContent().length == 0;
    }

    public int length() {
        int n2 = this.getByteContent().length;
        return (n2 + 2) / 3 * 4;
    }

    public boolean isSpace() {
        return this.length() == 0;
    }

    @Copyright(value="Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2011. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.")
    private static final class EMPTY_MTOM
    implements AttachmentContent {
        private EMPTY_MTOM() {
        }

        public byte[] getContent() {
            return EMPTY_BYTE_ARRAY;
        }
    }

    private static class MTOMBytes
    implements Bytes {
        private final AttachmentContent mtom;
        private Bytes delegate;

        private MTOMBytes(AttachmentContent attachmentContent) {
            this.mtom = attachmentContent;
        }

        private void makeDelegate() {
            if (this.delegate == null) {
                this.delegate = BytesUtils.make(this.mtom.getContent());
            }
        }

        public boolean hasByteAt(long l) {
            this.makeDelegate();
            return this.delegate.hasByteAt(l);
        }

        public byte byteAt(long l) {
            this.makeDelegate();
            return this.delegate.byteAt(l);
        }

        public long byteLength() {
            this.makeDelegate();
            return this.delegate.byteLength();
        }

        public void discardBytesUpto(long l) {
            this.makeDelegate();
            this.delegate.discardBytesUpto(l);
        }

        public Bytes byteSubSequence(long l, long l2) {
            this.makeDelegate();
            return this.delegate.byteSubSequence(l, l2);
        }

        public Bytes byteSubSequence(long l) {
            this.makeDelegate();
            return this.delegate.byteSubSequence(l);
        }

        public void writeBytesTo(OutputStream outputStream, boolean bl) throws IOException {
            this.makeDelegate();
            this.delegate.writeBytesTo(outputStream, bl);
        }

        public int writeBytesTo(int n2, byte[] byArray, int n3, boolean bl) {
            this.makeDelegate();
            return this.delegate.writeBytesTo(n2, byArray, n3, bl);
        }

        public void writeBytesTo(ByteBuffer byteBuffer, boolean bl) {
            this.makeDelegate();
            this.delegate.writeBytesTo(byteBuffer, bl);
        }

        public InputStream toInputStream(boolean bl) {
            this.makeDelegate();
            return this.delegate.toInputStream(bl);
        }

        public byte[] toByteArray(boolean bl) {
            this.makeDelegate();
            return this.delegate.toByteArray(bl);
        }

        public ByteBuffer toByteBuffer(boolean bl) {
            this.makeDelegate();
            return this.delegate.toByteBuffer(bl);
        }

        public boolean equals(Object object2) {
            this.makeDelegate();
            return ((Object)this.delegate).equals(object2);
        }

        public int hashCode() {
            this.makeDelegate();
            return ((Object)this.delegate).hashCode();
        }
    }
}

