/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.internal.values;

import com.ibm.xml.xci.errors.XCIDynamicErrorException;
import com.ibm.xml.xci.internal.cast.CastJV2String;
import com.ibm.xml.xci.internal.values.QNameCDataAbstract;
import com.ibm.xml.xci.res.XCIMessages;
import com.ibm.xml.xci.type.TypeRegistry;
import com.ibm.xml.xml4j.api.s1.xs.XSSimpleTypeDefinition;
import com.ibm.xml.xml4j.internal.s1.impl.dv.InvalidDatatypeValueException;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;

public class QNameCData
extends QNameCDataAbstract {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    protected QName name;
    protected XSSimpleTypeDefinition xstype;

    public QNameCData(QName qName, XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        this.xstype = xSSimpleTypeDefinition;
        this.name = qName;
    }

    public QNameCData(XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        this.xstype = xSSimpleTypeDefinition;
        this.name = null;
    }

    protected QNameCData(NamespaceContext namespaceContext, QName qName, XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        this.xstype = xSSimpleTypeDefinition;
        this.name = qName;
        String string2 = qName.getNamespaceURI();
        String string3 = qName.getPrefix();
        if (string2 != null && !"".equals(string2)) {
            if (string3 == null) {
                string3 = namespaceContext.getPrefix(string2);
            } else {
                boolean bl = false;
                Iterator<String> iterator = namespaceContext.getPrefixes(string2);
                while (!bl && iterator.hasNext()) {
                    String string4 = iterator.next();
                    if (!string4.equals(string3)) continue;
                    bl = true;
                }
                assert (bl) : "Cannot find a suitable prefix for the namespace " + string2;
            }
        }
    }

    public QName getQName(int n2, NamespaceContext namespaceContext) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        return this.name;
    }

    public String getQNameLocalPart(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        return this.name.getLocalPart();
    }

    public String getQNameNamespaceURI(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        return this.name.getNamespaceURI();
    }

    public String getQNamePrefix(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        return this.name.getPrefix();
    }

    public CharSequence getOriginalLexicalValue() {
        if (this.name != null) {
            String string2 = this.name.getPrefix();
            return string2 == null || "".equals(string2) ? this.name.getLocalPart() : string2 + ":" + this.name.getLocalPart();
        }
        String string3 = this.getQNamePrefix(1);
        return string3 == null || "".equals(string3) ? this.getQNameLocalPart(1) : string3 + ":" + this.getQNameLocalPart(1);
    }

    public String getString(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        try {
            return CastJV2String.jVToString(this.name, TypeRegistry.XSSTRING, false);
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            throw new XCIDynamicErrorException(invalidDatatypeValueException);
        }
    }

    protected QName getQName() {
        return this.name;
    }

    public XSSimpleTypeDefinition getXSTypeDefinition() {
        return this.xstype;
    }
}

