/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.serializer;

import com.ibm.xml.xci.CursorFactory;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.serialize.AbstractSerializeCursor;
import com.ibm.xml.xci.serializer.ElemContext;
import com.ibm.xml.xci.serializer.Messages;
import com.ibm.xml.xci.serializer.NamespaceMappings;
import com.ibm.xml.xci.serializer.SerializerCursorFactory;
import java.util.Map;

public abstract class AbstractSerializeCommon
extends AbstractSerializeCursor {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2008, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    protected ElemContext m_elemContext = new ElemContext();
    protected final NamespaceMappings m_prefixMap = new NamespaceMappings();

    public AbstractSerializeCommon(CursorFactory cursorFactory, Map map2) {
        super(cursorFactory, map2);
    }

    public AbstractSerializeCommon(CursorFactory cursorFactory) {
        super(cursorFactory);
    }

    public final String getPrefixOfNSHandle(int n2) {
        NamespaceMappings.MappingRecord mappingRecord = this.m_prefixMap.lookupNamespace(n2);
        String string2 = mappingRecord.get_prefix();
        return string2;
    }

    final String getURIOfNSHandle(int n2) {
        NamespaceMappings.MappingRecord mappingRecord = this.m_prefixMap.lookupNamespace(n2);
        String string2 = mappingRecord.get_uri();
        return string2;
    }

    public final void pushNamespaceContext() {
        if (SerializerCursorFactory.TRACE_SER_API) {
            this.dbgTrace(".pushNamespaceContext(); called");
        }
        this.m_elemContext = this.m_elemContext.push(null, null, null);
    }

    public final void popNamespaceContext() {
        if (SerializerCursorFactory.TRACE_SER_API) {
            this.dbgTrace(".popNamespaceContext(); called");
        }
        int n2 = this.m_elemContext.get_elemDepth();
        this.m_elemContext = this.m_elemContext.pop();
        this.m_prefixMap.popNamespaces(n2, null);
    }

    protected int declareNS(String string2, String string3, boolean bl) {
        int n2;
        int n3;
        if (SerializerCursorFactory.TRACE_SER_API) {
            String string4 = ".declareNS('" + string2 + "', '" + string3 + "', " + bl + "); called";
            this.dbgTrace(string4);
        }
        if ((n3 = this.m_prefixMap.pushNamespace(string3, string2, n2 = this.m_elemContext.get_elemDepth(), bl)) >= 0) {
            this.m_elemContext.addNamespaceNode(n3);
        }
        if (SerializerCursorFactory.TRACE_SER_API) {
            String string5 = ".declareNS('" + string2 + "', '" + string3 + "', " + bl + "); returns index:" + n3;
            this.dbgTrace(string5);
        }
        return n3;
    }

    protected final int toHandle(String string2) {
        NamespaceMappings.MappingRecord mappingRecord = this.m_prefixMap.lookupPrefix(string2);
        int n2 = mappingRecord == null ? -1 : mappingRecord.get_index();
        if (SerializerCursorFactory.TRACE_SER_API) {
            String string3 = ".toHandle('" + string2 + "'); called, returns index: " + n2;
            this.dbgTrace(string3);
        }
        return n2;
    }

    protected final int toHandleFromPrefix(String string2) {
        NamespaceMappings.MappingRecord mappingRecord = this.m_prefixMap.getMappingFromPrefix(string2);
        int n2 = mappingRecord == null ? -1 : mappingRecord.get_index();
        return n2;
    }

    protected final NamespaceMappings.MappingRecord lookupPrefix(String string2) {
        return this.m_prefixMap.getMappingFromPrefix(string2);
    }

    protected void declarePrefix(int n2, String string2, boolean bl) {
    }

    protected void dbgTrace(String string2) {
        int n2 = this.m_elemContext.get_elemDepth();
        for (int i = 1; i < n2; ++i) {
            System.err.print("  ");
        }
        System.err.println("TRACE_SER_API: XMLStreamCursor" + string2);
    }

    public final void unimplemented(String string2) {
        String string3 = Messages.createMessage2("ER_UNIMPLEMENTED_METHOD", new String[]{string2, this.getClass().getName()});
        Messages.xciDynamicErrorException(string3);
    }

    public final VolatileCData itemValue() {
        this.unimplemented("itemValue");
        return null;
    }

    public final boolean toNext() {
        return true;
    }
}

