/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.serializer;

import com.ibm.xml.xci.serializer.EntitiesTable;
import java.util.HashMap;

final class CharInfo {
    private HashMap m_charToString;
    static final char S_HORIZONAL_TAB = '\t';
    static final char S_LINEFEED = '\n';
    static final char S_CARRIAGERETURN = '\r';
    static final char S_SPACE = ' ';
    static final char S_QUOTE = '\"';
    static final char S_LT = '<';
    static final char S_GT = '>';
    static final char S_NEL = '\u0085';
    static final char S_LINE_SEPARATOR = '\u2028';
    static final char S_NBSP = '\u00a0';
    private static final int ASCII_MAX = 128;
    private final boolean[] shouldMapAttrChar_ASCII;
    private final boolean[] shouldMapTextChar_ASCII;
    private final int[] array_of_bits = this.createEmptySetOfIntegers(65535);
    private static final int SHIFT_PER_WORD = 5;
    private static final int LOW_ORDER_BITMASK = 31;
    private int firstWordNotUsed = 0;
    private boolean onlyStandardEntities;

    private CharInfo() {
        this.shouldMapAttrChar_ASCII = new boolean[128];
        this.shouldMapTextChar_ASCII = new boolean[128];
    }

    private CharInfo(String string2, String string3) {
        this();
        this.m_charToString = new HashMap();
        int[] nArray = null;
        String[] stringArray = null;
        this.setOnlyStandardEntities(true);
        if ("html".equals(string3)) {
            nArray = EntitiesTable.getHTMLCodePoints();
            stringArray = EntitiesTable.getHTMLEntities();
        } else if ("xml".equals(string3) || "xhtml".equals(string3)) {
            nArray = EntitiesTable.getXMLCodePoints();
            stringArray = EntitiesTable.getXMLEntities();
        }
        if (nArray != null && stringArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                String string4 = stringArray[i];
                int n2 = nArray[i];
                this.defineChar2StringMapping(string4, (char)n2);
            }
        }
        if ("xml".equals(string3) || "xhtml".equals(string3)) {
            this.shouldMapTextChar_ASCII[34] = false;
        }
        if ("html".equals(string3)) {
            this.shouldMapAttrChar_ASCII[60] = false;
            this.shouldMapTextChar_ASCII[34] = false;
        }
    }

    private void setOnlyStandardEntities(boolean bl) {
        this.onlyStandardEntities = bl;
    }

    boolean getOnlyStandardEntities() {
        return this.onlyStandardEntities;
    }

    private void defineEntity(String string2, char c) {
        StringBuilder stringBuilder = new StringBuilder("&");
        stringBuilder.append(string2);
        stringBuilder.append(';');
        String string3 = stringBuilder.toString();
        this.defineChar2StringMapping(string3, c);
    }

    String getOutputStringForChar(int n2, CharKey charKey) {
        charKey.setChar(n2);
        return (String)this.m_charToString.get(charKey);
    }

    final boolean shouldMapAttrChar(int n2) {
        if (n2 < 128) {
            return this.shouldMapAttrChar_ASCII[n2];
        }
        return this.get(n2);
    }

    final boolean shouldMapTextChar(int n2) {
        if (n2 < 128) {
            return this.shouldMapTextChar_ASCII[n2];
        }
        return this.get(n2);
    }

    static CharInfo getCharInfo(String string2, String string3) {
        return new CharInfo(string2, string3);
    }

    private static int arrayIndex(int n2) {
        return n2 >> 5;
    }

    private int[] createEmptySetOfIntegers(int n2) {
        this.firstWordNotUsed = 0;
        int[] nArray = new int[CharInfo.arrayIndex(n2 - 1) + 1];
        return nArray;
    }

    private final void set(int n2) {
        this.setASCIItextDirty(n2);
        this.setASCIIattrDirty(n2);
        int n3 = n2 >> 5;
        int n4 = n3 + 1;
        if (this.firstWordNotUsed < n4) {
            this.firstWordNotUsed = n4;
        }
        int n5 = n3;
        this.array_of_bits[n5] = this.array_of_bits[n5] | 1 << (n2 & 0x1F);
    }

    private final boolean get(int n2) {
        boolean bl = false;
        int n3 = n2 >> 5;
        if (n3 < this.firstWordNotUsed) {
            bl = (this.array_of_bits[n3] & 1 << (n2 & 0x1F)) != 0;
        }
        return bl;
    }

    private void setASCIItextDirty(int n2) {
        if (0 <= n2 && n2 < 128) {
            this.shouldMapTextChar_ASCII[n2] = true;
        }
    }

    private void setASCIIattrDirty(int n2) {
        if (0 <= n2 && n2 < 128) {
            this.shouldMapAttrChar_ASCII[n2] = true;
        }
    }

    private void defineChar2StringMapping(String string2, int n2) {
        CharKey charKey = new CharKey(n2);
        this.m_charToString.put(charKey, string2);
        this.set(n2);
    }

    static class CharKey {
        private int m_char;

        public CharKey(int n2) {
            this.m_char = n2;
        }

        public CharKey() {
        }

        public final void setChar(int n2) {
            this.m_char = n2;
        }

        public final int hashCode() {
            return this.m_char;
        }

        public final boolean equals(Object object2) {
            return ((CharKey)object2).m_char == this.m_char;
        }
    }
}

