/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.serializer;

import com.ibm.xml.xci.serializer.CharEscapeMaps;
import com.ibm.xml.xci.serializer.Int2StringHashMap;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CodepointMappings {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private boolean m_hasMappings = false;
    private final Int2StringHashMap m_codepointToString;
    private int m_low = -1;
    private int m_high = -1;
    static final int ASCII_MAX = 127;
    static final int CHAR_ESCAPE_MAP_MAX = CharEscapeMaps.getTableSize();
    private final String[] m_ByteSizeMappings = new String[CHAR_ESCAPE_MAP_MAX + 1];
    private final List<String> useCharacterMapsValues;
    Vector<Integer> codePointsMapped;

    public CodepointMappings(List<String> list) {
        this.m_codepointToString = new Int2StringHashMap(256);
        this.useCharacterMapsValues = list;
        this.codePointsMapped = new Vector();
    }

    public CodepointMappings() {
        this.m_codepointToString = new Int2StringHashMap(256);
        this.useCharacterMapsValues = null;
        this.codePointsMapped = new Vector();
    }

    public final List<String> getUseCharacterMapsValues() {
        return this.useCharacterMapsValues;
    }

    public boolean hasByteSizeMappings() {
        return this.m_hasMappings && this.m_low < CHAR_ESCAPE_MAP_MAX;
    }

    String getString(int n2) {
        if (n2 < this.m_low || n2 > this.m_high) {
            return null;
        }
        if (n2 <= CHAR_ESCAPE_MAP_MAX) {
            return this.m_ByteSizeMappings[n2];
        }
        return this.m_codepointToString.get(n2);
    }

    public void setString(int n2, String string2) {
        this.recordCodePointMapped(n2);
        if (n2 <= CHAR_ESCAPE_MAP_MAX) {
            this.m_ByteSizeMappings[n2] = string2;
        } else {
            this.m_codepointToString.put(n2, string2);
        }
        if (this.m_low == -1 && this.m_high == -1) {
            this.m_low = this.m_high = n2;
        } else if (n2 > this.m_high) {
            this.m_high = n2;
        } else if (n2 < this.m_low) {
            this.m_low = n2;
        }
        this.m_hasMappings = true;
    }

    private void recordCodePointMapped(int n2) {
        int n3 = this.codePointsMapped.size() - 1;
        boolean bl = false;
        for (int i = n3; i >= 0; --i) {
            int n4 = this.codePointsMapped.get(i);
            if (n2 > n4) {
                this.codePointsMapped.insertElementAt(n2, i + 1);
                bl = true;
                break;
            }
            if (n2 != n4) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.codePointsMapped.insertElementAt(n2, 0);
        }
    }

    public List<Integer> getCodePointsMapped() {
        return this.codePointsMapped;
    }

    public boolean hasMappings() {
        return this.m_hasMappings;
    }

    public void reset() {
        for (int i = 0; i <= CHAR_ESCAPE_MAP_MAX; ++i) {
            this.m_ByteSizeMappings[i] = null;
        }
        this.m_codepointToString.clear();
        this.m_hasMappings = false;
        this.m_high = -1;
        this.m_low = -1;
    }
}

