/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.serializer;

import com.ibm.xml.xci.serializer.EncodingInfo;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;

public final class Encodings {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2008. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String[] stateless_endcogings = new String[]{"ASCII", "ASCII,US-ASCII", "EUC-KR", "EUC-KR", "EUC_KR", "EUC-KR", "ISO8859-1", "ISO-8859-1", "ISO8859_1", "ISO-8859-1", "8859-1", "ISO-8859-1", "8859_1", "ISO-8859-1", "ISO8859-2", "ISO-8859-2", "ISO8859_2", "ISO-8859-2", "8859-2", "ISO-8859-2", "8859_2", "ISO-8859-2", "ISO8859-3", "ISO-8859-3", "ISO8859_3", "ISO-8859-3", "8859-3", "ISO-8859-3", "8859_3", "ISO-8859-3", "ISO8859-4", "ISO-8859-4", "ISO8859_4", "ISO-8859-4", "8859-4", "ISO-8859-4", "8859_4", "ISO-8859-4", "ISO8859-5", "ISO-8859-5", "ISO8859_5", "ISO-8859-5", "8859-5", "ISO-8859-5", "8859_5", "ISO-8859-5", "ISO8859-6", "ISO-8859-6", "ISO8859_6", "ISO-8859-6", "8859-6", "ISO-8859-6", "8859_6", "ISO-8859-6", "ISO8859-7", "ISO-8859-7", "ISO8859_7", "ISO-8859-7", "8859-7", "ISO-8859-7", "8859_7", "ISO-8859-7", "ISO8859-8", "ISO-8859-8", "ISO8859_8", "ISO-8859-8", "8859-8", "ISO-8859-8", "8859_8", "ISO-8859-8", "ISO8859-9", "ISO-8859-9", "ISO8859_9", "ISO-8859-9", "8859-9", "ISO-8859-9", "8859_9", "ISO-8859-9", "ISO8859-10", "ISO-8859-10", "ISO8859_10", "ISO-8859-10", "ISO8859-11", "ISO-8859-11", "ISO8859_11", "ISO-8859-11", "ISO8859-12", "ISO-8859-12", "ISO8859_12", "ISO-8859-12", "ISO8859-13", "ISO-8859-13", "ISO8859_13", "ISO-8859-13", "ISO8859-14", "ISO-8859-14", "ISO8859_14", "ISO-8859-14", "ISO8859-15", "ISO-8859-15", "ISO8859_15", "ISO-8859-15"};
    private static final String[] stateful_endcogings = new String[]{"Big5", "BIG5,csBig5", "Big5_HKSCS", "BIG5-HKSCS", "Cp037", "EBCDIC-CP-US,EBCDIC-CP-CA,EBCDIC-CP-WT,EBCDIC-CP-NL,IBM037", "Cp273", "IBM273,csIBM273", "Cp274", "csIBM274,EBCDIC-BE", "Cp275", "csIBM275,EBCDIC-BR", "Cp277", "EBCDIC-CP-DK,EBCDIC-CP-NO,IBM277,csIBM277", "Cp278", "EBCDIC-CP-FI,EBCDIC-CP-SE,IBM278,csIBM278", "Cp280", "EBCDIC-CP-IT,IBM280,csIBM280", "Cp281", "EBCDIC-JP-E,csIBM281", "Cp284", "EBCDIC-CP-ES,IBM284,csIBM284", "Cp285", "EBCDIC-CP-GB,IBM284,csIBM285", "Cp290", "EBCDIC-JP-kana,IBM290,csIBM290", "Cp297", "EBCDIC-CP-FR,IBM297,csIBM297", "Cp420", "EBCDIC-CP-AR1,IBM420,csIBM420", "Cp423", "EBCDIC-CP-GR,IBM423,csIBM423", "Cp424", "EBCDIC-CP-HE,IBM424,csIBM424", "Cp437", "437,IBM437,csPC8CodePage437", "Cp500", "EBCDIC-CP-CH,EBCDIC-CP-BE,IBM500,csIBM500", "Cp775", "IBM775,csPC775Baltic", "Cp838", "IBM-Thai,838,csIBMThai", "Cp850", "850,csPC850Multilingual,IBM850", "Cp851", "851,IBM851,csIBM851", "Cp852", "IBM852,852,csPCp852", "Cp855", "IBM855,855,csIBM855", "Cp857", "IBM857,857,csIBM857", "Cp858", "IBM00858", "Cp860", "860,csIBM860,IBM860", "Cp861", "IBM861,861,csIBM861,cp-is", "Cp862", "IBM862,862,csPCi62LatinHebrew", "Cp863", "IBM863,863,csIBM863", "Cp864", "IBM864,864,csIBM864", "Cp865", "IBM865,865,csIBM865", "Cp866", "IBM866,866,csIBM866", "Cp868", "IBM868,cp-ar,csIBM868", "Cp869", "IBM869,869,cp-gr,csIBM869", "Cp870", "EBCDIC-CP-ROECE,EBCDIC-CP-YU,IBM870,csIBM870", "Cp871", "EBCDIC-CP-IS,IBM871,csIBM871", "Cp880", "EBCDIC-Cyrillic,IBM880,csIBM880", "Cp891", "IBM891,csIBM891", "Cp903", "IBM903,csIBM903", "Cp904", "IBM904,csIBM904", "Cp905", "IBM905,csIBM905,EBCDIC-CP-TR", "Cp918", "EBCDIC-CP-AR2,IBM918,csIBM918", "Cp936", "GBK,MS936,WINDOWS-936", "Cp1026", "IBM1026,csIBM1026", "Cp1047", "IBM1047,IBM-1047", "Cp1140", "IBM01140", "Cp1141", "IBM01141", "Cp1142", "IBM01142", "Cp1143", "IBM01143", "Cp1144", "IBM01144", "Cp1145", "IBM01145", "Cp1146", "IBM01146", "Cp1147", "IBM01147", "Cp1148", "IBM01148", "Cp1149", "IBM01149", "Cp1250", "WINDOWS-1250", "Cp1251", "WINDOWS-1251", "Cp1252", "WINDOWS-1252", "Cp1253", "WINDOWS-1253", "Cp1254", "WINDOWS-1254", "Cp1255", "WINDOWS-1255", "Cp1256", "WINDOWS-1256", "Cp1257", "WINDOWS-1257", "Cp1258", "WINDOWS-1258", "EUC-CN", "EUC-CN", "EUC_CN", "EUC-CN", "EUC-JP", "EUC-JP", "EUC_JP", "EUC-JP", "EUC-TW", "EUC-TW", "EUC_TW", "EUC-TW,x-EUC-TW", "EUCJIS", "EUC-JP", "GB2312", "GB2312", "ISO2022CN", "ISO-2022-CN", "ISO2022JP", "ISO-2022-JP", "ISO2022KR", "ISO-2022-KR", "GB18030", "GB18030", "UTF8", "UTF-8", "Unicode", "UNICODE,UTF-16", "UnicodeBig", "UTF-16BE", "UnicodeLittle", "UTF-16LE", "JIS", "ISO-2022-JP", "CKOI8_R", "KOI8-R", "KSC5601", "EUC-KR", "KS_C_5601-1987", "KS_C_5601-1987,iso-ir-149,KS_C_5601-1989,KSC_5601,csKSC56011987", "MacTEC", "MacRoman", "MS932", "windows-31j", "SJIS", "SHIFT_JIS", "TIS620", "TIS-620"};
    static final String DEFAULT_MIME_ENCODING = "UTF-8";
    private static final Hashtable<String, EncodingInfo> _encodingTableKeyJava = new Hashtable();
    private static final Hashtable<String, EncodingInfo> _encodingTableKeyMime = new Hashtable();
    private static final EncodingInfo[] _encodings = Encodings.loadEncodingInfo();

    static Writer getWriter(OutputStream outputStream, String string2) throws UnsupportedEncodingException {
        for (int i = 0; i < _encodings.length; ++i) {
            if (!_encodings[i].getName().equalsIgnoreCase(string2)) continue;
            try {
                String string3 = Encodings._encodings[i].javaName;
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, string3);
                return outputStreamWriter;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        try {
            return new OutputStreamWriter(outputStream, string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new UnsupportedEncodingException(string2);
        }
    }

    static EncodingInfo getEncodingInfo(String string2) {
        String string3 = Encodings.toUpperCaseFast(string2);
        EncodingInfo encodingInfo = _encodingTableKeyJava.get(string3);
        if (encodingInfo == null) {
            encodingInfo = _encodingTableKeyMime.get(string3);
        }
        return encodingInfo;
    }

    public static void printEncodings() {
        Collection<EncodingInfo> collection2 = _encodingTableKeyJava.values();
        for (EncodingInfo encodingInfo : collection2) {
            System.out.println(encodingInfo.getName());
        }
    }

    public static boolean isRecognizedEncoding(String string2) {
        String string3 = string2.toUpperCase(Locale.ENGLISH);
        EncodingInfo encodingInfo = _encodingTableKeyJava.get(string3);
        if (encodingInfo == null) {
            encodingInfo = _encodingTableKeyMime.get(string3);
        }
        return encodingInfo != null;
    }

    private static String toUpperCaseFast(String string2) {
        boolean bl = false;
        int n2 = string2.length();
        char[] cArray = new char[n2];
        for (int i = 0; i < n2; ++i) {
            char c = string2.charAt(i);
            if ('a' <= c && c <= 'z') {
                c = (char)(c + -32);
                bl = true;
            }
            cArray[i] = c;
        }
        String string3 = bl ? String.valueOf(cArray) : string2;
        return string3;
    }

    static String getMimeEncoding(String string2) {
        block5: {
            if (null == string2) {
                try {
                    string2 = System.getProperty("file.encoding", "UTF8");
                    if (null != string2) {
                        String string3 = string2.equalsIgnoreCase("Cp1252") || string2.equalsIgnoreCase("ISO8859_1") || string2.equalsIgnoreCase("8859_1") || string2.equalsIgnoreCase("UTF8") ? DEFAULT_MIME_ENCODING : Encodings.convertJava2MimeEncoding(string2);
                        string2 = null != string3 ? string3 : DEFAULT_MIME_ENCODING;
                        break block5;
                    }
                    string2 = DEFAULT_MIME_ENCODING;
                }
                catch (SecurityException securityException) {
                    string2 = DEFAULT_MIME_ENCODING;
                }
            } else {
                string2 = Encodings.convertJava2MimeEncoding(string2);
            }
        }
        return string2;
    }

    private static String convertJava2MimeEncoding(String string2) {
        EncodingInfo encodingInfo = _encodingTableKeyJava.get(Encodings.toUpperCaseFast(string2));
        if (null != encodingInfo) {
            return encodingInfo.getName();
        }
        return string2;
    }

    public static String convertMime2JavaEncoding(String string2) {
        for (int i = 0; i < _encodings.length; ++i) {
            if (!_encodings[i].getName().equalsIgnoreCase(string2)) continue;
            return Encodings._encodings[i].javaName;
        }
        return string2;
    }

    private static EncodingInfo[] loadEncodingInfo() {
        ArrayList arrayList = new ArrayList();
        String[] stringArray = stateful_endcogings;
        boolean bl = false;
        Encodings.processEncodingList(stringArray, bl, arrayList);
        stringArray = stateless_endcogings;
        bl = true;
        Encodings.processEncodingList(stringArray, bl, arrayList);
        EncodingInfo[] encodingInfoArray = new EncodingInfo[arrayList.size()];
        arrayList.toArray(encodingInfoArray);
        return encodingInfoArray;
    }

    private static void processEncodingList(String[] stringArray, boolean bl, List list) {
        int n2 = stringArray.length / 2;
        for (int i = 0; i < n2; ++i) {
            String string2 = stringArray[i * 2];
            String string3 = stringArray[i * 2 + 1];
            StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
            boolean bl2 = true;
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                EncodingInfo encodingInfo = new EncodingInfo(string4, string2, bl);
                list.add(encodingInfo);
                _encodingTableKeyMime.put(string4.toUpperCase(Locale.ENGLISH), encodingInfo);
                if (bl2) {
                    _encodingTableKeyJava.put(string2.toUpperCase(Locale.ENGLISH), encodingInfo);
                }
                bl2 = false;
            }
        }
    }

    public static boolean isHighUTF16Surrogate(char c) {
        return '\ud800' <= c && c <= '\udbff';
    }

    public static boolean isLowUTF16Surrogate(char c) {
        return '\udc00' <= c && c <= '\udfff';
    }

    public static int toCodePoint(char c, char c2) {
        int n2 = (c - 55296 << 10) + (c2 - 56320) + 65536;
        return n2;
    }

    static final boolean codePointHasSurrogatePair(int n2) {
        return n2 > 65535;
    }

    static int getHighSurrogate(int n2) {
        int n3 = n2 - 65536;
        if (n3 < 0) {
            return -1;
        }
        n3 >>>= 10;
        if ((n3 += 55296) > 56319) {
            return -1;
        }
        return n3;
    }

    static int getLowSurrogate(int n2) {
        int n3 = n2 & 0x3FF;
        if ((n3 += 56320) > 57343) {
            return -1;
        }
        return n3;
    }

    static int toCodePoint(char c) {
        char c2 = c;
        return c2;
    }
}

