/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.serializer;

import com.ibm.xml.xci.serializer.SerializerCursorFactory;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NamespaceMappings {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private int m_count = 0;
    private HashMap<String, Stack> m_namespaces;
    private Stack m_nodeStack;
    private static final String EMPTYSTRING = "";
    private static final String XML_PREFIX = "xml";
    private static final MappingRecord s_MapRecEmpty = new MappingRecord("", "", -1);
    private static final MappingRecord s_MapRecXML;
    private Stack m_emptyStringStack = new Stack();
    private Stack m_XMLStringStack;
    private boolean m_undeclarationIsEnabled = false;

    public NamespaceMappings() {
        this.m_namespaces = new HashMap();
        this.m_nodeStack = new Stack();
        this.m_emptyStringStack = new Stack();
        this.m_emptyStringStack.push(NamespaceMappings.s_MapRecEmpty);
        this.m_namespaces.put(EMPTYSTRING, this.m_emptyStringStack);
        this.m_XMLStringStack = new Stack();
        this.m_XMLStringStack.push(NamespaceMappings.s_MapRecXML);
        this.m_namespaces.put(XML_PREFIX, this.m_XMLStringStack);
    }

    public final MappingRecord lookupNamespace(int n2) {
        Object object2;
        if (SerializerCursorFactory.TRACE_SER_NS) {
            object2 = ".lookupNamespace(" + n2 + ") called";
            this.dbgTraceNS((String)object2);
        }
        object2 = this.m_nodeStack.peek(n2);
        return object2;
    }

    public final MappingRecord getMappingFromPrefix(String string2) {
        Stack stack = this.m_namespaces.get(string2);
        return stack != null && !stack.isEmpty() ? stack.peek() : null;
    }

    public final MappingRecord lookupPrefix(String string2) {
        MappingRecord mappingRecord = null;
        Set<String> set2 = this.m_namespaces.keySet();
        for (String string3 : set2) {
            MappingRecord mappingRecord2 = this.getMappingFromPrefix(string3);
            if (mappingRecord2 == null || !mappingRecord2.get_uri().equals(string2)) continue;
            mappingRecord = mappingRecord2;
            break;
        }
        return mappingRecord;
    }

    public final MappingRecord getMappingFromURI(String string2) {
        MappingRecord mappingRecord = null;
        Set<String> set2 = this.m_namespaces.keySet();
        for (String string3 : set2) {
            MappingRecord mappingRecord2 = this.getMappingFromPrefix(string3);
            if (mappingRecord2 == null || !mappingRecord2.get_uri().equals(string2)) continue;
            mappingRecord = mappingRecord2;
            break;
        }
        return mappingRecord;
    }

    public final MappingRecord getMappingFromURI(String string2, boolean bl) {
        MappingRecord mappingRecord = null;
        Set<String> set2 = this.m_namespaces.keySet();
        for (String string3 : set2) {
            MappingRecord mappingRecord2 = this.getMappingFromPrefix(string3);
            if (mappingRecord2 == null || !mappingRecord2.get_uri().equals(string2) || bl && mappingRecord2.get_prefix().length() <= 0) continue;
            mappingRecord = mappingRecord2;
            break;
        }
        return mappingRecord;
    }

    private boolean popNamespace(String string2) {
        if (string2.startsWith(XML_PREFIX)) {
            return false;
        }
        Stack stack = this.findPrefixStack(string2);
        if (stack != null) {
            stack.pop();
            return true;
        }
        return false;
    }

    public int pushNamespace(String string2, String string3, int n2, boolean bl) {
        MappingRecord mappingRecord;
        Object object2;
        if (SerializerCursorFactory.TRACE_SER_NS) {
            object2 = "pushNamespace('" + string2 + "', '" + string3 + "', " + n2 + ") called";
            this.dbgTraceNS((String)object2);
        }
        if (string2 == null) {
            string2 = EMPTYSTRING;
        }
        if (string3 == null) {
            string3 = EMPTYSTRING;
        }
        if (string2.startsWith(XML_PREFIX)) {
            if (SerializerCursorFactory.TRACE_SER_NS) {
                object2 = "pushNamespace() returns -1 as it is xml";
            }
            if (XML_PREFIX.equals(string2)) {
                return -1;
            }
            return -2;
        }
        object2 = this.getPrefixStack(string2);
        if (!((Stack)object2).empty()) {
            mappingRecord = ((Stack)object2).peek();
            if (string3.equals(mappingRecord.get_uri())) {
                return mappingRecord.get_index();
            }
            if (n2 == mappingRecord.m_declarationDepth) {
                if (bl) {
                    string2 = this.generateUnusedPrefix();
                    object2 = this.getPrefixStack(string2);
                    if (SerializerCursorFactory.TRACE_SER_NS) {
                        String string4 = ".pushNamespace() collision avoided with new prefix: " + string2;
                        this.dbgTraceNS(string4);
                    }
                } else {
                    if (SerializerCursorFactory.TRACE_SER_NS) {
                        String string5 = ".pushNamespace() returns -1 as there is a namespace collsion with prefix " + string2;
                        this.dbgTraceNS(string5);
                    }
                    return -3;
                }
            }
        }
        mappingRecord = new MappingRecord(string2, string3, n2);
        ((Stack)object2).push(mappingRecord);
        int n3 = this.m_nodeStack.push(mappingRecord);
        mappingRecord.set_index(n3);
        if (SerializerCursorFactory.TRACE_SER_NS) {
            String string6 = ".pushNamespace()\n          pushed this record on stack for prefix '" + string2 + " : " + mappingRecord.toString();
            this.dbgTraceNS(string6);
        }
        return n3;
    }

    private Stack getPrefixStack(String string2) {
        Stack stack = this.m_namespaces.get(string2);
        if (stack == null) {
            if (SerializerCursorFactory.TRACE_SER_NS) {
                String string3 = "pushNamespace() creating a new stack for prefix '" + string2 + "'";
                this.dbgTraceNS(string3);
            }
            stack = new Stack();
            this.m_namespaces.put(string2, stack);
        }
        return stack;
    }

    public void popNamespaces(int n2, ContentHandler contentHandler) {
        Object object2;
        if (SerializerCursorFactory.TRACE_SER_NS) {
            object2 = ".popNamespaces(" + n2 + ");  called";
            this.dbgTraceNS((String)object2);
        }
        while (true) {
            String string2;
            Stack stack;
            MappingRecord mappingRecord;
            if (this.m_nodeStack.isEmpty()) {
                return;
            }
            object2 = this.m_nodeStack.peek();
            if (n2 < 1 || ((MappingRecord)object2).m_declarationDepth < n2) break;
            MappingRecord mappingRecord2 = (MappingRecord)this.m_nodeStack.pop();
            if (mappingRecord2 != (mappingRecord = (stack = this.findPrefixStack(string2 = ((MappingRecord)object2).get_prefix())).peek())) continue;
            stack.pop();
            if (contentHandler == null) continue;
            try {
                contentHandler.endPrefixMapping(string2);
            }
            catch (SAXException sAXException) {}
        }
    }

    public String generateUnusedPrefix() {
        String string2;
        while (this.getMappingFromPrefix(string2 = "ns" + this.m_count++) != null) {
        }
        return string2;
    }

    final void reset() {
        this.m_count = 0;
        this.m_emptyStringStack.clear();
        this.m_namespaces.clear();
        this.m_nodeStack.clear();
        this.m_undeclarationIsEnabled = false;
        this.m_XMLStringStack.clear();
        this.m_namespaces.put(EMPTYSTRING, this.m_emptyStringStack);
        this.m_XMLStringStack.push(NamespaceMappings.s_MapRecXML);
        this.m_namespaces.put(XML_PREFIX, this.m_XMLStringStack);
        this.m_count = 0;
        this.m_namespaces.clear();
        this.m_nodeStack.clear();
        this.m_namespaces.put(EMPTYSTRING, this.m_emptyStringStack);
        this.m_XMLStringStack.push(NamespaceMappings.s_MapRecXML);
        this.m_namespaces.put(XML_PREFIX, this.m_XMLStringStack);
    }

    private Stack findPrefixStack(String string2) {
        Stack stack = this.m_namespaces.get(string2);
        return stack;
    }

    private void undeclareAllPrefixMappings(int n2) {
        if (this.m_undeclarationIsEnabled) {
            Set<String> set2 = this.m_namespaces.keySet();
            for (String string2 : set2) {
                MappingRecord mappingRecord;
                Stack stack = this.findPrefixStack(string2);
                if (stack.empty() || (mappingRecord = stack.peek()).get_uri().length() <= 0 || mappingRecord.m_declarationDepth > n2) continue;
                this.undeclarePrefixMapping(string2, n2);
            }
        }
    }

    private void undeclarePrefixMapping(String string2, int n2) {
        if (this.m_undeclarationIsEnabled) {
            this.pushNamespace(string2, EMPTYSTRING, n2, true);
        }
    }

    public List<MappingRecord> getPrefixMappingsAtDepth(int n2) {
        return this.getPrefixMappings(n2, false);
    }

    private List<MappingRecord> getPrefixMappings(int n2, boolean bl) {
        ArrayList<MappingRecord> arrayList = new ArrayList<MappingRecord>();
        if (n2 >= 0) {
            Set<String> set2 = this.m_namespaces.keySet();
            for (String string2 : set2) {
                int n3;
                Stack stack = this.findPrefixStack(string2);
                if (stack.empty() || (n3 = stack.top) < 0) continue;
                MappingRecord mappingRecord = stack.getElement(n3);
                if (mappingRecord.m_declarationDepth != n2 && (bl || mappingRecord.m_declarationDepth >= n2 || mappingRecord.m_declarationDepth == -1)) continue;
                arrayList.add(mappingRecord);
            }
        }
        return arrayList;
    }

    List<MappingRecord> getPrefixMappingsExactlyAtDepth(int n2) {
        return this.getPrefixMappings(n2, true);
    }

    void setUndeclaration(boolean bl) {
        this.m_undeclarationIsEnabled = bl;
    }

    private void dbgTraceNS(String string2) {
        System.err.println("TRACE_SER_NS:  NamespaceMappings" + string2);
    }

    static {
        NamespaceMappings.s_MapRecEmpty.set_index(0);
        s_MapRecXML = new MappingRecord(XML_PREFIX, "http://www.w3.org/XML/1998/namespace", -1);
        NamespaceMappings.s_MapRecXML.set_index(1);
    }

    private class MappingsAtDepth
    implements Enumeration {
        Stack prefixURIPairs = new Stack();

        MappingsAtDepth(int n2) {
            Set set2 = NamespaceMappings.this.m_namespaces.keySet();
            for (String string2 : set2) {
                int n3;
                Stack stack = NamespaceMappings.this.findPrefixStack(string2);
                if (stack.empty()) continue;
                MappingRecord mappingRecord = null;
                for (n3 = stack.top; 0 <= n3; --n3) {
                    mappingRecord = stack.getElement(n3);
                    if (mappingRecord.m_declarationDepth <= n2) break;
                }
                if (0 > n3 || mappingRecord.m_declarationDepth != n2 || mappingRecord.get_prefix().equals("xmlns") || mappingRecord.get_prefix().equals(NamespaceMappings.XML_PREFIX)) continue;
                this.prefixURIPairs.push(mappingRecord);
            }
        }

        public boolean hasMoreElements() {
            return !this.prefixURIPairs.empty();
        }

        public Object nextElement() {
            return this.prefixURIPairs.pop();
        }
    }

    static final class Stack {
        private int top = -1;
        private int max = 20;
        MappingRecord[] m_stack = new MappingRecord[this.max];

        private Stack() {
        }

        private int push(MappingRecord mappingRecord) {
            ++this.top;
            if (this.max <= this.top) {
                int n2 = 2 * this.max + 1;
                MappingRecord[] mappingRecordArray = new MappingRecord[n2];
                System.arraycopy(this.m_stack, 0, mappingRecordArray, 0, this.max);
                this.max = n2;
                this.m_stack = mappingRecordArray;
            }
            this.m_stack[this.top] = mappingRecord;
            return this.top;
        }

        private Object pop() {
            MappingRecord mappingRecord;
            if (0 <= this.top) {
                mappingRecord = this.m_stack[this.top];
                --this.top;
            } else {
                mappingRecord = null;
            }
            return mappingRecord;
        }

        private MappingRecord peek() {
            if (0 <= this.top) {
                return this.m_stack[this.top];
            }
            return null;
        }

        private MappingRecord peek(int n2) {
            return this.m_stack[n2];
        }

        private boolean isEmpty() {
            return this.top < 0;
        }

        private boolean empty() {
            return this.top < 0;
        }

        private void clear() {
            for (int i = 0; i <= this.top; ++i) {
                this.m_stack[i] = null;
            }
            this.top = -1;
        }

        private MappingRecord getElement(int n2) {
            return this.m_stack[n2];
        }
    }

    public static class MappingRecord {
        private final String m_prefix;
        private final String m_uri;
        final int m_declarationDepth;
        private int m_stackDepth;

        MappingRecord(String string2, String string3, int n2) {
            this.m_prefix = string2;
            this.m_uri = string3 == null ? NamespaceMappings.EMPTYSTRING : string3;
            this.m_declarationDepth = n2;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.get_prefix().length() == 0) {
                stringBuilder.append("xmlns");
            } else {
                stringBuilder.append("xmlns:").append(this.get_prefix());
            }
            stringBuilder.append("='").append(this.get_uri()).append('\'');
            stringBuilder.append(", element stack depth: " + this.m_declarationDepth + ", prefix stack depth: " + this.get_index());
            return stringBuilder.toString();
        }

        public String get_prefix() {
            return this.m_prefix;
        }

        public String get_uri() {
            return this.m_uri;
        }

        private void set_index(int n2) {
            this.m_stackDepth = n2;
        }

        public int get_index() {
            return this.m_stackDepth;
        }

        public final int getDeclarationDepth() {
            return this.m_declarationDepth;
        }
    }
}

