/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.serializer;

import java.util.Vector;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class SAX2XMLStreamWriter
implements ContentHandler,
LexicalHandler {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private XMLStreamWriter m_streamWriter = null;
    private Vector m_prefixMappings = new Vector();
    private boolean m_isCData = false;
    private static final String EMPTYSTRING = "";

    public SAX2XMLStreamWriter(XMLStreamWriter xMLStreamWriter) {
        this.m_streamWriter = xMLStreamWriter;
    }

    public void characters(char[] cArray, int n2, int n3) throws SAXException {
        try {
            String string2 = new String(cArray, n2, n3);
            if (this.m_isCData) {
                this.m_streamWriter.writeCData(string2);
            } else {
                this.m_streamWriter.writeCharacters(string2);
            }
        }
        catch (XMLStreamException xMLStreamException) {
            throw new SAXException(xMLStreamException);
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.m_streamWriter.writeEndDocument();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new SAXException(xMLStreamException);
        }
    }

    public void endElement(String string2, String string3, String string4) throws SAXException {
        try {
            this.m_streamWriter.writeEndElement();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new SAXException(xMLStreamException);
        }
    }

    public void endPrefixMapping(String string2) throws SAXException {
    }

    public void ignorableWhitespace(char[] cArray, int n2, int n3) throws SAXException {
    }

    public void processingInstruction(String string2, String string3) throws SAXException {
        try {
            this.m_streamWriter.writeProcessingInstruction(string2, string3);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new SAXException(xMLStreamException);
        }
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String string2) throws SAXException {
    }

    public void startDocument() throws SAXException {
        try {
            this.m_streamWriter.writeStartDocument();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new SAXException(xMLStreamException);
        }
    }

    public void startElement(String string2, String string3, String string4, Attributes attributes2) throws SAXException {
        try {
            String string5;
            int n2;
            int n3;
            int n4 = string4.indexOf(":");
            String string6 = n4 != -1 ? string4.substring(0, n4) : EMPTYSTRING;
            this.m_streamWriter.writeStartElement(string6, string3, string2);
            if (this.m_prefixMappings != null) {
                n3 = this.m_prefixMappings.size();
                for (n2 = 0; n2 < n3; ++n2) {
                    string5 = (String)this.m_prefixMappings.elementAt(n2++);
                    String string7 = (String)this.m_prefixMappings.elementAt(n2);
                    if (string5.length() == 0) {
                        this.m_streamWriter.writeDefaultNamespace(string7);
                        continue;
                    }
                    this.m_streamWriter.writeNamespace(string5, string7);
                }
                this.m_prefixMappings.clear();
            }
            n3 = attributes2.getLength();
            for (n2 = 0; n2 < n3; ++n2) {
                if (attributes2.getLocalName(n2) == null) {
                    this.m_streamWriter.writeAttribute(attributes2.getQName(n2), attributes2.getValue(n2));
                    continue;
                }
                string5 = attributes2.getQName(n2);
                if (string5.equals("xmlns")) continue;
                n4 = string5.indexOf(":");
                String string8 = string6 = n4 != -1 ? string5.substring(0, n4) : EMPTYSTRING;
                if (string6.equals("xmlns")) continue;
                this.m_streamWriter.writeAttribute(string6, attributes2.getURI(n2), attributes2.getLocalName(n2), attributes2.getValue(n2));
            }
        }
        catch (XMLStreamException xMLStreamException) {
            throw new SAXException(xMLStreamException);
        }
    }

    public void startPrefixMapping(String string2, String string3) throws SAXException {
        this.m_prefixMappings.addElement(string2);
        this.m_prefixMappings.addElement(string3);
    }

    public void comment(char[] cArray, int n2, int n3) throws SAXException {
        try {
            String string2 = new String(cArray, n2, n3);
            this.m_streamWriter.writeComment(string2);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new SAXException(xMLStreamException);
        }
    }

    public void endCDATA() throws SAXException {
        this.m_isCData = false;
    }

    public void endDTD() throws SAXException {
    }

    public void endEntity(String string2) throws SAXException {
    }

    public void startCDATA() throws SAXException {
        this.m_isCData = true;
    }

    public void startDTD(String string2, String string3, String string4) throws SAXException {
    }

    public void startEntity(String string2) throws SAXException {
    }
}

