/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.serializer;

import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.util.copy.ItemCopier;
import com.ibm.xml.xci.serializer.SerializeCopier;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SerializeCopierMeta
extends SerializeCopier {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2009, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final int NONE_COPIED = 3;
    private final ItemCopier itemCopier;
    private final boolean forXHTML;
    private boolean toFork = false;
    private boolean headElementMatched = false;

    static void copy(Cursor cursor2, Cursor cursor3, Cursor cursor4, Cursor.Area area, int n2, ItemCopier itemCopier, Map<String, Object> map2, boolean bl) {
        SerializeCopierMeta serializeCopierMeta = new SerializeCopierMeta(n2, itemCopier, bl);
        serializeCopierMeta.copy(cursor2, cursor3, cursor4, area, n2, map2);
    }

    protected SerializeCopierMeta(int n2, ItemCopier itemCopier, boolean bl) {
        super(n2);
        this.itemCopier = itemCopier;
        this.forXHTML = bl;
    }

    @Override
    protected int copySequence2Content(Cursor cursor2, Cursor cursor3, Cursor.Area area) {
        if (this.toFork) {
            this.toFork = false;
        }
        return super.copySequence2Content(cursor2, cursor3, area);
    }

    @Override
    protected int copyContents(Cursor cursor2, Cursor cursor3) {
        int n2;
        Cursor cursor4;
        Cursor cursor5 = cursor2.fork(true);
        if (cursor5.toNamespaceDecls() && !this.discardNSDecls) {
            do {
                this.copyNode(cursor5, cursor3, Cursor.Area.FOLLOWING_SIBLING);
            } while (cursor5.toNext());
        }
        cursor5.release();
        if (this.discardNSDecls) {
            SerializeCopierMeta.fixupNamespace(cursor2, cursor3);
        }
        if ((cursor4 = cursor2.fork(true)).toAttributes(null)) {
            do {
                this.copyNode(cursor4, cursor3, Cursor.Area.FOLLOWING_SIBLING);
                if (!this.discardNSDecls) continue;
                SerializeCopierMeta.fixupNamespace(cursor4, cursor3);
            } while (cursor4.toNext());
        }
        cursor4.release();
        Cursor cursor6 = cursor2.fork(true);
        if (cursor6.toChildren(null)) {
            n2 = this.copySequence2Content(cursor6, cursor3, Cursor.Area.FIRST_CHILD);
        } else {
            if (this.toFork) {
                cursor3 = cursor3.fork(true, cursor3.profile(), cursor3.futureProfile());
                cursor3.release();
                this.toFork = false;
            }
            n2 = 1;
        }
        cursor6.release();
        return n2;
    }

    @Override
    protected int copyNode(Cursor cursor2, Cursor cursor3, Cursor.Area area) {
        if (cursor2.itemKind() == 1 && !this.headElementMatched) {
            this.matchHeadElement(cursor2);
        }
        if (this.itemCopier == null) {
            return super.copyNode(cursor2, cursor3, area);
        }
        return this.copyNode2(cursor2, cursor3, area);
    }

    private int copyNode2(Cursor cursor2, Cursor cursor3, Cursor.Area area) {
        int n2 = this.itemCopier.copyNode(cursor2, cursor3, area);
        if (n2 == 3) {
            return super.copyNode(cursor2, cursor3, area);
        }
        return n2;
    }

    private void matchHeadElement(Cursor cursor2) {
        if (this.isHeadElement(cursor2.itemName())) {
            this.toFork = true;
            this.headElementMatched = true;
        }
    }

    private boolean isHeadElement(VolatileCData volatileCData) {
        String string2 = volatileCData.getQNameLocalPart(1);
        String string3 = volatileCData.getQNameNamespaceURI(1);
        return string2.length() == 4 && (this.forXHTML ? "http://www.w3.org/1999/xhtml".equals(string3) && string2.equals("head") : string3.length() == 0 && string2.equalsIgnoreCase("head"));
    }
}

