/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.serializer;

import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.CursorFactory;
import com.ibm.xml.xci.RequestInfo;
import com.ibm.xml.xci.SessionContext;
import com.ibm.xml.xci.dp.base.AbstractCursorFactory;
import com.ibm.xml.xci.errors.XCIDynamicErrorException;
import com.ibm.xml.xci.sax.serializer.SAXCursor;
import com.ibm.xml.xci.serializer.HiddenOptions;
import com.ibm.xml.xci.serializer.SAX2XMLEventWriter;
import com.ibm.xml.xci.serializer.SAX2XMLStreamWriter;
import com.ibm.xml.xci.serializer.Serialize;
import com.ibm.xml.xml4j.internal.s1.impl.XMLEntityManager;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stax.StAXResult;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.ContentHandler;
import org.xml.sax.ext.LexicalHandler;

public class SerializerCursorFactory
extends AbstractCursorFactory {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final boolean TRACE_SER_NS = HiddenOptions.wasSpecified("TRACE_SER_NS");
    public static final boolean TRACE_SER_API = HiddenOptions.wasSpecified("TRACE_SER_API");

    public SerializerCursorFactory(SessionContext sessionContext) {
        super(sessionContext);
    }

    public Cursor document(Result result2, RequestInfo requestInfo) {
        Cursor cursor2 = null;
        if (result2 instanceof StreamResult) {
            StreamResult streamResult = (StreamResult)result2;
            Writer writer = streamResult.getWriter();
            if (writer != null) {
                cursor2 = Serialize.getTargetCursor((CursorFactory)this, writer, requestInfo.getParameters());
            } else {
                OutputStream outputStream = streamResult.getOutputStream();
                if (outputStream != null) {
                    cursor2 = Serialize.getTargetCursor((CursorFactory)this, outputStream, requestInfo.getParameters());
                } else {
                    try {
                        cursor2 = Serialize.getTargetCursor((CursorFactory)this, XMLEntityManager.createOutputStream(result2.getSystemId()), requestInfo.getParameters());
                    }
                    catch (IOException iOException) {
                        throw new XCIDynamicErrorException(iOException);
                    }
                }
            }
        } else if (result2 instanceof SAXResult) {
            SAXResult sAXResult = (SAXResult)result2;
            cursor2 = new SAXCursor(this, sAXResult.getHandler(), sAXResult.getLexicalHandler(), requestInfo.getParameters());
        } else if (result2 instanceof StAXResult) {
            ContentHandler contentHandler;
            ContentHandler contentHandler2;
            StAXResult stAXResult = (StAXResult)result2;
            XMLEventWriter xMLEventWriter = stAXResult.getXMLEventWriter();
            if (xMLEventWriter != null) {
                SAX2XMLEventWriter sAX2XMLEventWriter;
                contentHandler2 = sAX2XMLEventWriter = new SAX2XMLEventWriter(xMLEventWriter);
                contentHandler = sAX2XMLEventWriter;
            } else {
                XMLStreamWriter xMLStreamWriter = stAXResult.getXMLStreamWriter();
                SAX2XMLStreamWriter sAX2XMLStreamWriter = new SAX2XMLStreamWriter(xMLStreamWriter);
                contentHandler2 = sAX2XMLStreamWriter;
                contentHandler = sAX2XMLStreamWriter;
            }
            cursor2 = new SAXCursor(this, contentHandler2, (LexicalHandler)((Object)contentHandler), requestInfo.getParameters());
        }
        return this.proxy(cursor2, requestInfo.getNeededFeatures(), requestInfo.isSelfOnly(), requestInfo.getParameters(), requestInfo.getHints());
    }

    public Cursor document(Source source, RequestInfo requestInfo) {
        return null;
    }
}

