/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.serializer;

import com.ibm.icu.text.Normalizer;
import com.ibm.xml.xci.serializer.Messages;
import com.ibm.xml.xci.serializer.UnicodeNormalizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UnicodeNormalizerFactory {
    static final Class<?> m_icu = UnicodeNormalizerFactory.init();

    private static Class<?> init() {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.ibm.icu.text.Normalizer");
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz = null;
        }
        return clazz;
    }

    private static boolean icuIsOnTheClassPath() {
        return m_icu != null;
    }

    public static final UnicodeNormalizer getUnicodeNormalizer() {
        UnicodeNormalizer unicodeNormalizer = UnicodeNormalizerFactory.icuIsOnTheClassPath() ? new UnicodeNormalizerICUImpl() : new UnicodeNormalizerDefaultImpl();
        return unicodeNormalizer;
    }

    public static final int getNormalizerMode(String string2) {
        if (string2.equals("NFC")) {
            return 2;
        }
        if (string2.equals("NFD")) {
            return 3;
        }
        if (string2.equals("NFKC")) {
            return 4;
        }
        if (string2.equals("NFKD")) {
            return 5;
        }
        if (string2.equals("none")) {
            return 1;
        }
        String string3 = Messages.createMessage2("ER_SER_NORM_FORM_NOT_SUPPORTED", new String[]{string2});
        Messages.xciDynamicErrorException(string3);
        return 1;
    }

    private static class UnicodeNormalizerDefaultImpl
    implements UnicodeNormalizer {
        private UnicodeNormalizerDefaultImpl() {
        }

        public boolean alreadyNormalized(int n2, int n3) {
            return true;
        }

        public boolean alreadyNormalized(char[] cArray, int n2, int n3, int n4) {
            return true;
        }

        public boolean alreadyNormalized(String string2, int n2) {
            return true;
        }

        public String normalizeUnicode(int n2, int n3) {
            return null;
        }

        public int normalizeUnicode(char[] cArray, int n2, int n3, char[] cArray2, int n4, int n5, int n6) {
            return 0;
        }

        public String normalizeUnicode(String string2, int n2) {
            return null;
        }
    }

    private static class UnicodeNormalizerICUImpl
    implements UnicodeNormalizer {
        final Normalizer.Mode getMode(int n2) {
            switch (n2) {
                case 2: {
                    return Normalizer.NFC;
                }
                case 3: {
                    return Normalizer.NFD;
                }
                case 4: {
                    return Normalizer.NFKC;
                }
                case 5: {
                    return Normalizer.NFKD;
                }
                case 1: {
                    return Normalizer.NONE;
                }
            }
            return Normalizer.NONE;
        }

        public final boolean alreadyNormalized(int n2, int n3) {
            return Normalizer.isNormalized((int)n2, (Normalizer.Mode)this.getMode(n3), (int)0);
        }

        public final boolean alreadyNormalized(char[] cArray, int n2, int n3, int n4) {
            Normalizer.QuickCheckResult quickCheckResult = Normalizer.quickCheck((char[])cArray, (int)n2, (int)n3, (Normalizer.Mode)this.getMode(n4), (int)0);
            boolean bl = quickCheckResult == Normalizer.YES;
            return bl;
        }

        public final boolean alreadyNormalized(String string2, int n2) {
            Normalizer.QuickCheckResult quickCheckResult = Normalizer.quickCheck((String)string2, (Normalizer.Mode)this.getMode(n2), (int)0);
            boolean bl = quickCheckResult == Normalizer.YES;
            return bl;
        }

        public final String normalizeUnicode(int n2, int n3) {
            return Normalizer.normalize((int)n2, (Normalizer.Mode)this.getMode(n3), (int)0);
        }

        public final int normalizeUnicode(char[] cArray, int n2, int n3, char[] cArray2, int n4, int n5, int n6) {
            return Normalizer.normalize((char[])cArray, (int)n2, (int)n3, (char[])cArray2, (int)n4, (int)n5, (Normalizer.Mode)this.getMode(n6), (int)0);
        }

        public final String normalizeUnicode(String string2, int n2) {
            return Normalizer.normalize((String)string2, (Normalizer.Mode)this.getMode(n2));
        }
    }
}

