/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.serializer;

import com.ibm.xml.xci.serializer.EncodingInfo;
import com.ibm.xml.xci.serializer.Encodings;
import com.ibm.xml.xci.serializer.WriterOptimized;
import java.io.IOException;
import java.io.OutputStream;

public class WriterStateless
extends WriterOptimized {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2008. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    final EncodingInfo m_ei;
    final EncodingInfo.EncodingImpl m_enc_info;

    public WriterStateless(OutputStream outputStream, EncodingInfo encodingInfo) {
        super(outputStream);
        this.m_ei = encodingInfo;
        this.m_enc_info = new EncodingInfo.EncodingImpl(encodingInfo);
        encodingInfo.m_encoding = this.m_enc_info;
    }

    public void write(int n2) throws IOException {
        int n3;
        Object object2;
        if (this.count >= 16384) {
            this.flushBuffer();
        }
        if (n2 < 128) {
            object2 = this.m_enc_info.getEncodedBytes127(n2);
        } else {
            try {
                if (Encodings.codePointHasSurrogatePair(n2)) {
                    n3 = Encodings.getLowSurrogate(n2);
                    int n4 = Encodings.getHighSurrogate(n2);
                    object2 = n3 != -1 && n4 != -1 ? this.m_ei.getEncodedBytesForCodepoint(n2, (char)n4, (char)n3) : null;
                } else {
                    object2 = this.m_ei.getEncodedBytesForChar((char)n2);
                }
            }
            catch (Exception exception) {
                object2 = null;
            }
        }
        if (object2 != null) {
            for (n3 = 0; n3 < ((byte[])object2).length; ++n3) {
                this.m_outputBytes[this.count++] = object2[n3];
            }
        }
    }

    void writeCharsNoChunking(char[] cArray, int n2, int n3) {
        int n4;
        char c;
        int n5;
        EncodingInfo.EncodingImpl encodingImpl = this.m_enc_info;
        int n6 = n3 + n2;
        byte[] byArray = this.m_outputBytes;
        int n7 = this.count;
        for (n5 = n2; n5 < n6 && (c = cArray[n5]) < '\u0080'; ++n5) {
            byte[] byArray2 = encodingImpl.getEncodedBytes127(c);
            if (byArray2 == null) continue;
            for (n4 = 0; n4 < byArray2.length; ++n4) {
                byArray[n7++] = byArray2[n4];
            }
        }
        while (n5 < n6) {
            c = cArray[n5];
            if (c < '\u0080') {
                byte[] byArray3 = encodingImpl.getEncodedBytes127(c);
                if (byArray3 != null) {
                    for (n4 = 0; n4 < byArray3.length; ++n4) {
                        byArray[n7++] = byArray3[n4];
                    }
                }
            } else if (Encodings.isHighUTF16Surrogate(c) && n5 < n6 - 1) {
                char c2 = cArray[n5 + 1];
                ++n5;
                n4 = Encodings.toCodePoint(c, c2);
                byte[] byArray4 = this.m_ei.getEncodedBytesForCodepoint(n4, c, c2);
                if (byArray4 != null) {
                    for (int i = 0; i < byArray4.length; ++i) {
                        byArray[n7++] = byArray4[i];
                    }
                }
            } else {
                byte[] byArray5 = this.m_ei.getEncodedBytesForChar(c);
                if (byArray5 != null) {
                    for (n4 = 0; n4 < byArray5.length; ++n4) {
                        byArray[n7++] = byArray5[n4];
                    }
                }
            }
            ++n5;
        }
        this.count = n7;
    }

    void writeASCIINoChunking(char[] cArray, int n2, int n3) {
        int n4 = n3 + n2;
        byte[] byArray = this.m_outputBytes;
        int n5 = this.count;
        EncodingInfo.EncodingImpl encodingImpl = this.m_enc_info;
        for (int i = n2; i < n4; ++i) {
            byte[] byArray2 = encodingImpl.getEncodedBytes127(cArray[i]);
            if (byArray2 == null) continue;
            for (int j = 0; j < byArray2.length; ++j) {
                byArray[n5++] = byArray2[j];
            }
        }
        this.count = n5;
    }

    public void writeByte(byte by2) throws IOException {
        if (this.count >= 16384) {
            this.flushBuffer();
        }
        this.m_outputBytes[this.count++] = by2;
    }
}

