/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.serializer;

import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.internal.values.StringCDataMutable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

class XInScopeNamespaces {
    private int fPrefixesDefined = 0;
    private String[] fPrefixes = new String[4];
    private PrefixBindingInfo[] fPrefixBindings = new PrefixBindingInfo[4];
    private boolean[] fPrefixUsedAtCurrentDepth = new boolean[4];
    private boolean fSawUsesAtMostRecentDepth;
    private int fMostRecentDepthWithBinding = -1;
    private final HashMap<String, Integer> fPrefixMapping = new HashMap(4);
    private int fNumberOfNamespacesToEmit;
    private StringCDataMutable fReusablePrefixCData = new StringCDataMutable("");
    private StringCDataMutable fReusableURICData = new StringCDataMutable("");
    private static PrefixBindingInfo XML_BINDING = new ReservedPrefixBindingInfo("http://www.w3.org/XML/1998/namespace", true);
    private static PrefixBindingInfo XMLNS_BINDING = new ReservedPrefixBindingInfo("http://www.w3.org/2000/xmlns/", false);
    private int fManufacturedPrefixCounter;
    private static final int CONFLICTING_BINDING = 0;
    private static final int CREATED_NEW_BINDING = 1;
    private static final int REDUNDANT_BINDING = 2;

    XInScopeNamespaces() {
        this.addPrefixBinding("xml", XML_BINDING);
        this.addPrefixBinding("xmlns", XMLNS_BINDING);
    }

    private void addPrefixBinding(String string2, PrefixBindingInfo prefixBindingInfo) {
        int n2 = this.fPrefixesDefined;
        if (this.fPrefixesDefined == this.fPrefixes.length) {
            this.growPrefixArrays();
        }
        this.fPrefixes[n2] = string2;
        this.fPrefixBindings[n2] = prefixBindingInfo;
        this.fPrefixUsedAtCurrentDepth[n2] = true;
        this.fSawUsesAtMostRecentDepth = true;
        this.fPrefixMapping.put(string2, n2);
        ++this.fPrefixesDefined;
    }

    private void growPrefixArrays() {
        int n2 = this.fPrefixes.length;
        int n3 = n2 << 1;
        String[] stringArray = new String[n3];
        System.arraycopy(this.fPrefixes, 0, stringArray, 0, n2);
        this.fPrefixes = stringArray;
        int n4 = this.fPrefixBindings.length;
        int n5 = n4 << 1;
        PrefixBindingInfo[] prefixBindingInfoArray = new PrefixBindingInfo[n5];
        System.arraycopy(this.fPrefixBindings, 0, prefixBindingInfoArray, 0, n4);
        this.fPrefixBindings = prefixBindingInfoArray;
        int n6 = this.fPrefixUsedAtCurrentDepth.length;
        int n7 = n6 << 1;
        boolean[] blArray = new boolean[n7];
        System.arraycopy(this.fPrefixUsedAtCurrentDepth, 0, blArray, 0, n6);
        this.fPrefixUsedAtCurrentDepth = blArray;
    }

    public boolean bindPrefix(String string2, String string3, int n2) {
        boolean bl;
        Integer n3 = this.findBindingIndex(string2);
        if (n3 != null) {
            int n4 = n3;
            PrefixBindingInfo prefixBindingInfo = this.fPrefixBindings[n4];
            boolean bl2 = this.fPrefixUsedAtCurrentDepth[n4];
            switch (prefixBindingInfo.pushBinding(string3, n2, bl2)) {
                case 0: {
                    bl = false;
                    break;
                }
                case 1: {
                    bl = true;
                    ++this.fNumberOfNamespacesToEmit;
                    this.fPrefixUsedAtCurrentDepth[n4] = true;
                    this.fSawUsesAtMostRecentDepth = true;
                    this.fMostRecentDepthWithBinding = n2;
                    break;
                }
                default: {
                    bl = true;
                    this.fPrefixUsedAtCurrentDepth[n4] = true;
                    this.fSawUsesAtMostRecentDepth = true;
                    break;
                }
            }
        } else {
            OrdinaryPrefixBindingInfo ordinaryPrefixBindingInfo = new OrdinaryPrefixBindingInfo(string3, n2);
            this.addPrefixBinding(string2, ordinaryPrefixBindingInfo);
            bl = true;
            this.fMostRecentDepthWithBinding = n2;
            ++this.fNumberOfNamespacesToEmit;
        }
        return bl;
    }

    public boolean isDefaultNSBoundToEmpty() {
        String string2;
        int n2;
        PrefixBindingInfo prefixBindingInfo;
        Integer n3 = this.findBindingIndex("");
        if (n3 != null && (prefixBindingInfo = this.fPrefixBindings[n2 = n3.intValue()]) != null && (string2 = prefixBindingInfo.getCurrentBinding()) != null) {
            return string2.length() == 0;
        }
        return true;
    }

    public String makeNewPrefix(String string2) {
        String string3;
        while (this.fPrefixMapping.get(string3 = "ns" + this.fManufacturedPrefixCounter++) != null) {
        }
        return string3;
    }

    private Integer findBindingIndex(String string2) {
        return this.fPrefixMapping.get(string2);
    }

    public void emitNamespaces(Cursor cursor2, boolean bl, int n2) {
        int n3 = this.fNumberOfNamespacesToEmit;
        int n4 = this.fPrefixesDefined;
        if (n3 != 0 || bl) {
            String[] stringArray = this.fPrefixes;
            PrefixBindingInfo[] prefixBindingInfoArray = this.fPrefixBindings;
            boolean bl2 = false;
            for (int i = n4 - 1; !bl2 && i >= 0; --i) {
                PrefixBindingInfo prefixBindingInfo = prefixBindingInfoArray[i];
                String string2 = null;
                if (prefixBindingInfo.getBindingDepth() == n2) {
                    string2 = prefixBindingInfo.getCurrentBinding();
                    bl2 = --n3 == 0 && !bl;
                } else if (bl && !this.fPrefixUsedAtCurrentDepth[i] && prefixBindingInfo.pushBinding("", n2, false) == 1) {
                    string2 = "";
                }
                if (string2 == null) continue;
                String string3 = stringArray[i];
                this.fReusablePrefixCData.setString(string3);
                this.fReusableURICData.setString(string2);
                cursor2.addNamespaceNode(this.fReusablePrefixCData, this.fReusableURICData, true);
            }
            this.fNumberOfNamespacesToEmit = 0;
        }
        if (this.fSawUsesAtMostRecentDepth) {
            Arrays.fill(this.fPrefixUsedAtCurrentDepth, 0, n4, false);
            this.fSawUsesAtMostRecentDepth = false;
        }
    }

    public void popNamespaceScope(int n2) {
        if (this.fMostRecentDepthWithBinding >= n2) {
            int n3 = this.fPrefixesDefined;
            int n4 = -1;
            for (int i = 0; i < n3; ++i) {
                int n5 = this.fPrefixBindings[i].popBinding(n2);
                if (n4 >= n5) continue;
                n4 = n5;
            }
            this.fMostRecentDepthWithBinding = n4;
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[Buffered namespaces \n");
        for (int i = 0; i < this.fPrefixesDefined; ++i) {
            stringBuilder.append("  prefix == '").append(this.fPrefixes[i]).append("' ").append(this.fPrefixBindings[i].toString()).append('\n');
        }
        stringBuilder.append("  number of namespaces to emit == ").append(this.fNumberOfNamespacesToEmit).append(']');
        return stringBuilder.toString();
    }

    private static final class OrdinaryPrefixBindingInfo
    extends PrefixBindingInfo {
        private int fBindingDepth;
        private int fUseDepth;
        private ArrayList<String> fHiddenBindings;
        private ArrayList<Integer> fHiddenBindingDepths;

        public OrdinaryPrefixBindingInfo(String string2, int n2) {
            super(string2);
            this.fCurrentURI = string2;
            this.fUseDepth = this.fBindingDepth = n2;
        }

        public int getBindingDepth() {
            return this.fBindingDepth;
        }

        public int pushBinding(String string2, int n2, boolean bl) {
            int n3;
            String string3 = this.fCurrentURI;
            if (string3 == null) {
                this.fCurrentURI = string2;
                this.fBindingDepth = n2;
                n3 = 1;
            } else if (string2 == string3 || string3.equals(string2)) {
                n3 = 2;
            } else if (bl) {
                n3 = 0;
            } else {
                this.changeBinding(string2, n2);
                n3 = 1;
            }
            return n3;
        }

        private void changeBinding(String string2, int n2) {
            ArrayList<String> arrayList = this.fHiddenBindings;
            ArrayList<Integer> arrayList2 = this.fHiddenBindingDepths;
            if (arrayList == null) {
                this.fHiddenBindings = arrayList = new ArrayList(2);
                this.fHiddenBindingDepths = arrayList2 = new ArrayList(2);
            }
            arrayList.add(this.fCurrentURI);
            this.fCurrentURI = string2;
            arrayList2.add(this.fBindingDepth);
            this.fBindingDepth = n2;
        }

        public int popBinding(int n2) {
            boolean bl = false;
            if (this.fBindingDepth == n2) {
                if (this.fHiddenBindingDepths != null) {
                    int n3 = this.fHiddenBindingDepths.size();
                    if (n3 != 0) {
                        this.fBindingDepth = this.fHiddenBindingDepths.remove(n3 - 1);
                        this.fCurrentURI = this.fHiddenBindings.remove(n3 - 1);
                        bl = false;
                    } else {
                        bl = true;
                    }
                } else {
                    bl = true;
                }
            }
            if (this.fUseDepth == n2) {
                this.fUseDepth = -1;
            }
            if (bl) {
                this.fCurrentURI = null;
                this.fBindingDepth = -1;
            }
            return this.fBindingDepth;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("[Ordinary binding:  URI == '").append(this.fCurrentURI).append("'\n");
            stringBuilder.append("use depth == ").append(this.fUseDepth).append(" current binding depth == ").append(this.fBindingDepth).append('\n');
            if (this.fHiddenBindings != null) {
                for (int i = 0; i < this.fHiddenBindings.size(); ++i) {
                    stringBuilder.append("\n  hidden binding to '").append(this.fHiddenBindings.get(i)).append("' at depth ").append(this.fHiddenBindingDepths.get(i));
                }
            } else {
                stringBuilder.append("\n  no bindings hidden");
            }
            stringBuilder.append(']');
            return stringBuilder.toString();
        }
    }

    private static final class ReservedPrefixBindingInfo
    extends PrefixBindingInfo {
        private boolean fPermitSameBinding;

        public ReservedPrefixBindingInfo(String string2, boolean bl) {
            super(string2);
            this.fPermitSameBinding = bl;
        }

        public int getBindingDepth() {
            return -1;
        }

        public int pushBinding(String string2, int n2, boolean bl) {
            return this.fPermitSameBinding && string2.equals(this.fCurrentURI) ? 2 : 0;
        }

        public int popBinding(int n2) {
            return -1;
        }

        public String toString() {
            return "[Reserved binding:  " + this.fCurrentURI + "]";
        }
    }

    private static abstract class PrefixBindingInfo {
        protected String fCurrentURI;

        public PrefixBindingInfo(String string2) {
            this.fCurrentURI = string2;
        }

        public String getCurrentBinding() {
            return this.fCurrentURI;
        }

        public abstract int getBindingDepth();

        public abstract int pushBinding(String var1, int var2, boolean var3);

        public abstract int popBinding(int var1);
    }
}

