/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.serializer;

import com.ibm.xml.xci.CursorFactory;
import com.ibm.xml.xci.SessionContext;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.serializer.HtmlElemInfo;

public final class XOutputElemContext {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private final int m_currentElemDepth;
    private HtmlElemInfo.ElemDesc m_elementDesc = HtmlElemInfo.s_elemNotFound;
    private boolean m_isCdataSection = false;
    private boolean m_isInline = false;
    private boolean m_isRaw = false;
    private XOutputElemContext m_next;
    private final XOutputElemContext m_prev;
    private VolatileCData m_qname;
    private State fState;

    final XOutputElemContext getNext() {
        return this.m_next;
    }

    public XOutputElemContext() {
        this.m_prev = this;
        this.m_currentElemDepth = 0;
        this.setState(State.NOTHING);
    }

    private XOutputElemContext(XOutputElemContext xOutputElemContext) {
        this.m_prev = xOutputElemContext;
        this.m_currentElemDepth = xOutputElemContext.getElemDepth() + 1;
    }

    public final XOutputElemContext pop() {
        return this.m_prev;
    }

    public final XOutputElemContext push() {
        XOutputElemContext xOutputElemContext = this.m_next;
        if (xOutputElemContext == null) {
            this.m_next = xOutputElemContext = new XOutputElemContext(this);
        }
        xOutputElemContext.setState(State.IN_START_TAG);
        return xOutputElemContext;
    }

    public final XOutputElemContext pushFresh() {
        XOutputElemContext xOutputElemContext = this.m_next;
        if (xOutputElemContext == null) {
            this.m_next = xOutputElemContext = new XOutputElemContext(this);
        } else {
            xOutputElemContext.setIsCdataSection(false);
            xOutputElemContext.setElementDesc(HtmlElemInfo.s_elemNotFound);
        }
        xOutputElemContext.clearName();
        xOutputElemContext.setIsInline(false);
        xOutputElemContext.setState(State.IN_START_TAG);
        return xOutputElemContext;
    }

    final XOutputElemContext pushFreshNoInit() {
        XOutputElemContext xOutputElemContext = this.m_next;
        if (xOutputElemContext == null) {
            this.m_next = xOutputElemContext = new XOutputElemContext(this);
        }
        return xOutputElemContext;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("depth     : " + this.getElemDepth() + '\n');
        stringBuilder.append("state     : ");
        switch (this.fState) {
            case NOTHING: {
                stringBuilder.append("NOTHING\n");
                break;
            }
            case START_DOCUMENT: {
                stringBuilder.append("NOTHING\n");
                break;
            }
            case IN_START_TAG: {
                stringBuilder.append("IN_START_TAG\n");
                break;
            }
            case IN_NAMESPACES: {
                stringBuilder.append("IN_NAMESPACES\n");
                break;
            }
            case IN_ATTRIBUTES: {
                stringBuilder.append("IN_ATTRIBUTES\n");
                break;
            }
            case IN_CONTENT: {
                stringBuilder.append("IN_CONTENT\n");
                break;
            }
            case IN_TEXT_CONTENT: {
                stringBuilder.append("IN_TEXT_CONTENT\n");
                break;
            }
            case END_DOCUMENT: {
                stringBuilder.append("END_DOCUMENT\n");
                break;
            }
            default: {
                stringBuilder.append("*** ERROR IN VALUE ***\n");
            }
        }
        stringBuilder.append("name      : " + this.getName().getString(1) + '\n');
        stringBuilder.append("local name: " + this.getName().getQNameLocalPart(1) + '\n');
        stringBuilder.append("prefix    : \"" + this.getName().getQNamePrefix(1) + "\"\n");
        stringBuilder.append("uri       : " + this.getName().getQNameNamespaceURI(1) + '\n');
        stringBuilder.append("ElemDesc  :\n");
        if (this.getElementDesc() != null) {
            stringBuilder.append(this.getElementDesc().toString());
        }
        return stringBuilder.toString();
    }

    public int getElemDepth() {
        return this.m_currentElemDepth;
    }

    public void setElemPrefix(String string2) {
        CursorFactory cursorFactory = SessionContext.getStaticSimpleDataFactory();
        this.m_qname = cursorFactory.data((CharSequence)this.m_qname.getQNameNamespaceURI(1), this.m_qname.getQNameLocalPart(1), string2);
    }

    public void setElementDesc(HtmlElemInfo.ElemDesc elemDesc) {
        this.m_elementDesc = elemDesc;
    }

    public HtmlElemInfo.ElemDesc getElementDesc() {
        return this.m_elementDesc;
    }

    public void clearName() {
        this.m_qname = null;
    }

    public void setName(VolatileCData volatileCData) {
        this.m_qname = volatileCData;
    }

    public VolatileCData getName() {
        return this.m_qname;
    }

    public void setIsCdataSection(boolean bl) {
        this.m_isCdataSection = bl;
    }

    public boolean isCDataSection() {
        return this.m_isCdataSection;
    }

    public void setIsInline(boolean bl) {
        this.m_isInline = bl;
    }

    public boolean isInline() {
        return this.m_isInline;
    }

    public void setIsRaw(boolean bl) {
        this.m_isRaw = bl;
    }

    public boolean isRaw() {
        return this.m_isRaw;
    }

    public State getState() {
        return this.fState;
    }

    public void setState(State state) {
        this.fState = state;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        NOTHING(-1, false, false),
        START_DOCUMENT(0, false, false),
        IN_START_TAG(1, true, true),
        IN_NAMESPACES(2, true, true),
        IN_ATTRIBUTES(3, true, false),
        IN_CONTENT(4, false, false),
        IN_TEXT_CONTENT(5, false, false),
        END_DOCUMENT(6, false, false);

        private final int externalOrdinal;
        private final boolean mayAddElemAttr;
        private final boolean mayAddNamespaceNode;

        private State(int n3, boolean bl, boolean bl2) {
            this.externalOrdinal = n3;
            this.mayAddElemAttr = bl;
            this.mayAddNamespaceNode = bl2;
        }

        public int getExternalOrdinal() {
            return this.externalOrdinal;
        }

        public final boolean mayAddElemAttr() {
            return this.mayAddElemAttr;
        }

        public final boolean mayAddNamespaceNode() {
            return this.mayAddNamespaceNode;
        }
    }
}

