/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.serializer;

import com.ibm.xml.xci.dp.values.chars.EncodeContext;
import com.ibm.xml.xci.serializer.HtmlElemInfo;
import com.ibm.xml.xci.serializer.SerializeParamValue;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum XOutputMethod {
    XML("xml", SerializeParamValue.METHOD_XML, "text/xml", "1.0", false, false, EncodeContext.Variant.XML),
    HTML("html", SerializeParamValue.METHOD_HTML, "text/html", "4.01", true, true, EncodeContext.Variant.HTML, new HtmlElemInfo.Trie(false)),
    XHTML("xhtml", SerializeParamValue.METHOD_XHTML, "text/html", "4.01", true, true, EncodeContext.Variant.XML, "http://www.w3.org/1999/xhtml", new HtmlElemInfo.Trie(true)),
    TEXT("text", SerializeParamValue.METHOD_TEXT, "text/plain", "1.0", false, false, EncodeContext.Variant.ASCII),
    UNKNOWN("", "text/xml", "1.0", false, false, EncodeContext.Variant.XML);

    public final String name;
    public final QName qname;
    public final String uri;
    public final String defaultMediaType;
    public final String defaultVersion;
    public final boolean defaultIndent;
    public final boolean isHTMLNature;
    public final EncodeContext.Variant encodeContextVariant;
    public final HtmlElemInfo.Trie elementFlags;
    public final EncodeContext NAME;
    public final EncodeContext PCDATA;
    public final EncodeContext PCDATA_ROUNDTRIP;
    public final EncodeContext ATTRIBUTE_SINGLE_QUOTE;
    public final EncodeContext ATTRIBUTE_DOUBLE_QUOTE;
    public final EncodeContext PI;
    public final EncodeContext COMMENT;
    public final EncodeContext NAMESPACE;
    public final EncodeContext CDATASECTION;
    public final EncodeContext NOTHING;

    public static void main(String[] stringArray) throws IllegalArgumentException, IllegalAccessException {
    }

    private XOutputMethod(String string3, QName qName, String string4, String string5, boolean bl, boolean bl2, EncodeContext.Variant variant, String string6, HtmlElemInfo.Trie trie) {
        this.name = string3;
        this.qname = qName;
        this.defaultMediaType = string4;
        this.defaultVersion = string5;
        this.defaultIndent = bl;
        this.isHTMLNature = bl2;
        this.encodeContextVariant = variant;
        this.uri = string6;
        this.NAME = EncodeContext.NAME.getVariant(variant);
        this.PCDATA = EncodeContext.PCDATA.getVariant(variant);
        this.PCDATA_ROUNDTRIP = EncodeContext.PCDATA_ROUNDTRIP.getVariant(variant);
        this.ATTRIBUTE_SINGLE_QUOTE = EncodeContext.ATTRIBUTE_SINGLE_QUOTE.getVariant(variant);
        this.ATTRIBUTE_DOUBLE_QUOTE = EncodeContext.ATTRIBUTE_DOUBLE_QUOTE.getVariant(variant);
        this.PI = EncodeContext.PI.getVariant(variant);
        this.COMMENT = EncodeContext.COMMENT.getVariant(variant);
        this.NAMESPACE = EncodeContext.NAMESPACE.getVariant(variant);
        this.CDATASECTION = EncodeContext.CDATASECTION.getVariant(variant);
        this.NOTHING = EncodeContext.NOTHING.getVariant(variant);
        this.elementFlags = trie;
        if (trie != null) {
            HtmlElemInfo.initTagReference(trie);
        }
    }

    private XOutputMethod(String string3, QName qName, String string4, String string5, boolean bl, boolean bl2, EncodeContext.Variant variant, HtmlElemInfo.Trie trie) {
        this(string3, qName, string4, string5, bl, bl2, variant, "", trie);
    }

    private XOutputMethod(String string3, QName qName, String string4, String string5, boolean bl, boolean bl2, EncodeContext.Variant variant) {
        this(string3, qName, string4, string5, bl, bl2, variant, "", null);
    }

    private XOutputMethod(String string3, String string4, String string5, boolean bl, boolean bl2, EncodeContext.Variant variant) {
        this(string3, new QName(string3), string4, string5, bl, bl2, variant, "", null);
    }

    public static XOutputMethod get(Object object2) {
        if (object2 instanceof String) {
            String string2 = (String)object2;
            return XOutputMethod.getMethodFromString(string2);
        }
        if (object2 instanceof QName) {
            XOutputMethod[] xOutputMethodArray;
            QName qName = (QName)object2;
            String string3 = qName.getLocalPart();
            XOutputMethod xOutputMethod = XOutputMethod.getMethodFromString(string3);
            String string4 = qName.getNamespaceURI();
            switch (xOutputMethod) {
                case XML: 
                case HTML: {
                    if (string4 == null || "".equals(string4)) {
                        return xOutputMethod;
                    }
                    return UNKNOWN;
                }
                case XHTML: {
                    if (string4 != null && "http://ibm.com/xml/xci/serializer".equals(string4)) {
                        return xOutputMethod;
                    }
                    if (string4 == null || "".equals(string4)) {
                        return xOutputMethod;
                    }
                    return UNKNOWN;
                }
                case TEXT: {
                    if (string4 == null || "".equals(string4)) {
                        return xOutputMethod;
                    }
                    return UNKNOWN;
                }
                case UNKNOWN: {
                    return xOutputMethod;
                }
            }
            for (XOutputMethod xOutputMethod2 : xOutputMethodArray = XOutputMethod.values()) {
                if (xOutputMethod2.qname == null || !xOutputMethod2.qname.equals(object2)) continue;
                return xOutputMethod2;
            }
        } else if (object2 == null) {
            return XML;
        }
        return UNKNOWN;
    }

    private static XOutputMethod getMethodFromString(String string2) {
        char c = (char)(string2.charAt(0) & 0xFFDF);
        if (c == 'X') {
            if (string2.length() == 3 && (char)(string2.charAt(1) & 0xFFDF) == 'M' && (char)(string2.charAt(2) & 0xFFDF) == 'L') {
                return XML;
            }
            if (string2.length() == 5 && (char)(string2.charAt(1) & 0xFFDF) == 'H' && (char)(string2.charAt(2) & 0xFFDF) == 'T' && (char)(string2.charAt(3) & 0xFFDF) == 'M' && (char)(string2.charAt(4) & 0xFFDF) == 'L') {
                return XHTML;
            }
            return UNKNOWN;
        }
        if (c == 'H' && (char)(string2.charAt(1) & 0xFFDF) == 'T' && (char)(string2.charAt(2) & 0xFFDF) == 'M' && (char)(string2.charAt(3) & 0xFFDF) == 'L' && string2.length() == 4) {
            return HTML;
        }
        if (c == 'T' && (char)(string2.charAt(1) & 0xFFDF) == 'E' && (char)(string2.charAt(2) & 0xFFDF) == 'X' && (char)(string2.charAt(3) & 0xFFDF) == 'T' && string2.length() == 4) {
            return TEXT;
        }
        return UNKNOWN;
    }
}

