/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.serializer;

import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.CursorFactory;
import com.ibm.xml.xci.SessionContext;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.serializer.HtmlElemInfo;
import com.ibm.xml.xci.serializer.XOutputElemContext;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;

public final class XOutputNamespaceContext {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private HtmlElemInfo.ElemDesc elementDesc = HtmlElemInfo.s_elemNotFound;
    private VolatileCData qname;
    private int namespaceNodeFirst;
    private int namespaceNodeLast;
    private Cursor.Area where;
    private XSTypeDefinition type;
    private boolean hasBeenOutput;
    private XOutputElemContext.State fState;

    public XOutputNamespaceContext() {
        this.setState(XOutputElemContext.State.NOTHING);
        this.hasBeenOutput = true;
    }

    public void scrub() {
        this.fState = XOutputElemContext.State.NOTHING;
        this.hasBeenOutput = true;
        this.qname = null;
        this.type = null;
        this.where = null;
        this.namespaceNodeFirst = -1;
        this.namespaceNodeLast = -1;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("state     : ");
        stringBuilder.append(this.fState != null ? this.fState.toString() : "NULL");
        stringBuilder.append("\n");
        VolatileCData volatileCData = this.getName();
        if (volatileCData != null) {
            stringBuilder.append("name      : " + volatileCData.getString(1) + '\n');
            stringBuilder.append("local name: " + volatileCData.getQNameLocalPart(1) + '\n');
            stringBuilder.append("prefix    : \"" + volatileCData.getQNamePrefix(1) + "\"\n");
            stringBuilder.append("uri       : " + volatileCData.getQNameNamespaceURI(1) + '\n');
            stringBuilder.append("where: " + this.where);
            stringBuilder.append('\n');
        } else {
            stringBuilder.append("(name not set)\n");
        }
        if (this.getElementDesc() != null) {
            stringBuilder.append(this.getElementDesc().toString());
        }
        stringBuilder.append("namespaceNodeFirst: " + this.namespaceNodeFirst);
        stringBuilder.append('\n');
        stringBuilder.append("namespaceNodeLast: " + this.namespaceNodeLast);
        stringBuilder.append('\n');
        stringBuilder.append("hasBeenOutput: " + this.hasBeenOutput);
        stringBuilder.append('\n');
        return stringBuilder.toString();
    }

    public void setElemPrefix(String string2) {
        CursorFactory cursorFactory = SessionContext.getStaticSimpleDataFactory();
        this.qname = cursorFactory.data((CharSequence)this.qname.getQNameNamespaceURI(1), this.qname.getQNameLocalPart(1), string2);
    }

    public void setElementDesc(HtmlElemInfo.ElemDesc elemDesc) {
        this.elementDesc = elemDesc;
    }

    public HtmlElemInfo.ElemDesc getElementDesc() {
        return this.elementDesc;
    }

    public void clearName() {
        this.qname = null;
    }

    public void setName(VolatileCData volatileCData) {
        this.qname = volatileCData;
    }

    public VolatileCData getName() {
        return this.qname;
    }

    public void addNamespaceNode(int n2) {
        int n3 = this.getNamespaceNodeFirst();
        if (n3 == -1) {
            this.setNamespaceNodeFirst(n2);
        }
        this.setNamespaceNodeLast(n2);
    }

    public XOutputElemContext.State getState() {
        return this.fState;
    }

    public void setState(XOutputElemContext.State state) {
        this.fState = state;
    }

    public final Cursor.Area getWhere() {
        return this.where;
    }

    public final void setWhere(Cursor.Area area) {
        this.where = area;
    }

    public final XSTypeDefinition getType() {
        return this.type;
    }

    public final void setType(XSTypeDefinition xSTypeDefinition) {
        this.type = xSTypeDefinition;
    }

    public final boolean getHasBeenOutput() {
        return this.hasBeenOutput;
    }

    public final void setHasBeenOutput(boolean bl) {
        this.hasBeenOutput = bl;
    }

    public final int getNamespaceNodeFirst() {
        return this.namespaceNodeFirst;
    }

    public final void setNamespaceNodeFirst(int n2) {
        this.namespaceNodeFirst = n2;
    }

    public final int getNamespaceNodeLast() {
        return this.namespaceNodeLast;
    }

    public final void setNamespaceNodeLast(int n2) {
        this.namespaceNodeLast = n2;
    }

    public final boolean hasNamespaces() {
        return this.namespaceNodeFirst >= 0;
    }
}

