/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.serializer;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.dp.util.XCIErrorHelper;
import com.ibm.xml.xci.dp.values.chars.Chars;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;

class XOutputStream2Writer
extends OutputStream {
    private static final Logger gLogger = LoggerUtil.getLogger(XOutputStream2Writer.class);
    final Writer writer;
    final Charset charset;

    public XOutputStream2Writer(Writer writer, Charset charset) {
        if (LoggerUtil.isFinestLoggable(gLogger)) {
            XOutputStream2Writer.logConstructor(gLogger, Level.FINEST, writer, charset);
        }
        this.writer = writer;
        this.charset = charset == null ? Chars.UTF8 : charset;
    }

    public void write(int n2) throws IOException {
        byte[] byArray = new byte[]{(byte)n2};
        if (LoggerUtil.isFinerLoggable(gLogger)) {
            XOutputStream2Writer.logBytes(gLogger, Level.FINER, byArray, 0, byArray.length, "write(int)");
        }
        CharBuffer charBuffer = this.charset.decode(ByteBuffer.wrap(byArray));
        if (LoggerUtil.isFinestLoggable(gLogger)) {
            XOutputStream2Writer.logCharBuffer(gLogger, Level.FINEST, charBuffer, "write(int)");
        }
        this.writer.append(charBuffer);
    }

    public void write(byte[] byArray, int n2, int n3) throws IOException {
        if (LoggerUtil.isFinerLoggable(gLogger)) {
            XOutputStream2Writer.logBytes(gLogger, Level.FINER, byArray, n2, n2 + n3, "write(byte[], int, int)");
        }
        CharBuffer charBuffer = this.charset.decode(ByteBuffer.wrap(byArray, n2, n3));
        if (LoggerUtil.isFinestLoggable(gLogger)) {
            XOutputStream2Writer.logCharBuffer(gLogger, Level.FINEST, charBuffer, "write(byte[], int, int)");
        }
        this.writer.append(charBuffer);
    }

    public void write(byte[] byArray) throws IOException {
        if (LoggerUtil.isFinerLoggable(gLogger)) {
            XOutputStream2Writer.logBytes(gLogger, Level.FINER, byArray, 0, byArray.length, "write(byte[])");
        }
        CharBuffer charBuffer = this.charset.decode(ByteBuffer.wrap(byArray));
        if (LoggerUtil.isFinestLoggable(gLogger)) {
            XOutputStream2Writer.logCharBuffer(gLogger, Level.FINEST, charBuffer, "write(byte[])");
        }
        this.writer.append(charBuffer);
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public Writer getWriter() {
        return this.writer;
    }

    protected static final void logConstructor(Logger logger, Level level, Writer writer, Charset charset) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Writer: ");
        stringBuilder.append(writer.getClass().getName());
        stringBuilder.append('@');
        stringBuilder.append(Integer.toHexString(writer.hashCode()));
        stringBuilder.append(" - Charset: ");
        stringBuilder.append(charset.name());
        logger.logp(level, logger.getName(), "XOutputStream2Writer(...)", stringBuilder.toString());
    }

    protected static final void logBytes(Logger logger, Level level, byte[] byArray, int n2, int n3, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nstart: ");
        stringBuilder.append(n2);
        stringBuilder.append(", end: ");
        stringBuilder.append(n3);
        stringBuilder.append(", bbuf: @");
        stringBuilder.append(Integer.toHexString(byArray.hashCode()));
        stringBuilder.append("\n bytes before decoding (from start) {\n");
        if (n3 > n2) {
            stringBuilder.append(byArray[n2]);
            for (int i = n2 + 1; i < n3; ++i) {
                stringBuilder.append(' ');
                stringBuilder.append(byArray[i]);
                if (i % 32 != 0) continue;
                stringBuilder.append('\n');
            }
        }
        stringBuilder.append("}\nStack trace= ");
        stringBuilder.append(XCIErrorHelper.getStackTrace(20));
        logger.logp(level, logger.getName(), string2, stringBuilder.toString());
    }

    protected static final void logCharBuffer(Logger logger, Level level, CharBuffer charBuffer, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Characters after decoding: [");
        stringBuilder.append(charBuffer);
        stringBuilder.append("]\nCharacters after decoding as int[] {\n");
        int n2 = charBuffer.length();
        if (n2 > 0) {
            stringBuilder.append((int)charBuffer.charAt(0));
            for (int i = 1; i < n2; ++i) {
                stringBuilder.append(' ');
                stringBuilder.append((int)charBuffer.charAt(i));
                if (i % 32 != 0) continue;
                stringBuilder.append('\n');
            }
        }
        stringBuilder.append("\n}");
        logger.logp(level, logger.getName(), string2, stringBuilder.toString());
    }
}

