/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.serializer;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.dp.util.XCIErrorHelper;
import com.ibm.xml.xci.dp.values.chars.Chars;
import com.ibm.xml.xci.dp.values.chars.EncodeContext;
import com.ibm.xml.xci.serializer.CharInfo;
import com.ibm.xml.xci.serializer.CodepointMappings;
import com.ibm.xml.xci.serializer.EncodingInfo;
import com.ibm.xml.xci.serializer.Encodings;
import com.ibm.xml.xci.serializer.Messages;
import com.ibm.xml.xci.serializer.UnicodeNormalizer;
import com.ibm.xml.xci.serializer.UnicodeNormalizerFactory;
import com.ibm.xml.xci.serializer.XOutputMethod;
import com.ibm.xml.xci.serializer.XOutputStream2Writer;
import com.ibm.xml.xci.serializer.XOutputWriter2Writer;
import com.ibm.xml.xci.serializer.XOutputWriter8Bit;
import com.ibm.xml.xci.serializer.XWriterCache;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class XOutputWriter {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2010. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger gLogger = LoggerUtil.getLogger(XOutputWriter.class);
    protected OutputStream out;
    protected Writer writer;
    final boolean shouldCloseOutputStreamAtEnd;
    final boolean shouldCloseWriterAtEnd;
    protected Charset outputCharset;
    protected EncodingInfo encodingInfo;
    protected boolean isXML11;
    protected int normalizerMode;
    protected UnicodeNormalizer unicodeNormalizer;
    protected int m_normalizerMode = 1;
    protected UnicodeNormalizer m_unicodeNormalizer = null;
    protected char[] indentLineSep;
    protected int indentLineSepLen;
    protected char indentChar;
    public byte[][] charmaps;
    protected CodepointMappings codepointMappings;
    private static final byte[][] s_charMaps1_0;
    private static final byte[][] s_charMaps1_1;
    private static final byte[][] s_charMaps1_0CodePoint;
    private static final byte[][] s_charMaps1_1CodePoint;
    private static final CharInfo s_htmlcharInfo;
    private CharInfo.CharKey m_charKey = new CharInfo.CharKey();
    protected final int CHARSBUFF_MAX_SIZE = 65536;
    private char[] m_charsBuff = new char[60];
    private static final int HIGH1Mask = 128;
    private static final int HIGH2Mask = 192;
    private static final int HIGH3Mask = 224;
    private static final int HIGH4Mask = 240;
    private static final int HIGH5Mask = 248;
    private static final int BYTES1 = 0;
    private static final int BYTES2 = 192;
    private static final int BYTES3 = 224;
    private static final int BYTES4 = 240;
    private static final int ANOTHER = 128;
    private int byteCodePointCollectingStartIndex = -1;
    private int bytesStillToCollect = -1;
    private byte[] encodeBuf = new byte[4];
    private int posInEncodeBuf = 0;

    public static XOutputWriter make(EncodingInfo encodingInfo, boolean bl, char[] cArray, char c, CodepointMappings codepointMappings, OutputStream outputStream, boolean bl2) {
        String string2 = encodingInfo.getName();
        Charset charset = Charset.forName(string2);
        XOutputWriter xOutputWriter = charset == Chars.UTF8 ? XWriterCache.getXOutputWriter8Bit(charset, encodingInfo, bl, cArray, c, codepointMappings, outputStream) : (encodingInfo.isAsciiType() ? XWriterCache.getXOutputWriter8Bit(charset, encodingInfo, bl, cArray, c, codepointMappings, outputStream) : new XOutputWriter2Writer(charset, encodingInfo, bl, cArray, c, codepointMappings, outputStream, bl2));
        if (LoggerUtil.isFinestLoggable(gLogger)) {
            XOutputWriter.logWriter(gLogger, Level.FINEST, xOutputWriter, "make");
        }
        return xOutputWriter;
    }

    public static void returnWriter(XOutputWriter xOutputWriter) {
        if (xOutputWriter instanceof XOutputWriter8Bit) {
            XWriterCache.returnXOutputWriter8Bit((XOutputWriter8Bit)xOutputWriter);
        }
    }

    public static XOutputWriter make(EncodingInfo encodingInfo, boolean bl, char[] cArray, char c, CodepointMappings codepointMappings, Writer writer) {
        String string2 = encodingInfo.getName();
        Charset charset = Charset.forName(string2);
        XOutputWriter2Writer xOutputWriter2Writer = new XOutputWriter2Writer(charset, encodingInfo, bl, cArray, c, codepointMappings, writer);
        return xOutputWriter2Writer;
    }

    protected XOutputWriter(Charset charset, EncodingInfo encodingInfo, boolean bl, char[] cArray, char c, CodepointMappings codepointMappings, OutputStream outputStream) {
        this.outputCharset = charset;
        this.encodingInfo = encodingInfo;
        this.isXML11 = bl;
        this.out = outputStream;
        this.shouldCloseOutputStreamAtEnd = false;
        this.shouldCloseWriterAtEnd = true;
        this.normalizerMode = 1;
        this.unicodeNormalizer = null;
        this.indentLineSep = cArray;
        this.indentLineSepLen = cArray.length;
        this.indentChar = c;
        this.codepointMappings = codepointMappings;
        int n2 = EncodeContext.variantList.length;
        this.charmaps = new byte[n2][];
        byte[][] byArray = codepointMappings != null && codepointMappings.hasByteSizeMappings() ? (bl ? s_charMaps1_1CodePoint : s_charMaps1_0CodePoint) : (bl ? s_charMaps1_1 : s_charMaps1_0);
        System.arraycopy(byArray, 0, this.charmaps, 0, n2);
    }

    protected XOutputWriter(Charset charset, EncodingInfo encodingInfo, boolean bl, char[] cArray, char c, CodepointMappings codepointMappings, Writer writer) {
        this.outputCharset = charset;
        this.encodingInfo = encodingInfo;
        this.isXML11 = bl;
        this.writer = writer;
        this.shouldCloseWriterAtEnd = false;
        this.out = new XOutputStream2Writer(writer, charset);
        this.shouldCloseOutputStreamAtEnd = true;
        this.normalizerMode = 1;
        this.unicodeNormalizer = null;
        this.indentLineSep = cArray;
        this.indentLineSepLen = cArray.length;
        this.indentChar = c;
        this.codepointMappings = codepointMappings;
        int n2 = EncodeContext.variantList.length;
        this.charmaps = new byte[n2][];
        byte[][] byArray = codepointMappings != null && codepointMappings.hasByteSizeMappings() ? (bl ? s_charMaps1_1CodePoint : s_charMaps1_0CodePoint) : (bl ? s_charMaps1_1 : s_charMaps1_0);
        System.arraycopy(byArray, 0, this.charmaps, 0, n2);
    }

    protected void reset(Charset charset, EncodingInfo encodingInfo, boolean bl, char[] cArray, char c, CodepointMappings codepointMappings, OutputStream outputStream) {
        this.outputCharset = charset;
        this.encodingInfo = encodingInfo;
        this.isXML11 = bl;
        this.out = outputStream;
        this.normalizerMode = 1;
        this.unicodeNormalizer = null;
        this.indentLineSep = cArray;
        this.indentLineSepLen = cArray.length;
        this.indentChar = c;
        this.codepointMappings = codepointMappings;
        int n2 = EncodeContext.variantList.length;
        byte[][] byArray = codepointMappings != null && codepointMappings.hasByteSizeMappings() ? (bl ? s_charMaps1_1CodePoint : s_charMaps1_0CodePoint) : (bl ? s_charMaps1_1 : s_charMaps1_0);
        System.arraycopy(byArray, 0, this.charmaps, 0, n2);
    }

    public void startHTMLAttrState() {
    }

    public void endHTMLAttrState() throws IOException {
    }

    private void initCharMappings(CodepointMappings codepointMappings, EncodeContext[] encodeContextArray) {
        for (int i = 0; i < encodeContextArray.length; ++i) {
            if (encodeContextArray[i].map == null) continue;
            if (codepointMappings != null && codepointMappings.hasByteSizeMappings()) {
                EncodeContext encodeContext = encodeContextArray[i].base;
                switch (encodeContext) {
                    case NAME: {
                        this.charmaps[i] = encodeContextArray[i].map;
                        break;
                    }
                    case PCDATA: {
                        this.charmaps[i] = null;
                        break;
                    }
                    case PCDATA_ROUNDTRIP: {
                        this.charmaps[i] = null;
                        break;
                    }
                    case ATTRIBUTE_SINGLE_QUOTE: {
                        this.charmaps[i] = null;
                        break;
                    }
                    case ATTRIBUTE_DOUBLE_QUOTE: {
                        this.charmaps[i] = null;
                        break;
                    }
                    case PI: {
                        if (this.isXML11) {
                            this.charmaps[i] = null;
                            break;
                        }
                        this.charmaps[i] = encodeContextArray[i].map;
                        break;
                    }
                    case COMMENT: {
                        if (this.isXML11) {
                            this.charmaps[i] = null;
                            break;
                        }
                        this.charmaps[i] = encodeContextArray[i].map;
                        break;
                    }
                    case NAMESPACE: {
                        this.charmaps[i] = encodeContextArray[i].map;
                        break;
                    }
                    case CDATASECTION: {
                        this.charmaps[i] = encodeContextArray[i].map;
                        break;
                    }
                    case NOTHING: {
                        this.charmaps[i] = encodeContextArray[i].map;
                    }
                }
                continue;
            }
            this.charmaps[i] = (byte[])(this.isXML11 && (encodeContextArray[i].base == EncodeContext.PI || encodeContextArray[i].base == EncodeContext.COMMENT) ? null : encodeContextArray[i].map);
        }
    }

    private final byte[] makeInstanceMapping(int n2) {
        EncodeContext[] encodeContextArray = EncodeContext.values();
        EncodeContext encodeContext = encodeContextArray[n2];
        int n3 = encodeContext.map.length;
        byte[] byArray = new byte[n3];
        System.arraycopy(encodeContext.map, 0, byArray, 0, n3);
        if (encodeContext.base == EncodeContext.PI || encodeContext.base == EncodeContext.COMMENT) {
            assert (this.isXML11);
            byArray[133] = 0;
        } else {
            int n4;
            List<Integer> list = this.codepointMappings.getCodePointsMapped();
            int n5 = list.size();
            for (int i = 0; i < n5 && (n4 = list.get(i).intValue()) < n3; ++i) {
                byArray[n4] = 17;
            }
        }
        this.charmaps[n2] = byArray;
        return byArray;
    }

    public final byte[] getCharMap(EncodeContext encodeContext) {
        int n2 = encodeContext.ordinal();
        byte[] byArray = this.charmaps[n2];
        return byArray != null ? byArray : this.makeInstanceMapping(n2);
    }

    public void close() throws IOException {
        if (this.shouldCloseWriterAtEnd) {
            this.writer.close();
        }
        if (this.shouldCloseOutputStreamAtEnd) {
            this.out.close();
        }
    }

    public void flushBuffers() throws IOException {
    }

    public abstract void write(Chars var1, int var2, int var3, EncodeContext var4) throws IOException;

    public abstract void write(Chars var1, EncodeContext var2) throws IOException;

    public abstract void write(String var1, EncodeContext var2) throws IOException;

    public abstract void write(String var1, int var2, int var3, EncodeContext var4) throws IOException;

    public abstract void write(CharSequence var1, EncodeContext var2) throws IOException;

    public abstract void write(char[] var1, int var2, int var3, EncodeContext var4) throws IOException;

    public abstract void write(char var1, EncodeContext var2) throws IOException;

    public abstract void write(byte[] var1, int var2, int var3, EncodeContext var4) throws IOException;

    public abstract void writeWithLBNormalization(byte[] var1, int var2, int var3, EncodeContext var4) throws IOException;

    public abstract void write(byte[] var1, EncodeContext var2) throws IOException;

    public abstract void write(byte var1, EncodeContext var2) throws IOException;

    public abstract void write(char var1, int var2, EncodeContext var3) throws IOException;

    public abstract void writeBOM() throws IOException;

    public abstract void writeLineBreak() throws IOException;

    public abstract void writeXMLVersionOpen() throws IOException;

    public abstract void writeXMLEncodingOpen() throws IOException;

    public abstract void writeXMLHeaderClose() throws IOException;

    public abstract void writeDocTypeOpen() throws IOException;

    public abstract void writePublicIDOpen() throws IOException;

    public abstract void writeSystemIDOpen() throws IOException;

    public abstract void writeQuoteSpaceQuote() throws IOException;

    public abstract void writeStartTagOpen() throws IOException;

    public abstract void writeStartTagClose() throws IOException;

    public abstract void writeEndTagOpen() throws IOException;

    public abstract void writeEndTagClose() throws IOException;

    public abstract void writeEmptyElementClose() throws IOException;

    public abstract void writeSpaceEmptyElementClose() throws IOException;

    public abstract void writeEmptyElementEndEndTagOpen() throws IOException;

    public abstract void writeSpace() throws IOException;

    public abstract void writeEqualsQuote() throws IOException;

    public abstract void writeQuote() throws IOException;

    public abstract void writeColon() throws IOException;

    public abstract void writePIOpen() throws IOException;

    public abstract void writePIClose(EncodeContext var1) throws IOException;

    public abstract void writeSpaceXMLNSColon() throws IOException;

    public abstract void writeSpaceXMLNS() throws IOException;

    public abstract void writeQuoteDocTypeClose() throws IOException;

    public abstract void writeLTEntity() throws IOException;

    public abstract void writeGTEntity() throws IOException;

    public abstract void writeAmpEntity() throws IOException;

    public abstract void writeQuotEntity() throws IOException;

    public abstract void writeIntEntityStart() throws IOException;

    public abstract void writeHexEntityStart() throws IOException;

    public abstract void writeEntityEnd() throws IOException;

    public abstract void writeCDataSectionStart() throws IOException;

    public abstract void writeCDataSectionEnd() throws IOException;

    public abstract void writeCommentStart() throws IOException;

    public abstract void writeCommentEnd() throws IOException;

    void writeHTMLAttrURI(Chars chars, EncodeContext encodeContext) throws IOException {
        int n2;
        String string2 = ((Object)chars).toString();
        Writer writer = this.getWriter();
        if (this.m_unicodeNormalizer == null) {
            this.m_unicodeNormalizer = UnicodeNormalizerFactory.getUnicodeNormalizer();
        }
        if (!this.m_unicodeNormalizer.alreadyNormalized(string2, 2)) {
            string2 = this.m_unicodeNormalizer.normalizeUnicode(string2, 2);
        }
        int n3 = string2.length();
        for (int i = 0; i < n3; i += n2) {
            n2 = this.getChars(string2, i, n3);
            char[] cArray = this.getCharsBuff();
            char c = '\u0000';
            for (int j = 0; j < n2; ++j) {
                String string3;
                c = cArray[j];
                if (c < ' ' || c > '~') {
                    int n4;
                    int n5;
                    if (c <= '\u007f') {
                        writer.write(37);
                        writer.write(XOutputWriter.makeHexString(c));
                        continue;
                    }
                    if (c <= '\u07ff') {
                        int n6 = c >> 6 | 0xC0;
                        n5 = c & 0x3F | 0x80;
                        writer.write(37);
                        writer.write(XOutputWriter.makeHexString(n6));
                        writer.write(37);
                        writer.write(XOutputWriter.makeHexString(n5));
                        continue;
                    }
                    if (Encodings.isHighUTF16Surrogate(c)) {
                        int n7 = c & 0x3FF;
                        n5 = (n7 & 0x3C0) >> 6;
                        n4 = n5 + 1;
                        int n8 = (n7 & 0x3C) >> 2;
                        int n9 = (n7 & 3) << 4 & 0x30;
                        c = cArray[++j];
                        int n10 = c & 0x3FF;
                        int n11 = n10 & 0x3F;
                        int n12 = 0xF0 | n4 >> 2;
                        int n13 = 0x80 | (n4 & 3) << 4 & 0x30 | n8;
                        int n14 = 0x80 | (n9 |= (n10 & 0x3C0) >> 6);
                        int n15 = 0x80 | n11;
                        writer.write(37);
                        writer.write(XOutputWriter.makeHexString(n12));
                        writer.write(37);
                        writer.write(XOutputWriter.makeHexString(n13));
                        writer.write(37);
                        writer.write(XOutputWriter.makeHexString(n14));
                        writer.write(37);
                        writer.write(XOutputWriter.makeHexString(n15));
                        continue;
                    }
                    int n16 = c >> 12 | 0xE0;
                    n5 = (c & 0xFC0) >> 6 | 0x80;
                    n4 = c & 0x3F | 0x80;
                    writer.write(37);
                    writer.write(XOutputWriter.makeHexString(n16));
                    writer.write(37);
                    writer.write(XOutputWriter.makeHexString(n5));
                    writer.write(37);
                    writer.write(XOutputWriter.makeHexString(n4));
                    continue;
                }
                switch (c) {
                    case '\"': {
                        string3 = "&quot;";
                        break;
                    }
                    case '&': {
                        string3 = "&amp;";
                        break;
                    }
                    case '<': {
                        string3 = "&lt;";
                        break;
                    }
                    case '>': {
                        string3 = "&gt;";
                        break;
                    }
                    default: {
                        string3 = null;
                    }
                }
                if (string3 != null) {
                    writer.write(string3);
                    continue;
                }
                writer.write(c);
            }
        }
    }

    int getChars(String string2, int n2, int n3) {
        int n4;
        int n5 = n3 - n2;
        if (n5 <= 0) {
            n4 = 0;
        } else {
            char[] cArray = this.m_charsBuff;
            int n6 = cArray.length;
            if (n5 <= n6) {
                int n7 = n5 - 1;
                string2.getChars(n2, n3, cArray, 0);
                char c = cArray[n7];
                n4 = Encodings.isHighUTF16Surrogate(c) ? n7 : n5;
            } else {
                if (n6 != 65536) {
                    n6 = n5 * 2 + 1;
                    if (n6 > 65536) {
                        n6 = 65536;
                    }
                    this.m_charsBuff = cArray = new char[n6];
                }
                if (n6 < n5) {
                    n5 = n6;
                    n3 = n2 + n5;
                }
                int n8 = n5 - 1;
                string2.getChars(n2, n3, cArray, 0);
                char c = cArray[n8];
                n4 = Encodings.isHighUTF16Surrogate(c) ? n8 : n5;
            }
        }
        return n4;
    }

    final char[] getCharsBuff() {
        return this.m_charsBuff;
    }

    protected static final String makeHexString(int n2) {
        String string2 = Integer.toHexString(n2).toUpperCase(Locale.ENGLISH);
        if (string2.length() == 1) {
            string2 = "0" + string2;
        }
        return string2;
    }

    public final int getNormalizerMode() {
        return this.normalizerMode;
    }

    public final void setNormalizerMode(int n2) {
        this.normalizerMode = n2;
    }

    public final UnicodeNormalizer getUnicodeNormalizer() {
        return this.unicodeNormalizer;
    }

    public final void setUnicodeNormalizer(UnicodeNormalizer unicodeNormalizer) {
        this.unicodeNormalizer = unicodeNormalizer;
    }

    public final Charset getCharset() {
        return this.outputCharset;
    }

    public final boolean isXML11() {
        return this.isXML11;
    }

    public final EncodingInfo getEncodingInfo() {
        return this.encodingInfo;
    }

    public abstract void writeDirect(byte[] var1) throws IOException;

    public abstract void writeDirect(byte[] var1, int var2, int var3) throws IOException;

    public abstract void writeDirectUTF8(byte[] var1, int var2, int var3) throws IOException;

    protected final OutputStream getOutputStream() {
        return this.out;
    }

    protected final void setOuputStream(OutputStream outputStream) {
        this.out = outputStream;
    }

    public final Writer getWriter() {
        return this.writer;
    }

    protected abstract void writeCharacterAsInt(int var1) throws IOException;

    protected abstract void writeCharacterAsHex(int var1) throws IOException;

    protected final boolean writeEscaped(byte by2, int n2) throws IOException {
        return this.writeEscaped((char)by2, n2);
    }

    protected final boolean writeEscaped(char c, int n2) throws IOException {
        if (LoggerUtil.isFinestLoggable(gLogger)) {
            gLogger.logp(Level.FINEST, gLogger.getName(), "writeEscaped", "writing char: '" + c + "', charAsInt: " + c + " - with escapeCode: " + n2);
        }
        switch (n2) {
            case 0: 
            case 23: {
                this.writer.write(c);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                this.writeCharacterAsInt(c);
                break;
            }
            case 4: {
                this.writeLTEntity();
                break;
            }
            case 5: {
                this.writeGTEntity();
                break;
            }
            case 6: {
                this.writeAmpEntity();
                break;
            }
            case 7: {
                this.writeQuotEntity();
                break;
            }
            case 8: {
                this.writer.write(c);
                break;
            }
            case 9: {
                this.writeHTMLAttrAmp();
                return true;
            }
            case 18: {
                this.writeHTMLAttrLeftCurly();
                break;
            }
            case 10: {
                if (this.encodingInfo.isCharInEncoding(c)) {
                    this.writer.write(c);
                    break;
                }
                this.writeCharacterAsHex(c);
                break;
            }
            case 11: {
                String string2 = Messages.createMessage2("ER_SER_INVALID_CHARACTER_IN_TEXT", new String[]{Integer.toString(c, 16)});
                Messages.xciDynamicErrorException(string2);
                break;
            }
            case 12: {
                String string3 = s_htmlcharInfo.getOutputStringForChar(c, this.m_charKey);
                this.writer.write(string3);
                break;
            }
            case 15: {
                String string4 = Messages.createMessage2("ER_SER_INVALID_CHARACTER_IN_TEXT", new String[]{Integer.toString(c, 16)});
                Messages.xciDynamicErrorException(string4);
                break;
            }
            case 16: {
                if (c <= '\u007f') {
                    if (c <= '\u001f' && !this.isXML11) {
                        String string5 = Messages.createMessage2("ER_SER_INVALID_CHARACTER_IN_TEXT", new String[]{Integer.toString(c, 16)});
                        Messages.xciDynamicErrorException(string5);
                    }
                    this.writeCharacterAsInt(c);
                    break;
                }
                this.writeCharacterAsHex(c);
                break;
            }
            case 21: {
                String string6 = Messages.createMessage2("ER_SER_BAD_HTML_CONTROL_CHARS", new String[]{Integer.toString(c, 16)});
                Messages.xciDynamicErrorException(string6);
                break;
            }
            case 17: {
                assert (this.codepointMappings != null && this.codepointMappings.hasMappings());
                String string7 = this.codepointMappings.getString(c);
                assert (string7 != null);
                this.writer.write(string7);
                break;
            }
            case 22: {
                this.writeLineBreak();
                break;
            }
            default: {
                assert (false) : "assert didn't handle char exception code";
                break;
            }
        }
        return false;
    }

    protected abstract void writeHTMLAttrAmp() throws IOException;

    protected abstract void writeHTMLAttrLeftCurly() throws IOException;

    protected final boolean isValidXMLChar(int n2) {
        return n2 < 55296 || n2 >= 57344 && n2 <= 65533 || n2 >= 65536 && n2 <= 0x10FFFF;
    }

    protected int writeHighUTF16(char c, CharSequence charSequence, int n2, int n3, EncodeContext encodeContext) throws IOException {
        if ((c & Short.MIN_VALUE) == 0 && this.isValidXMLChar(c)) {
            String string2;
            if (this.codepointMappings != null && (string2 = this.codepointMappings.getString(c)) != null) {
                this.writer.write(string2);
                return n2;
            }
            if (encodeContext.isASCIIEncoding && encodeContext.isHTML) {
                switch (encodeContext.base) {
                    case NAME: {
                        break;
                    }
                    case PCDATA: 
                    case PCDATA_ROUNDTRIP: {
                        if (!s_htmlcharInfo.shouldMapTextChar(c)) break;
                        string2 = s_htmlcharInfo.getOutputStringForChar(c, this.m_charKey);
                        this.writer.write(string2);
                        return n2;
                    }
                    case ATTRIBUTE_SINGLE_QUOTE: 
                    case ATTRIBUTE_DOUBLE_QUOTE: {
                        if (!s_htmlcharInfo.shouldMapAttrChar(c)) break;
                        string2 = s_htmlcharInfo.getOutputStringForChar(c, this.m_charKey);
                        this.writer.write(string2);
                        return n2;
                    }
                }
            }
            if (!this.encodingInfo.isCharInEncoding(c)) {
                this.writeCharacterAsInt(c);
            } else if (c == '\u2028' || !this.encodingInfo.isCharInEncoding(c)) {
                if (!(c != '\u2028' && c != '\u0085' || !this.isXML11 || encodeContext.base != EncodeContext.PI && encodeContext.base != EncodeContext.COMMENT)) {
                    this.writer.write(c);
                } else {
                    this.writeCharacterAsHex(c);
                }
            } else {
                this.writer.write(c);
            }
        } else if (c >= '\ud800' && c <= '\udbff') {
            if (n2 < n3 - 1) {
                String string3;
                char c2;
                if (!Encodings.isLowUTF16Surrogate(c2 = charSequence.charAt(++n2))) {
                    String string4 = Messages.createMessage2("ER_SER_INVALID_UTF16_SURROGATE2", new String[]{Integer.toString(c, 16), Integer.toString(c2, 16)});
                    Messages.xciDynamicErrorException(string4);
                }
                int n4 = Encodings.toCodePoint(c, c2);
                if (this.codepointMappings != null && this.codepointMappings.hasMappings() && (string3 = this.codepointMappings.getString(n4)) != null) {
                    this.writer.write(string3);
                    return n2;
                }
                if (this.isValidXMLChar(n4)) {
                    if (this.codepointMappings != null && (string3 = this.codepointMappings.getString(n4)) != null) {
                        this.writer.write(string3);
                        return n2;
                    }
                    if (!this.encodingInfo.isSurrogatePairInEncoding(c, c2)) {
                        this.writeCharacterAsHex(n4);
                    } else {
                        this.writer.write(c);
                        this.writer.write(c2);
                    }
                } else {
                    string3 = Messages.createMessage2("ER_SER_INVALID_CHARACTER_IN_TEXT", new String[]{Integer.toString(c, 16)});
                    Messages.xciDynamicErrorException(string3);
                }
            } else {
                String string5 = Messages.createMessage2("ER_SER_INVALID_UTF16_SURROGATE1", new String[]{Integer.toString(c, 16)});
                Messages.xciDynamicErrorException(string5);
            }
        } else if (Encodings.isLowUTF16Surrogate(c)) {
            String string6 = Messages.createMessage2("ER_SER_INVALID_UTF16_SURROGATE3", new String[]{Integer.toString(c, 16)});
            Messages.xciDynamicErrorException(string6);
        } else {
            String string7;
            if (this.codepointMappings != null && this.codepointMappings.hasMappings() && (string7 = this.codepointMappings.getString(c)) != null) {
                this.writer.write(string7);
                return n2;
            }
            if (this.isValidXMLChar(c)) {
                if (c == '\u2028' || !this.encodingInfo.isCharInEncoding(c)) {
                    this.writeCharacterAsHex(c);
                } else {
                    this.writer.write(c);
                }
            } else {
                string7 = Messages.createMessage2("ER_SER_INVALID_CHARACTER_IN_TEXT", new String[]{Integer.toString(c, 16)});
                Messages.xciDynamicErrorException(string7);
            }
        }
        return n2;
    }

    protected int writeHighUTF16(char c, char[] cArray, int n2, int n3, EncodeContext encodeContext) throws IOException {
        if ((c & Short.MIN_VALUE) == 0 && this.isValidXMLChar(c)) {
            String string2;
            if (this.codepointMappings != null && (string2 = this.codepointMappings.getString(c)) != null) {
                this.writer.write(string2);
                return n2;
            }
            if (encodeContext.isASCIIEncoding && encodeContext.isHTML) {
                switch (encodeContext.base) {
                    case NAME: {
                        break;
                    }
                    case PCDATA: 
                    case PCDATA_ROUNDTRIP: {
                        if (!s_htmlcharInfo.shouldMapTextChar(c)) break;
                        string2 = s_htmlcharInfo.getOutputStringForChar(c, this.m_charKey);
                        this.writer.write(string2);
                        return n2;
                    }
                    case ATTRIBUTE_SINGLE_QUOTE: 
                    case ATTRIBUTE_DOUBLE_QUOTE: {
                        if (!s_htmlcharInfo.shouldMapAttrChar(c)) break;
                        string2 = s_htmlcharInfo.getOutputStringForChar(c, this.m_charKey);
                        this.writer.write(string2);
                        return n2;
                    }
                }
            }
            if (!this.encodingInfo.isCharInEncoding(c)) {
                this.writeCharacterAsInt(c);
            } else if (c == '\u2028' || !this.encodingInfo.isCharInEncoding(c)) {
                if (!(c != '\u2028' && c != '\u0085' || !this.isXML11 || encodeContext.base != EncodeContext.PI && encodeContext.base != EncodeContext.COMMENT)) {
                    this.writer.write(c);
                } else {
                    this.writeCharacterAsHex(c);
                }
            } else {
                this.writer.write(c);
            }
        } else if (c >= '\ud800' && c <= '\udbff') {
            if (n2 < n3 - 1) {
                String string3;
                char c2;
                if (!Encodings.isLowUTF16Surrogate(c2 = cArray[++n2])) {
                    String string4 = Messages.createMessage2("ER_SER_INVALID_UTF16_SURROGATE2", new String[]{Integer.toString(c, 16), Integer.toString(c2, 16)});
                    Messages.xciDynamicErrorException(string4);
                }
                int n4 = Encodings.toCodePoint(c, c2);
                if (this.codepointMappings != null && this.codepointMappings.hasMappings() && (string3 = this.codepointMappings.getString(n4)) != null) {
                    this.writer.write(string3);
                    return n2;
                }
                if (this.isValidXMLChar(n4)) {
                    if (!this.encodingInfo.isSurrogatePairInEncoding(c, c2)) {
                        this.writeCharacterAsHex(n4);
                    } else {
                        this.writer.write(c);
                        this.writer.write(c2);
                    }
                } else {
                    string3 = Messages.createMessage2("ER_SER_INVALID_CHARACTER_IN_TEXT", new String[]{Integer.toString(c, 16)});
                    Messages.xciDynamicErrorException(string3);
                }
            } else {
                String string5 = Messages.createMessage2("ER_SER_INVALID_UTF16_SURROGATE1", new String[]{Integer.toString(c, 16)});
                Messages.xciDynamicErrorException(string5);
            }
        } else if (Encodings.isLowUTF16Surrogate(c)) {
            String string6 = Messages.createMessage2("ER_SER_INVALID_UTF16_SURROGATE3", new String[]{Integer.toString(c, 16)});
            Messages.xciDynamicErrorException(string6);
        } else {
            String string7;
            if (this.codepointMappings != null && this.codepointMappings.hasMappings() && (string7 = this.codepointMappings.getString(c)) != null) {
                this.writer.write(string7);
                return n2;
            }
            if (this.isValidXMLChar(c)) {
                if (c == '\u2028' || !this.encodingInfo.isCharInEncoding(c)) {
                    this.writeCharacterAsHex(c);
                } else {
                    this.writer.write(c);
                }
            } else {
                string7 = Messages.createMessage2("ER_SER_INVALID_CHARACTER_IN_TEXT", new String[]{Integer.toString(c, 16)});
                Messages.xciDynamicErrorException(string7);
            }
        }
        return n2;
    }

    protected final boolean haveAllUtf8BytesPerCodePoint(byte[] byArray, int n2) {
        byte by2 = byArray[n2];
        if ((by2 & 0xF8) == 240) {
            return byArray[n2 + 1] != 0 && byArray[n2 + 2] != 0 && byArray[n2 + 3] != 0;
        }
        if ((by2 & 0xF0) == 224) {
            return byArray[n2 + 1] != 0 && byArray[n2 + 2] != 0;
        }
        if ((by2 & 0xE0) == 192) {
            return byArray[n2 + 1] != 0;
        }
        if ((by2 & 0xC0) == 128) {
            String string2 = Messages.createMessage2("ER_SER_INVALID_CHARACTER_IN_TEXT", new String[]{Integer.toString(byArray[n2], 16)});
            Messages.xciDynamicErrorException(string2);
        } else if ((by2 & 0x80) != 0) {
            String string3 = Messages.createMessage2("ER_SER_INVALID_CHARACTER_IN_TEXT", new String[]{Integer.toString(byArray[n2], 16)});
            Messages.xciDynamicErrorException(string3);
        }
        return true;
    }

    protected final int countUtf8BytesPerCodePointNoCheck(byte by2) {
        if ((by2 & 0xF8) == 240) {
            return 4;
        }
        if ((by2 & 0xF0) == 224) {
            return 3;
        }
        if ((by2 & 0xE0) == 192) {
            return 2;
        }
        if ((by2 & 0xC0) == 128) {
            String string2 = Messages.createMessage2("ER_SER_INVALID_CHARACTER_IN_TEXT", new String[]{Integer.toString(by2, 16)});
            Messages.xciDynamicErrorException(string2);
        } else if ((by2 & 0x80) != 0) {
            String string3 = Messages.createMessage2("ER_SER_INVALID_CHARACTER_IN_TEXT", new String[]{Integer.toString(by2, 16)});
            Messages.xciDynamicErrorException(string3);
        }
        return 1;
    }

    protected final int countUtf8BytesPerCodePoint(byte[] byArray, int n2) {
        byte by2 = byArray[n2];
        if ((by2 & 0xF8) == 240) {
            if ((byArray[n2 + 1] & 0xC0) == 128 && (byArray[n2 + 2] & 0xC0) == 128 && (byArray[n2 + 3] & 0xC0) == 128) {
                return 4;
            }
        } else if ((by2 & 0xF0) == 224) {
            if ((byArray[n2 + 1] & 0xC0) == 128 && (byArray[n2 + 2] & 0xC0) == 128) {
                return 3;
            }
        } else if ((by2 & 0xE0) == 192) {
            if ((byArray[n2 + 1] & 0xC0) == 128) {
                return 2;
            }
        } else if ((by2 & 0xC0) == 128) {
            String string2 = Messages.createMessage2("ER_SER_INVALID_CHARACTER_IN_TEXT", new String[]{Integer.toString(byArray[n2], 16)});
            Messages.xciDynamicErrorException(string2);
        } else if ((by2 & 0x80) != 0) {
            String string3 = Messages.createMessage2("ER_SER_INVALID_CHARACTER_IN_TEXT", new String[]{Integer.toString(byArray[n2], 16)});
            Messages.xciDynamicErrorException(string3);
        }
        return 1;
    }

    private char[] getCharArray(CharBuffer charBuffer) {
        char[] cArray;
        if (charBuffer.hasArray()) {
            cArray = charBuffer.array();
            if (cArray.length != charBuffer.length()) {
                char[] cArray2 = new char[charBuffer.length()];
                System.arraycopy(cArray, 0, cArray2, 0, charBuffer.length());
                cArray = cArray2;
                assert (cArray.length == charBuffer.length());
            }
        } else {
            cArray = new char[charBuffer.length()];
            charBuffer.get(cArray);
        }
        return cArray;
    }

    protected int writeUTF8VariableWidthChar(byte[] byArray, int n2, int n3, EncodeContext encodeContext) throws IOException {
        int n4;
        int n5;
        assert (n3 > 0);
        if (this.byteCodePointCollectingStartIndex == -1) {
            int n6;
            n5 = this.countUtf8BytesPerCodePointNoCheck(byArray[n2]);
            this.byteCodePointCollectingStartIndex = this.posInEncodeBuf;
            int n7 = n6 = n5 < n3 ? n5 : n3;
            for (n4 = 0; n4 < n6; ++n4) {
                this.encodeBuf[this.posInEncodeBuf++] = byArray[n2 + n4];
            }
            this.bytesStillToCollect = n5 - n6;
            n2 += n4;
            int n8 = 0;
            while (n4 < n5) {
                this.encodeBuf[this.posInEncodeBuf + n8] = 0;
                ++n8;
                ++n4;
            }
            if (LoggerUtil.isFinestLoggable(gLogger)) {
                XOutputWriter.logUTF8VariableWidthChar1(gLogger, Level.FINEST, this.encodeBuf, n5, n3, "writeUTF8VariableWidthChar");
            }
            if (n3 < n5) {
                if (LoggerUtil.isFinestLoggable(gLogger)) {
                    gLogger.logp(Level.FINEST, gLogger.getName(), "writeUTF8VariableWidthChar", "About to return offset (lenInCbuf < bytesNeeded): " + n2);
                }
                return n2;
            }
        } else {
            int n9 = n4 = this.bytesStillToCollect < n3 ? this.bytesStillToCollect : n3;
            for (n5 = 0; n5 < n4; ++n5) {
                this.encodeBuf[this.posInEncodeBuf++] = byArray[n2 + n5];
            }
            n2 += n5;
            this.bytesStillToCollect -= n5;
            if (LoggerUtil.isFinestLoggable(gLogger)) {
                XOutputWriter.logUTF8VariableWidthChar2(gLogger, Level.FINEST, this.encodeBuf, n4, this.bytesStillToCollect, n3, "writeUTF8VariableWidthChar");
            }
            if (!this.haveAllUtf8BytesPerCodePoint(this.encodeBuf, this.byteCodePointCollectingStartIndex)) {
                if (LoggerUtil.isFinestLoggable(gLogger)) {
                    gLogger.logp(Level.FINEST, gLogger.getName(), "writeUTF8VariableWidthChar", "About to return offset (!haveAllUtf8BytesPerCodePoint(...)): " + n2);
                }
                return n2;
            }
        }
        n5 = this.countUtf8BytesPerCodePoint(this.encodeBuf, this.byteCodePointCollectingStartIndex);
        assert (n5 == this.posInEncodeBuf);
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.encodeBuf, this.byteCodePointCollectingStartIndex, n5);
        CharBuffer charBuffer = Chars.UTF8.decode(byteBuffer);
        char[] cArray = this.getCharArray(charBuffer);
        this.write(cArray, 0, cArray.length, encodeContext);
        this.byteCodePointCollectingStartIndex = -1;
        this.bytesStillToCollect = -1;
        this.posInEncodeBuf = 0;
        return n2;
    }

    static boolean shouldBeBigEndian(Charset charset) {
        CharsetEncoder charsetEncoder = charset.newEncoder();
        byte[] byArray = new byte[4];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, 0, 4);
        CharBuffer charBuffer = CharBuffer.allocate(4);
        charBuffer.append('x');
        charsetEncoder.encode(charBuffer, byteBuffer, true);
        if (byArray[0] == -2) {
            return true;
        }
        if (byArray[0] == -1) {
            return false;
        }
        assert (false) : "Don't understand default UTF-16 BOM!";
        return true;
    }

    protected void checkPICommentValue(Chars chars, int n2, int n3, byte[] byArray, boolean bl, XOutputMethod xOutputMethod) {
        if (xOutputMethod == XOutputMethod.HTML) {
            block14: for (int i = n2; i < n3; ++i) {
                char c = chars.charAt(i);
                if (c < byArray.length) {
                    block0 : switch (byArray[c]) {
                        case 0: {
                            ++i;
                            while (i < n3 && (c = chars.charAt(i)) < byArray.length) {
                                if (byArray[c] != 0) break block0;
                                ++i;
                            }
                            continue block14;
                        }
                        case 5: {
                            String string2 = Messages.createMessage2("ER_SER_GT_IN_PROCESSING_INSTRUCTION1", new String[]{((Object)chars).toString()});
                            Messages.xciDynamicErrorException(string2);
                            break;
                        }
                        case 8: {
                            if (i >= n3 - 1 || chars.charAt(++i) != '-') continue block14;
                            String string3 = Messages.createMessage2("ER_SER_INVALID_DASH_IN_COMMENT", null);
                            Messages.xciDynamicErrorException(string3);
                            break;
                        }
                        case 16: {
                            String string4 = Messages.createMessage2("ER_SER_BAD_HTML_CONTROL_CHARS", new String[]{Integer.toString(c, 16)});
                            Messages.xciDynamicErrorException(string4);
                            break;
                        }
                        case 15: {
                            String string5 = Messages.createMessage2(bl ? "ER_SER_CHAR_NOT_REPRESENTABLE_IN_ENCODING_FOR_PI" : "ER_SER_CHAR_NOT_REPRESENTABLE_IN_ENCODING_FOR_COMMENT", new String[]{XOutputWriter.makeHexString(c), this.getEncodingInfo().getName()});
                            Messages.xciDynamicErrorException(string5);
                            break;
                        }
                    }
                    continue;
                }
                if (c >= '\ud800' && c <= '\udbff') {
                    if (i < n3 - 1) {
                        String string6;
                        char c2;
                        if (!Encodings.isLowUTF16Surrogate(c2 = chars.charAt(++i))) {
                            string6 = Messages.createMessage2("ER_SER_INVALID_UTF16_SURROGATE2", new String[]{Integer.toString(c, 16), Integer.toString(c2, 16)});
                            Messages.xciDynamicErrorException(string6);
                        }
                        if (this.getEncodingInfo().isSurrogatePairInEncoding(c, c2)) continue;
                        string6 = Messages.createMessage2(bl ? "ER_SER_CHAR_NOT_REPRESENTABLE_IN_ENCODING_FOR_PI" : "ER_SER_CHAR_NOT_REPRESENTABLE_IN_ENCODING_FOR_COMMENT", new String[]{XOutputWriter.makeHexString(Encodings.toCodePoint(c, c2)), this.getEncodingInfo().getName()});
                        Messages.xciDynamicErrorException(string6);
                        continue;
                    }
                    String string7 = Messages.createMessage2("ER_SER_INVALID_UTF16_SURROGATE1", new String[]{Integer.toString(c, 16)});
                    Messages.xciDynamicErrorException(string7);
                    continue;
                }
                if (Encodings.isLowUTF16Surrogate(c)) {
                    String string8 = Messages.createMessage2("ER_SER_INVALID_UTF16_SURROGATE3", new String[]{Integer.toString(c, 16)});
                    Messages.xciDynamicErrorException(string8);
                    continue;
                }
                if (this.getEncodingInfo().isCharInEncoding(c)) continue;
                String string9 = Messages.createMessage2(bl ? "ER_SER_CHAR_NOT_REPRESENTABLE_IN_ENCODING_FOR_PI" : "ER_SER_CHAR_NOT_REPRESENTABLE_IN_ENCODING_FOR_COMMENT", new String[]{XOutputWriter.makeHexString(c), this.getEncodingInfo().getName()});
                Messages.xciDynamicErrorException(string9);
            }
        } else {
            block16: for (int i = n2; i < n3; ++i) {
                char c = chars.charAt(i);
                if (c < byArray.length) {
                    block7 : switch (byArray[c]) {
                        case 0: {
                            ++i;
                            while (i < n3 && (c = chars.charAt(i)) < byArray.length) {
                                if (byArray[c] != 0) break block7;
                                ++i;
                            }
                            continue block16;
                        }
                        case 8: {
                            if (i >= n3 - 1 || chars.charAt(++i) != '-') continue block16;
                            String string10 = Messages.createMessage2("ER_SER_INVALID_DASH_IN_COMMENT", null);
                            Messages.xciDynamicErrorException(string10);
                            break;
                        }
                        case 11: {
                            String string11 = Messages.createMessage2(bl ? "ER_SER_INVALID_CHARACTER_IN_PI" : "ER_SER_INVALID_CHARACTER_IN_COMMENT", new String[]{Integer.toString(c, 16)});
                            Messages.xciDynamicErrorException(string11);
                            break;
                        }
                        case 15: {
                            String string12 = Messages.createMessage2(bl ? "ER_SER_CHAR_NOT_REPRESENTABLE_IN_ENCODING_FOR_PI" : "ER_SER_CHAR_NOT_REPRESENTABLE_IN_ENCODING_FOR_COMMENT", new String[]{XOutputWriter.makeHexString(c), this.getEncodingInfo().getName()});
                            Messages.xciDynamicErrorException(string12);
                            break;
                        }
                        case 16: {
                            String string13 = Messages.createMessage2(bl ? "ER_SER_INVALID_CHARACTER_IN_PI" : "ER_SER_INVALID_CHARACTER_IN_COMMENT", new String[]{XOutputWriter.makeHexString(c)});
                            Messages.xciDynamicErrorException(string13);
                            break;
                        }
                    }
                    continue;
                }
                if (c >= '\ud800' && c <= '\udbff') {
                    if (i < n3 - 1) {
                        String string14;
                        int n4;
                        char c3;
                        if (!Encodings.isLowUTF16Surrogate(c3 = chars.charAt(++i))) {
                            String string15 = Messages.createMessage2("ER_SER_INVALID_UTF16_SURROGATE2", new String[]{Integer.toString(c, 16), Integer.toString(c3, 16)});
                            Messages.xciDynamicErrorException(string15);
                        }
                        if (this.isValidXMLChar(n4 = Encodings.toCodePoint(c, c3))) {
                            if (this.getEncodingInfo().isSurrogatePairInEncoding(c, c3)) continue;
                            string14 = Messages.createMessage2(bl ? "ER_SER_CHAR_NOT_REPRESENTABLE_IN_ENCODING_FOR_PI" : "ER_SER_CHAR_NOT_REPRESENTABLE_IN_ENCODING_FOR_COMMENT", new String[]{XOutputWriter.makeHexString(n4), this.getEncodingInfo().getName()});
                            Messages.xciDynamicErrorException(string14);
                            continue;
                        }
                        string14 = Messages.createMessage2(bl ? "ER_SER_INVALID_CHARACTER_IN_PI" : "ER_SER_INVALID_CHARACTER_IN_COMMENT", new String[]{Integer.toString(c, 16)});
                        Messages.xciDynamicErrorException(string14);
                        continue;
                    }
                    String string16 = Messages.createMessage2("ER_SER_INVALID_UTF16_SURROGATE1", new String[]{Integer.toString(c, 16)});
                    Messages.xciDynamicErrorException(string16);
                    continue;
                }
                if (Encodings.isLowUTF16Surrogate(c)) {
                    String string17 = Messages.createMessage2("ER_SER_INVALID_UTF16_SURROGATE3", new String[]{Integer.toString(c, 16)});
                    Messages.xciDynamicErrorException(string17);
                    continue;
                }
                if (this.isValidXMLChar(c)) {
                    if (this.getEncodingInfo().isCharInEncoding(c)) continue;
                    String string18 = Messages.createMessage2(bl ? "ER_SER_CHAR_NOT_REPRESENTABLE_IN_ENCODING_FOR_PI" : "ER_SER_CHAR_NOT_REPRESENTABLE_IN_ENCODING_FOR_COMMENT", new String[]{XOutputWriter.makeHexString(c), this.getEncodingInfo().getName()});
                    Messages.xciDynamicErrorException(string18);
                    continue;
                }
                String string19 = Messages.createMessage2(bl ? "ER_SER_INVALID_CHARACTER_IN_PI" : "ER_SER_INVALID_CHARACTER_IN_COMMENT", new String[]{Integer.toString(c, 16)});
                Messages.xciDynamicErrorException(string19);
            }
        }
    }

    public boolean isOptimizedForDirectWrites(String string2) {
        return this.getCodepointMappings() == null && (string2 == this.encodingInfo.getName() || string2.equals(this.encodingInfo.getName()));
    }

    public final CodepointMappings getCodepointMappings() {
        return this.codepointMappings;
    }

    protected static final void logChars(Logger logger, Level level, char[] cArray, int n2, int n3, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Thread id: ");
        stringBuilder.append(Thread.currentThread().getId());
        stringBuilder.append("\nstart: ");
        stringBuilder.append(n2);
        stringBuilder.append(", end: ");
        stringBuilder.append(n3);
        stringBuilder.append(", cbuf: @");
        stringBuilder.append(Integer.toHexString(cArray.hashCode()));
        stringBuilder.append("\nchars as char[] {");
        stringBuilder.append(cArray, n2, n3 - n2);
        stringBuilder.append("}\n chars as int[] (from start) {\n");
        if (n3 > n2) {
            stringBuilder.append((int)cArray[n2]);
            for (int i = n2 + 1; i < n3; ++i) {
                stringBuilder.append(' ');
                stringBuilder.append((int)cArray[i]);
                if (i % 32 != 0) continue;
                stringBuilder.append('\n');
            }
        }
        stringBuilder.append("}\nStack trace= ");
        stringBuilder.append(XCIErrorHelper.getStackTrace(20));
        logger.logp(level, logger.getName(), string2, stringBuilder.toString());
    }

    protected static final void logBytes(Logger logger, Level level, byte[] byArray, int n2, int n3, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Thread id: ");
        stringBuilder.append(Thread.currentThread().getId());
        stringBuilder.append("\nstart: ");
        stringBuilder.append(n2);
        stringBuilder.append(", end: ");
        stringBuilder.append(n3);
        stringBuilder.append(", bbuf: @");
        stringBuilder.append(Integer.toHexString(byArray.hashCode()));
        stringBuilder.append("\n bytes (from start) {\n");
        if (n3 > n2) {
            stringBuilder.append(byArray[n2]);
            for (int i = n2 + 1; i < n3; ++i) {
                stringBuilder.append(' ');
                stringBuilder.append(byArray[i]);
                if (i % 32 != 0) continue;
                stringBuilder.append('\n');
            }
        }
        stringBuilder.append("}\nStack trace= ");
        stringBuilder.append(XCIErrorHelper.getStackTrace(20));
        logger.logp(level, logger.getName(), string2, stringBuilder.toString());
    }

    private static final void logUTF8VariableWidthChar1(Logger logger, Level level, byte[] byArray, int n2, int n3, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("bytesNeeded: ");
        stringBuilder.append(n2);
        stringBuilder.append(" - lenInCBuf: ");
        stringBuilder.append(n3);
        stringBuilder.append(" - encodedBytes [");
        stringBuilder.append(byArray[0]);
        for (int i = 1; i < byArray.length; ++i) {
            stringBuilder.append(' ');
            stringBuilder.append(byArray[i]);
        }
        stringBuilder.append("]");
        logger.logp(level, logger.getName(), string2, stringBuilder.toString());
    }

    private static final void logUTF8VariableWidthChar2(Logger logger, Level level, byte[] byArray, int n2, int n3, int n4, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("charsToCollect: ");
        stringBuilder.append(n2);
        stringBuilder.append(" - bytesStillToCollect: ");
        stringBuilder.append(n3);
        stringBuilder.append(" - lenInCBuf: ");
        stringBuilder.append(n4);
        stringBuilder.append(" - encodedBytes [");
        stringBuilder.append(byArray[0]);
        for (int i = 1; i < byArray.length; ++i) {
            stringBuilder.append(' ');
            stringBuilder.append(byArray[i]);
        }
        stringBuilder.append("]");
        logger.logp(level, logger.getName(), string2, stringBuilder.toString());
    }

    private static final void logWriter(Logger logger, Level level, XOutputWriter xOutputWriter, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("About to return writer: ");
        stringBuilder.append(xOutputWriter.getClass().getName());
        stringBuilder.append('@');
        stringBuilder.append(Integer.toHexString(xOutputWriter.hashCode()));
        logger.logp(level, logger.getName(), string2, stringBuilder.toString());
    }

    static {
        EncodeContext[] encodeContextArray = EncodeContext.variantList;
        s_charMaps1_0 = new byte[encodeContextArray.length][];
        s_charMaps1_1 = new byte[encodeContextArray.length][];
        s_charMaps1_0CodePoint = new byte[encodeContextArray.length][];
        s_charMaps1_1CodePoint = new byte[encodeContextArray.length][];
        for (int i = 0; i < encodeContextArray.length; ++i) {
            EncodeContext encodeContext = encodeContextArray[i].base;
            XOutputWriter.s_charMaps1_0[i] = encodeContextArray[i].map;
            if (encodeContext == EncodeContext.PI || encodeContext == EncodeContext.COMMENT) {
                XOutputWriter.s_charMaps1_0CodePoint[i] = encodeContextArray[i].map;
                continue;
            }
            XOutputWriter.s_charMaps1_1[i] = encodeContextArray[i].map;
            switch (encodeContext) {
                case NAME: 
                case NAMESPACE: 
                case CDATASECTION: 
                case NOTHING: {
                    XOutputWriter.s_charMaps1_0CodePoint[i] = encodeContextArray[i].map;
                    XOutputWriter.s_charMaps1_1CodePoint[i] = encodeContextArray[i].map;
                }
            }
        }
        s_htmlcharInfo = CharInfo.getCharInfo(null, "html");
    }
}

