/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.serializer;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.dp.values.BaseCData;
import com.ibm.xml.xci.dp.values.chars.Chars;
import com.ibm.xml.xci.dp.values.chars.EncodeContext;
import com.ibm.xml.xci.dp.values.chars.WhitespaceCharsConstant;
import com.ibm.xml.xci.serializer.CodepointMappings;
import com.ibm.xml.xci.serializer.EncodingInfo;
import com.ibm.xml.xci.serializer.Encodings;
import com.ibm.xml.xci.serializer.Messages;
import com.ibm.xml.xci.serializer.XOutputFrag;
import com.ibm.xml.xci.serializer.XOutputWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class XOutputWriter2Writer
extends XOutputWriter {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2010. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger gLogger = LoggerUtil.getLogger(XOutputWriter2Writer.class);
    private static final Logger gLogger2 = LoggerUtil.getLogger(OutputStreamWriterFlushed.class);
    private final OutputStreamAmpAttrHandler outputStreamAmpAttrHandler;
    private final WriterAmpAttrHandler writerAmpAttrHandler;
    char highUTF16Surrogate = '\u0000';
    private char[] charBuf = new char[128];

    protected XOutputWriter2Writer(Charset charset, EncodingInfo encodingInfo, boolean bl, char[] cArray, char c, CodepointMappings codepointMappings, OutputStream outputStream, boolean bl2) {
        super(charset, encodingInfo, bl, cArray, c, codepointMappings, outputStream);
        this.writer = new OutputStreamWriterFlushed(this.outputCharset, bl2);
        this.outputStreamAmpAttrHandler = new OutputStreamAmpAttrHandler(this.out);
        this.writerAmpAttrHandler = null;
    }

    protected XOutputWriter2Writer(Charset charset, EncodingInfo encodingInfo, boolean bl, char[] cArray, char c, CodepointMappings codepointMappings, Writer writer) {
        super(charset, encodingInfo, bl, cArray, c, codepointMappings, writer);
        this.outputStreamAmpAttrHandler = null;
        this.writerAmpAttrHandler = new WriterAmpAttrHandler(this.writer);
    }

    private void flushBuf() throws IOException {
        if (this.writer instanceof OutputStreamWriterFlushed) {
            ((OutputStreamWriterFlushed)this.writer).flushBuf();
        } else {
            this.writer.flush();
        }
    }

    public void flushBuffers() throws IOException {
        this.flushBuf();
    }

    public void writeDirectUTF8(byte[] byArray, int n2, int n3) throws IOException {
        if (LoggerUtil.isFinerLoggable(gLogger)) {
            XOutputWriter2Writer.logBytes(gLogger, Level.FINER, byArray, n2, n2 + n3, "writeDirectUTF8(byte[], int, int)");
        }
        this.flushBuf();
        if (this.outputCharset == BaseCData.UTF8) {
            this.out.write(byArray, n2, n3);
        } else {
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n2, n3);
            CharBuffer charBuffer = BaseCData.UTF8.decode(byteBuffer);
            this.writer.append(charBuffer);
        }
    }

    public final void writeDirect(byte[] byArray) throws IOException {
        this.flushBuf();
        this.out.write(byArray);
    }

    public final void writeDirect(byte[] byArray, int n2, int n3) throws IOException {
        this.flushBuf();
        this.out.write(byArray, n2, n3);
    }

    protected final void writeCharacterAsInt(int n2) throws IOException {
        Writer writer = this.writer;
        this.writeIntEntityStart();
        writer.write(Integer.toString(n2));
        this.writeEntityEnd();
    }

    protected final void writeCharacterAsHex(int n2) throws IOException {
        Writer writer = this.writer;
        this.writeHexEntityStart();
        writer.write(XOutputWriter2Writer.makeHexString(n2));
        this.writeEntityEnd();
    }

    public void write(char[] cArray, int n2, int n3, EncodeContext encodeContext) throws IOException {
        if (LoggerUtil.isFinerLoggable(gLogger)) {
            XOutputWriter2Writer.logChars(gLogger, Level.FINER, cArray, n2, n3, "write(char[], int, int, EncodeContext)");
        }
        byte[] byArray = this.getCharMap(encodeContext);
        Writer writer = this.writer;
        block3: for (int i = n2; i < n3; ++i) {
            char c = cArray[i];
            if ((c & 0xFF00) == 0) {
                byte by2 = byArray[c];
                switch (by2) {
                    case 0: {
                        int n4 = i;
                        while (++i < n3 && ((c = cArray[i]) & 0xFF00) == 0 && byArray[c] == 0) {
                        }
                        writer.write(cArray, n4, i - n4);
                        if (i == n3) {
                            return;
                        }
                        if ((c & 0xFF00) == 0) {
                            this.writeEscaped(c, (int)byArray[c]);
                            break;
                        }
                        i = this.writeHighUTF16(c, cArray, i, n3, encodeContext);
                        continue block3;
                    }
                    default: {
                        this.writeEscaped(c, (int)by2);
                        break;
                    }
                }
                continue;
            }
            i = this.writeHighUTF16(c, cArray, i, n3, encodeContext);
        }
    }

    public void write(char c, EncodeContext encodeContext) throws IOException {
        byte[] byArray = this.getCharMap(encodeContext);
        if (c < byArray.length) {
            byte by2 = byArray[c];
            switch (by2) {
                case 0: {
                    this.writer.write(c);
                    break;
                }
                default: {
                    this.writeEscaped(c, (int)by2);
                    break;
                }
            }
        } else if (c < '\u0800') {
            this.writer.write(c);
        } else if (Encodings.isHighUTF16Surrogate(c)) {
            this.highUTF16Surrogate = c;
        } else if (Encodings.isLowUTF16Surrogate(c)) {
            if (this.highUTF16Surrogate == '\u0000') {
                String string2 = Messages.createMessage2("ER_SER_INVALID_UTF16_SURROGATE3", new String[]{Integer.toString(c, 16)});
                Messages.xciDynamicErrorException(string2);
            }
            int n2 = Encodings.toCodePoint(this.highUTF16Surrogate, c);
            this.highUTF16Surrogate = '\u0000';
            if (this.isValidXMLChar(n2)) {
                if (!this.encodingInfo.isSurrogatePairInEncoding(this.highUTF16Surrogate, c)) {
                    this.writeCharacterAsHex(n2);
                } else {
                    this.writer.write(this.highUTF16Surrogate);
                    this.writer.write(c);
                }
            } else {
                String string3 = Messages.createMessage2("ER_SER_INVALID_CHARACTER_IN_TEXT", new String[]{Integer.toString(c, 16)});
                Messages.xciDynamicErrorException(string3);
            }
        } else if (!this.isValidXMLChar(c)) {
            String string4 = Messages.createMessage2("ER_SER_INVALID_CHARACTER_IN_TEXT", new String[]{Integer.toString(c, 16)});
            Messages.xciDynamicErrorException(string4);
        } else if (c < '\u10000') {
            this.flushBuf();
            this.out.write((byte)(224 + (c >> 12)));
            this.out.write((byte)(128 + (c >> 6 & 0x3F)));
            this.out.write((byte)(128 + (c & 0x3F)));
        } else {
            this.flushBuf();
            this.out.write((byte)(240 + (c >> 18)));
            this.out.write((byte)(128 + (c >> 12 & 0x3F)));
            this.out.write((byte)(128 + (c >> 6 & 0x3F)));
            this.out.write((byte)(128 + (c & 0x3F)));
        }
    }

    private static void writeClean(Writer writer, byte[] byArray, int n2, int n3) throws IOException {
        for (int i = n2; i < n3; ++i) {
            writer.write((char)byArray[i]);
        }
    }

    public void write(byte by2, EncodeContext encodeContext) throws IOException {
        byte[] byArray = this.getCharMap(encodeContext);
        Writer writer = this.writer;
        if (by2 >= 0) {
            byte by3 = byArray[by2];
            switch (by3) {
                case 0: {
                    writer.write((char)by2);
                    break;
                }
                default: {
                    this.writeEscaped(by2, (int)by3);
                    break;
                }
            }
        } else {
            byte[] byArray2 = new byte[]{by2};
            this.readToCharsWriteBack(byArray2, 0, 1, encodeContext);
            return;
        }
    }

    public void writeWithLBNormalization(byte[] byArray, int n2, int n3, EncodeContext encodeContext) throws IOException {
        if (LoggerUtil.isFinerLoggable(gLogger)) {
            XOutputWriter2Writer.logBytes(gLogger, Level.FINER, byArray, n2, n3, "writeWithLBNormalization(byte[], int, int, EncodeContext)");
        }
        byte[] byArray2 = this.getCharMap(encodeContext);
        Writer writer = this.writer;
        block3: for (int i = n2; i < n3; ++i) {
            byte by2 = byArray[i];
            if (by2 >= 0) {
                byte by3 = byArray2[by2];
                switch (by3) {
                    case 0: {
                        int n4 = i;
                        while (++i < n3 && (by2 = byArray[i]) >= 0 && byArray2[by2] == 0) {
                        }
                        XOutputWriter2Writer.writeClean(writer, byArray, n4, i);
                        if (i == n3) {
                            return;
                        }
                        if (by2 == 13 && i + 1 < n3 && byArray[i + 1] == 10) {
                            this.writeLineBreak();
                            ++i;
                            continue block3;
                        }
                        if ((by2 & 0xFF00) == 0) {
                            this.writeEscaped(by2, (int)byArray2[by2]);
                            continue block3;
                        }
                        i = this.writeUTF8VariableWidthChar(byArray, i, n3 - i, encodeContext) - 1;
                        continue block3;
                    }
                    default: {
                        if (by2 == 13 && i + 1 < n3 && byArray[i + 1] == 10) {
                            this.writeLineBreak();
                            ++i;
                            break;
                        }
                        this.writeEscaped(by2, (int)by3);
                        break;
                    }
                }
                continue;
            }
            i = this.writeUTF8VariableWidthChar(byArray, i, n3 - i, encodeContext) - 1;
        }
    }

    public void write(byte[] byArray, int n2, int n3, EncodeContext encodeContext) throws IOException {
        if (LoggerUtil.isFinerLoggable(gLogger)) {
            XOutputWriter2Writer.logBytes(gLogger, Level.FINER, byArray, n2, n3, "write(byte[], int, int, EncodeContext)");
        }
        byte[] byArray2 = this.getCharMap(encodeContext);
        Writer writer = this.writer;
        block3: for (int i = n2; i < n3; ++i) {
            byte by2 = byArray[i];
            if (by2 >= 0) {
                byte by3 = byArray2[by2];
                switch (by3) {
                    case 0: {
                        int n4 = i;
                        while (++i < n3 && (by2 = byArray[i]) >= 0 && byArray2[by2] == 0) {
                        }
                        XOutputWriter2Writer.writeClean(writer, byArray, n4, i);
                        if (i == n3) {
                            return;
                        }
                        if ((by2 & 0xFF00) == 0) {
                            this.writeEscaped(by2, (int)byArray2[by2]);
                            continue block3;
                        }
                        i = this.writeUTF8VariableWidthChar(byArray, i, n3 - i, encodeContext) - 1;
                        continue block3;
                    }
                    default: {
                        this.writeEscaped(by2, (int)by3);
                        break;
                    }
                }
                continue;
            }
            i = this.writeUTF8VariableWidthChar(byArray, i, n3 - i, encodeContext) - 1;
        }
    }

    private void readToCharsWriteBack(byte[] byArray, int n2, int n3, EncodeContext encodeContext) throws IOException {
        this.writeUTF8VariableWidthChar(byArray, n2, n3 - n2, encodeContext);
    }

    public void write(byte[] byArray, EncodeContext encodeContext) throws IOException {
        this.write(byArray, 0, byArray.length, encodeContext);
    }

    public void write(Chars chars, EncodeContext encodeContext) throws IOException {
        this.write(chars, 0, chars.length(), encodeContext);
    }

    private final void writeCharSeq(CharSequence charSequence, int n2, int n3, EncodeContext encodeContext) throws IOException {
        byte[] byArray = this.getCharMap(encodeContext);
        Writer writer = this.writer;
        int n4 = this.charBuf.length;
        boolean bl = n3 >= n4;
        block3: for (int i = n2; i < n3; ++i) {
            char c = charSequence.charAt(i);
            if ((c & 0xFF00) == 0) {
                byte by2 = byArray[c];
                switch (by2) {
                    case 0: {
                        int n5 = 0;
                        this.charBuf[n5++] = c;
                        if (!bl) {
                            while (++i < n3 && ((c = charSequence.charAt(i)) & 0xFF00) == 0 && byArray[c] == 0) {
                                this.charBuf[n5++] = c;
                            }
                            writer.write(this.charBuf, 0, n5);
                        } else {
                            while (true) {
                                if (n5 < n4 && ++i < n3 && ((c = charSequence.charAt(i)) & 0xFF00) == 0 && byArray[c] == 0) {
                                    this.charBuf[n5++] = c;
                                    continue;
                                }
                                writer.write(this.charBuf, 0, n5);
                                n5 = 0;
                                if (i >= n3 || (c & 0xFF00) != 0 || byArray[c] != 0) break;
                            }
                        }
                        if (i == n3) {
                            return;
                        }
                        if ((c & 0xFF00) == 0) {
                            this.writeEscaped(c, (int)byArray[c]);
                            break;
                        }
                        i = this.writeHighUTF16(c, charSequence, i, n3, encodeContext);
                        continue block3;
                    }
                    default: {
                        this.writeEscaped(c, (int)by2);
                        break;
                    }
                }
                continue;
            }
            i = this.writeHighUTF16(c, charSequence, i, n3, encodeContext);
        }
    }

    public void write(String string2, EncodeContext encodeContext) throws IOException {
        this.writeCharSeq(string2, 0, string2.length(), encodeContext);
    }

    public void write(CharSequence charSequence, EncodeContext encodeContext) throws IOException {
        this.writeCharSeq(charSequence, 0, charSequence.length(), encodeContext);
    }

    public void write(Chars chars, int n2, int n3, EncodeContext encodeContext) throws IOException {
        this.writeCharSeq(chars, n2, n3, encodeContext);
    }

    public void write(String string2, int n2, int n3, EncodeContext encodeContext) throws IOException {
        this.writeCharSeq(string2, n2, n3, encodeContext);
    }

    public void write(char c, int n2, EncodeContext encodeContext) throws IOException {
        byte[] byArray = this.getCharMap(encodeContext);
        if (c < byArray.length) {
            byte by2 = byArray[c];
            if (by2 == 0) {
                Writer writer = this.writer;
                if (c == ' ' && n2 < 20) {
                    char[] cArray = WhitespaceCharsConstant.whitespaceConstantsCharArrays[n2];
                    writer.write(cArray, 0, n2);
                } else {
                    for (int i = 0; i < n2; ++i) {
                        writer.write(c);
                    }
                }
            } else {
                for (int i = 0; i < n2; ++i) {
                    this.writeEscaped(c, (int)by2);
                }
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                this.write(c, encodeContext);
            }
        }
    }

    public void writeBOM() throws IOException {
        this.writer.write(65279);
    }

    public void writeLineBreak() throws IOException {
        this.writer.write(this.indentLineSep, 0, this.indentLineSepLen);
    }

    public void writeAmpEntity() throws IOException {
        this.writer.write(XOutputFrag.AmpEntity.chars, 0, XOutputFrag.AmpEntity.len);
    }

    public void writeCDataSectionEnd() throws IOException {
        this.writer.write(XOutputFrag.CDataSectionEnd.chars, 0, XOutputFrag.CDataSectionEnd.len);
    }

    public void writeCDataSectionStart() throws IOException {
        this.writer.write(XOutputFrag.CDataSectionStart.chars, 0, XOutputFrag.CDataSectionStart.len);
    }

    public void writeColon() throws IOException {
        this.writer.write(XOutputFrag.Colon.chars, 0, XOutputFrag.Colon.len);
    }

    public void writeCommentEnd() throws IOException {
        this.writer.write(XOutputFrag.CommentEnd.chars, 0, XOutputFrag.CommentEnd.len);
    }

    public void writeCommentStart() throws IOException {
        this.writer.write(XOutputFrag.CommentStart.chars, 0, XOutputFrag.CommentStart.len);
    }

    public void writeQuoteDocTypeClose() throws IOException {
        this.writer.write(XOutputFrag.DocTypeClose.chars, 0, XOutputFrag.DocTypeClose.len);
    }

    public void writeDocTypeOpen() throws IOException {
        this.writer.write(XOutputFrag.DocTypeOpen.chars, 0, XOutputFrag.DocTypeOpen.len);
    }

    public void writeEmptyElementClose() throws IOException {
        this.writer.write(XOutputFrag.EmptyElementClose.chars, 0, XOutputFrag.EmptyElementClose.len);
    }

    public void writeEmptyElementEndEndTagOpen() throws IOException {
        this.writer.write(XOutputFrag.EmptyElementEndEndTagOpen.chars, 0, XOutputFrag.EmptyElementEndEndTagOpen.len);
    }

    public void writeEndTagClose() throws IOException {
        this.writer.write(XOutputFrag.EndTagClose.chars, 0, XOutputFrag.EndTagClose.len);
    }

    public void writeEndTagOpen() throws IOException {
        this.writer.write(XOutputFrag.EndTagOpen.chars, 0, XOutputFrag.EndTagOpen.len);
    }

    public void writeEntityEnd() throws IOException {
        this.writer.write(XOutputFrag.EntityEnd.chars, 0, XOutputFrag.EntityEnd.len);
    }

    public void writeEqualsQuote() throws IOException {
        this.writer.write(XOutputFrag.EqualsQuote.chars, 0, XOutputFrag.EqualsQuote.len);
    }

    public void writeGTEntity() throws IOException {
        this.writer.write(XOutputFrag.GTEntity.chars, 0, XOutputFrag.GTEntity.len);
    }

    public void writeHexEntityStart() throws IOException {
        this.writer.write(XOutputFrag.HexEntityStart.chars, 0, XOutputFrag.HexEntityStart.len);
    }

    public void writeIntEntityStart() throws IOException {
        this.writer.write(XOutputFrag.IntEntityStart.chars, 0, XOutputFrag.IntEntityStart.len);
    }

    public void writeLTEntity() throws IOException {
        this.writer.write(XOutputFrag.LTEntity.chars, 0, XOutputFrag.LTEntity.len);
    }

    public void writePIClose(EncodeContext encodeContext) throws IOException {
        if (encodeContext == EncodeContext.HTML_PI) {
            this.writer.write(XOutputFrag.PICloseHTML.chars, 0, XOutputFrag.PICloseHTML.len);
        } else {
            this.writer.write(XOutputFrag.PIClose.chars, 0, XOutputFrag.PIClose.len);
        }
    }

    public void writePIOpen() throws IOException {
        this.writer.write(XOutputFrag.PIOpen.chars, 0, XOutputFrag.PIOpen.len);
    }

    public void writePublicIDOpen() throws IOException {
        this.writer.write(XOutputFrag.PublicIDOpen.chars, 0, XOutputFrag.PublicIDOpen.len);
    }

    public void writeQuotEntity() throws IOException {
        this.writer.write(XOutputFrag.QuotEntity.chars, 0, XOutputFrag.QuotEntity.len);
    }

    public void writeQuote() throws IOException {
        this.writer.write(XOutputFrag.Quote.chars, 0, XOutputFrag.Quote.len);
    }

    public void writeQuoteSpaceQuote() throws IOException {
        this.writer.write(XOutputFrag.QuoteSpaceQuote.chars, 0, XOutputFrag.QuoteSpaceQuote.len);
    }

    public void writeSpace() throws IOException {
        this.writer.write(XOutputFrag.Space.chars, 0, XOutputFrag.Space.len);
    }

    public void writeSpaceEmptyElementClose() throws IOException {
        this.writer.write(XOutputFrag.SpaceEmptyElementClose.chars, 0, XOutputFrag.SpaceEmptyElementClose.len);
    }

    public void writeSpaceXMLNS() throws IOException {
        this.writer.write(XOutputFrag.SpaceXMLNS.chars, 0, XOutputFrag.SpaceXMLNS.len);
    }

    public void writeSpaceXMLNSColon() throws IOException {
        this.writer.write(XOutputFrag.SpaceXMLNSColon.chars, 0, XOutputFrag.SpaceXMLNSColon.len);
    }

    public void writeStartTagClose() throws IOException {
        this.writer.write(XOutputFrag.StartTagClose.chars, 0, XOutputFrag.StartTagClose.len);
    }

    public void writeStartTagOpen() throws IOException {
        this.writer.write(XOutputFrag.StartTagOpen.chars, 0, XOutputFrag.StartTagOpen.len);
    }

    public void writeSystemIDOpen() throws IOException {
        this.writer.write(XOutputFrag.SystemIDOpen.chars, 0, XOutputFrag.SystemIDOpen.len);
    }

    public void writeXMLEncodingOpen() throws IOException {
        this.writer.write(XOutputFrag.XMLEncodingOpen.chars, 0, XOutputFrag.XMLEncodingOpen.len);
    }

    public void writeXMLHeaderClose() throws IOException {
        this.writer.write(XOutputFrag.XMLHeaderClose.chars, 0, XOutputFrag.XMLHeaderClose.len);
    }

    public void writeXMLVersionOpen() throws IOException {
        this.writer.write(XOutputFrag.XMLVersionOpen.chars, 0, XOutputFrag.XMLVersionOpen.len);
    }

    protected void writeHTMLAttrAmp() throws IOException {
        if (this.out instanceof OutputStreamAmpAttrHandler) {
            this.out.flush();
            ((OutputStreamAmpAttrHandler)this.out).setAmpState();
        } else if (this.writer instanceof WriterAmpAttrHandler) {
            this.writer.flush();
            ((WriterAmpAttrHandler)this.writer).setAmpState();
        } else {
            this.writeGTEntity();
        }
    }

    protected void writeHTMLAttrLeftCurly() throws IOException {
        this.writer.write(123);
    }

    public void startHTMLAttrState() {
        if (this.outputStreamAmpAttrHandler != null) {
            this.out = this.outputStreamAmpAttrHandler;
        } else {
            this.writer = this.writerAmpAttrHandler;
        }
    }

    public void endHTMLAttrState() throws IOException {
        if (this.outputStreamAmpAttrHandler != null) {
            this.outputStreamAmpAttrHandler.flushAmp();
            this.out = this.outputStreamAmpAttrHandler.getInnterOutputStream();
        } else {
            this.writerAmpAttrHandler.flushAmp();
            this.writer = this.writerAmpAttrHandler.getInnerWriter();
        }
    }

    private final class OutputStreamAmpAttrHandler
    extends OutputStream {
        OutputStream inner;
        boolean haveAmp;

        protected OutputStreamAmpAttrHandler(OutputStream outputStream) {
            this.inner = outputStream;
            this.haveAmp = false;
        }

        public final OutputStream getInnterOutputStream() {
            return this.inner;
        }

        public void setAmpState() {
            this.haveAmp = true;
        }

        public void flushAmp() throws IOException {
            if (this.haveAmp) {
                this.inner.write(XOutputFrag.AmpEntity.bytes);
                this.haveAmp = false;
            }
        }

        public void flushAmp(int n2) throws IOException {
            if (this.haveAmp) {
                if (n2 == 123) {
                    this.inner.write(38);
                } else {
                    this.inner.write(XOutputFrag.AmpEntity.bytes);
                }
                this.haveAmp = false;
            }
        }

        public void close() throws IOException {
            this.flushAmp();
            this.inner.close();
        }

        public boolean equals(Object object2) {
            return this.inner.equals(object2);
        }

        public void flush() throws IOException {
            this.flushAmp();
            this.inner.flush();
        }

        public int hashCode() {
            return this.inner.hashCode();
        }

        public String toString() {
            return this.inner.toString();
        }

        public void write(byte[] byArray, int n2, int n3) throws IOException {
            if (this.haveAmp) {
                this.flushAmp(byArray[n2]);
            }
            this.inner.write(byArray, n2, n3);
        }

        public void write(byte[] byArray) throws IOException {
            if (this.haveAmp) {
                this.flushAmp(byArray[0]);
            }
            this.inner.write(byArray);
        }

        public void write(int n2) throws IOException {
            if (this.haveAmp) {
                this.flushAmp(n2);
            }
            this.inner.write(n2);
        }
    }

    private final class WriterAmpAttrHandler
    extends Writer {
        final Writer inner;
        boolean haveAmp;

        protected WriterAmpAttrHandler(Writer writer) {
            this.inner = writer;
            this.haveAmp = false;
        }

        public final Writer getInnerWriter() {
            return this.inner;
        }

        public void setAmpState() {
            this.haveAmp = true;
        }

        public void flushAmp() throws IOException {
            if (this.haveAmp) {
                this.inner.write(XOutputFrag.AmpEntity.chars);
                this.haveAmp = false;
            }
        }

        public void flushAmp(int n2) throws IOException {
            if (this.haveAmp) {
                if (n2 == 123) {
                    this.inner.write(38);
                } else {
                    this.inner.write(XOutputFrag.AmpEntity.chars);
                }
                this.haveAmp = false;
            }
        }

        public void close() throws IOException {
            this.flushAmp();
            this.inner.close();
        }

        public boolean equals(Object object2) {
            return this.inner.equals(object2);
        }

        public void flush() throws IOException {
            this.flushAmp();
            this.inner.flush();
        }

        public void write(char[] cArray, int n2, int n3) throws IOException {
            if (this.haveAmp) {
                this.flushAmp(cArray[n2]);
            }
            this.inner.write(cArray, n2, n3);
        }

        public void write(int n2) throws IOException {
            if (this.haveAmp) {
                this.flushAmp(n2);
            }
            this.inner.write(n2);
        }
    }

    final class OutputStreamWriterFlushed
    extends Writer {
        final Charset enc;
        final CharsetEncoder charsetEncoder;
        final ByteBuffer bbout;
        final CharBuffer ccin;
        int ccinPos;
        protected static final int BYTES_MAX = 16384;
        protected static final int BYTES_MAX_1CHAR_SAFE = 16380;
        static final int BYTES_MAX_CHARS_SAFE = 5461;
        OutputStream m_os;
        protected final byte[] obuf;
        protected int count;
        protected boolean writerNeedsFlushing;
        boolean needToWriteBOM;
        static final int writeOffset = 0;
        private final boolean isBE;

        public OutputStreamWriterFlushed(Charset charset, boolean bl) {
            if (charset.name().equals("UTF-16")) {
                if (XOutputWriter.shouldBeBigEndian(charset)) {
                    this.enc = Charset.forName("UTF-16BE");
                    this.isBE = true;
                } else {
                    this.enc = Charset.forName("UTF-16LE");
                    this.isBE = false;
                }
                this.needToWriteBOM = bl;
            } else {
                this.isBE = true;
                this.needToWriteBOM = bl;
                this.enc = charset;
            }
            this.charsetEncoder = this.enc.newEncoder();
            this.writerNeedsFlushing = false;
            this.count = 0;
            this.obuf = new byte[16387];
            this.bbout = ByteBuffer.wrap(this.obuf, 0, this.obuf.length);
            this.ccin = CharBuffer.allocate(4);
            this.ccinPos = 0;
        }

        public void write(char[] cArray, int n2, int n3) throws IOException {
            if (LoggerUtil.isFinerLoggable(gLogger2)) {
                XOutputWriter.logChars(gLogger2, Level.FINER, cArray, n2, n2 + n3, "write(char[], int, int)");
            }
            this.ensureBufForChars(n3);
            CharBuffer charBuffer = CharBuffer.wrap(cArray, n2, n3);
            this.bbout.position(this.count);
            CoderResult coderResult = this.charsetEncoder.encode(charBuffer, this.bbout, true);
            this.flushOBuf(this.bbout);
        }

        private void writeBOMIfNeeded() throws IOException {
            if (this.needToWriteBOM) {
                if (this.isBE) {
                    XOutputWriter2Writer.this.out.write(-2);
                    XOutputWriter2Writer.this.out.write(-1);
                } else {
                    XOutputWriter2Writer.this.out.write(-1);
                    XOutputWriter2Writer.this.out.write(-2);
                }
                this.needToWriteBOM = false;
            }
        }

        public void write(int n2) throws IOException {
            this.ensureBufForChars(1);
            this.ccin.position(this.ccinPos);
            this.ccin.limit(this.ccinPos + 1);
            this.ccin.put((char)n2).position(0);
            this.bbout.position(this.count);
            CoderResult coderResult = this.charsetEncoder.encode(this.ccin, this.bbout, true);
            if (coderResult != CoderResult.UNDERFLOW) {
                boolean bl = coderResult.isMalformed();
                if (bl && Encodings.isHighUTF16Surrogate((char)n2) && this.ccinPos == 0) {
                    if (LoggerUtil.isFinestLoggable(gLogger2)) {
                        gLogger2.logp(Level.FINEST, gLogger2.getName(), "write(int)", "We have a high UTF-16 surrogate and waiting for the low surrogate");
                    }
                    ++this.ccinPos;
                    this.writerNeedsFlushing = true;
                    return;
                }
                boolean bl2 = coderResult.isError();
                boolean bl3 = Encodings.isLowUTF16Surrogate((char)n2);
                boolean bl4 = Encodings.isHighUTF16Surrogate((char)n2);
                if (bl3 || bl4 || this.ccinPos > 1) {
                    String string2 = Messages.createMessage2("ER_SER_INVALID_UTF16_SURROGATE3", new String[]{Integer.toString(n2, 16)});
                    Messages.xciDynamicErrorException(string2);
                } else {
                    assert (bl2);
                    String string3 = Messages.createMessage2("ER_SER_INVALID_CHARACTER_IN_TEXT", new String[]{Integer.toString(n2, 16)});
                    Messages.xciDynamicErrorException(string3);
                }
                this.count = this.bbout.position();
            } else if (this.ccinPos > 0) {
                this.writerNeedsFlushing = false;
                this.ccinPos = 0;
                this.flushOBuf(this.bbout);
            } else {
                this.flushOBuf(this.bbout);
            }
        }

        public void write(String string2, int n2, int n3) throws IOException {
            this.ensureBufForChars(n3);
            CharBuffer charBuffer = CharBuffer.wrap(string2, n2, n3);
            this.bbout.position(this.count);
            CoderResult coderResult = this.charsetEncoder.encode(charBuffer, this.bbout, true);
            this.flushOBuf(this.bbout);
        }

        public void close() throws IOException {
            if (this.writerNeedsFlushing) {
                this.bbout.position(this.count);
                this.charsetEncoder.flush(this.bbout);
                this.flushOBuf(this.bbout);
            }
            this.writerNeedsFlushing = false;
        }

        public void flush() throws IOException {
            if (this.writerNeedsFlushing) {
                this.bbout.position(this.count);
                this.charsetEncoder.flush(this.bbout);
                this.flushOBuf(this.bbout);
            }
            this.writerNeedsFlushing = false;
        }

        final void flushBuf() throws IOException {
            if (this.writerNeedsFlushing) {
                XOutputWriter2Writer.this.writer.flush();
            }
            this.flushOBuf();
        }

        private void flushOBuf(ByteBuffer byteBuffer) throws IOException {
            if (byteBuffer.position() > this.count) {
                this.writeBOMIfNeeded();
                XOutputWriter2Writer.this.out.write(this.obuf, 0, byteBuffer.position());
            }
            this.count = 0;
        }

        private void flushOBuf() throws IOException {
            if (this.count > 0) {
                this.writeBOMIfNeeded();
                XOutputWriter2Writer.this.out.write(this.obuf, 0, this.count);
            }
            this.count = 0;
        }

        protected final boolean ensureBufForChars(int n2) throws IOException {
            if (LoggerUtil.isFinestLoggable(gLogger2)) {
                gLogger2.logp(Level.FINEST, gLogger2.getName(), "ensureBufForChars(int len)", "len = " + n2 + ", len+count = " + (n2 + this.count));
            }
            if (this.count + n2 < 5461) {
                return false;
            }
            if (this.writerNeedsFlushing) {
                XOutputWriter2Writer.this.writer.flush();
            }
            this.flushOBuf();
            return n2 > 5461;
        }

        protected final boolean ensureBufForChars(int n2, int n3) throws IOException {
            int n4 = n3 - n2;
            if (LoggerUtil.isFinestLoggable(gLogger2)) {
                gLogger2.logp(Level.FINEST, gLogger2.getName(), "ensureBufForChars(int start, int end)", "len = " + n4 + ", len+count = " + (n4 + this.count));
            }
            if (this.count + n4 < 5461) {
                return false;
            }
            if (this.writerNeedsFlushing) {
                XOutputWriter2Writer.this.writer.flush();
            }
            this.flushOBuf();
            return n4 > 5461;
        }

        protected final boolean ensureBufForBytes(int n2) throws IOException {
            if (LoggerUtil.isFinestLoggable(gLogger2)) {
                gLogger2.logp(Level.FINEST, gLogger2.getName(), "ensureBufForBytes(int len)", "len = " + n2 + ", len+count = " + (n2 + this.count));
            }
            if (this.count + n2 < 5461) {
                return false;
            }
            if (this.writerNeedsFlushing) {
                XOutputWriter2Writer.this.writer.flush();
            }
            this.flushOBuf();
            return n2 > 5461;
        }

        protected final boolean ensureBufForBytes(int n2, int n3) throws IOException {
            int n4 = n3 - n2;
            if (LoggerUtil.isFinestLoggable(gLogger2)) {
                gLogger2.logp(Level.FINEST, gLogger2.getName(), "ensureBufForBytes(int start, int end)", "len = " + n4 + ", len+count = " + n4 + this.count);
            }
            if (this.count + n4 < 5461) {
                return false;
            }
            if (this.writerNeedsFlushing) {
                XOutputWriter2Writer.this.writer.flush();
            }
            this.flushOBuf();
            return n4 > 5461;
        }
    }

    class ZZZOutputStreamWriterFlushed
    extends Writer {
        final Charset enc;
        final CharsetEncoder charsetEncoder;
        final CharBuffer ccout;

        public ZZZOutputStreamWriterFlushed(OutputStream outputStream, Charset charset) {
            this.enc = charset;
            this.charsetEncoder = charset.newEncoder();
            this.ccout = CharBuffer.allocate(1);
        }

        public void write(char[] cArray, int n2, int n3) throws IOException {
            CharBuffer charBuffer = CharBuffer.wrap(cArray, n2, n3);
            ByteBuffer byteBuffer = this.charsetEncoder.encode(charBuffer);
            XOutputWriter2Writer.this.out.write(byteBuffer.array());
        }

        public void write(int n2) throws IOException {
            this.ccout.position(0);
            this.ccout.put((char)n2).position(0);
            ByteBuffer byteBuffer = this.charsetEncoder.encode(this.ccout);
            XOutputWriter2Writer.this.out.write(byteBuffer.array());
        }

        public void write(String string2, int n2, int n3) throws IOException {
            CharBuffer charBuffer = CharBuffer.wrap(string2, n2, n3);
            ByteBuffer byteBuffer = this.charsetEncoder.encode(charBuffer);
            XOutputWriter2Writer.this.out.write(byteBuffer.array());
        }

        public void close() throws IOException {
        }

        public void flush() throws IOException {
        }
    }
}

