/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.serializer;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.dp.values.chars.Chars;
import com.ibm.xml.xci.dp.values.chars.EncodeContext;
import com.ibm.xml.xci.dp.values.chars.WhitespaceCharsConstant;
import com.ibm.xml.xci.serializer.CharEscapeMaps;
import com.ibm.xml.xci.serializer.CodepointMappings;
import com.ibm.xml.xci.serializer.EncodingInfo;
import com.ibm.xml.xci.serializer.Encodings;
import com.ibm.xml.xci.serializer.Messages;
import com.ibm.xml.xci.serializer.UnicodeNormalizerFactory;
import com.ibm.xml.xci.serializer.XOutputFrag;
import com.ibm.xml.xci.serializer.XOutputWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class XOutputWriter8Bit
extends XOutputWriter {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2010. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger gLogger = LoggerUtil.getLogger(XOutputWriter8Bit.class);
    private static final Logger gLogger2 = LoggerUtil.getLogger(OutputStreamWriterFlushed.class);
    byte[] indentLineSepBytes;
    protected static final int BYTES_MAX = 16384;
    protected static final int BYTES_MAX_1CHAR_SAFE = 16380;
    static final int BYTES_MAX_CHARS_SAFE = 5461;
    OutputStream m_os;
    protected final byte[] obuf;
    protected int count;
    protected boolean writerNeedsFlushing;
    private static int BUFFERING_SIZE_CUTOFF = 128;
    char highUTF16Surrogate = '\u0000';
    static final boolean useWholeStringNormalization = true;

    protected XOutputWriter8Bit(Charset charset, EncodingInfo encodingInfo, boolean bl, char[] cArray, char c, CodepointMappings codepointMappings, OutputStream outputStream) {
        super(charset, encodingInfo, bl, cArray, c, codepointMappings, outputStream);
        if (cArray == WhitespaceCharsConstant.s_systemLineSep) {
            this.indentLineSepBytes = WhitespaceCharsConstant.indentLineSepUTF8;
        } else {
            CharBuffer charBuffer = CharBuffer.wrap(cArray);
            ByteBuffer byteBuffer = charset.encode(charBuffer);
            this.indentLineSepBytes = new byte[byteBuffer.limit() - byteBuffer.position()];
            byteBuffer.get(this.indentLineSepBytes);
        }
        this.obuf = new byte[16387];
        this.count = 0;
        this.writer = new OutputStreamWriterFlushed(this.outputCharset);
    }

    protected final void reset(Charset charset, EncodingInfo encodingInfo, boolean bl, char[] cArray, char c, CodepointMappings codepointMappings, OutputStream outputStream) {
        super.reset(charset, encodingInfo, bl, cArray, c, codepointMappings, outputStream);
        if (cArray == WhitespaceCharsConstant.s_systemLineSep) {
            this.indentLineSepBytes = WhitespaceCharsConstant.indentLineSepUTF8;
        } else {
            CharBuffer charBuffer = CharBuffer.wrap(cArray);
            ByteBuffer byteBuffer = charset.encode(charBuffer);
            this.indentLineSepBytes = new byte[byteBuffer.limit() - byteBuffer.position()];
            byteBuffer.get(this.indentLineSepBytes);
        }
        this.count = 0;
        ((OutputStreamWriterFlushed)this.writer).reset(this.outputCharset);
    }

    protected final void flushBuf() throws IOException {
        this.out.write(this.obuf, 0, this.count);
        this.count = 0;
    }

    public void flushBuffers() throws IOException {
        this.flushBuf();
    }

    protected final boolean ensureBufForChars(int n2) throws IOException {
        if (LoggerUtil.isFinestLoggable(gLogger)) {
            gLogger.logp(Level.FINEST, gLogger.getName(), "ensureBufForChars(int len)", "len = " + n2 + ", len+count = " + (n2 + this.count));
        }
        if (this.count + n2 < 5461) {
            return false;
        }
        if (this.writerNeedsFlushing) {
            this.writer.flush();
        }
        this.out.write(this.obuf, 0, this.count);
        this.count = 0;
        return n2 > 5461;
    }

    protected final boolean ensureBufForChars(int n2, int n3) throws IOException {
        int n4 = n3 - n2;
        if (LoggerUtil.isFinestLoggable(gLogger)) {
            gLogger.logp(Level.FINEST, gLogger.getName(), "ensureBufForChars(int start, int end)", "len = " + n4 + ", len+count = " + (n4 + this.count));
        }
        if (this.count + n4 < 5461) {
            return false;
        }
        if (this.writerNeedsFlushing) {
            this.writer.flush();
        }
        this.out.write(this.obuf, 0, this.count);
        this.count = 0;
        return n4 > 5461;
    }

    protected final boolean ensureBufForBytes(int n2) throws IOException {
        if (LoggerUtil.isFinestLoggable(gLogger)) {
            gLogger.logp(Level.FINEST, gLogger.getName(), "ensureBufForBytes(int len)", "len = " + n2 + ", len+count = " + (n2 + this.count));
        }
        if (this.count + n2 < 5461) {
            return false;
        }
        if (this.writerNeedsFlushing) {
            this.writer.flush();
        }
        this.out.write(this.obuf, 0, this.count);
        this.count = 0;
        return n2 > 5461;
    }

    protected final boolean ensureBufForBytes(int n2, int n3) throws IOException {
        int n4 = n3 - n2;
        if (LoggerUtil.isFinestLoggable(gLogger)) {
            gLogger.logp(Level.FINEST, gLogger.getName(), "ensureBufForBytes(int start, int end)", "len = " + n4 + ", len+count = " + (n4 + this.count));
        }
        if (this.count + n4 < 5461) {
            return false;
        }
        if (this.writerNeedsFlushing) {
            this.writer.flush();
        }
        this.out.write(this.obuf, 0, this.count);
        this.count = 0;
        return n4 > 5461;
    }

    public void writeDirectUTF8(byte[] byArray, int n2, int n3) throws IOException {
        if (LoggerUtil.isFinerLoggable(gLogger)) {
            XOutputWriter8Bit.logBytes(gLogger, Level.FINER, byArray, n2, n2 + n3, "writeDirectUTF8(byte[], int, int)");
        }
        if (n3 < BUFFERING_SIZE_CUTOFF) {
            this.ensureBufForBytes(n3);
            System.arraycopy(byArray, n2, this.obuf, this.count, n3);
            this.count += n3;
        } else {
            if (this.writerNeedsFlushing) {
                this.writer.flush();
            }
            this.flushBuf();
            this.out.write(byArray, n2, n3);
        }
    }

    public final void writeDirect(byte[] byArray) throws IOException {
        int n2 = byArray.length;
        this.ensureBufForBytes(n2);
        System.arraycopy(byArray, 0, this.obuf, this.count, n2);
        this.count += n2;
    }

    public final void writeDirect(byte[] byArray, int n2, int n3) throws IOException {
        this.ensureBufForBytes(n3);
        System.arraycopy(byArray, n2, this.obuf, this.count, n3);
        this.count += n3;
    }

    private final void writeDirect(String string2) throws IOException {
        ByteBuffer byteBuffer = this.outputCharset.encode(string2);
        int n2 = byteBuffer.limit() - byteBuffer.position();
        if (byteBuffer.hasArray()) {
            byte[] byArray = byteBuffer.array();
            System.arraycopy(byArray, byteBuffer.position(), this.obuf, this.count, n2);
        } else {
            byte[] byArray = new byte[n2];
            byteBuffer.get(byArray);
            System.arraycopy(byArray, 0, this.obuf, this.count, n2);
        }
        this.count += n2;
    }

    public void writeBOM() throws IOException {
        this.obuf[this.count++] = -17;
        this.obuf[this.count++] = -69;
        this.obuf[this.count++] = -65;
    }

    public void writeLineBreak() throws IOException {
        int n2 = this.count + this.indentLineSepLen;
        if (n2 >= 16384) {
            this.flushBuf();
        }
        System.arraycopy(this.indentLineSepBytes, 0, this.obuf, this.count, this.indentLineSepLen);
        this.count = n2;
    }

    public void writeAmpEntity() throws IOException {
        int n2 = this.count + XOutputFrag.AmpEntity.len;
        if (n2 >= 16384) {
            this.flushBuf();
        }
        System.arraycopy(XOutputFrag.AmpEntity.bytes, 0, this.obuf, this.count, XOutputFrag.AmpEntity.len);
        this.count = n2;
    }

    public void writeCDataSectionEnd() throws IOException {
        int n2 = this.count + XOutputFrag.CDataSectionEnd.len;
        if (n2 >= 16384) {
            this.flushBuf();
        }
        System.arraycopy(XOutputFrag.CDataSectionEnd.bytes, 0, this.obuf, this.count, XOutputFrag.CDataSectionEnd.len);
        this.count = n2;
    }

    public void writeCDataSectionStart() throws IOException {
        int n2 = this.count + XOutputFrag.CDataSectionStart.len;
        if (n2 >= 16384) {
            this.flushBuf();
        }
        System.arraycopy(XOutputFrag.CDataSectionStart.bytes, 0, this.obuf, this.count, XOutputFrag.CDataSectionStart.len);
        this.count = n2;
    }

    public void writeColon() throws IOException {
        int n2 = this.count + XOutputFrag.Colon.len;
        if (n2 >= 16384) {
            this.flushBuf();
        }
        System.arraycopy(XOutputFrag.Colon.bytes, 0, this.obuf, this.count, XOutputFrag.Colon.len);
        this.count = n2;
    }

    public void writeCommentEnd() throws IOException {
        int n2 = this.count + XOutputFrag.CommentEnd.len;
        if (n2 >= 16384) {
            this.flushBuf();
        }
        System.arraycopy(XOutputFrag.CommentEnd.bytes, 0, this.obuf, this.count, XOutputFrag.CommentEnd.len);
        this.count = n2;
    }

    public void writeCommentStart() throws IOException {
        int n2 = this.count + XOutputFrag.CommentStart.len;
        if (n2 >= 16384) {
            this.flushBuf();
        }
        System.arraycopy(XOutputFrag.CommentStart.bytes, 0, this.obuf, this.count, XOutputFrag.CommentStart.len);
        this.count = n2;
    }

    public void writeQuoteDocTypeClose() throws IOException {
        int n2 = this.count + XOutputFrag.DocTypeClose.len;
        if (n2 >= 16384) {
            this.flushBuf();
        }
        System.arraycopy(XOutputFrag.DocTypeClose.bytes, 0, this.obuf, this.count, XOutputFrag.DocTypeClose.len);
        this.count = n2;
    }

    public void writeDocTypeOpen() throws IOException {
        int n2 = this.count + XOutputFrag.DocTypeOpen.len;
        if (n2 >= 16384) {
            this.flushBuf();
        }
        System.arraycopy(XOutputFrag.DocTypeOpen.bytes, 0, this.obuf, this.count, XOutputFrag.DocTypeOpen.len);
        this.count = n2;
    }

    public void writeEmptyElementClose() throws IOException {
        int n2 = this.count + XOutputFrag.EmptyElementClose.len;
        if (n2 >= 16384) {
            this.flushBuf();
        }
        System.arraycopy(XOutputFrag.EmptyElementClose.bytes, 0, this.obuf, this.count, XOutputFrag.EmptyElementClose.len);
        this.count = n2;
    }

    public void writeEmptyElementEndEndTagOpen() throws IOException {
        int n2 = this.count + XOutputFrag.EmptyElementEndEndTagOpen.len;
        if (n2 >= 16384) {
            this.flushBuf();
        }
        System.arraycopy(XOutputFrag.EmptyElementEndEndTagOpen.bytes, 0, this.obuf, this.count, XOutputFrag.EmptyElementEndEndTagOpen.len);
        this.count = n2;
    }

    public void writeEndTagClose() throws IOException {
        int n2 = this.count + XOutputFrag.EndTagClose.len;
        if (n2 >= 16384) {
            this.flushBuf();
        }
        System.arraycopy(XOutputFrag.EndTagClose.bytes, 0, this.obuf, this.count, XOutputFrag.EndTagClose.len);
        this.count = n2;
    }

    public void writeEndTagOpen() throws IOException {
        int n2 = this.count + XOutputFrag.EndTagOpen.len;
        if (n2 >= 16384) {
            this.flushBuf();
        }
        System.arraycopy(XOutputFrag.EndTagOpen.bytes, 0, this.obuf, this.count, XOutputFrag.EndTagOpen.len);
        this.count = n2;
    }

    public void writeEntityEnd() throws IOException {
        int n2 = this.count + XOutputFrag.EntityEnd.len;
        if (n2 >= 16384) {
            this.flushBuf();
        }
        System.arraycopy(XOutputFrag.EntityEnd.bytes, 0, this.obuf, this.count, XOutputFrag.EntityEnd.len);
        this.count = n2;
    }

    public void writeEqualsQuote() throws IOException {
        int n2 = this.count + XOutputFrag.EqualsQuote.len;
        if (n2 >= 16384) {
            this.flushBuf();
        }
        System.arraycopy(XOutputFrag.EqualsQuote.bytes, 0, this.obuf, this.count, XOutputFrag.EqualsQuote.len);
        this.count = n2;
    }

    public void writeGTEntity() throws IOException {
        int n2 = this.count + XOutputFrag.GTEntity.len;
        if (n2 >= 16384) {
            this.flushBuf();
        }
        System.arraycopy(XOutputFrag.GTEntity.bytes, 0, this.obuf, this.count, XOutputFrag.GTEntity.len);
        this.count = n2;
    }

    public void writeHexEntityStart() throws IOException {
        int n2 = this.count + XOutputFrag.HexEntityStart.len;
        if (n2 >= 16384) {
            this.flushBuf();
        }
        System.arraycopy(XOutputFrag.HexEntityStart.bytes, 0, this.obuf, this.count, XOutputFrag.HexEntityStart.len);
        this.count = n2;
    }

    public void writeIntEntityStart() throws IOException {
        int n2 = this.count + XOutputFrag.IntEntityStart.len;
        if (n2 >= 16384) {
            this.flushBuf();
        }
        System.arraycopy(XOutputFrag.IntEntityStart.bytes, 0, this.obuf, this.count, XOutputFrag.IntEntityStart.len);
        this.count = n2;
    }

    public void writeLTEntity() throws IOException {
        int n2 = this.count + XOutputFrag.LTEntity.len;
        if (n2 >= 16384) {
            this.flushBuf();
        }
        System.arraycopy(XOutputFrag.LTEntity.bytes, 0, this.obuf, this.count, XOutputFrag.LTEntity.len);
        this.count = n2;
    }

    public void writePIClose(EncodeContext encodeContext) throws IOException {
        if (encodeContext == EncodeContext.HTML_PI) {
            int n2 = this.count + XOutputFrag.PICloseHTML.len;
            if (n2 >= 16384) {
                this.flushBuf();
            }
            System.arraycopy(XOutputFrag.PICloseHTML.bytes, 0, this.obuf, this.count, XOutputFrag.PICloseHTML.len);
            this.count = n2;
        } else {
            int n3 = this.count + XOutputFrag.PIClose.len;
            if (n3 >= 16384) {
                this.flushBuf();
            }
            System.arraycopy(XOutputFrag.PIClose.bytes, 0, this.obuf, this.count, XOutputFrag.PIClose.len);
            this.count = n3;
        }
    }

    public void writePIOpen() throws IOException {
        int n2 = this.count + XOutputFrag.PIOpen.len;
        if (n2 >= 16384) {
            this.flushBuf();
        }
        System.arraycopy(XOutputFrag.PIOpen.bytes, 0, this.obuf, this.count, XOutputFrag.PIOpen.len);
        this.count = n2;
    }

    public void writePublicIDOpen() throws IOException {
        int n2 = this.count + XOutputFrag.PublicIDOpen.len;
        if (n2 >= 16384) {
            this.flushBuf();
        }
        System.arraycopy(XOutputFrag.PublicIDOpen.bytes, 0, this.obuf, this.count, XOutputFrag.PublicIDOpen.len);
        this.count = n2;
    }

    public void writeQuotEntity() throws IOException {
        int n2 = this.count + XOutputFrag.QuotEntity.len;
        if (n2 >= 16384) {
            this.flushBuf();
        }
        System.arraycopy(XOutputFrag.QuotEntity.bytes, 0, this.obuf, this.count, XOutputFrag.QuotEntity.len);
        this.count = n2;
    }

    public void writeQuote() throws IOException {
        int n2 = this.count + XOutputFrag.Quote.len;
        if (n2 >= 16384) {
            this.flushBuf();
        }
        System.arraycopy(XOutputFrag.Quote.bytes, 0, this.obuf, this.count, XOutputFrag.Quote.len);
        this.count = n2;
    }

    public void writeQuoteSpaceQuote() throws IOException {
        int n2 = this.count + XOutputFrag.QuoteSpaceQuote.len;
        if (n2 >= 16384) {
            this.flushBuf();
        }
        System.arraycopy(XOutputFrag.QuoteSpaceQuote.bytes, 0, this.obuf, this.count, XOutputFrag.QuoteSpaceQuote.len);
        this.count = n2;
    }

    public void writeSpace() throws IOException {
        int n2 = this.count + XOutputFrag.Space.len;
        if (n2 >= 16384) {
            this.flushBuf();
        }
        System.arraycopy(XOutputFrag.Space.bytes, 0, this.obuf, this.count, XOutputFrag.Space.len);
        this.count = n2;
    }

    public void writeSpaceEmptyElementClose() throws IOException {
        int n2 = this.count + XOutputFrag.SpaceEmptyElementClose.len;
        if (n2 >= 16384) {
            this.flushBuf();
        }
        System.arraycopy(XOutputFrag.SpaceEmptyElementClose.bytes, 0, this.obuf, this.count, XOutputFrag.SpaceEmptyElementClose.len);
        this.count = n2;
    }

    public void writeSpaceXMLNS() throws IOException {
        int n2 = this.count + XOutputFrag.SpaceXMLNS.len;
        if (n2 >= 16384) {
            this.flushBuf();
        }
        System.arraycopy(XOutputFrag.SpaceXMLNS.bytes, 0, this.obuf, this.count, XOutputFrag.SpaceXMLNS.len);
        this.count = n2;
    }

    public void writeSpaceXMLNSColon() throws IOException {
        int n2 = this.count + XOutputFrag.SpaceXMLNSColon.len;
        if (n2 >= 16384) {
            this.flushBuf();
        }
        System.arraycopy(XOutputFrag.SpaceXMLNSColon.bytes, 0, this.obuf, this.count, XOutputFrag.SpaceXMLNSColon.len);
        this.count = n2;
    }

    public void writeStartTagClose() throws IOException {
        int n2 = this.count + XOutputFrag.StartTagClose.len;
        if (n2 >= 16384) {
            this.flushBuf();
        }
        System.arraycopy(XOutputFrag.StartTagClose.bytes, 0, this.obuf, this.count, XOutputFrag.StartTagClose.len);
        this.count = n2;
    }

    public void writeStartTagOpen() throws IOException {
        int n2 = this.count + XOutputFrag.StartTagOpen.len;
        if (n2 >= 16384) {
            this.flushBuf();
        }
        System.arraycopy(XOutputFrag.StartTagOpen.bytes, 0, this.obuf, this.count, XOutputFrag.StartTagOpen.len);
        this.count = n2;
    }

    public void writeSystemIDOpen() throws IOException {
        int n2 = this.count + XOutputFrag.SystemIDOpen.len;
        if (n2 >= 16384) {
            this.flushBuf();
        }
        System.arraycopy(XOutputFrag.SystemIDOpen.bytes, 0, this.obuf, this.count, XOutputFrag.SystemIDOpen.len);
        this.count = n2;
    }

    public void writeXMLEncodingOpen() throws IOException {
        int n2 = this.count + XOutputFrag.XMLEncodingOpen.len;
        if (n2 >= 16384) {
            this.flushBuf();
        }
        System.arraycopy(XOutputFrag.XMLEncodingOpen.bytes, 0, this.obuf, this.count, XOutputFrag.XMLEncodingOpen.len);
        this.count = n2;
    }

    public void writeXMLHeaderClose() throws IOException {
        int n2 = this.count + XOutputFrag.XMLHeaderClose.len;
        if (n2 >= 16384) {
            this.flushBuf();
        }
        System.arraycopy(XOutputFrag.XMLHeaderClose.bytes, 0, this.obuf, this.count, XOutputFrag.XMLHeaderClose.len);
        this.count = n2;
    }

    public void writeXMLVersionOpen() throws IOException {
        int n2 = this.count + XOutputFrag.XMLVersionOpen.len;
        if (n2 >= 16384) {
            this.flushBuf();
        }
        System.arraycopy(XOutputFrag.XMLVersionOpen.bytes, 0, this.obuf, this.count, XOutputFrag.XMLVersionOpen.len);
        this.count = n2;
    }

    protected final void writeCharacterAsInt(int n2) throws IOException {
        this.writeIntEntityStart();
        byte[] byArray = this.encodingInfo.getBytes(Integer.toString(n2));
        int n3 = this.count + byArray.length;
        if (n3 >= 16384) {
            this.flushBuf();
        }
        System.arraycopy(byArray, 0, this.obuf, this.count, byArray.length);
        this.count = n3;
        this.writeEntityEnd();
    }

    protected final void writeCharacterAsHex(int n2) throws IOException {
        this.writeHexEntityStart();
        byte[] byArray = this.encodingInfo.getBytes(XOutputWriter8Bit.makeHexString(n2));
        int n3 = this.count + byArray.length;
        if (n3 >= 16384) {
            this.flushBuf();
        }
        System.arraycopy(byArray, 0, this.obuf, this.count, byArray.length);
        this.count = n3;
        this.writeEntityEnd();
    }

    public void write(char c, EncodeContext encodeContext) throws IOException {
        byte[] byArray;
        int n2;
        if (this.count >= 16380) {
            this.flushBuf();
        }
        if (c < (n2 = (byArray = this.getCharMap(encodeContext)).length)) {
            byte by2 = byArray[c];
            switch (by2) {
                case 0: {
                    this.obuf[this.count++] = (byte)c;
                    break;
                }
                default: {
                    this.writeEscaped(c, (int)by2);
                    break;
                }
            }
        } else if (c < '\u0800') {
            this.obuf[this.count++] = (byte)(192 + (c >> 6));
            this.obuf[this.count++] = (byte)(128 + (c & 0x3F));
        } else if (Encodings.isHighUTF16Surrogate(c)) {
            this.highUTF16Surrogate = c;
        } else if (Encodings.isLowUTF16Surrogate(c)) {
            if (this.highUTF16Surrogate == '\u0000') {
                String string2 = Messages.createMessage2("ER_SER_INVALID_UTF16_SURROGATE3", new String[]{Integer.toString(c, 16)});
                Messages.xciDynamicErrorException(string2);
            }
            int n3 = Encodings.toCodePoint(this.highUTF16Surrogate, c);
            this.highUTF16Surrogate = '\u0000';
            if (this.isValidXMLChar(n3)) {
                if (!this.encodingInfo.isSurrogatePairInEncoding(this.highUTF16Surrogate, c)) {
                    this.writeCharacterAsHex(n3);
                } else {
                    this.writer.write(this.highUTF16Surrogate);
                    this.writer.write(c);
                }
            } else {
                String string3 = Messages.createMessage2("ER_SER_INVALID_CHARACTER_IN_TEXT", new String[]{Integer.toString(c, 16)});
                Messages.xciDynamicErrorException(string3);
            }
        } else if (!this.isValidXMLChar(c)) {
            String string4 = Messages.createMessage2("ER_SER_INVALID_CHARACTER_IN_TEXT", new String[]{Integer.toString(c, 16)});
            Messages.xciDynamicErrorException(string4);
        } else if (c < '\u10000') {
            this.obuf[this.count++] = (byte)(224 + (c >> 12));
            this.obuf[this.count++] = (byte)(128 + (c >> 6 & 0x3F));
            this.obuf[this.count++] = (byte)(128 + (c & 0x3F));
        } else {
            this.obuf[this.count++] = (byte)(240 + (c >> 18));
            this.obuf[this.count++] = (byte)(128 + (c >> 12 & 0x3F));
            this.obuf[this.count++] = (byte)(128 + (c >> 6 & 0x3F));
            this.obuf[this.count++] = (byte)(128 + (c & 0x3F));
        }
    }

    public void write(char[] cArray, int n2, int n3, EncodeContext encodeContext) throws IOException {
        if (LoggerUtil.isFinerLoggable(gLogger)) {
            XOutputWriter8Bit.logChars(gLogger, Level.FINER, cArray, n2, n3, "write(char[], int, int, EncodeContext)");
        }
        boolean bl = this.ensureBufForChars(n2, n3);
        byte[] byArray = this.getCharMap(encodeContext);
        block3: for (int i = n2; i < n3; ++i) {
            char c = cArray[i];
            if ((c & 0xFF80) == 0) {
                byte by2 = byArray[c];
                switch (by2) {
                    case 0: {
                        this.obuf[this.count++] = (byte)c;
                        if (!bl) {
                            while (++i < n3 && ((c = cArray[i]) & 0xFF80) == 0 && byArray[c] == 0) {
                                this.obuf[this.count++] = (byte)c;
                            }
                        } else {
                            while (true) {
                                if (this.count < 5461 && ++i < n3 && ((c = cArray[i]) & 0xFF80) == 0 && byArray[c] == 0) {
                                    this.obuf[this.count++] = (byte)c;
                                    continue;
                                }
                                if (this.count >= 5461) {
                                    this.flushBuf();
                                }
                                if (i >= n3 || (c & 0xFF80) != 0 || byArray[c] != 0) break;
                            }
                        }
                        if (i == n3) {
                            return;
                        }
                        if ((c & 0xFF00) == 0) {
                            this.writeEscaped(c, (int)byArray[c]);
                            break;
                        }
                        i = this.writeHighUTF16(c, cArray, i, n3, encodeContext);
                        continue block3;
                    }
                    default: {
                        this.writeEscaped(c, (int)by2);
                        break;
                    }
                }
                continue;
            }
            if ((c & 0xFF00) == 0) {
                this.writeEscaped(c, (int)byArray[c]);
                continue;
            }
            i = this.writeHighUTF16(c, cArray, i, n3, encodeContext);
        }
    }

    public void write(byte by2, EncodeContext encodeContext) throws IOException {
        this.ensureBufForBytes(0, 1);
        byte[] byArray = this.getCharMap(encodeContext);
        if ((by2 & 0xFF80) == 0) {
            byte by3 = byArray[by2];
            switch (by3) {
                case 0: {
                    this.obuf[this.count] = by2;
                    ++this.count;
                    break;
                }
                default: {
                    this.writeEscaped(by2, (int)by3);
                    break;
                }
            }
        } else if ((by2 & 0xFF00) == 0) {
            this.writeEscaped(by2, (int)byArray[by2]);
        } else {
            byte[] byArray2 = new byte[]{by2};
            this.writeUTF8VariableWidthChar(byArray2, 0, 1, encodeContext);
        }
    }

    public void writeWithLBNormalization(byte[] byArray, int n2, int n3, EncodeContext encodeContext) throws IOException {
        if (LoggerUtil.isFinerLoggable(gLogger)) {
            XOutputWriter8Bit.logBytes(gLogger, Level.FINER, byArray, n2, n3, "writeWithLBNormalization(byte[], int, int, EncodeContext)");
        }
        boolean bl = this.ensureBufForBytes(n2, n3);
        byte[] byArray2 = this.getCharMap(encodeContext);
        block3: for (int i = n2; i < n3; ++i) {
            byte by2 = byArray[i];
            if ((by2 & 0xFF80) == 0) {
                byte by3 = byArray2[by2];
                switch (by3) {
                    case 0: {
                        int n4;
                        int n5;
                        if (!bl) {
                            n5 = i;
                            while (++i < n3 && ((by2 = byArray[i]) & 0xFF80) == 0 && byArray2[by2] == 0) {
                            }
                            n4 = i - n5;
                            System.arraycopy(byArray, n5, this.obuf, this.count, n4);
                            this.count += n4;
                        } else {
                            do {
                                n5 = i;
                                while (++i < n3 && ((by2 = byArray[i]) & 0xFF80) == 0 && byArray2[by2] == 0 && i - n5 + this.count < 5461) {
                                }
                                n4 = i - n5;
                                System.arraycopy(byArray, n5, this.obuf, this.count, n4);
                                this.count += n4;
                                if (this.count < 5461) continue;
                                this.flushBuf();
                            } while (i < n3 && (by2 & 0xFF80) == 0 && byArray2[by2] == 0);
                        }
                        if (i == n3) {
                            return;
                        }
                        if (by2 == 13 && i + 1 < n3 && byArray[i + 1] == 10) {
                            this.writeLineBreak();
                            ++i;
                            continue block3;
                        }
                        if ((by2 & 0xFF00) == 0) {
                            this.writeEscaped(by2, (int)byArray2[by2]);
                            break;
                        }
                        i = this.writeUTF8VariableWidthChar(byArray, i, n3 - i, encodeContext) - 1;
                        continue block3;
                    }
                    default: {
                        if (by2 == 13 && i + 1 < n3 && byArray[i + 1] == 10) {
                            this.writeLineBreak();
                            ++i;
                            break;
                        }
                        this.writeEscaped(by2, (int)by3);
                        break;
                    }
                }
                continue;
            }
            if ((by2 & 0xFF00) == 0) {
                this.writeEscaped(by2, (int)byArray2[by2]);
                continue;
            }
            i = this.writeUTF8VariableWidthChar(byArray, i, n3 - i, encodeContext) - 1;
        }
    }

    public void write(byte[] byArray, int n2, int n3, EncodeContext encodeContext) throws IOException {
        if (LoggerUtil.isFinerLoggable(gLogger)) {
            XOutputWriter8Bit.logBytes(gLogger, Level.FINER, byArray, n2, n3, "write(byte[], int, int, EncodeContext)");
        }
        boolean bl = this.ensureBufForBytes(n2, n3);
        byte[] byArray2 = this.getCharMap(encodeContext);
        block3: for (int i = n2; i < n3; ++i) {
            byte by2 = byArray[i];
            if ((by2 & 0xFF80) == 0) {
                byte by3 = byArray2[by2];
                switch (by3) {
                    case 0: {
                        int n4;
                        int n5;
                        if (!bl) {
                            n5 = i;
                            while (++i < n3 && ((by2 = byArray[i]) & 0xFF80) == 0 && byArray2[by2] == 0) {
                            }
                            n4 = i - n5;
                            System.arraycopy(byArray, n5, this.obuf, this.count, n4);
                            this.count += n4;
                        } else {
                            do {
                                n5 = i;
                                while (++i < n3 && ((by2 = byArray[i]) & 0xFF80) == 0 && byArray2[by2] == 0 && i - n5 + this.count < 5461) {
                                }
                                n4 = i - n5;
                                System.arraycopy(byArray, n5, this.obuf, this.count, n4);
                                this.count += n4;
                                if (this.count < 5461) continue;
                                this.flushBuf();
                            } while (i < n3 && (by2 & 0xFF80) == 0 && byArray2[by2] == 0);
                        }
                        if (i == n3) {
                            return;
                        }
                        if ((by2 & 0xFF00) == 0) {
                            this.writeEscaped(by2, (int)byArray2[by2]);
                            break;
                        }
                        i = this.writeUTF8VariableWidthChar(byArray, i, n3 - i, encodeContext) - 1;
                        continue block3;
                    }
                    default: {
                        this.writeEscaped(by2, (int)by3);
                        break;
                    }
                }
                continue;
            }
            if ((by2 & 0xFF00) == 0) {
                this.writeEscaped(by2, (int)byArray2[by2]);
                continue;
            }
            i = this.writeUTF8VariableWidthChar(byArray, i, n3 - i, encodeContext) - 1;
        }
    }

    public void write(byte[] byArray, EncodeContext encodeContext) throws IOException {
        this.write(byArray, 0, byArray.length, encodeContext);
    }

    public void write(Chars chars, EncodeContext encodeContext) throws IOException {
        this.writeCharSeq(chars, 0, chars.length(), encodeContext);
    }

    public void write(String string2, EncodeContext encodeContext) throws IOException {
        this.writeCharSeq(string2, 0, string2.length(), encodeContext);
    }

    public void write(CharSequence charSequence, EncodeContext encodeContext) throws IOException {
        this.writeCharSeq(charSequence, 0, charSequence.length(), encodeContext);
    }

    private final void writeCharSeq(CharSequence charSequence, int n2, int n3, EncodeContext encodeContext) throws IOException {
        boolean bl = this.ensureBufForChars(n2, n3);
        byte[] byArray = this.getCharMap(encodeContext);
        block3: for (int i = n2; i < n3; ++i) {
            char c = charSequence.charAt(i);
            if ((c & 0xFF80) == 0) {
                byte by2 = byArray[c];
                switch (by2) {
                    case 0: {
                        this.obuf[this.count++] = (byte)c;
                        if (!bl) {
                            while (++i < n3 && ((c = charSequence.charAt(i)) & 0xFF80) == 0 && byArray[c] == 0) {
                                this.obuf[this.count++] = (byte)c;
                            }
                        } else {
                            while (true) {
                                if (this.count < 5461 && ++i < n3 && ((c = charSequence.charAt(i)) & 0xFF80) == 0 && byArray[c] == 0) {
                                    this.obuf[this.count++] = (byte)c;
                                    continue;
                                }
                                if (this.count >= 5461) {
                                    this.flushBuf();
                                }
                                if (i >= n3 || (c & 0xFF80) != 0 || byArray[c] != 0) break;
                            }
                        }
                        if (i == n3) {
                            return;
                        }
                        if ((c & 0xFF00) == 0) {
                            this.writeEscaped(c, (int)byArray[c]);
                            break;
                        }
                        i = this.writeHighUTF16(c, charSequence, i, n3, encodeContext);
                        continue block3;
                    }
                    default: {
                        this.writeEscaped(c, (int)by2);
                        break;
                    }
                }
                continue;
            }
            if ((c & 0xFF00) == 0) {
                this.writeEscaped(c, (int)byArray[c]);
                continue;
            }
            i = this.writeHighUTF16(c, charSequence, i, n3, encodeContext);
        }
    }

    public void write(Chars chars, int n2, int n3, EncodeContext encodeContext) throws IOException {
        this.writeCharSeq(chars, n2, n3, encodeContext);
    }

    public void write(String string2, int n2, int n3, EncodeContext encodeContext) throws IOException {
        boolean bl = this.ensureBufForChars(n2, n3);
        byte[] byArray = this.getCharMap(encodeContext);
        block3: for (int i = n2; i < n3; ++i) {
            char c = string2.charAt(i);
            if ((c & 0xFF80) == 0) {
                byte by2 = byArray[c];
                switch (by2) {
                    case 0: {
                        this.obuf[this.count++] = (byte)c;
                        if (!bl) {
                            while (++i < n3 && ((c = string2.charAt(i)) & 0xFF80) == 0 && byArray[c] == 0) {
                                this.obuf[this.count++] = (byte)c;
                            }
                        } else {
                            while (true) {
                                if (this.count < 5461 && ++i < n3 && ((c = string2.charAt(i)) & 0xFF80) == 0 && byArray[c] == 0) {
                                    this.obuf[this.count++] = (byte)c;
                                    continue;
                                }
                                if (this.count >= 5461) {
                                    this.flushBuf();
                                }
                                if (i >= n3 || (c & 0xFF80) != 0 || byArray[c] != 0) break;
                            }
                        }
                        if (i == n3) {
                            return;
                        }
                        if ((c & 0xFF00) == 0) {
                            this.writeEscaped(c, (int)byArray[c]);
                            break;
                        }
                        i = this.writeHighUTF16(c, string2, i, n3, encodeContext);
                        continue block3;
                    }
                    default: {
                        this.writeEscaped(c, (int)by2);
                        break;
                    }
                }
                continue;
            }
            if ((c & 0xFF00) == 0) {
                this.writeEscaped(c, (int)byArray[c]);
                continue;
            }
            i = this.writeHighUTF16(c, string2, i, n3, encodeContext);
        }
    }

    public void write(char c, int n2, EncodeContext encodeContext) throws IOException {
        this.ensureBufForChars(n2);
        byte[] byArray = this.getCharMap(encodeContext);
        if (c < byArray.length) {
            byte by2 = byArray[c];
            if (by2 == 0) {
                if (c == ' ' && n2 < 20) {
                    byte[] byArray2 = WhitespaceCharsConstant.whitespaceConstantsByteArrays[n2];
                    System.arraycopy(byArray2, 0, this.obuf, this.count, n2);
                    this.count += n2;
                } else {
                    for (int i = 0; i < n2; ++i) {
                        this.obuf[this.count++] = (byte)c;
                    }
                }
            } else {
                for (int i = 0; i < n2; ++i) {
                    this.writeEscaped(c, (int)by2);
                }
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                this.write(c, encodeContext);
            }
        }
    }

    void writeHTMLAttrURI(Chars chars, EncodeContext encodeContext) throws IOException {
        int n2;
        boolean bl;
        CharSequence charSequence;
        String string2;
        if (this.m_unicodeNormalizer == null) {
            this.m_unicodeNormalizer = UnicodeNormalizerFactory.getUnicodeNormalizer();
        }
        if (!this.m_unicodeNormalizer.alreadyNormalized(string2 = ((Object)(charSequence = chars)).toString(), 2)) {
            charSequence = this.m_unicodeNormalizer.normalizeUnicode(string2, 2);
        }
        if (bl = this.ensureBufForChars(n2 = charSequence.length())) {
            super.writeHTMLAttrURI(chars, encodeContext);
            return;
        }
        byte[] byArray = CharEscapeMaps.Maps.URL_NORMALIZION_CHAR_ESCAPE_MAP;
        char c = '\u0000';
        int n3 = 0;
        block6: while (true) {
            if (n3 < n2 && ((c = charSequence.charAt(n3)) & 0xFF80) == 0 && byArray[c] == 0) {
                this.obuf[this.count++] = (byte)c;
                ++n3;
                continue;
            }
            if (n3 >= n2) {
                return;
            }
            ++n3;
            switch (c) {
                case '\"': {
                    this.writeQuotEntity();
                    continue block6;
                }
                case '&': {
                    this.writeAmpEntity();
                    continue block6;
                }
                case '<': {
                    this.writeLTEntity();
                    continue block6;
                }
                case '>': {
                    this.writeGTEntity();
                    continue block6;
                }
            }
            n3 = this.urlEncodeChar(charSequence, c, n3);
        }
    }

    private int urlEncodeChar(CharSequence charSequence, char c, int n2) throws IOException {
        if (c < ' ' || c > '~') {
            if (c <= '\u007f') {
                this.obuf[this.count++] = 37;
                this.writeDirect(XOutputWriter8Bit.makeHexString(c));
            } else if (c <= '\u07ff') {
                int n3 = c >> 6 | 0xC0;
                int n4 = c & 0x3F | 0x80;
                this.obuf[this.count++] = 37;
                String string2 = XOutputWriter8Bit.makeHexString(n3);
                this.writeDirect(string2);
                this.obuf[this.count++] = 37;
                String string3 = XOutputWriter8Bit.makeHexString(n4);
                this.writeDirect(string3);
            } else if (Encodings.isHighUTF16Surrogate(c)) {
                int n5 = c & 0x3FF;
                int n6 = (n5 & 0x3C0) >> 6;
                int n7 = n6 + 1;
                int n8 = (n5 & 0x3C) >> 2;
                int n9 = (n5 & 3) << 4 & 0x30;
                c = charSequence.charAt(n2);
                ++n2;
                int n10 = c & 0x3FF;
                int n11 = n10 & 0x3F;
                int n12 = 0xF0 | n7 >> 2;
                int n13 = 0x80 | (n7 & 3) << 4 & 0x30 | n8;
                int n14 = 0x80 | (n9 |= (n10 & 0x3C0) >> 6);
                int n15 = 0x80 | n11;
                this.obuf[this.count++] = 37;
                String string4 = XOutputWriter8Bit.makeHexString(n12);
                this.writeDirect(string4);
                this.obuf[this.count++] = 37;
                String string5 = XOutputWriter8Bit.makeHexString(n13);
                this.writeDirect(string5);
                this.obuf[this.count++] = 37;
                String string6 = XOutputWriter8Bit.makeHexString(n14);
                this.writeDirect(string6);
                this.obuf[this.count++] = 37;
                String string7 = XOutputWriter8Bit.makeHexString(n15);
                this.writeDirect(string7);
            } else {
                int n16 = c >> 12 | 0xE0;
                int n17 = (c & 0xFC0) >> 6 | 0x80;
                int n18 = c & 0x3F | 0x80;
                this.obuf[this.count++] = 37;
                this.writeDirect(XOutputWriter8Bit.makeHexString(n16));
                this.obuf[this.count++] = 37;
                this.writeDirect(XOutputWriter8Bit.makeHexString(n17));
                this.obuf[this.count++] = 37;
                this.writeDirect(XOutputWriter8Bit.makeHexString(n18));
            }
            return n2;
        }
        switch (c) {
            case '\"': {
                this.writeQuotEntity();
                break;
            }
            case '&': {
                this.writeAmpEntity();
                break;
            }
            case '<': {
                this.writeLTEntity();
                break;
            }
            case '>': {
                this.writeGTEntity();
                break;
            }
            default: {
                this.obuf[this.count++] = 37;
            }
        }
        return n2;
    }

    protected void writeHTMLAttrAmp() throws IOException {
        this.flushBuf();
        this.writeAmpEntity();
    }

    protected void writeHTMLAttrLeftCurly() {
        if (this.count >= XOutputFrag.AmpEntity.len && this.obuf[this.count - 5] == 38 && this.obuf[this.count - 4] == 97 && this.obuf[this.count - 3] == 109 && this.obuf[this.count - 2] == 112 && this.obuf[this.count - 1] == 59) {
            this.count -= XOutputFrag.AmpEntity.len;
            this.obuf[this.count++] = 38;
        }
        this.obuf[this.count++] = 123;
    }

    public boolean isOptimizedForDirectWrites(String string2) {
        String string3 = this.getEncodingInfo().getName();
        return this.getCodepointMappings() == null && (string2 == string3 || string2.equals(string3));
    }

    final class OutputStreamWriterFlushed
    extends Writer {
        Charset enc;
        CharsetEncoder charsetEncoder;
        final ByteBuffer bbout;
        final CharBuffer ccin;
        int ccinPos;

        public OutputStreamWriterFlushed(Charset charset) {
            this.enc = charset;
            this.charsetEncoder = charset.newEncoder();
            this.bbout = ByteBuffer.wrap(XOutputWriter8Bit.this.obuf, 0, XOutputWriter8Bit.this.obuf.length);
            this.ccin = CharBuffer.allocate(4);
            XOutputWriter8Bit.this.writerNeedsFlushing = false;
            this.ccinPos = 0;
        }

        public void reset(Charset charset) {
            if (this.enc != charset) {
                this.enc = charset;
                this.charsetEncoder = charset.newEncoder();
            }
            this.bbout.position(0);
            this.ccinPos = 0;
            XOutputWriter8Bit.this.writerNeedsFlushing = false;
        }

        public void write(char[] cArray, int n2, int n3) throws IOException {
            if (LoggerUtil.isFinerLoggable(gLogger2)) {
                XOutputWriter.logChars(gLogger2, Level.FINER, cArray, n2, n2 + n3, "write(char[], int, int)");
            }
            XOutputWriter8Bit.this.ensureBufForChars(n3);
            CharBuffer charBuffer = CharBuffer.wrap(cArray, n2, n3);
            this.bbout.position(XOutputWriter8Bit.this.count);
            CoderResult coderResult = this.charsetEncoder.encode(charBuffer, this.bbout, true);
            XOutputWriter8Bit.this.count = this.bbout.position();
        }

        public void write(int n2) throws IOException {
            XOutputWriter8Bit.this.ensureBufForChars(1);
            this.ccin.position(this.ccinPos);
            this.ccin.limit(this.ccinPos + 1);
            this.ccin.put((char)n2).position(0);
            this.bbout.position(XOutputWriter8Bit.this.count);
            CoderResult coderResult = this.charsetEncoder.encode(this.ccin, this.bbout, true);
            if (coderResult != CoderResult.UNDERFLOW) {
                boolean bl = coderResult.isMalformed();
                if (bl && Encodings.isHighUTF16Surrogate((char)n2) && this.ccinPos == 0) {
                    ++this.ccinPos;
                    XOutputWriter8Bit.this.writerNeedsFlushing = true;
                    return;
                }
                boolean bl2 = coderResult.isError();
                boolean bl3 = Encodings.isLowUTF16Surrogate((char)n2);
                boolean bl4 = Encodings.isHighUTF16Surrogate((char)n2);
                if (bl3 || bl4 || this.ccinPos > 1) {
                    String string2 = Messages.createMessage2("ER_SER_INVALID_UTF16_SURROGATE3", new String[]{Integer.toString(n2, 16)});
                    Messages.xciDynamicErrorException(string2);
                } else {
                    assert (bl2);
                    String string3 = Messages.createMessage2("ER_SER_INVALID_CHARACTER_IN_TEXT", new String[]{Integer.toString(n2, 16)});
                    Messages.xciDynamicErrorException(string3);
                }
            } else if (this.ccinPos > 0) {
                XOutputWriter8Bit.this.writerNeedsFlushing = false;
                this.ccinPos = 0;
            }
            XOutputWriter8Bit.this.count = this.bbout.position();
        }

        public void write(String string2, int n2, int n3) throws IOException {
            XOutputWriter8Bit.this.ensureBufForChars(n3);
            CharBuffer charBuffer = CharBuffer.wrap(string2, n2, n3);
            this.bbout.position(XOutputWriter8Bit.this.count);
            CoderResult coderResult = this.charsetEncoder.encode(charBuffer, this.bbout, true);
            XOutputWriter8Bit.this.count = this.bbout.position();
        }

        public void close() throws IOException {
            if (XOutputWriter8Bit.this.writerNeedsFlushing) {
                this.bbout.position(XOutputWriter8Bit.this.count);
                this.charsetEncoder.flush(this.bbout);
            }
            XOutputWriter8Bit.this.writerNeedsFlushing = false;
        }

        public void flush() throws IOException {
            if (XOutputWriter8Bit.this.writerNeedsFlushing) {
                this.bbout.position(XOutputWriter8Bit.this.count);
                this.charsetEncoder.flush(this.bbout);
            }
            XOutputWriter8Bit.this.writerNeedsFlushing = false;
        }
    }
}

