/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.serializer;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.CData;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.CursorFactory;
import com.ibm.xml.xci.NodeTest;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.base.AbstractCursor;
import com.ibm.xml.xci.dp.util.XCIErrorHelper;
import com.ibm.xml.xci.dp.values.chars.CharBufferChars;
import com.ibm.xml.xci.dp.values.chars.Chars;
import com.ibm.xml.xci.dp.values.chars.EncodeContext;
import com.ibm.xml.xci.dp.values.chars.StringChars;
import com.ibm.xml.xci.dp.values.chars.WhitespaceCharsConstant;
import com.ibm.xml.xci.serializer.AddContentInterface;
import com.ibm.xml.xci.serializer.AdditionalAPIs;
import com.ibm.xml.xci.serializer.CodepointMappings;
import com.ibm.xml.xci.serializer.CursorExtended;
import com.ibm.xml.xci.serializer.EncodingInfo;
import com.ibm.xml.xci.serializer.Encodings;
import com.ibm.xml.xci.serializer.HtmlElemInfo;
import com.ibm.xml.xci.serializer.Messages;
import com.ibm.xml.xci.serializer.NamespaceMappings;
import com.ibm.xml.xci.serializer.SerializeParam;
import com.ibm.xml.xci.serializer.SerializeParamValue;
import com.ibm.xml.xci.serializer.UnicodeNormalizer;
import com.ibm.xml.xci.serializer.UnicodeNormalizerFactory;
import com.ibm.xml.xci.serializer.XOutputElemContext;
import com.ibm.xml.xci.serializer.XOutputMethod;
import com.ibm.xml.xci.serializer.XOutputWriter;
import com.ibm.xml.xci.type.TypeRegistry;
import com.ibm.xml.xml4j.api.s1.xs.ItemPSVI;
import com.ibm.xml.xml4j.api.s1.xs.XSSimpleTypeDefinition;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import com.ibm.xml.xml4j.internal.s1.util.XMLChar;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XSerializer
extends AbstractCursor
implements AddContentInterface,
AdditionalAPIs,
CursorExtended {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2011. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger gLogger = LoggerUtil.getLogger(XSerializer.class);
    public static final boolean DISABLE_WRITE_ENCODED = false;
    private static final String EMPTY_STRING = "";
    public static final Cursor.Profile FEATURES_LIMIT = Cursor.Profile.MINIMAL_STREAMING_MUTATION;
    static final Integer s_i2 = 2;
    private static final boolean s_supportYesNo = true;
    public static final String s_xhtmlURI = "http://www.w3.org/1999/xhtml";
    private static final String XMLVERSION10 = "1.0";
    private static final String XMLVERSION11 = "1.1";
    private static final int[] fgMultiByteLength = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 3, 3, 4, 0};
    private static final int[] fgFirstByteValueMask = new int[]{0, 0, 31, 15, 7};
    private boolean avoidEmptyTags;
    private boolean bomMarker;
    private EncodeContext ecATTRIBUTE_DOUBLE_QUOTE;
    private EncodeContext ecATTRIBUTE_SINGLE_QUOTE;
    private EncodeContext ecCDATASECTION;
    private EncodeContext ecCOMMENT;
    private EncodeContext ecNAME;
    private EncodeContext ecNAMESPACE;
    private EncodeContext ecNOTHING;
    private EncodeContext ecPCDATA;
    private EncodeContext ecPCDATA_ROUNDTRIP;
    private EncodeContext ecPI;
    private EncodeContext ecTextContext;
    private boolean expectingFirstChild = false;
    private int indentCount;
    private Chars indentNewLine;
    private Chars indentSequence;
    private boolean indentationState = true;
    private int indentationNoElemDepth = -1;
    boolean previousNonWhitespaceExists;
    private boolean releaseJustCalled1;
    private boolean stripWhitespace;
    List<Cursor.Area> textNodeArea = new ArrayList<Cursor.Area>();
    List<Chars> textNodes = new ArrayList<Chars>();
    private boolean indent;
    private ArrayList<QName> cdataElements = null;
    private boolean toEndCDATASection = false;
    private CodepointMappings codePointMappings;
    private String doctypePublic;
    private String doctypeSystem;
    private XOutputElemContext xoutputElemContext;
    private XOutputMethod outputContext;
    private EncodingInfo encodingInfo = new EncodingInfo(null, null, true);
    private char indentChar = (char)32;
    private char[] indentLineSep = WhitespaceCharsConstant.s_systemLineSep;
    private boolean inlineOnlyIfNoElemContent = false;
    private boolean isFirstRoot;
    private boolean isInlineElem = false;
    private boolean isXML11 = false;
    private boolean needTowriteDOCTYPE;
    private int normalizerMode = 1;
    private boolean openMutationCalled = false;
    private final Map<String, Object> outputProps;
    private final boolean percentEscapeURIAttrs;
    private boolean scriptOrStyle = false;
    private int scriptOrStyleDepth = -1;
    private String standalone;
    private UnicodeNormalizer unicodeNormalizer = null;
    private String version = null;
    private boolean wasJustReset;
    private XOutputWriter xout;
    private OutputStreamHolder outputStreamHolder;
    private boolean toUndeclarePrefixes = false;
    private WriterHolder writerHolder;
    private static final String NS_XOP = "http://www.w3.org/2004/08/xop/include";
    private static final String NAME_INCLUDE = "Include";
    private final boolean mtomEnabled;
    private static final HtmlElemInfo.ElemDesc INLINED_ELEMENT = new HtmlElemInfo.ElemDesc(512);

    private static boolean isAllWhitespace(byte[] byArray, int n2, int n3) {
        assert (n2 >= 0);
        int n4 = n2 + n3;
        assert (n4 <= byArray.length);
        while (n2 < n4) {
            int n5;
            if ((n5 = byArray[n2++]) >= 0) {
                if (XMLChar.isSpace(n5)) continue;
                return false;
            }
            int n6 = fgMultiByteLength[(n5 &= 0xFF) >> 3];
            if (n2 + n6 > n4) {
                return false;
            }
            int n7 = n5 & fgFirstByteValueMask[n6];
            switch (n6) {
                case 2: {
                    n7 = (n7 << 6) + (0x3F & byArray[n2++]);
                    break;
                }
                case 3: {
                    n7 = (n7 << 12) + ((0x3F & byArray[n2++]) << 6) + (0x3F & byArray[n2++]);
                    break;
                }
                default: {
                    n7 = (n7 << 18) + ((0x3F & byArray[n2++]) << 12) + ((0x3F & byArray[n2++]) << 6) + (0x3F & byArray[n2++]);
                }
            }
            if (XMLChar.isSpace(n7)) continue;
            return false;
        }
        return true;
    }

    private static boolean isAllWhitespace(char[] cArray, int n2, int n3) {
        int n4 = cArray.length;
        for (int i = 0; i < n4; ++i) {
            if (XMLChar.isSpace(cArray[i])) continue;
            return false;
        }
        return true;
    }

    static boolean isAllWhitespace(Chars chars) {
        return chars.isSpace();
    }

    private static final boolean isQNameType(VolatileCData volatileCData) {
        XSSimpleTypeDefinition xSSimpleTypeDefinition = volatileCData.getXSTypeDefinition();
        return xSSimpleTypeDefinition != null && xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSQNAME, (short)0);
    }

    XSerializer(CursorFactory cursorFactory, OutputStream outputStream, XOutputMethod xOutputMethod, Map<String, Object> map2) {
        this(cursorFactory, xOutputMethod, map2);
        this.outputStreamHolder = new OutputStreamHolder(outputStream);
        this.writerHolder = null;
        this.xout = null;
    }

    XSerializer(CursorFactory cursorFactory, Writer writer, XOutputMethod xOutputMethod, Map<String, Object> map2) {
        this(cursorFactory, xOutputMethod, map2);
        this.writerHolder = new WriterHolder(writer);
        this.outputStreamHolder = null;
        this.xout = null;
    }

    private XSerializer(CursorFactory cursorFactory, XOutputMethod xOutputMethod, Map<String, Object> map2) {
        super(cursorFactory);
        if (LoggerUtil.isFinestLoggable(gLogger)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Output method: ");
            stringBuilder.append(xOutputMethod == null ? "null" : xOutputMethod.name);
            stringBuilder.append(" - Parameters: {");
            if (map2 != null) {
                for (String string2 : map2.keySet()) {
                    stringBuilder.append('(');
                    stringBuilder.append(string2);
                    stringBuilder.append(',');
                    stringBuilder.append(map2.get(string2));
                    stringBuilder.append(')');
                }
            }
            stringBuilder.append("}");
            gLogger.logp(Level.FINEST, gLogger.getName(), "XSerializer2(...)", stringBuilder.toString());
        }
        this.xoutputElemContext = new XOutputElemContext();
        this.outputProps = map2;
        this.outputContext = xOutputMethod;
        this.percentEscapeURIAttrs = this.shouldEscape(map2);
        this.processSerializationParams(map2, xOutputMethod);
        this.mtomEnabled = map2 != null && map2.containsKey("http://www.ibm.com/xml/xci/attachment-marshaller");
    }

    @Override
    public final void addAttribute(VolatileCData volatileCData, Chars chars) {
        if (LoggerUtil.isFinerLoggable(gLogger)) {
            XSerializer.logNameValue(gLogger, Level.FINER, volatileCData, chars, "addAttribute(VolatileCData, Chars)");
        }
        try {
            boolean bl;
            if (!this.xoutputElemContext.getState().mayAddElemAttr() && !this.xoutputElemContext.getState().mayAddNamespaceNode()) {
                String string2 = Messages.createMessage2("ER_SER_ATTR_NAMESPACE", null);
                Messages.xciDynamicErrorException(string2);
            }
            this.xoutputElemContext.setState(XOutputElemContext.State.IN_ATTRIBUTES);
            this.xout.writeSpace();
            volatileCData.write(this.xout, this.outputContext.NAME, false);
            int n2 = this.outputContext.isHTMLNature ? this.xoutputElemContext.getElementDesc().getAttrFlags(volatileCData) : 0;
            boolean bl2 = bl = this.outputContext == XOutputMethod.HTML;
            if (bl && (n2 & 4) != 0 && volatileCData.getQNameLocalPart(1).equals(((Object)chars).toString())) {
                return;
            }
            this.xout.writeEqualsQuote();
            if ((n2 & 2) != 0 && this.percentEscapeURIAttrs) {
                this.xout.writeHTMLAttrURI(chars, this.ecATTRIBUTE_DOUBLE_QUOTE);
                this.xout.writeQuote();
                return;
            }
            if (bl) {
                this.xout.startHTMLAttrState();
            }
            if (this.normalizerMode == 1) {
                chars.write(this.xout, this.ecATTRIBUTE_DOUBLE_QUOTE, true);
            } else {
                this.normalizeValue(chars, this.ecATTRIBUTE_DOUBLE_QUOTE, true);
            }
            if (bl) {
                this.xout.endHTMLAttrState();
            }
            this.xout.writeQuote();
            if (this.indent && this.outputContext == XOutputMethod.XML && this.indentationState) {
                this.checkForXMLSpaceAttribute(volatileCData, chars);
            }
        }
        catch (IOException iOException) {
            Messages.xciDynamicErrorException(iOException);
        }
    }

    @Override
    public final void addAttribute(VolatileCData volatileCData, VolatileCData volatileCData2) {
        this.addAttribute(volatileCData, (Chars)volatileCData2);
    }

    @Override
    public void addComment(Cursor.Area area, Chars chars) {
        if (LoggerUtil.isFinestLoggable(gLogger)) {
            XSerializer.logValue(gLogger, Level.FINEST, chars, "addComment(" + area + ")");
        }
        try {
            if (this.toEndCDATASection) {
                this.writeEndCDataSectionText();
            }
            if (this.indent) {
                if (this.expectingFirstChild) {
                    if (area == Cursor.Area.FIRST_CHILD) {
                        this.expectingFirstChild = false;
                    } else {
                        this.indentationState = true;
                    }
                }
                area = this.maybeDumpWhitespace(area);
                this.isInlineElem = false;
            }
            this.ensureContentState(area);
            this.checkPICommentValue(chars, this.ecCOMMENT.map, false);
            XOutputWriter xOutputWriter = this.xout;
            xOutputWriter.writeCommentStart();
            chars.write(xOutputWriter, this.ecCOMMENT, false);
            xOutputWriter.writeCommentEnd();
            this.setReleaseJustCalled(false);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    @Override
    public void addComment(Cursor.Area area, VolatileCData volatileCData) {
        this.addComment(area, (Chars)volatileCData);
    }

    @Override
    public final void addContent(Cursor.Area area, byte[] byArray, int n2, int n3) {
        try {
            if (this.indent) {
                if (this.startTagIsOpen() && XSerializer.isAllWhitespace(byArray, n2, n3)) {
                    CData cData = this.getStringValue(byArray, n2, n3);
                    this.addWhitespace(area, cData);
                    this.setReleaseJustCalled(false);
                    this.setNoPreviousNonWhite();
                    return;
                }
                this.dumpWhitespace(EncodeContext.NOTHING);
            }
            this.ensureContentState(area);
            this.writeBytes(byArray, n2, n3);
            this.setReleaseJustCalled(false);
            if (this.indent) {
                this.setHasPreviousNonWhite();
            }
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    @Override
    public void addContent(Cursor.Area area, char[] cArray, int n2, int n3) {
        try {
            if (this.indent) {
                if (this.startTagIsOpen() && XSerializer.isAllWhitespace(cArray, n2, n3)) {
                    CData cData = this.getStringValue(cArray, n2, n3);
                    this.addWhitespace(area, cData);
                    this.setReleaseJustCalled(false);
                    this.setNoPreviousNonWhite();
                    return;
                }
                this.dumpWhitespace(EncodeContext.NOTHING);
            }
            this.ensureContentState(area);
            this.writeChars(cArray, n2, n3);
            this.setReleaseJustCalled(false);
            if (this.indent) {
                this.setHasPreviousNonWhite();
            }
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    @Override
    public boolean isOptimizedForDirectWrites(String string2) {
        return this.xout.isOptimizedForDirectWrites(string2);
    }

    @Override
    public void addElement(Cursor.Area object2, VolatileCData volatileCData, XSTypeDefinition xSTypeDefinition) {
        if (LoggerUtil.isFinerLoggable(gLogger)) {
            XSerializer.logName(gLogger, Level.FINER, volatileCData, "addElement(" + object2 + ")");
        }
        try {
            Object object3;
            Object object4;
            HtmlElemInfo.ElemDesc elemDesc;
            if (this.needTowriteDOCTYPE) {
                this.writeoutDOCTYPE(volatileCData);
                this.needTowriteDOCTYPE = false;
            } else if (this.toEndCDATASection) {
                this.writeEndCDataSectionText();
            }
            String string2 = volatileCData.getQNamePrefix(1);
            if (string2 == null) {
                string2 = EMPTY_STRING;
            }
            String string3 = volatileCData.getQNameLocalPart(1);
            assert (string3.indexOf(58) < 0);
            if (this.indent && this.mtomEnabled && NAME_INCLUDE.equals(string3) && NS_XOP.equals(volatileCData.getQNameNamespaceURI(1))) {
                elemDesc = INLINED_ELEMENT;
            } else {
                HtmlElemInfo.ElemDesc elemDesc2 = elemDesc = this.outputContext.elementFlags != null ? this.outputContext.elementFlags.get2(volatileCData.getQNameNamespaceURI(1), string3, this.outputContext) : HtmlElemInfo.s_elemNotFound;
            }
            if (this.indent) {
                if (this.expectingFirstChild) {
                    if (object2 == Cursor.Area.FIRST_CHILD) {
                        this.expectingFirstChild = false;
                    } else {
                        this.indentationState = true;
                    }
                }
                if (this.indentationState) {
                    if (elemDesc.is(512) || object2 != Cursor.Area.FIRST_CHILD && this.isInlineElem) {
                        if (this.whitespaceToBeDumped()) {
                            this.dumpWhitespace(this.ecPCDATA);
                        }
                    } else {
                        object4 = this.whereIsWhitespace();
                        if (object4 != null) {
                            this.clearWhitespace();
                        }
                        if (this.startTagIsOpen() || this.releaseJustCalled1 || object4 != null) {
                            if (!this.stripWhitespace) {
                                object3 = object4;
                                if (object3 == null) {
                                    object3 = object2;
                                }
                                int n2 = this.getElemDepth();
                                if (this.startTagIsOpen()) {
                                    if (object4 != Cursor.Area.FIRST_CHILD && object2 != Cursor.Area.FIRST_CHILD) {
                                        --n2;
                                    }
                                } else if (!this.releaseJustCalled1 && object4 != Cursor.Area.FOLLOWING_SIBLING) {
                                    --n2;
                                }
                                this.insertIndentation((Cursor.Area)object3, n2);
                                object2 = Cursor.Area.FOLLOWING_SIBLING;
                            } else if (object2 == Cursor.Area.FOLLOWING_SIBLING && object4 != null) {
                                object2 = object4;
                            }
                        }
                    }
                }
                this.isInlineElem = false;
                if (this.inlineOnlyIfNoElemContent) {
                    if (object2 == Cursor.Area.FIRST_CHILD || !this.xoutputElemContext.getState().mayAddElemAttr()) {
                        this.xoutputElemContext.setIsInline(false);
                    }
                    this.inlineOnlyIfNoElemContent = false;
                }
            }
            this.ensureContentState((Cursor.Area)object2);
            if (this.xoutputElemContext.getElemDepth() == 0) {
                if (this.isFirstRoot) {
                    if (this.standaloneApplicable() || this.getDoctypeSystem() != null) {
                        if (LoggerUtil.isFinestLoggable(gLogger)) {
                            XSerializer.logElementError(gLogger, Level.FINEST, volatileCData, this.xout.toString(), "addElement(" + object2 + ")");
                        }
                        object4 = Messages.createMessage2("ER_SER_ROOT_MULTIPLE_ELEMENT_TEXT_CHILDREN", null);
                        Messages.xciDynamicErrorException((String)object4);
                    }
                } else {
                    this.isFirstRoot = true;
                }
            }
            object4 = this.xoutputElemContext.pushFreshNoInit();
            this.xoutputElemContext = object4;
            ((XOutputElemContext)object4).setState(XOutputElemContext.State.IN_START_TAG);
            ((XOutputElemContext)object4).setIsInline(false);
            ((XOutputElemContext)object4).setElementDesc(elemDesc);
            ((XOutputElemContext)object4).setName(volatileCData.constant(false));
            if (this.cdataElements != null) {
                object3 = volatileCData.getQNameNamespaceURI(1);
                ((XOutputElemContext)object4).setIsCdataSection(this.isCDataSectionElement((String)object3, string3));
            } else {
                ((XOutputElemContext)object4).setIsCdataSection(false);
            }
            this.xout.writeStartTagOpen();
            volatileCData.write(this.xout, EncodeContext.NAME, false);
            if (this.outputContext == XOutputMethod.HTML && elemDesc != HtmlElemInfo.s_elemNotFound && elemDesc.is(0x3000000)) {
                this.scriptOrStyle = true;
                this.scriptOrStyleDepth = ((XOutputElemContext)object4).getElemDepth();
                this.ecTextContext = EncodeContext.NOTHING;
            }
            this.isInlineElem = elemDesc.is(512);
            ((XOutputElemContext)object4).setIsInline(this.isInlineElem);
            if (this.indent && this.outputContext.isHTMLNature) {
                this.inlineOnlyIfNoElemContent = elemDesc.is(0x4000000);
                if (this.indentationState) {
                    this.checkForNoIndentationElement();
                }
            }
            this.setReleaseJustCalled(false);
        }
        catch (IOException iOException) {
            Messages.xciDynamicErrorException(iOException);
        }
    }

    @Override
    public boolean toAttributes(NodeTest nodeTest) {
        return false;
    }

    @Override
    public void setItemPSVI(ItemPSVI itemPSVI) {
    }

    @Override
    public final void addNamespaceNode(Chars chars, Chars chars2, boolean bl) {
        Object object2;
        if (LoggerUtil.isFinerLoggable(gLogger)) {
            XSerializer.logNamespace(gLogger, Level.FINER, chars, chars2, "addNamespaceNode");
        }
        if (!this.xoutputElemContext.getState().mayAddElemAttr()) {
            object2 = Messages.createMessage2("ER_SER_ATTR_NAMESPACE", null);
            Messages.xciDynamicErrorException((String)object2);
        }
        object2 = this.xout;
        try {
            if (chars == null || chars.isEmpty()) {
                ((XOutputWriter)object2).writeSpaceXMLNS();
            } else {
                if (!(chars2 != null && !chars2.isEmpty() || this.isXML11() && this.toUndeclarePrefixes)) {
                    return;
                }
                ((XOutputWriter)object2).writeSpaceXMLNSColon();
                chars.write((XOutputWriter)object2, this.ecNAME, false);
            }
            ((XOutputWriter)object2).writeEqualsQuote();
            chars2.write(this.xout, this.ecNAMESPACE, true);
            ((XOutputWriter)object2).writeQuote();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    public final void addNamespaceNode(VolatileCData volatileCData, VolatileCData volatileCData2, boolean bl) {
        this.addNamespaceNode((Chars)volatileCData, (Chars)volatileCData2, bl);
    }

    @Override
    public final void addProcessingInstruction(Cursor.Area area, VolatileCData volatileCData, Chars chars) {
        try {
            if (LoggerUtil.isFinestLoggable(gLogger)) {
                XSerializer.logNameValue(gLogger, Level.FINEST, volatileCData, chars, "addProcessingInstruction(" + area + ")");
            }
            if (this.toEndCDATASection) {
                this.writeEndCDataSectionText();
            }
            if (this.indent) {
                if (this.expectingFirstChild) {
                    if (area == Cursor.Area.FIRST_CHILD) {
                        this.expectingFirstChild = false;
                    } else {
                        this.indentationState = true;
                    }
                }
                area = this.maybeDumpWhitespace(area);
                this.isInlineElem = false;
            }
            this.ensureContentState(area);
            if (this.shouldIndent()) {
                this.indent();
            }
            this.checkPICommentValue(chars, this.ecPI.map, true);
            XOutputWriter xOutputWriter = this.xout;
            xOutputWriter.writePIOpen();
            volatileCData.write(this.xout, EncodeContext.PI, true);
            xOutputWriter.writeSpace();
            chars.write(xOutputWriter, this.ecPI, false);
            xOutputWriter.writePIClose(this.ecPI);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
        this.setReleaseJustCalled(false);
        if (this.indent) {
            this.setNoPreviousNonWhite();
        }
    }

    @Override
    public void addProcessingInstruction(Cursor.Area area, VolatileCData volatileCData, VolatileCData volatileCData2) {
        this.addProcessingInstruction(area, volatileCData, (Chars)volatileCData2);
    }

    @Override
    public void addText(Cursor.Area area, Chars chars) {
        if (LoggerUtil.isFinestLoggable(gLogger)) {
            XSerializer.logValue(gLogger, Level.FINEST, chars, "addText(" + area + ")");
        }
        try {
            XOutputElemContext xOutputElemContext;
            XOutputElemContext.State state;
            if (this.indent) {
                if (this.expectingFirstChild) {
                    if (area == Cursor.Area.FIRST_CHILD) {
                        this.expectingFirstChild = false;
                    } else {
                        this.indentationState = true;
                    }
                }
                boolean bl = this.isInlineElem;
                this.isInlineElem = false;
                if (this.indentationState && (area == Cursor.Area.FIRST_CHILD || !bl)) {
                    if (this.startTagIsOpen()) {
                        if (XSerializer.isAllWhitespace(chars)) {
                            this.addWhitespace(area, chars);
                            this.setReleaseJustCalled(false);
                            return;
                        }
                    } else {
                        state = this.xoutputElemContext.getState();
                        if (state == XOutputElemContext.State.IN_CONTENT && XSerializer.isAllWhitespace(chars)) {
                            this.addWhitespace(area, chars);
                            this.setReleaseJustCalled(false);
                            return;
                        }
                    }
                }
                this.dumpWhitespace(this.ecPCDATA_ROUNDTRIP);
            }
            if (!this.isFirstRoot && (this.standaloneApplicable() || this.getDoctypeSystem() != null)) {
                if (LoggerUtil.isFinestLoggable(gLogger)) {
                    XSerializer.logTextError(gLogger, Level.FINEST, ((Object)chars).toString(), this.xout.toString(), "addText(" + area + ")");
                }
                String string2 = Messages.createMessage2("ER_SER_ROOT_MULTIPLE_ELEMENT_TEXT_CHILDREN", null);
                Messages.xciDynamicErrorException(string2);
            }
            if ((state = (xOutputElemContext = this.xoutputElemContext).getState()).mayAddElemAttr()) {
                if (area == Cursor.Area.FOLLOWING_SIBLING) {
                    if (this.avoidEmptyTags) {
                        VolatileCData volatileCData = this.xoutputElemContext.getName();
                        this.writeBracketClosingTag(volatileCData);
                    } else if (this.outputContext == XOutputMethod.XML) {
                        this.xout.writeEmptyElementClose();
                    } else {
                        this.writeSlashBracket();
                    }
                    xOutputElemContext = this.xoutputElemContext = this.xoutputElemContext.pop();
                } else {
                    this.xout.writeEndTagClose();
                }
            }
            xOutputElemContext.setState(XOutputElemContext.State.IN_TEXT_CONTENT);
            if (xOutputElemContext.isCDataSection()) {
                this.writeValueCData(chars, EncodeContext.CDATASECTION);
            } else if (this.normalizerMode == 1) {
                chars.write(this.xout, this.ecTextContext, true);
            } else {
                this.normalizeValue(chars, this.ecTextContext, false);
            }
            this.setReleaseJustCalled(false);
            if (this.indent) {
                this.setHasPreviousNonWhite();
            }
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    private void writeValueCData(Chars chars, EncodeContext encodeContext) {
        try {
            String string2 = ((Object)chars).toString();
            this.writeValueCData2(string2, encodeContext);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void writeValueCData2(String string2, EncodeContext encodeContext) throws IOException {
        int n2;
        if (this.normalizerMode != 1 && !this.unicodeNormalizer.alreadyNormalized(string2, this.normalizerMode)) {
            string2 = this.unicodeNormalizer.normalizeUnicode(string2, this.normalizerMode);
        }
        int n3 = string2.length();
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            char c = string2.charAt(n2);
            if (c <= '\u007f') {
                if (c != ']' || n2 + 2 >= n3 || string2.charAt(n2 + 1) != ']' || string2.charAt(n2 + 2) != '>') continue;
                this.writeCDataSectionText(string2, n4, n2 += 2, encodeContext);
                n4 = n2;
                continue;
            }
            if (this.encodingInfo.isCharInEncoding(c)) continue;
            if (n4 < n2) {
                this.writeCDataSectionText(string2, n4, n2, encodeContext);
            }
            this.xout.writeCharacterAsInt(c);
            n4 = n2 + 1;
        }
        if (n4 < n2) {
            this.writeCDataSectionText2(string2, n4, n2, encodeContext);
        }
    }

    private void writeCDataSectionText(String string2, int n2, int n3, EncodeContext encodeContext) throws IOException {
        if (this.toEndCDATASection) {
            this.toEndCDATASection = false;
        } else {
            this.xout.writeCDataSectionStart();
        }
        this.xout.write(string2, n2, n3, encodeContext);
        this.xout.writeCDataSectionEnd();
    }

    private void writeCDataSectionText2(String string2, int n2, int n3, EncodeContext encodeContext) throws IOException {
        if (!this.toEndCDATASection) {
            this.xout.writeCDataSectionStart();
        }
        this.xout.write(string2, n2, n3, encodeContext);
        this.toEndCDATASection = true;
    }

    private void writeEndCDataSectionText() throws IOException {
        this.xout.writeCDataSectionEnd();
        this.toEndCDATASection = false;
    }

    @Override
    public void addText(Cursor.Area area, VolatileCData volatileCData) {
        this.addText(area, (Chars)volatileCData);
    }

    private void addWhitespace(Cursor.Area area, Chars chars) {
        chars = chars.constant(false);
        this.textNodes.add(chars);
        this.textNodeArea.add(area);
    }

    @Override
    public boolean canBeSpecialized() {
        return true;
    }

    private void checkForNoIndentationElement() {
        if (this.xoutputElemContext.getElementDesc().is(0x8000000)) {
            this.indentationState = false;
            this.expectingFirstChild = true;
            this.indentationNoElemDepth = this.getElemDepth();
        }
    }

    private void checkForXMLSpaceAttribute(VolatileCData volatileCData, Chars chars) {
        if (volatileCData.getQNamePrefix(1).equals("xml") && volatileCData.getQNameLocalPart(1).equals("space") && ((Object)chars).toString().equals("preserve")) {
            this.indentationState = false;
            this.expectingFirstChild = true;
            this.indentationNoElemDepth = this.getElemDepth();
        }
    }

    private void checkSupportedVersion(String string2) {
        switch (this.outputContext) {
            case XML: 
            case XHTML: {
                if (string2.equals(XMLVERSION10) || string2.equals(XMLVERSION11)) break;
                String string3 = Messages.createMessage2("ER_SER_BAD_XML_VERSION", new String[]{string2});
                Messages.xciDynamicErrorException(string3);
                break;
            }
            case HTML: {
                if (string2.equals("4.01") || string2.equals("4.0")) break;
                String string4 = Messages.createMessage2("ER_SER_BAD_HTML_VERSION", new String[]{string2});
                Messages.xciDynamicErrorException(string4);
                break;
            }
        }
    }

    private void clearWhitespace() {
        this.textNodes.clear();
        this.textNodeArea.clear();
    }

    @Override
    public final void closeMutation() {
        if (LoggerUtil.isFinestLoggable(gLogger)) {
            gLogger.logp(Level.FINEST, gLogger.getName(), "closeMutation", "called");
        }
        this.openMutationCalled = false;
        try {
            this.xout.flushBuffers();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        this.setReleaseJustCalled(false);
        if (this.indent) {
            this.indentationState = true;
        }
        XOutputWriter.returnWriter(this.xout);
    }

    private boolean decrementForkReleaseCounter() {
        return true;
    }

    private final boolean doIndent() {
        return this.indent;
    }

    private void dumpWhitespace(EncodeContext encodeContext) throws IOException {
        int n2 = this.textNodes.size();
        for (int i = 0; i < n2; ++i) {
            Chars chars = this.textNodes.get(i);
            Cursor.Area area = this.textNodeArea.get(i);
            this.ensureContentState(area);
            this.xoutputElemContext.setState(XOutputElemContext.State.IN_TEXT_CONTENT);
            chars.write(this.xout, encodeContext, true);
        }
        this.clearWhitespace();
    }

    private boolean whitespaceToBeDumped() {
        return this.textNodes.size() > 0;
    }

    public void ensureContentState(Cursor.Area area) throws IOException {
        if (this.xoutputElemContext.getState().mayAddElemAttr()) {
            if (area == Cursor.Area.FOLLOWING_SIBLING) {
                if (this.toEndCDATASection) {
                    this.writeEndCDataSectionText();
                }
                this.finishTag();
                this.xoutputElemContext = this.xoutputElemContext.pop();
            } else {
                this.xout.writeEndTagClose();
            }
            this.xoutputElemContext.setState(XOutputElemContext.State.IN_CONTENT);
        }
    }

    private ArrayList<QName> extractToQNameArray(Object object2) {
        return (ArrayList)object2;
    }

    private List<String> extractToStringList(Object object2) {
        return (List)object2;
    }

    private final void finishTag() throws IOException {
        if (this.avoidEmptyTags) {
            VolatileCData volatileCData = this.xoutputElemContext.getName();
            this.writeBracketClosingTag(volatileCData);
        } else {
            this.writeSlashBracket();
        }
    }

    @Override
    public void flushContent() {
        try {
            this.xout.flushBuffers();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    public final Cursor fork(boolean bl, Cursor.Profile profile, Cursor.Profile profile2) {
        if (LoggerUtil.isFinestLoggable(gLogger)) {
            gLogger.logp(Level.FINEST, gLogger.getName(), "fork", "called");
        }
        this.setReleaseJustCalled(false);
        return this;
    }

    @Override
    public Cursor.Profile futureProfile() {
        return FEATURES_LIMIT;
    }

    private final String get_doctypePublic() {
        return this.doctypePublic;
    }

    @Override
    public AdditionalAPIs getCursorExtensions() {
        return this;
    }

    private final String getDoctypePublic() {
        return this.get_doctypePublic();
    }

    private final String getDoctypeSystem() {
        return this.doctypeSystem;
    }

    @Override
    public int getElemDepth() {
        int n2 = this.xoutputElemContext.getElemDepth();
        return n2;
    }

    private final HtmlElemInfo.ElemDesc getElemDesc(String string2) {
        Object object2;
        if (this.outputContext.elementFlags != null && null != (object2 = this.outputContext.elementFlags.get(string2))) {
            return (HtmlElemInfo.ElemDesc)object2;
        }
        return HtmlElemInfo.s_elemNotFound;
    }

    private final String getEncoding() {
        return (String)this.getOutputProperty("encoding");
    }

    private final Boolean getOmitXMLDeclaration() {
        Object object2 = this.getOutputPropertyNonDefault("omit-xml-declaration");
        if (Boolean.TRUE.equals(object2) || "yes".equals(object2)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private final Object getOutputProperty(Object object2) {
        Object object3 = this.getOutputPropertyNonDefault(object2);
        if (object3 == null) {
            object3 = this.getOutputPropertyDefault(object2);
        }
        return object3;
    }

    private final Object getOutputPropertyDefault(Object object2) {
        return this.getProp(object2, true);
    }

    private final Object getOutputPropertyNonDefault(Object object2) {
        return this.getProp(object2, false);
    }

    private XOutputElemContext.State getInternalParentSerializationState() {
        XOutputElemContext xOutputElemContext = this.xoutputElemContext.pop();
        if (xOutputElemContext != null) {
            XOutputElemContext.State state = xOutputElemContext.getState();
            return state;
        }
        return XOutputElemContext.State.NOTHING;
    }

    @Override
    public int getParentSerializationState() {
        return this.getInternalParentSerializationState().getExternalOrdinal();
    }

    @Override
    public int getSerializationState() {
        return this.xoutputElemContext.getState().getExternalOrdinal();
    }

    private final Object getProp(Object object2, boolean bl) {
        Object object3 = null;
        String string2 = null;
        if (object2 instanceof String) {
            string2 = (String)object2;
        } else if (object2 instanceof SerializeParam) {
            string2 = ((SerializeParam)object2).toString();
        } else {
            return null;
        }
        if (bl) {
            if (string2.equals("version".toString())) {
                object3 = this.outputContext.defaultVersion;
                return object3;
            }
            if (string2.equals("encoding".toString())) {
                object3 = Chars.UTF8.name();
                return object3;
            }
            if (string2.equals("indent".toString())) {
                object3 = this.outputContext.defaultIndent;
                return object3;
            }
            if (string2.equals("method".toString())) {
                object3 = this.outputContext.name;
                return object3;
            }
            if (string2.equals("media-type".toString())) {
                object3 = this.outputContext.defaultMediaType;
                return object3;
            }
            if (string2.equals("omit-xml-declaration".toString())) {
                object3 = Boolean.FALSE;
                return object3;
            }
            if (string2.equals("standalone".toString())) {
                object3 = Boolean.FALSE;
                return object3;
            }
            if (string2.equals(SerializeParam.INDENT_AMOUNT.toString())) {
                object3 = s_i2;
                return object3;
            }
        } else if (this.outputProps == null) {
            object3 = null;
        } else {
            object3 = this.outputProps.get(object2);
            if (object3 == null && object2 instanceof SerializeParam) {
                object3 = this.outputProps.get(object2.toString());
            }
        }
        return object3;
    }

    private final String getStandalone() {
        return this.standalone;
    }

    private final CData getStringValue(byte[] byArray, int n2, int n3) {
        String string2 = new String(byArray, n2, n3);
        CData cData = this.factory().data((CharSequence)string2, null, false);
        return cData;
    }

    private final CData getStringValue(char[] cArray, int n2, int n3) {
        String string2 = new String(cArray, n2, n3);
        CData cData = this.factory().data((CharSequence)string2, null, false);
        return cData;
    }

    private final String getVersion() {
        return this.version;
    }

    private final String getXMLVersion() {
        String string2 = this.getVersion();
        string2 = string2 == null || string2.equals(XMLVERSION10) ? XMLVERSION10 : (string2.equals(XMLVERSION11) ? XMLVERSION11 : XMLVERSION10);
        return string2;
    }

    public final XOutputWriter getXOutputWriter() {
        return this.xout;
    }

    private XOutputWriter getXOutputWriter2String(StringWriter stringWriter) {
        XOutputWriter xOutputWriter = XOutputWriter.make(this.encodingInfo, this.isXML11, this.indentLineSep, this.indentChar, this.codePointMappings, stringWriter);
        return xOutputWriter;
    }

    private void indent() throws IOException {
        if (this.outputContext.isHTMLNature) {
            int n2 = this.getElemDepth() - 1;
            Integer n3 = (Integer)this.getOutputProperty(SerializeParam.INDENT_AMOUNT);
            Character c = (Character)this.getOutputProperty(SerializeParam.INDENT_CHARACTER);
            this.xout.write(c.charValue(), n2 *= n3.intValue(), EncodeContext.PCDATA);
        }
    }

    private final void initXOutputWriter(boolean bl) {
        if (this.writerHolder != null) {
            this.xout = XOutputWriter.make(this.encodingInfo, this.isXML11, this.indentLineSep, this.indentChar, this.codePointMappings, this.writerHolder.getWriter());
            this.writerHolder = null;
        } else {
            this.xout = XOutputWriter.make(this.encodingInfo, this.isXML11, this.indentLineSep, this.indentChar, this.codePointMappings, this.outputStreamHolder.getOutputStream(), this.bomMarker);
            this.outputStreamHolder = null;
        }
    }

    @Override
    public final void addNewLine(Cursor.Area area) {
        try {
            this.ensureContentState(area);
            this.xoutputElemContext.setState(XOutputElemContext.State.IN_TEXT_CONTENT);
            this.indentNewLine.write(this.xout, this.ecNOTHING, false);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    private void insertIndentation(Cursor.Area area, int n2) throws IOException {
        this.clearWhitespace();
        this.addNewLine(area);
        if (this.indentSequence == null) {
            int n3;
            for (n3 = this.indentCount * n2; n3 > 20; n3 -= 20) {
                WhitespaceCharsConstant.whitespaceConstants[20].write(this.xout, this.ecNOTHING, false);
            }
            WhitespaceCharsConstant.whitespaceConstants[n3].write(this.xout, this.ecNOTHING, false);
        } else {
            for (int i = 0; i < n2; ++i) {
                this.indentSequence.write(this.xout, this.ecPCDATA, false);
            }
        }
    }

    private boolean isAnHTMLElemName(HtmlElemInfo.ElemDesc elemDesc) {
        return elemDesc != HtmlElemInfo.s_elemNotFound;
    }

    private boolean isCDataSectionElement(String string2, String string3) {
        if (this.outputContext == XOutputMethod.HTML && (string2 == null || string2.length() == 0)) {
            return false;
        }
        int n2 = this.cdataElements.size();
        for (int i = 0; i < n2; ++i) {
            QName qName = this.cdataElements.get(i);
            if (!qName.getLocalPart().equals(string3) || !qName.getNamespaceURI().equals(string2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isCurrentElemInline(VolatileCData volatileCData) {
        if (this.outputContext.isHTMLNature) {
            String string2 = volatileCData.getQNameLocalPart(1);
            HtmlElemInfo.ElemDesc elemDesc = this.getElemDesc(string2);
            if (this.isAnHTMLElemName(elemDesc) && !string2.equalsIgnoreCase("ins") && !string2.equalsIgnoreCase("del")) {
                return elemDesc.is(512);
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean isPreviousElemInline() {
        return this.isInlineElem;
    }

    private final boolean isValidStandalone(String string2) {
        return string2.equals("no") || string2.equals("omit") || string2.equals("yes");
    }

    @Override
    public final boolean isXML11() {
        return this.isXML11;
    }

    @Override
    public final VolatileCData itemValue() {
        this.unimplemented("itemValue");
        return null;
    }

    private Cursor.Area maybeDumpWhitespace(Cursor.Area area) throws IOException {
        if (1 <= this.textNodes.size()) {
            if (this.stripWhitespace) {
                area = this.textNodeArea.get(0);
                this.clearWhitespace();
            } else {
                this.dumpWhitespace(this.ecPCDATA);
            }
        }
        return area;
    }

    private final void normalizeValue(Chars chars, EncodeContext encodeContext, boolean bl) throws IOException {
        String string2 = ((Object)chars).toString();
        if (!this.unicodeNormalizer.alreadyNormalized(string2, this.normalizerMode)) {
            string2 = this.unicodeNormalizer.normalizeUnicode(string2, this.normalizerMode);
            this.xout.write(string2, encodeContext);
        } else {
            chars.write(this.xout, encodeContext, true);
        }
    }

    private final boolean notAnHTMLElemName(HtmlElemInfo.ElemDesc elemDesc) {
        if (this.outputContext.isHTMLNature) {
            return elemDesc == HtmlElemInfo.s_elemNotFound;
        }
        return false;
    }

    @Override
    public final boolean openMutation(Cursor.Area area) {
        if (LoggerUtil.isFinestLoggable(gLogger)) {
            gLogger.logp(Level.FINEST, gLogger.getName(), "openMutation", "called");
        }
        if (this.openMutationCalled) {
            return false;
        }
        this.setReleaseJustCalled(false);
        this.indentationState = true;
        this.openMutationCalled = true;
        this.xoutputElemContext.setState(XOutputElemContext.State.START_DOCUMENT);
        try {
            this.startDocumentInternal();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    private boolean previousNonWhiteExists() {
        return this.previousNonWhitespaceExists;
    }

    @Override
    public boolean outputParamNeedsFixing(String string2, Object object2) {
        return !string2.equals("indent");
    }

    private void processSerializationParams(Map<String, Object> map2, XOutputMethod xOutputMethod) {
        if (map2 != null) {
            List<String> list;
            int n2;
            Object object2;
            if (map2.get("method") != null) {
                object2 = map2.get("method");
                this.outputContext = XOutputMethod.get(object2);
                if (this.outputContext == XOutputMethod.HTML) {
                    this.indent = true;
                } else if (this.outputContext == XOutputMethod.XHTML) {
                    this.indent = true;
                }
            }
            if (map2.get("indent") != null) {
                this.indent = (Boolean)map2.get("indent");
                boolean bl = this.stripWhitespace = !this.indent;
            }
            if ((object2 = map2.get(SerializeParam.INDENT_AMOUNT)) != null) {
                if (object2 instanceof Integer) {
                    int n3 = (Integer)object2;
                    if (n3 < 0) {
                        String string2 = Messages.createMessage2("ER_SER_PARAM_BAD", new String[]{SerializeParam.INDENT_AMOUNT, object2.toString()});
                        Messages.xciDynamicErrorException(string2);
                    } else {
                        this.indentCount = n3;
                    }
                } else {
                    String string3 = Messages.createMessage2("ER_SER_PARAM_BAD", new String[]{SerializeParam.INDENT_AMOUNT, object2.toString()});
                    Messages.xciDynamicErrorException(string3);
                }
            } else {
                this.indentCount = 2;
            }
            object2 = map2.get(SerializeParam.INDENT_LINE_SEPARATOR);
            this.indentNewLine = object2 instanceof String ? new StringChars((String)object2) : WhitespaceCharsConstant.newLineChar;
            object2 = map2.get(SerializeParam.INDENT_CHARACTER);
            if (object2 instanceof Character && !((Character)object2).equals(Character.valueOf(' '))) {
                char[] cArray = new char[this.indentCount];
                for (int i = 0; i < this.indentCount; ++i) {
                    Array.setChar(cArray, i, ((Character)object2).charValue());
                }
                this.indentSequence = CharBufferChars.make(cArray);
            } else {
                this.indentSequence = null;
            }
            Object object3 = map2.get("cdata-section-elements");
            if (object3 instanceof ArrayList) {
                this.cdataElements = this.extractToQNameArray(object3);
            }
            object3 = map2.get("undeclare-prefixes");
            this.toUndeclarePrefixes = Boolean.TRUE.equals(object3);
            object3 = map2.get("use-character-maps");
            if (object3 instanceof List && (n2 = (list = this.extractToStringList(object3)).size()) > 0) {
                this.codePointMappings = new CodepointMappings(list);
                for (int i = 0; i < n2; i += 2) {
                    this.codePointMappings.setString(list.get(i).charAt(0), list.get(i + 1));
                }
            }
        } else {
            this.indentNewLine = WhitespaceCharsConstant.newLineChar;
            this.indentSequence = null;
            this.indentCount = 2;
        }
    }

    @Override
    public final Cursor.Profile profile() {
        Cursor.Profile profile = super.profile();
        return profile;
    }

    @Override
    public Cursor.Profile profileLimit() {
        return this.futureProfile();
    }

    @Override
    public final void release() {
        if (LoggerUtil.isFinestLoggable(gLogger)) {
            gLogger.logp(Level.FINEST, gLogger.getName(), "release", "called");
        }
        try {
            Object object2;
            if (this.toEndCDATASection) {
                this.writeEndCDataSectionText();
            }
            if (this.indent) {
                object2 = this.whereIsWhitespace();
                if (object2 != null) {
                    if (object2 == Cursor.Area.FIRST_CHILD || this.isInlineElem) {
                        this.dumpWhitespace(this.ecPCDATA);
                    } else {
                        this.clearWhitespace();
                    }
                }
                if (this.indentationState && !this.isInlineElem) {
                    XOutputElemContext.State state = this.xoutputElemContext.getState();
                    switch (state) {
                        case IN_CONTENT: {
                            int n2;
                            if (this.stripWhitespace || object2 == null && this.previousNonWhiteExists() || (n2 = this.getElemDepth()) <= 0) break;
                            this.insertIndentation(Cursor.Area.FOLLOWING_SIBLING, n2 - 1);
                            break;
                        }
                        case IN_START_TAG: 
                        case IN_NAMESPACES: 
                        case IN_ATTRIBUTES: {
                            if (this.stripWhitespace) break;
                            int n3 = this.getElemDepth() - 2;
                            if (n3 < 0) {
                                n3 = 0;
                            }
                            this.insertIndentation(Cursor.Area.FOLLOWING_SIBLING, n3);
                            break;
                        }
                    }
                }
            }
            if (this.xoutputElemContext.getState().mayAddElemAttr()) {
                this.finishTag();
                this.xoutputElemContext = this.xoutputElemContext.pop();
            }
            if (this.xoutputElemContext.getElemDepth() == 0) {
                object2 = this.xoutputElemContext.getState();
                switch (1.$SwitchMap$com$ibm$xml$xci$serializer$XOutputElemContext$State[((Enum)object2).ordinal()]) {
                    case 5: {
                        break;
                    }
                    case 6: {
                        break;
                    }
                    default: {
                        this.xoutputElemContext.setState(XOutputElemContext.State.END_DOCUMENT);
                        break;
                    }
                }
            } else {
                this.writeClosingTag();
                this.xoutputElemContext = this.xoutputElemContext.pop();
                this.xoutputElemContext.setState(XOutputElemContext.State.IN_CONTENT);
            }
            if (this.indent && !this.indentationState && this.getElemDepth() < this.indentationNoElemDepth) {
                this.indentationState = true;
                this.expectingFirstChild = false;
            }
            this.setReleaseJustCalled(true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        assert (this.decrementForkReleaseCounter());
    }

    @Override
    public boolean requiresRelease() {
        return true;
    }

    @Override
    public void resetInlineElem(boolean bl) {
        this.isInlineElem = false;
        if (this.outputContext.isHTMLNature && this.inlineOnlyIfNoElemContent) {
            if (!bl) {
                this.xoutputElemContext.setIsInline(false);
            }
            this.inlineOnlyIfNoElemContent = false;
        }
    }

    private final void set_doctypePublic(String string2) {
        this.doctypePublic = string2;
    }

    private final void setDefaultProperties() {
        EncodingInfo encodingInfo;
        this.version = this.outputContext.defaultVersion;
        this.isXML11 = false;
        this.encodingInfo = encodingInfo = Encodings.getEncodingInfo("UTF-8");
        this.setIndent(this.outputContext.defaultIndent);
        this.setStandalone("omit");
        this.wasJustReset = true;
        this.normalizerMode = 1;
        this.isFirstRoot = false;
        this.doctypeSystem = null;
        this.doctypePublic = null;
    }

    private final void setDoctypeSystem(String string2) {
        this.doctypeSystem = string2;
    }

    private void setHasPreviousNonWhite() {
        this.previousNonWhitespaceExists = true;
    }

    private final void setIndent(Boolean bl) {
        this.indent = bl;
    }

    private final void setIndentChars(Character c) {
        this.indentChar = c.charValue();
    }

    @Override
    public void setItemValue(VolatileCData volatileCData) {
        try {
            this.ensureContentState(Cursor.Area.FIRST_CHILD);
            this.writeValue(volatileCData, this.ecTextContext, false);
            this.writeClosingTag();
            this.xoutputElemContext = this.xoutputElemContext.pop();
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    private void setNoPreviousNonWhite() {
        this.previousNonWhitespaceExists = false;
    }

    private void setReleaseJustCalled(boolean bl) {
        this.releaseJustCalled1 = bl;
        if (bl && this.indent) {
            this.setNoPreviousNonWhite();
        }
    }

    private final void setStandalone(String string2) {
        this.standalone = string2;
    }

    private boolean shouldEscape(Map<String, Object> map2) {
        if (this.outputContext.isHTMLNature) {
            Object object2;
            return map2 == null || !((object2 = map2.get("escape-uri-attributes")) instanceof Boolean) || !Boolean.FALSE.equals(object2);
        }
        return false;
    }

    private final boolean shouldIndent() {
        return false;
    }

    private final boolean standaloneApplicable() {
        return !this.standalone.equals("omit");
    }

    private final void startDocumentInternal() throws IOException {
        Object object2;
        this.setDefaultProperties();
        this.wasJustReset = false;
        String string2 = Encodings.getMimeEncoding(this.getEncoding());
        EncodingInfo encodingInfo = Encodings.getEncodingInfo(string2);
        if (encodingInfo != null) {
            this.encodingInfo = encodingInfo;
        } else {
            object2 = Messages.createMessage2("ER_SER_ENCODING_NOT_SUPPORTED", new String[]{string2});
            Messages.xciDynamicErrorException((String)object2);
        }
        object2 = this.outputContext.encodeContextVariant;
        if (encodingInfo.isAsciiType()) {
            if (object2 == EncodeContext.Variant.XML) {
                object2 = EncodeContext.Variant.ASCII;
            } else if (object2 == EncodeContext.Variant.HTML) {
                object2 = EncodeContext.Variant.HTML_ASCII;
            }
        }
        this.ecNAME = EncodeContext.NAME.getVariant((EncodeContext.Variant)((Object)object2));
        this.ecPCDATA = EncodeContext.PCDATA.getVariant((EncodeContext.Variant)((Object)object2));
        this.ecPCDATA_ROUNDTRIP = EncodeContext.PCDATA_ROUNDTRIP.getVariant((EncodeContext.Variant)((Object)object2));
        this.ecATTRIBUTE_SINGLE_QUOTE = EncodeContext.ATTRIBUTE_SINGLE_QUOTE.getVariant((EncodeContext.Variant)((Object)object2));
        this.ecATTRIBUTE_DOUBLE_QUOTE = EncodeContext.ATTRIBUTE_DOUBLE_QUOTE.getVariant((EncodeContext.Variant)((Object)object2));
        this.ecPI = EncodeContext.PI.getVariant((EncodeContext.Variant)((Object)object2));
        this.ecCOMMENT = EncodeContext.COMMENT.getVariant((EncodeContext.Variant)((Object)object2));
        this.ecNAMESPACE = EncodeContext.NAMESPACE.getVariant((EncodeContext.Variant)((Object)object2));
        this.ecCDATASECTION = EncodeContext.CDATASECTION.getVariant((EncodeContext.Variant)((Object)object2));
        this.ecNOTHING = EncodeContext.NOTHING.getVariant((EncodeContext.Variant)((Object)object2));
        this.ecTextContext = this.ecPCDATA_ROUNDTRIP;
        if (this.outputProps != null) {
            this.startDocumentInternal0(string2);
        }
        if (this.xout == null) {
            this.initXOutputWriter(false);
            assert (this.validateStreamsAndWriters());
            if (this.bomMarker && !string2.startsWith("UTF-16")) {
                this.xout.writeBOM();
            }
        }
        this.needTowriteDOCTYPE = true;
        String string3 = this.getXMLVersion();
        if (!this.getOmitXMLDeclaration().booleanValue()) {
            String string4 = this.standaloneApplicable() ? " standalone=\"" + this.getStandalone() + "\"" : EMPTY_STRING;
            this.writeOutHeader(string3, string2, string4);
        } else if (this.standaloneApplicable()) {
            String string5 = Messages.createMessage2("ER_SER_NO_XML_DECL_STANDALONE", null);
            Messages.xciDynamicErrorException(string5);
        } else if (this.getDoctypeSystem() != null && !this.version.equals(XMLVERSION10)) {
            String string6 = Messages.createMessage2("ER_SER_DOCTYPE_SYSTEM_NOT_XML1", null);
            Messages.xciDynamicErrorException(string6);
        }
    }

    private final void startDocumentInternal0(String string2) throws IOException {
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        Object object9 = this.getOutputPropertyNonDefault("byte-order-mark");
        this.bomMarker = object9 != null ? Boolean.TRUE.equals(object9) : string2 != null && string2.equalsIgnoreCase("UTF-16");
        Object object10 = this.getOutputPropertyNonDefault("doctype-public");
        if (object10 instanceof String) {
            this.set_doctypePublic((String)object10);
        }
        if ((object8 = this.getOutputPropertyNonDefault("doctype-system")) instanceof String) {
            this.setDoctypeSystem((String)object8);
        }
        if ((object7 = this.getOutputPropertyNonDefault("indent")) instanceof Boolean) {
            this.setIndent((Boolean)object7);
        }
        if ((object6 = this.getOutputPropertyNonDefault(SerializeParam.INDENT_CHARACTER)) instanceof Character) {
            this.setIndentChars((Character)object6);
        }
        if ((object5 = this.getOutputPropertyNonDefault("standalone")) instanceof String) {
            if (this.isValidStandalone((String)object5)) {
                this.setStandalone((String)object5);
            } else {
                object4 = Messages.createMessage2("ER_SER_PARAM_NOT_YES_OR_NO_OR_OMIT", new String[]{(String)object5});
                Messages.xciDynamicErrorException((String)object4);
            }
        }
        if ((object4 = this.getOutputPropertyNonDefault("version")) instanceof String) {
            this.version = (String)object4;
            this.checkSupportedVersion(this.version);
            this.isXML11 = XMLVERSION11.equals(this.version);
        }
        if (Boolean.TRUE.equals(object3 = this.getOutputPropertyNonDefault("omit-xml-declaration"))) {
            if (this.standaloneApplicable()) {
                object2 = Messages.createMessage2("ER_SER_NO_XML_DECL_STANDALONE", null);
                Messages.xciDynamicErrorException((String)object2);
            } else if (this.getDoctypeSystem() != null && !this.version.equals(XMLVERSION10)) {
                object2 = Messages.createMessage2("ER_SER_DOCTYPE_SYSTEM_NOT_XML1", null);
                Messages.xciDynamicErrorException((String)object2);
            }
        }
        if (this.toUndeclarePrefixes && !this.isXML11) {
            object2 = Messages.createMessage2("ER_SER_UNDECLARE_PREFIXES_XML1", null);
            Messages.xciDynamicErrorException((String)object2);
        }
        if ((object2 = this.getOutputPropertyNonDefault("normalization-form")) instanceof QName) {
            QName qName = (QName)object2;
            if (SerializeParamValue.UNICODE_NF_C.equals(qName)) {
                this.normalizerMode = 2;
            } else if (SerializeParamValue.UNICODE_NF_D.equals(qName)) {
                this.normalizerMode = 3;
            } else if (SerializeParamValue.UNICODE_NF_KC.equals(qName)) {
                this.normalizerMode = 4;
            } else if (SerializeParamValue.UNICODE_NF_KD.equals(qName)) {
                this.normalizerMode = 5;
            } else if (!SerializeParamValue.UNICODE_NF_NONE.equals(qName)) {
                String string3 = Messages.createMessage2("ER_SER_NORM_FORM_NOT_SUPPORTED", new String[]{qName.getLocalPart()});
                Messages.xciDynamicErrorException(string3);
            }
            if (this.normalizerMode != 1) {
                this.unicodeNormalizer = UnicodeNormalizerFactory.getUnicodeNormalizer();
            }
        }
    }

    private boolean startTagIsOpen() {
        XOutputElemContext.State state = this.xoutputElemContext.getState();
        boolean bl = state.mayAddElemAttr();
        return bl;
    }

    @Override
    public final boolean toChildren(NodeTest nodeTest) {
        return true;
    }

    @Override
    public final void toEndOfDocument() {
        while (this.xoutputElemContext.getElemDepth() > 0) {
            this.xoutputElemContext = this.xoutputElemContext.pop();
        }
        this.xoutputElemContext.setState(XOutputElemContext.State.END_DOCUMENT);
    }

    public boolean toFollowingSibling() {
        return true;
    }

    @Override
    public final boolean toNext() {
        return true;
    }

    private final void unimplemented(String string2) {
        String string3 = Messages.createMessage2("ER_UNIMPLEMENTED_METHOD", new String[]{string2, this.getClass().getName()});
        Messages.xciDynamicErrorException(string3);
    }

    private boolean validateStreamsAndWriters() {
        boolean bl;
        boolean bl2 = this.xout != null;
        boolean bl3 = bl = this.encodingInfo != null;
        boolean bl4 = this.encodingInfo.getName() != null ? this.encodingInfo.getName() == Charset.forName(this.encodingInfo.getName()).name() : true;
        return bl2 && bl && bl4;
    }

    private Cursor.Area whereIsWhitespace() {
        Cursor.Area area = 1 <= this.textNodes.size() ? this.textNodeArea.get(0) : null;
        return area;
    }

    @Override
    public final void writeAttribute(String string2, String string3) throws IOException {
        if (this.xoutputElemContext.getState().mayAddNamespaceNode()) {
            this.xoutputElemContext.setState(XOutputElemContext.State.IN_ATTRIBUTES);
        }
        XOutputWriter xOutputWriter = this.xout;
        xOutputWriter.writeSpace();
        xOutputWriter.write(string2, EncodeContext.NAME);
        xOutputWriter.writeEqualsQuote();
        xOutputWriter.write(string3, EncodeContext.ATTRIBUTE_DOUBLE_QUOTE);
        xOutputWriter.writeQuote();
    }

    private final void writeBracketClosingTag(VolatileCData volatileCData) throws IOException {
        this.isInlineElem = this.xoutputElemContext.isInline();
        if (this.outputContext.isHTMLNature && this.indent) {
            this.inlineOnlyIfNoElemContent = false;
        }
        this.xout.writeEmptyElementEndEndTagOpen();
        volatileCData.write(this.xout, EncodeContext.NAME, true);
        this.xout.writeEndTagClose();
    }

    private final void writeBytes(byte[] byArray, int n2, int n3) throws IOException {
        this.xout.writeDirectUTF8(byArray, n2, n3);
    }

    private final void writeChars(char[] cArray, int n2, int n3) throws IOException {
        this.xout.write(cArray, n2, n2 + n3, EncodeContext.NOTHING);
    }

    private void writeClosingTag() throws IOException {
        this.isInlineElem = this.xoutputElemContext.isInline();
        if (this.outputContext.isHTMLNature && this.indent) {
            this.inlineOnlyIfNoElemContent = false;
        }
        XOutputWriter xOutputWriter = this.xout;
        if (!this.xoutputElemContext.getState().mayAddNamespaceNode()) {
            xOutputWriter.writeEndTagOpen();
            this.xoutputElemContext.getName().write(xOutputWriter, EncodeContext.NAME, false);
        }
        xOutputWriter.writeEndTagClose();
        if (this.outputContext == XOutputMethod.HTML && this.scriptOrStyle && this.scriptOrStyleDepth == this.xoutputElemContext.getElemDepth()) {
            this.scriptOrStyle = false;
            this.ecTextContext = this.ecPCDATA_ROUNDTRIP;
        }
    }

    private final void writeoutDOCTYPE(CharSequence charSequence) throws IOException {
        if (this.outputContext == XOutputMethod.HTML) {
            XOutputWriter xOutputWriter = this.xout;
            boolean bl = "HTML".equals(charSequence) || "html".equals(charSequence);
            String string2 = this.getDoctypeSystem();
            String string3 = this.getDoctypePublic();
            if (null != string3) {
                xOutputWriter.writeDocTypeOpen();
                if (bl) {
                    xOutputWriter.write(charSequence, EncodeContext.NAME);
                } else {
                    xOutputWriter.write("HTML", EncodeContext.NAME);
                }
                xOutputWriter.writePublicIDOpen();
                xOutputWriter.write(string3, EncodeContext.PCDATA);
                if (null != string2) {
                    xOutputWriter.writeQuoteSpaceQuote();
                    xOutputWriter.write(string2, EncodeContext.PCDATA);
                    xOutputWriter.writeQuoteDocTypeClose();
                } else {
                    xOutputWriter.writeQuoteDocTypeClose();
                }
                xOutputWriter.writeLineBreak();
            } else if (null != string2) {
                xOutputWriter.writeDocTypeOpen();
                if (bl) {
                    xOutputWriter.write(charSequence, EncodeContext.NAME);
                } else {
                    xOutputWriter.write("HTML", EncodeContext.NAME);
                }
                xOutputWriter.writeSystemIDOpen();
                xOutputWriter.write(string2, EncodeContext.PCDATA);
                xOutputWriter.writeQuoteDocTypeClose();
                xOutputWriter.writeLineBreak();
            }
        } else {
            String string4 = this.getDoctypeSystem();
            if (null == string4) {
                return;
            }
            XOutputWriter xOutputWriter = this.xout;
            xOutputWriter.writeDocTypeOpen();
            xOutputWriter.write(charSequence, EncodeContext.NAME);
            String string5 = this.getDoctypePublic();
            if (null != string5) {
                xOutputWriter.writePublicIDOpen();
                xOutputWriter.write(string5, EncodeContext.PCDATA);
                xOutputWriter.writeQuoteSpaceQuote();
            } else {
                xOutputWriter.writeSystemIDOpen();
            }
            xOutputWriter.write(string4, EncodeContext.PCDATA);
            xOutputWriter.writeQuoteDocTypeClose();
            xOutputWriter.writeLineBreak();
        }
    }

    private final void writeOutHeader(String string2, String string3, String string4) throws IOException {
        if (this.outputContext == XOutputMethod.HTML) {
            this.scriptOrStyle = false;
        } else {
            XOutputWriter xOutputWriter = this.xout;
            xOutputWriter.writeXMLVersionOpen();
            xOutputWriter.write(string2, EncodeContext.PCDATA);
            xOutputWriter.writeXMLEncodingOpen();
            xOutputWriter.write(string3, EncodeContext.PCDATA);
            xOutputWriter.writeQuote();
            xOutputWriter.write(string4, EncodeContext.PCDATA);
            xOutputWriter.writeXMLHeaderClose();
            if (this.doIndent() || null != this.getOutputPropertyNonDefault("doctype-system")) {
                this.xout.writeLineBreak();
            }
        }
    }

    private final void writeSlashBracket() throws IOException {
        if (this.outputContext == XOutputMethod.XML) {
            this.isInlineElem = this.xoutputElemContext.isInline();
            this.xout.writeEmptyElementClose();
        } else if (this.outputContext == XOutputMethod.HTML) {
            boolean bl;
            String string2 = this.xoutputElemContext.getName().getQNameNamespaceURI(1);
            boolean bl2 = bl = string2 != null && string2.length() > 0;
            if (this.indent) {
                this.isInlineElem = this.xoutputElemContext.isInline();
                this.inlineOnlyIfNoElemContent = false;
            }
            XOutputWriter xOutputWriter = this.xout;
            if (this.xoutputElemContext.getState().mayAddNamespaceNode()) {
                if (bl) {
                    xOutputWriter.writeEmptyElementClose();
                    return;
                }
                HtmlElemInfo.ElemDesc elemDesc = this.xoutputElemContext.getElementDesc();
                if (this.notAnHTMLElemName(elemDesc)) {
                    xOutputWriter.writeEmptyElementEndEndTagOpen();
                    this.xoutputElemContext.getName().write(xOutputWriter, EncodeContext.HTML_NAME, true);
                    xOutputWriter.writeEndTagClose();
                    return;
                }
                if (elemDesc.is(2)) {
                    xOutputWriter.writeEndTagClose();
                } else {
                    xOutputWriter.writeEmptyElementEndEndTagOpen();
                    this.xoutputElemContext.getName().write(xOutputWriter, EncodeContext.HTML_NAME, true);
                    xOutputWriter.writeEndTagClose();
                }
                return;
            }
            if (bl) {
                xOutputWriter.writeEmptyElementClose();
            } else {
                HtmlElemInfo.ElemDesc elemDesc = this.xoutputElemContext.getElementDesc();
                if (elemDesc.is(2)) {
                    xOutputWriter.writeStartTagClose();
                } else {
                    xOutputWriter.writeEmptyElementEndEndTagOpen();
                    this.xoutputElemContext.getName().write(xOutputWriter, EncodeContext.HTML_NAME, true);
                    xOutputWriter.writeEndTagClose();
                }
            }
            if (this.scriptOrStyle && this.scriptOrStyleDepth == this.xoutputElemContext.getElemDepth()) {
                this.scriptOrStyle = false;
                this.ecTextContext = this.ecPCDATA_ROUNDTRIP;
            }
        } else if (this.outputContext == XOutputMethod.XHTML) {
            String string3 = this.xoutputElemContext.getName().getQNameNamespaceURI(1);
            boolean bl = string3 == null || !s_xhtmlURI.equals(string3);
            String string4 = this.xoutputElemContext.getName().getQNameLocalPart(1);
            if (this.indent) {
                this.isInlineElem = this.xoutputElemContext.isInline();
                this.inlineOnlyIfNoElemContent = false;
            }
            XOutputWriter xOutputWriter = this.xout;
            if (this.xoutputElemContext.getState().mayAddNamespaceNode()) {
                if (bl) {
                    xOutputWriter.writeSpaceEmptyElementClose();
                    return;
                }
                HtmlElemInfo.ElemDesc elemDesc = this.getElemDesc(string4);
                if (this.notAnHTMLElemName(elemDesc)) {
                    xOutputWriter.writeSpaceEmptyElementClose();
                    return;
                }
                if (elemDesc.is(2)) {
                    xOutputWriter.writeSpaceEmptyElementClose();
                } else {
                    xOutputWriter.writeEmptyElementEndEndTagOpen();
                    xOutputWriter.write(string4, EncodeContext.NAME);
                    xOutputWriter.writeEndTagClose();
                }
                return;
            }
            if (bl) {
                xOutputWriter.writeSpaceEmptyElementClose();
            } else {
                HtmlElemInfo.ElemDesc elemDesc = this.getElemDesc(string4);
                if (this.notAnHTMLElemName(elemDesc)) {
                    xOutputWriter.writeSpaceEmptyElementClose();
                    return;
                }
                if (elemDesc.is(2)) {
                    xOutputWriter.writeSpaceEmptyElementClose();
                } else {
                    xOutputWriter.writeEmptyElementEndEndTagOpen();
                    xOutputWriter.write(string4, EncodeContext.NAME);
                    xOutputWriter.writeEndTagClose();
                }
            }
        } else {
            this.xout.writeEmptyElementClose();
        }
    }

    private final void writeValue(Chars chars, EncodeContext encodeContext, boolean bl) throws IOException {
        if (this.normalizerMode == 1) {
            chars.write(this.xout, encodeContext, true);
        } else {
            this.normalizeValue(chars, encodeContext, bl);
        }
    }

    @Override
    public List<NamespaceMappings.MappingRecord> getInScopeNamespaces(int n2) {
        return null;
    }

    @Override
    public String getUnusedPrefix() {
        return null;
    }

    @Override
    public final XOutputMethod getOutputContext() {
        return this.outputContext;
    }

    @Override
    public void setAddInscopeNamespaces() {
    }

    protected final void checkPICommentValue(Chars chars, byte[] byArray, boolean bl) {
        int n2 = chars.needsEscaping(byArray);
        if (n2 != -1) {
            this.xout.checkPICommentValue(chars, n2, chars.length(), byArray, bl, this.outputContext);
        }
    }

    private static final void logName(Logger logger, Level level, VolatileCData volatileCData, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("QName [prefix: '");
        stringBuilder.append(volatileCData.getQNamePrefix(1));
        stringBuilder.append("' - localPart: '");
        stringBuilder.append(volatileCData.getQNameLocalPart(1));
        stringBuilder.append("' - uri: '");
        stringBuilder.append(volatileCData.getQNameNamespaceURI(1));
        stringBuilder.append("']\nStack trace= ");
        stringBuilder.append(XCIErrorHelper.getStackTrace(20));
        logger.logp(level, logger.getName(), string2, stringBuilder.toString());
    }

    private static final void logNameValue(Logger logger, Level level, VolatileCData volatileCData, Chars chars, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("QName [prefix: '");
        stringBuilder.append(volatileCData.getQNamePrefix(1));
        stringBuilder.append("' - localPart: '");
        stringBuilder.append(volatileCData.getQNameLocalPart(1));
        stringBuilder.append("' - uri: '");
        stringBuilder.append(volatileCData.getQNameNamespaceURI(1));
        stringBuilder.append("']\nValue [");
        stringBuilder.append(chars);
        stringBuilder.append("]\nValue as int[] {");
        int n2 = chars.length();
        if (n2 > 0) {
            stringBuilder.append((int)chars.charAt(0));
            for (int i = 1; i < n2; ++i) {
                stringBuilder.append(' ');
                stringBuilder.append((int)chars.charAt(i));
                if (i % 32 != 0) continue;
                stringBuilder.append('\n');
            }
        }
        stringBuilder.append("}\nStack trace= ");
        stringBuilder.append(XCIErrorHelper.getStackTrace(20));
        logger.logp(level, logger.getName(), string2, stringBuilder.toString());
    }

    private static final void logNamespace(Logger logger, Level level, Chars chars, Chars chars2, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("prefix: '");
        stringBuilder.append(chars);
        stringBuilder.append("' - uri: '");
        stringBuilder.append(chars2);
        stringBuilder.append("'\nStack trace= ");
        stringBuilder.append(XCIErrorHelper.getStackTrace(20));
        logger.logp(level, logger.getName(), string2, stringBuilder.toString());
    }

    private static final void logValue(Logger logger, Level level, Chars chars, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Value [");
        stringBuilder.append(chars);
        stringBuilder.append("]\nValue as int[] {");
        int n2 = chars.length();
        if (n2 > 0) {
            stringBuilder.append((int)chars.charAt(0));
            for (int i = 1; i < n2; ++i) {
                stringBuilder.append(' ');
                stringBuilder.append((int)chars.charAt(i));
                if (i % 32 != 0) continue;
                stringBuilder.append('\n');
            }
        }
        stringBuilder.append("}\nStack trace= ");
        stringBuilder.append(XCIErrorHelper.getStackTrace(20));
        logger.logp(level, logger.getName(), string2, stringBuilder.toString());
    }

    private static final void logElementError(Logger logger, Level level, VolatileCData volatileCData, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("content of m_writer {\n");
        stringBuilder.append(string2);
        stringBuilder.append("\n}\nElement [prefix: '");
        stringBuilder.append(volatileCData.getQNamePrefix(1));
        stringBuilder.append("' - localPart: '");
        stringBuilder.append(volatileCData.getQNameLocalPart(1));
        stringBuilder.append("' - uri: '");
        stringBuilder.append(volatileCData.getQNameNamespaceURI(1));
        stringBuilder.append("']");
        logger.logp(level, logger.getName(), string3, stringBuilder.toString());
    }

    private static final void logTextError(Logger logger, Level level, String string2, String string3, String string4) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("content of m_writer {\n");
        stringBuilder.append(string3);
        stringBuilder.append("\n}\ntext content {\n");
        stringBuilder.append(string2);
        stringBuilder.append("\n}");
        logger.logp(level, logger.getName(), string4, stringBuilder.toString());
    }

    private class WriterHolder {
        private final Writer writer;

        private WriterHolder(Writer writer) {
            this.writer = writer;
        }

        public final Writer getWriter() {
            return this.writer;
        }
    }

    private class OutputStreamHolder {
        private final OutputStream os;

        private OutputStreamHolder(OutputStream outputStream) {
            this.os = outputStream;
        }

        public final OutputStream getOutputStream() {
            return this.os;
        }
    }
}

