/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.serializer;

import com.ibm.xml.xci.serializer.CodepointMappings;
import com.ibm.xml.xci.serializer.EncodingInfo;
import com.ibm.xml.xci.serializer.XOutputWriter8Bit;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.nio.charset.Charset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XWriterCache {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2010. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";

    private XWriterCache() {
    }

    public static final XOutputWriter8Bit getXOutputWriter8Bit(Charset charset, EncodingInfo encodingInfo, boolean bl, char[] cArray, char c, CodepointMappings codepointMappings, OutputStream outputStream) {
        XOutputWriter8Bit xOutputWriter8Bit;
        assert (outputStream != null);
        SoftReference<XOutputWriter8Bit> softReference = XWriterCache.getThisThreadSoftReference();
        if (softReference != null && (xOutputWriter8Bit = softReference.get()) != null) {
            if (XWriterCache.writerIsInUse(xOutputWriter8Bit)) {
                xOutputWriter8Bit = new XOutputWriter8Bit(charset, encodingInfo, bl, cArray, c, codepointMappings, outputStream);
                XWriterCache.setThisThreadsWriter(xOutputWriter8Bit);
            } else {
                xOutputWriter8Bit.reset(charset, encodingInfo, bl, cArray, c, codepointMappings, outputStream);
            }
        } else {
            xOutputWriter8Bit = new XOutputWriter8Bit(charset, encodingInfo, bl, cArray, c, codepointMappings, outputStream);
            XWriterCache.setThisThreadsWriter(xOutputWriter8Bit);
        }
        return xOutputWriter8Bit;
    }

    private static final boolean writerIsInUse(XOutputWriter8Bit xOutputWriter8Bit) {
        OutputStream outputStream = xOutputWriter8Bit.getOutputStream();
        boolean bl = outputStream != null;
        return bl;
    }

    public static final void returnXOutputWriter8Bit(XOutputWriter8Bit xOutputWriter8Bit) {
        assert (xOutputWriter8Bit != null);
        xOutputWriter8Bit.setOuputStream(null);
    }

    private static SoftReference<XOutputWriter8Bit> getThisThreadSoftReference() {
        SoftReference<XOutputWriter8Bit> softReference = ThreadLocalHolder.s_singleton.get();
        return softReference;
    }

    private static final void setThisThreadsWriter(XOutputWriter8Bit xOutputWriter8Bit) {
        if (xOutputWriter8Bit != null) {
            SoftReference<XOutputWriter8Bit> softReference = new SoftReference<XOutputWriter8Bit>(xOutputWriter8Bit);
            ThreadLocalHolder.s_singleton.set(softReference);
        }
    }

    private static class ThreadLocalHolder {
        static final ThreadLocal<SoftReference<XOutputWriter8Bit>> s_singleton = new ThreadLocal();

        private ThreadLocalHolder() {
        }
    }
}

