/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.serializer;

import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.values.chars.Chars;
import com.ibm.xml.xci.dp.values.chars.EncodeContext;
import com.ibm.xml.xci.internal.values.QNameSimpleConstant;
import com.ibm.xml.xci.internal.values.StringCData;
import com.ibm.xml.xci.serializer.EncodingInfo;
import com.ibm.xml.xci.serializer.Encodings;
import com.ibm.xml.xci.serializer.SecuritySupport;
import com.ibm.xml.xci.serializer.XOutputWriter;
import com.ibm.xml.xci.type.TypeRegistry;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.Charset;

public class XXOutputWriterTester {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2010. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final char[] s_systemLineSep = SecuritySupport.getSystemProperty("line.separator").toCharArray();
    static char[] indentLineSep = (char[])s_systemLineSep.clone();
    static char indentChar = (char)32;
    static int testN = 0;

    public static void main(String[] stringArray) throws IOException {
        boolean bl;
        int n2;
        int n3;
        char[] cArray;
        ByteArrayInputStream byteArrayInputStream;
        XOutputWriter xOutputWriter;
        Object object2;
        Object object3;
        Object object4;
        byte[] byArray = new byte[10];
        int n4 = 0;
        byArray[n4++] = -17;
        byArray[n4++] = -69;
        byArray[n4++] = -65;
        System.out.println(false);
        System.out.println(EncodeContext.PCDATA.map.length);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(System.out);
        EncodingInfo encodingInfo = Encodings.getEncodingInfo("UTF-8");
        boolean bl2 = true;
        if (bl2) {
            XTestCaseVCD[] xTestCaseVCDArray = new XTestCaseVCD[]{new XTestCaseVCD(new QNameSimpleConstant(null, "lname", null), 0, 0), new XTestCaseVCD(new QNameSimpleConstant("http://example.com", "lname", "pre"), 0, 0), new XTestCaseVCD(new QNameSimpleConstant(null, "lname", null), 2, 2), new XTestCaseVCD(new QNameSimpleConstant("", "lname", ""), 0, 0), new XTestCaseVCD(new QNameSimpleConstant("", "lname", ""), 2, 1), new XTestCaseVCD(new QNameSimpleConstant("http://example.com", "lname", "prefix"), 0, 0), new XTestCaseVCD(new QNameSimpleConstant("http://example.com", "lname", "prefix"), 2, 2), new XTestCaseVCD(new QNameSimpleConstant("http://example.com", "lname", "prefix"), 6, 1), new XTestCaseVCD(new QNameSimpleConstant("http://example.com", "lname", "prefix"), 6, 2), new XTestCaseVCD(new QNameSimpleConstant("http://example.com", "lname", "prefix"), 5, 3), new XTestCaseVCD(new QNameSimpleConstant("http://example.com", "lname", "prefix"), 5, 2)};
            boolean bl3 = false;
            if (bl3) {
                object4 = XOutputWriter.make(encodingInfo, false, indentLineSep, indentChar, null, outputStreamWriter);
                object3 = xTestCaseVCDArray[9];
                int n5 = ((XTestCaseVCD)object3).start;
                int n6 = ((XTestCaseVCD)object3).start + ((XTestCaseVCD)object3).length;
                object2 = ((XTestCaseVCD)object3).data();
                object2.write((XOutputWriter)object4, n5, n6, ((XTestCaseVCD)object3).encodeContext, true);
                ((XOutputWriter)object4).writeLineBreak();
                ((XOutputWriter)object4).flushBuffers();
            }
            object4 = XOutputWriter.make(encodingInfo, false, indentLineSep, indentChar, null, outputStreamWriter);
            XXOutputWriterTester.runTests(xTestCaseVCDArray, (XOutputWriter)object4);
            object4 = XOutputWriter.make(encodingInfo, false, indentLineSep, indentChar, null, System.out, false);
            XXOutputWriterTester.runTests(xTestCaseVCDArray, (XOutputWriter)object4);
            object4 = Encodings.getEncodingInfo("US-ASCII");
            object3 = XOutputWriter.make((EncodingInfo)object4, false, indentLineSep, indentChar, null, System.out, false);
            XXOutputWriterTester.runTests(xTestCaseVCDArray, (XOutputWriter)object3);
            object4 = Encodings.getEncodingInfo("UTF-16BE");
            object3 = new ByteArrayOutputStream();
            xOutputWriter = XOutputWriter.make((EncodingInfo)object4, false, indentLineSep, indentChar, null, (OutputStream)object3, false);
            XXOutputWriterTester.runTests(xTestCaseVCDArray, xOutputWriter);
            byteArrayInputStream = new ByteArrayInputStream(((ByteArrayOutputStream)object3).toByteArray());
            object2 = new InputStreamReader((InputStream)byteArrayInputStream, Charset.forName(((EncodingInfo)object4).getName()));
            cArray = new char[512];
            while ((n3 = ((Reader)object2).read(cArray)) > 0) {
                for (n2 = 0; n2 < n3; ++n2) {
                    System.out.print(cArray[n2]);
                }
            }
            object4 = Encodings.getEncodingInfo("Shift_JIS");
            object3 = XOutputWriter.make((EncodingInfo)object4, false, indentLineSep, indentChar, null, System.out, false);
            XXOutputWriterTester.runTests(xTestCaseVCDArray, (XOutputWriter)object3);
        }
        if (bl = false) {
            XTestCase[] xTestCaseArray = new XTestCase[]{new XTestCase("0123456789", 0, 0), new XTestCase("0123456789", 0, 3), new XTestCase("0123456789", 3, -3), new XTestCase("012<456>89", 0, 0), new XTestCase("><", 0, 0), new XTestCase("&123><678&", 0, 0), new XTestCase("\"123><678\"", 0, 0), new XTestCase("\"123><678\"", 0, 0, EncodeContext.ATTRIBUTE_DOUBLE_QUOTE), new XTestCase("012345678&", 3, 7), new XTestCase("012345678&"), new XTestCase("012345678&", -1), new XTestCase("0123456789", 0, 1), new XTestCase("0123456789", -1, 1)};
            object4 = XOutputWriter.make(encodingInfo, false, indentLineSep, indentChar, null, outputStreamWriter);
            XXOutputWriterTester.runTests(xTestCaseArray, (XOutputWriter)object4);
            object4 = XOutputWriter.make(encodingInfo, false, indentLineSep, indentChar, null, System.out, false);
            XXOutputWriterTester.runTests(xTestCaseArray, (XOutputWriter)object4);
            object4 = Encodings.getEncodingInfo("US-ASCII");
            object3 = XOutputWriter.make((EncodingInfo)object4, false, indentLineSep, indentChar, null, System.out, false);
            XXOutputWriterTester.runTests(xTestCaseArray, (XOutputWriter)object3);
            object4 = Encodings.getEncodingInfo("UTF-16BE");
            object3 = new ByteArrayOutputStream();
            xOutputWriter = XOutputWriter.make((EncodingInfo)object4, false, indentLineSep, indentChar, null, (OutputStream)object3, false);
            XXOutputWriterTester.runTests(xTestCaseArray, xOutputWriter);
            byteArrayInputStream = new ByteArrayInputStream(((ByteArrayOutputStream)object3).toByteArray());
            object2 = new InputStreamReader((InputStream)byteArrayInputStream, Charset.forName(((EncodingInfo)object4).getName()));
            cArray = new char[512];
            while ((n3 = ((Reader)object2).read(cArray)) > 0) {
                for (n2 = 0; n2 < n3; ++n2) {
                    System.out.print(cArray[n2]);
                }
            }
            object4 = Encodings.getEncodingInfo("Shift_JIS");
            object3 = XOutputWriter.make((EncodingInfo)object4, false, indentLineSep, indentChar, null, System.out, false);
            XXOutputWriterTester.runTests(xTestCaseArray, (XOutputWriter)object3);
        }
    }

    private static void runTests(XTestCaseVCD[] xTestCaseVCDArray, XOutputWriter xOutputWriter) throws IOException {
        System.out.println("====== " + testN++ + ") " + xOutputWriter.getClass().getSimpleName() + ", " + xOutputWriter.getCharset().name() + " write no start end =======");
        for (XTestCaseVCD xTestCaseVCD : xTestCaseVCDArray) {
            xTestCaseVCD.data().write(xOutputWriter, xTestCaseVCD.encodeContext, true);
            xOutputWriter.writeLineBreak();
            xOutputWriter.flushBuffers();
        }
        System.out.println("====== " + testN++ + ") " + xOutputWriter.getClass().getSimpleName() + ", " + xOutputWriter.getCharset().name() + " write with start end =======");
        for (XTestCaseVCD xTestCaseVCD : xTestCaseVCDArray) {
            xTestCaseVCD.data().write(xOutputWriter, xTestCaseVCD.start, xTestCaseVCD.start + xTestCaseVCD.length, xTestCaseVCD.encodeContext, true);
            xOutputWriter.writeLineBreak();
            xOutputWriter.flushBuffers();
        }
    }

    private static void runTests(XTestCase[] xTestCaseArray, XOutputWriter xOutputWriter) throws IOException {
        Object object2;
        System.out.println("====== " + testN++ + ") " + xOutputWriter.getClass().getSimpleName() + ", " + xOutputWriter.getCharset().name() + " char[] =======");
        for (XTestCase xTestCase : xTestCaseArray) {
            object2 = ((Object)xTestCase.data).toString().toCharArray();
            xOutputWriter.write((char[])object2, xTestCase.start, xTestCase.start + xTestCase.length, EncodeContext.PCDATA);
            xOutputWriter.writeLineBreak();
            xOutputWriter.flushBuffers();
        }
        System.out.println("====== " + testN++ + ") " + xOutputWriter.getClass().getSimpleName() + ", " + xOutputWriter.getCharset().name() + " String =======");
        for (XTestCase xTestCase : xTestCaseArray) {
            object2 = ((Object)xTestCase.data).toString();
            xOutputWriter.write((String)object2, xTestCase.start, xTestCase.start + xTestCase.length, EncodeContext.PCDATA);
            xOutputWriter.writeLineBreak();
            xOutputWriter.flushBuffers();
        }
        System.out.println("====== " + testN++ + ") " + xOutputWriter.getClass().getSimpleName() + ", " + xOutputWriter.getCharset().name() + " Chars =======");
        for (XTestCase xTestCase : xTestCaseArray) {
            object2 = new StringCData(xTestCase.data, TypeRegistry.XSSTRING);
            xOutputWriter.write((Chars)object2, xTestCase.start, xTestCase.start + xTestCase.length, EncodeContext.PCDATA);
            xOutputWriter.writeLineBreak();
            xOutputWriter.flushBuffers();
        }
        System.out.println("====== " + testN++ + ") " + xOutputWriter.getClass().getSimpleName() + ", " + xOutputWriter.getCharset().name() + " char =======");
        for (XTestCase xTestCase : xTestCaseArray) {
            object2 = ((Object)xTestCase.data).toString().toCharArray();
            int n2 = xTestCase.start + xTestCase.length;
            for (int i = xTestCase.start; i < n2; ++i) {
                xOutputWriter.write(object2[i], EncodeContext.PCDATA);
                xOutputWriter.flushBuffers();
            }
            xOutputWriter.writeLineBreak();
            xOutputWriter.flushBuffers();
        }
    }

    static class XTestCaseVCD
    extends XTestCase {
        protected XTestCaseVCD(VolatileCData volatileCData, int n2, int n3, EncodeContext encodeContext) {
            super(volatileCData, n2, n3, encodeContext);
        }

        protected XTestCaseVCD(VolatileCData volatileCData, int n2, int n3) {
            super(volatileCData, n2, n3);
        }

        protected XTestCaseVCD(VolatileCData volatileCData, int n2) {
            super(volatileCData, n2);
        }

        protected XTestCaseVCD(VolatileCData volatileCData) {
            super(volatileCData);
        }

        VolatileCData data() {
            return (VolatileCData)this.data;
        }
    }

    static class XTestCase {
        CharSequence data;
        int start;
        int length;
        EncodeContext encodeContext;

        public XTestCase(CharSequence charSequence) {
            this.data = charSequence;
            this.start = 0;
            this.length = 0;
            this.encodeContext = EncodeContext.PCDATA;
        }

        public XTestCase(CharSequence charSequence, int n2) {
            this.data = charSequence;
            this.start = n2 < 0 ? charSequence.length() + n2 : n2;
            this.length = 0;
            this.encodeContext = EncodeContext.PCDATA;
        }

        public XTestCase(CharSequence charSequence, int n2, int n3) {
            this.data = charSequence;
            this.start = n2 < 0 ? charSequence.length() + n2 : n2;
            this.length = n3 <= 0 ? charSequence.length() + n3 : n3;
            this.encodeContext = EncodeContext.PCDATA;
        }

        public XTestCase(CharSequence charSequence, int n2, int n3, EncodeContext encodeContext) {
            this.data = charSequence;
            this.start = n2 < 0 ? charSequence.length() + n2 : n2;
            this.length = n3 <= 0 ? charSequence.length() + n3 : n3;
            this.encodeContext = encodeContext;
        }
    }
}

