/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.serializer.fixer;

import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.CursorFactory;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.values.chars.Chars;
import com.ibm.xml.xci.serializer.AddContentInterface;
import com.ibm.xml.xci.serializer.AdditionalAPIs;
import com.ibm.xml.xci.serializer.CursorExtended;
import com.ibm.xml.xci.serializer.ElemContext;
import com.ibm.xml.xci.serializer.NamespaceMappings;
import com.ibm.xml.xci.serializer.fixer.FixerBase;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixerExplicitNSDecl
extends FixerBase
implements CursorExtended,
AddContentInterface {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2008, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private final List<String> m_local_URI_pairs;
    private boolean m_includeEmptyXMLNS;
    boolean m_dumpNamespaceNodes;
    private boolean m_thisElementMatches;
    private HashMap<String, String> m_nsNodes = new HashMap();
    final CursorFactory fCursorFactory;

    public FixerExplicitNSDecl(CursorFactory cursorFactory, Map map2, CursorExtended cursorExtended, List<QName> list, boolean bl) {
        super(cursorExtended);
        this.fCursorFactory = cursorFactory;
        this.m_local_URI_pairs = new ArrayList<String>();
        this.m_includeEmptyXMLNS = bl;
        this.populatePrefix2URIMappings(list);
    }

    private void populatePrefix2URIMappings(List<QName> list) {
        if (list != null) {
            for (QName qName : list) {
                this.populateURI2Prefix(qName);
            }
        }
    }

    private void populateURI2Prefix(QName qName) {
        this.m_local_URI_pairs.add(qName.getLocalPart());
        this.m_local_URI_pairs.add(qName.getNamespaceURI());
    }

    private void processNamespaceNodes() {
        if (this.startTagIsOpen() && this.m_includeEmptyXMLNS) {
            this.addEmptyXMLNS();
        }
    }

    private void addEmptyXMLNS() {
        try {
            this.fCursor.getCursorExtensions().writeAttribute("xmlns", "");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.m_includeEmptyXMLNS = false;
    }

    private void dumpNamespaceNodes() {
        int n2 = this.getCursorExtensions().getElemDepth();
        List<NamespaceMappings.MappingRecord> list = this.getCursorExtensions().getInScopeNamespaces(n2 - 1);
        int n3 = list.size();
        for (int i = 0; i < n3; ++i) {
            NamespaceMappings.MappingRecord mappingRecord = list.get(i);
            String string2 = mappingRecord.get_prefix();
            String string3 = mappingRecord.get_uri();
            String string4 = this.m_nsNodes.get(string2);
            if (string4 != null && !string3.equals(string4)) continue;
            String string5 = string2.length() == 0 ? "xmlns" : "xmlns:" + string2;
            try {
                this.fCursor.getCursorExtensions().writeAttribute(string5, string3);
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.clearNamepacesNodesToGenerate();
    }

    private void clearNamepacesNodesToGenerate() {
        this.m_dumpNamespaceNodes = false;
        this.m_thisElementMatches = false;
        this.m_nsNodes.clear();
    }

    private boolean startTagIsOpen() {
        int n2 = this.getCursorExtensions().getSerializationState();
        boolean bl = ElemContext.mayAddElemAttr(n2);
        return bl;
    }

    @Override
    public void addElement(Cursor.Area area, VolatileCData volatileCData, XSTypeDefinition xSTypeDefinition) {
        if (this.m_dumpNamespaceNodes) {
            this.processNamespaceNodes();
        }
        this.m_dumpNamespaceNodes = this.m_includeEmptyXMLNS;
        if (this.m_local_URI_pairs.size() > 0) {
            this.m_thisElementMatches = this.thisElementMatches(volatileCData);
        }
        this.fCursor.addElement(area, volatileCData, xSTypeDefinition);
        if (this.m_thisElementMatches) {
            this.fCursor.getCursorExtensions().setAddInscopeNamespaces();
        }
    }

    private boolean thisElementMatches(VolatileCData volatileCData) {
        String string2 = volatileCData.getQNameLocalPart(1);
        String string3 = volatileCData.getQNameNamespaceURI(1);
        int n2 = this.m_local_URI_pairs.size();
        for (int i = 0; i < n2; i += 2) {
            if (!string2.equals(this.m_local_URI_pairs.get(i)) || !string3.equals(this.m_local_URI_pairs.get(i + 1))) continue;
            return true;
        }
        return false;
    }

    @Override
    public final void addText(Cursor.Area area, VolatileCData volatileCData) {
        if (this.m_dumpNamespaceNodes) {
            this.processNamespaceNodes();
        }
        this.fCursor.addText(area, volatileCData);
    }

    @Override
    public final void addText(Cursor.Area area, Chars chars) {
        if (this.m_dumpNamespaceNodes) {
            this.processNamespaceNodes();
        }
        this.fCursor.addText(area, chars);
    }

    @Override
    public final void closeMutation() {
        this.fCursor.closeMutation();
    }

    @Override
    public final boolean openMutation(Cursor.Area area) {
        boolean bl = this.fCursor.openMutation(area);
        return bl;
    }

    @Override
    public final void release() {
        int n2 = this.getCursorExtensions().getSerializationState();
        switch (n2) {
            case 4: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                if (!this.m_dumpNamespaceNodes) break;
                this.processNamespaceNodes();
                break;
            }
        }
        this.fCursor.release();
        assert (this.decrementForkReleaseCounter());
    }

    @Override
    public final void addContent(Cursor.Area area, byte[] byArray, int n2, int n3) {
        if (this.m_dumpNamespaceNodes) {
            this.processNamespaceNodes();
        }
        if (this.fCursor instanceof AddContentInterface) {
            this.fCursor.addContent(area, byArray, n2, n3);
        }
    }

    @Override
    public final Cursor fork(boolean bl, Cursor.Profile profile, Cursor.Profile profile2) {
        assert (this.incrementForkReleaseCounter());
        return this;
    }

    @Override
    public final void addNamespaceNode(VolatileCData volatileCData, VolatileCData volatileCData2, boolean bl) {
        if (this.m_dumpNamespaceNodes) {
            this.addNamespaceNodeToMap(volatileCData, volatileCData2);
        }
        this.fCursor.addNamespaceNode(volatileCData, volatileCData2, bl);
    }

    private void addNamespaceNodeToMap(VolatileCData volatileCData, VolatileCData volatileCData2) {
        String string2;
        String string3 = volatileCData == null ? "" : volatileCData.toString();
        String string4 = string2 = volatileCData2 == null ? "" : volatileCData2.toString();
        if (this.m_includeEmptyXMLNS && volatileCData.length() == 0) {
            this.m_includeEmptyXMLNS = false;
            this.m_dumpNamespaceNodes = false;
        }
    }

    @Override
    public final void addAttribute(VolatileCData volatileCData, VolatileCData volatileCData2) {
        if (this.m_dumpNamespaceNodes) {
            this.processNamespaceNodes();
        }
        this.fCursor.addAttribute(volatileCData, volatileCData2);
    }

    @Override
    public final void addAttribute(VolatileCData volatileCData, Chars chars) {
        if (this.m_dumpNamespaceNodes) {
            this.processNamespaceNodes();
        }
        this.fCursor.addAttribute(volatileCData, chars);
    }

    @Override
    public final void addComment(Cursor.Area area, VolatileCData volatileCData) {
        if (this.m_dumpNamespaceNodes) {
            this.processNamespaceNodes();
        }
        this.fCursor.addComment(area, volatileCData);
    }

    @Override
    public final void addComment(Cursor.Area area, Chars chars) {
        if (this.m_dumpNamespaceNodes) {
            this.processNamespaceNodes();
        }
        this.fCursor.addComment(area, chars);
    }

    @Override
    public final void addProcessingInstruction(Cursor.Area area, VolatileCData volatileCData, VolatileCData volatileCData2) {
        if (this.m_dumpNamespaceNodes) {
            this.processNamespaceNodes();
        }
        this.fCursor.addProcessingInstruction(area, volatileCData, volatileCData2);
    }

    @Override
    public final void addProcessingInstruction(Cursor.Area area, VolatileCData volatileCData, Chars chars) {
        if (this.m_dumpNamespaceNodes) {
            this.processNamespaceNodes();
        }
        this.fCursor.addProcessingInstruction(area, volatileCData, chars);
    }

    @Override
    public AdditionalAPIs getCursorExtensions() {
        return this.fCursor.getCursorExtensions();
    }
}

