/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.serializer.fixer;

import com.ibm.xml.xci.CData;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.CursorFactory;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.values.chars.Chars;
import com.ibm.xml.xci.dp.values.chars.EncodeContext;
import com.ibm.xml.xci.internal.values.QNameCData;
import com.ibm.xml.xci.internal.values.StringCData;
import com.ibm.xml.xci.serializer.AddContentInterface;
import com.ibm.xml.xci.serializer.AdditionalAPIs;
import com.ibm.xml.xci.serializer.CursorExtended;
import com.ibm.xml.xci.serializer.XOutputWriter;
import com.ibm.xml.xci.serializer.fixer.FixerBase;
import com.ibm.xml.xci.type.TypeRegistry;
import com.ibm.xml.xml4j.api.s1.xs.XSSimpleTypeDefinition;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.namespace.QName;

public class FixerMeta
extends FixerBase
implements AddContentInterface,
CursorExtended {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2008, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private final boolean fIsForXHTML;
    private boolean fIsInMetaElement = false;
    private boolean fIgnoreMetaAttributes = false;
    private XSTypeDefinition fMetaType = null;
    private ArrayList<Object> fMetaAttributes = null;
    private ArrayList<Object> fMetaNamespaces = null;
    private int fHeadElemDepth = -1;
    private int fMetaElemDepth = -1;
    private static final VolatileCData http_equiv = new StringCDataNoEscaping("http-equiv", TypeRegistry.XSSTRING);
    private static final Chars http_equiv_val = new StringCDataNoEscaping("Content-Type", TypeRegistry.XSSTRING);
    private static final VolatileCData content = new StringCDataNoEscaping("content", TypeRegistry.XSSTRING);
    private final Chars content_val;
    private final CData meta;
    private static final CData metaForHTML = new QNameCData(new QName("", "META"), TypeRegistry.XSQNAME);
    private static final CData metaForXHTML = new QNameCData(new QName("http://www.w3.org/1999/xhtml", "meta"), TypeRegistry.XSQNAME);
    private static final CData defaultContentVal = new StringCDataNoEscaping("text/html; charset=UTF-8", TypeRegistry.XSSTRING);
    boolean fShouldStillAddMETA = true;
    private boolean fHEADJustAdded;

    public FixerMeta(CursorFactory cursorFactory, Map map2, CursorExtended cursorExtended, boolean bl) {
        super(cursorExtended);
        Object v;
        Object object2;
        assert (this.initForkReleaseCounter());
        this.fIsForXHTML = bl;
        String string2 = map2 != null ? ((object2 = map2.get("encoding")) instanceof String ? (String)object2 : "UTF-8") : "UTF-8";
        object2 = map2 != null ? ((v = map2.get("media-type")) instanceof String ? (String)v : "text/html") : "text/html";
        this.content_val = string2.equals("UTF-8") && ((String)object2).equals("text/html") ? defaultContentVal : new StringCDataNoEscaping(object2 + "; charset=" + string2, TypeRegistry.XSSTRING);
        this.meta = bl ? metaForXHTML : metaForHTML;
    }

    private void setHEADJustAdded(boolean bl) {
        this.fHEADJustAdded = bl;
    }

    private boolean HEADJustAdded() {
        return this.fHEADJustAdded;
    }

    public final void closeMutation() {
        this.fCursor.closeMutation();
        this.setHEADJustAdded(false);
        this.clearMETA();
        this.fHeadElemDepth = -1;
        this.fMetaElemDepth = -1;
        this.fIgnoreMetaAttributes = false;
    }

    public final boolean openMutation(Cursor.Area area) {
        this.setHEADJustAdded(false);
        this.clearMETA();
        this.fHeadElemDepth = -1;
        this.fMetaElemDepth = -1;
        this.fIgnoreMetaAttributes = false;
        return this.fCursor.openMutation(area);
    }

    public final Cursor fork(boolean bl, Cursor.Profile profile, Cursor.Profile profile2) {
        assert (this.incrementForkReleaseCounter());
        this.fCursor.fork(bl);
        return this;
    }

    public final void release() {
        if (this.HEADJustAdded()) {
            if (this.fShouldStillAddMETA) {
                this.insertMETA(Cursor.Area.FIRST_CHILD);
            } else if (this.fIsInMetaElement) {
                this.handleMETA();
            }
        }
        this.fCursor.release();
        if (this.HEADJustAdded()) {
            int n2 = this.getCursorExtensions().getElemDepth();
            if (n2 < this.fHeadElemDepth) {
                this.setHEADJustAdded(false);
            } else if (n2 == this.fHeadElemDepth) {
                this.fMetaElemDepth = this.fHeadElemDepth;
            }
        }
        assert (this.decrementForkReleaseCounter());
    }

    public final void addProcessingInstruction(Cursor.Area area, VolatileCData volatileCData, VolatileCData volatileCData2) {
        if (this.HEADJustAdded()) {
            if (this.fShouldStillAddMETA) {
                boolean bl = area == Cursor.Area.FIRST_CHILD;
                area = this.insertMETA(Cursor.Area.FIRST_CHILD);
                if (!bl) {
                    this.fork(true, this.profile(), this.futureProfile());
                    this.release();
                }
            } else if (this.fIsInMetaElement) {
                this.handleMETA();
            }
        }
        this.fCursor.addProcessingInstruction(area, volatileCData, volatileCData2);
        this.setHEADJustAdded(false);
    }

    public final void addProcessingInstruction(Cursor.Area area, VolatileCData volatileCData, Chars chars) {
        if (this.HEADJustAdded()) {
            if (this.fShouldStillAddMETA) {
                boolean bl = area == Cursor.Area.FIRST_CHILD;
                area = this.insertMETA(Cursor.Area.FIRST_CHILD);
                if (!bl) {
                    this.fork(true, this.profile(), this.futureProfile());
                    this.release();
                }
            } else if (this.fIsInMetaElement) {
                this.handleMETA();
            }
        }
        this.fCursor.addProcessingInstruction(area, volatileCData, chars);
        this.setHEADJustAdded(false);
    }

    public final void addComment(Cursor.Area area, VolatileCData volatileCData) {
        if (this.HEADJustAdded()) {
            if (this.fShouldStillAddMETA) {
                boolean bl = area == Cursor.Area.FIRST_CHILD;
                area = this.insertMETA(Cursor.Area.FIRST_CHILD);
                if (!bl) {
                    this.fork(true, this.profile(), this.futureProfile());
                    this.release();
                }
            } else if (this.fIsInMetaElement) {
                this.handleMETA();
            }
        }
        this.fCursor.addComment(area, volatileCData);
        this.setHEADJustAdded(false);
    }

    public final void addComment(Cursor.Area area, Chars chars) {
        if (this.HEADJustAdded()) {
            if (this.fShouldStillAddMETA) {
                boolean bl = area == Cursor.Area.FIRST_CHILD;
                area = this.insertMETA(Cursor.Area.FIRST_CHILD);
                if (!bl) {
                    this.fork(true, this.profile(), this.futureProfile());
                    this.release();
                }
            } else if (this.fIsInMetaElement) {
                this.handleMETA();
            }
        }
        this.fCursor.addComment(area, chars);
        this.setHEADJustAdded(false);
    }

    public final void addText(Cursor.Area area, VolatileCData volatileCData) {
        if (this.HEADJustAdded()) {
            if (this.fShouldStillAddMETA) {
                boolean bl = area == Cursor.Area.FIRST_CHILD;
                area = this.insertMETA(Cursor.Area.FIRST_CHILD);
                if (!bl) {
                    this.fork(true, this.profile(), this.futureProfile());
                    this.release();
                }
            } else if (this.fIsInMetaElement) {
                this.handleMETA();
            }
        }
        this.fCursor.addText(area, volatileCData);
    }

    public final void addText(Cursor.Area area, Chars chars) {
        if (this.HEADJustAdded()) {
            if (this.fShouldStillAddMETA) {
                boolean bl = area == Cursor.Area.FIRST_CHILD;
                area = this.insertMETA(Cursor.Area.FIRST_CHILD);
                if (!bl) {
                    this.fork(true, this.profile(), this.futureProfile());
                    this.release();
                }
            } else if (this.fIsInMetaElement) {
                this.handleMETA();
            }
        }
        this.fCursor.addText(area, chars);
    }

    public final void addAttribute(VolatileCData volatileCData, VolatileCData volatileCData2) {
        if (!this.fIsInMetaElement) {
            this.fCursor.addAttribute(volatileCData, volatileCData2);
        } else if (!this.fIgnoreMetaAttributes) {
            String string2 = volatileCData.getQNameLocalPart(1);
            if (string2.equalsIgnoreCase("http-equiv") && "Content-Type".equalsIgnoreCase(volatileCData2.getString(1).trim())) {
                this.fIgnoreMetaAttributes = true;
                return;
            }
            if (this.fMetaAttributes == null) {
                this.fMetaAttributes = new ArrayList();
            }
            this.fMetaAttributes.add(volatileCData.constant(false));
            this.fMetaAttributes.add(volatileCData2.constant(false));
        }
    }

    public final void addAttribute(VolatileCData volatileCData, Chars chars) {
        if (!this.fIsInMetaElement) {
            this.fCursor.addAttribute(volatileCData, chars);
        } else if (!this.fIgnoreMetaAttributes) {
            String string2 = volatileCData.getQNameLocalPart(1);
            if (string2.equalsIgnoreCase("http-equiv") && "Content-Type".equalsIgnoreCase(((Object)chars).toString().trim())) {
                this.fIgnoreMetaAttributes = true;
                return;
            }
            if (this.fMetaAttributes == null) {
                this.fMetaAttributes = new ArrayList();
            }
            this.fMetaAttributes.add(volatileCData.constant(false));
            this.fMetaAttributes.add(chars.constant(false));
        }
    }

    public final void addNamespaceNode(VolatileCData volatileCData, VolatileCData volatileCData2, boolean bl) {
        if (!this.fIgnoreMetaAttributes) {
            if (!this.fIsInMetaElement) {
                this.fCursor.addNamespaceNode(volatileCData, volatileCData2, bl);
            } else {
                if (this.fMetaNamespaces != null) {
                    this.fMetaAttributes = new ArrayList();
                }
                this.fMetaNamespaces.add(volatileCData.constant(false));
                this.fMetaNamespaces.add(volatileCData2.constant(false));
                this.fMetaNamespaces.add(bl);
            }
        }
    }

    public final void addElement(Cursor.Area area, VolatileCData volatileCData, XSTypeDefinition xSTypeDefinition) {
        String string2 = volatileCData.getQNameLocalPart(1);
        String string3 = volatileCData.getQNameNamespaceURI(1);
        if (this.HEADJustAdded()) {
            boolean bl;
            boolean bl2 = bl = this.fShouldStillAddMETA || area != Cursor.Area.FIRST_CHILD && this.getCursorExtensions().getElemDepth() <= this.fMetaElemDepth;
            if (this.fShouldStillAddMETA) {
                boolean bl3 = area == Cursor.Area.FIRST_CHILD;
                area = this.insertMETA(Cursor.Area.FIRST_CHILD);
                if (!bl3) {
                    bl = false;
                    this.fork(true, this.profile(), this.futureProfile());
                    this.release();
                }
            } else if (this.fIsInMetaElement) {
                this.handleMETA();
            }
            if (bl) {
                this.fIsInMetaElement = this.isElement(string2, string3, "meta");
                if (this.fIsInMetaElement) {
                    this.fMetaType = xSTypeDefinition;
                    return;
                }
            }
        }
        this.fCursor.addElement(area, volatileCData, xSTypeDefinition);
        if (this.fShouldStillAddMETA && this.isElement(string2, string3, "head")) {
            this.fHeadElemDepth = this.getCursorExtensions().getElemDepth();
            this.setHEADJustAdded(true);
            this.setInMetaElement(false);
        }
    }

    private boolean isElement(String string2, String string3, String string4) {
        if (string2.length() != 4) {
            return false;
        }
        return this.isElement2(string2, string3, string4);
    }

    private boolean isElement2(String string2, String string3, String string4) {
        boolean bl = this.fIsForXHTML ? "http://www.w3.org/1999/xhtml".equals(string3) && string2.equals(string4) : string3.length() == 0 && string2.equalsIgnoreCase(string4);
        return bl;
    }

    private boolean isHttpEquiv(String string2, String string3) {
        return this.fIsForXHTML ? "http://www.w3.org/1999/xhtml".equals(string2) && string3.equals("http-equiv") : string2.length() == 0 && string3.equalsIgnoreCase("http-equiv");
    }

    private Cursor.Area insertMETA(Cursor.Area area) {
        this.fCursor.addElement(area, this.meta, null);
        this.fCursor.addAttribute(content, this.content_val);
        this.fCursor.addAttribute(http_equiv, http_equiv_val);
        this.fShouldStillAddMETA = false;
        this.fMetaElemDepth = this.getCursorExtensions().getElemDepth();
        return Cursor.Area.FOLLOWING_SIBLING;
    }

    private void handleMETA() {
        if (!this.fIgnoreMetaAttributes) {
            this.dumpMETA();
        }
        this.clearMETA();
        this.setInMetaElement(false);
        this.fIgnoreMetaAttributes = false;
    }

    private void dumpMETA() {
        int n2;
        int n3;
        this.fCursor.addElement(Cursor.Area.FOLLOWING_SIBLING, this.meta, this.fMetaType);
        if (this.fMetaNamespaces != null) {
            n3 = this.fMetaNamespaces.size();
            for (n2 = 0; n2 < n3; n2 += 3) {
                this.fCursor.addNamespaceNode((VolatileCData)this.fMetaNamespaces.get(n2), (VolatileCData)this.fMetaNamespaces.get(n2 + 1), (boolean)((Boolean)this.fMetaNamespaces.get(n2 + 2)));
            }
        }
        if (this.fMetaAttributes != null) {
            n3 = this.fMetaAttributes.size();
            for (n2 = 0; n2 < n3; n2 += 2) {
                this.fCursor.addAttribute((VolatileCData)this.fMetaAttributes.get(n2), (Chars)this.fMetaAttributes.get(n2 + 1));
            }
        }
    }

    private void clearMETA() {
        this.fMetaType = null;
        if (this.fMetaAttributes != null) {
            this.fMetaAttributes.clear();
        }
        if (this.fMetaNamespaces != null) {
            this.fMetaNamespaces.clear();
        }
    }

    private void setInMetaElement(boolean bl) {
        this.fIsInMetaElement = bl;
    }

    public final void addContent(Cursor.Area area, byte[] byArray, int n2, int n3) {
        if (this.HEADJustAdded()) {
            if (this.fShouldStillAddMETA) {
                boolean bl = area == Cursor.Area.FIRST_CHILD;
                area = this.insertMETA(Cursor.Area.FIRST_CHILD);
                if (!bl) {
                    this.fork(true, this.profile(), this.futureProfile());
                    this.release();
                }
            } else if (this.fIsInMetaElement) {
                this.handleMETA();
            }
        }
        if (this.fCursor instanceof AddContentInterface) {
            this.fCursor.addContent(area, byArray, n2, n3);
        }
    }

    public AdditionalAPIs getCursorExtensions() {
        return this.fCursor.getCursorExtensions();
    }

    private static class StringCDataNoEscaping
    extends StringCData {
        byte[] bytes;

        public StringCDataNoEscaping(CharSequence charSequence, XSSimpleTypeDefinition xSSimpleTypeDefinition) {
            super(charSequence, xSSimpleTypeDefinition);
            try {
                this.bytes = ((Object)charSequence).toString().getBytes(Chars.UTF8_String);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException);
            }
        }

        public StringCDataNoEscaping(String string2, XSSimpleTypeDefinition xSSimpleTypeDefinition) {
            super(string2, xSSimpleTypeDefinition);
            try {
                this.bytes = string2.toString().getBytes(Chars.UTF8_String);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException);
            }
        }

        public int needsEscaping(byte[] byArray) {
            return -1;
        }

        public int needsEscaping(int n2, int n3, byte[] byArray) {
            return -1;
        }

        public boolean isEmpty() {
            return false;
        }

        public boolean isSpace() {
            return false;
        }

        public void write(XOutputWriter xOutputWriter, EncodeContext encodeContext, boolean bl) throws IOException {
            xOutputWriter.writeDirectUTF8(this.bytes, 0, this.bytes.length);
        }

        public void write(XOutputWriter xOutputWriter, int n2, int n3, EncodeContext encodeContext, boolean bl) throws IOException {
            xOutputWriter.writeDirectUTF8(this.bytes, n2, n3);
        }
    }
}

