/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.serializer.fixer;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.CData;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.CursorFactory;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.util.XCIErrorHelper;
import com.ibm.xml.xci.dp.values.chars.Chars;
import com.ibm.xml.xci.internal.values.StringCDataMutable;
import com.ibm.xml.xci.serializer.AddContentInterface;
import com.ibm.xml.xci.serializer.AdditionalAPIs;
import com.ibm.xml.xci.serializer.CursorExtended;
import com.ibm.xml.xci.serializer.HtmlElemInfo;
import com.ibm.xml.xci.serializer.Messages;
import com.ibm.xml.xci.serializer.NamespaceMappings;
import com.ibm.xml.xci.serializer.SerializerCursorFactory;
import com.ibm.xml.xci.serializer.XOutputElemContext;
import com.ibm.xml.xci.serializer.XOutputMethod;
import com.ibm.xml.xci.serializer.XOutputNamespaceContext;
import com.ibm.xml.xci.serializer.fixer.FixerBase;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixerNamespaces
extends FixerBase
implements CursorExtended,
AddContentInterface,
AdditionalAPIs {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2008, 2010. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger gLogger = LoggerUtil.getLogger(FixerNamespaces.class);
    private final XOutputNamespaceContext nsContext;
    private int currentElemDepth;
    protected final NamespaceMappings prefixMap;
    protected boolean toUndeclarePrefixes = false;
    protected boolean toAvoidDefaultNS = false;
    protected boolean toAddInscopeNamespaces = false;
    protected boolean toIncludeEmptyXMLNS = false;
    private boolean extraOptions = false;
    private List<String> forceNSList = null;
    private HashMap<String, String> uri2RequiredPrefix = null;
    final CursorFactory fCursorFactory;
    protected boolean m_isXML11 = false;
    private StringCDataMutable fPrefixCData = new StringCDataMutable("");
    private StringCDataMutable fNamespaceURICData = new StringCDataMutable("");

    public FixerNamespaces(CursorFactory cursorFactory, Map map2, CursorExtended cursorExtended, List<QName> list) {
        super(cursorExtended);
        this.nsContext = new XOutputNamespaceContext();
        this.fCursorFactory = cursorFactory;
        this.prefixMap = new NamespaceMappings();
        this.currentElemDepth = 0;
        if (map2 != null) {
            this.processParameters(map2);
        }
    }

    private final void processParameters(Map<String, Object> map2) {
        int n2;
        List list;
        Object object2 = map2.get("undeclare-prefixes");
        this.toUndeclarePrefixes = Boolean.TRUE.equals(object2);
        object2 = map2.get("{http://ibm.com/xml/xci/serializer}use-default-ns");
        this.toAvoidDefaultNS = Boolean.FALSE.equals(object2);
        object2 = map2.get("{http://ibm.com/xml/xci/serializer}include-empty-xmlns");
        this.toIncludeEmptyXMLNS = Boolean.TRUE.equals(object2);
        object2 = map2.get("{http://ibm.com/xml/xci/serializer}force-ns-delcarations");
        if (object2 instanceof List) {
            try {
                list = (List)object2;
                n2 = list.size();
                if (n2 > 0) {
                    this.forceNSList = new ArrayList<String>(n2);
                    for (QName qName : list) {
                        this.forceNSList.add(qName.getLocalPart());
                        this.forceNSList.add(qName.getNamespaceURI());
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((object2 = map2.get("{http://ibm.com/xml/xci/serializer}required-prefixes")) instanceof List) {
            try {
                list = (List)object2;
                n2 = list.size();
                if (n2 > 0) {
                    this.uri2RequiredPrefix = new HashMap();
                    for (QName qName : list) {
                        this.uri2RequiredPrefix.put(qName.getNamespaceURI(), qName.getPrefix());
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.extraOptions = this.toIncludeEmptyXMLNS;
    }

    @Override
    public final boolean isXML11() {
        return this.m_isXML11;
    }

    void privateElemStart() throws IOException {
        if (this.nsContext.getHasBeenOutput()) {
            return;
        }
        VolatileCData volatileCData = this.nsContext.getName();
        if (LoggerUtil.isFinerLoggable(gLogger)) {
            FixerNamespaces.logOriginalName(gLogger, Level.FINER, volatileCData, "privateElemStart()");
        }
        this.processElemPrefix(volatileCData);
        this.fCursor.addElement(this.nsContext.getWhere(), this.nsContext.getName(), this.nsContext.getType());
        if (this.nsContext.hasNamespaces()) {
            this.writeElemNamespaces(volatileCData);
        }
        if (this.extraOptions) {
            this.processExtraOptions();
        }
        this.nsContext.setHasBeenOutput(true);
    }

    private void processExtraOptions() {
        if (this.toIncludeEmptyXMLNS) {
            this.addEmptyXMLNS();
        }
        if (this.toAddInscopeNamespaces) {
            this.dumpInscopeNamespaces();
        }
    }

    private void processElemPrefix(VolatileCData volatileCData) {
        String string2 = volatileCData.getQNamePrefix(1);
        NamespaceMappings.MappingRecord mappingRecord = this.prefixMap.getMappingFromPrefix(string2);
        if (mappingRecord == null) {
            this.processElemPrefixNew(volatileCData, string2);
        } else {
            this.processElemPrefixExisting(volatileCData, string2, mappingRecord);
        }
    }

    private void processElemPrefixNew(VolatileCData volatileCData, String string2) {
        int n2;
        String string3 = volatileCData.getQNameNamespaceURI(1);
        int n3 = n2 = string3 == null ? 0 : string3.length();
        if (n2 > 0 || string2.length() > 0 && this.isXML11()) {
            if (LoggerUtil.isFinestLoggable(gLogger)) {
                FixerNamespaces.logPrefixMapping1(gLogger, Level.FINEST, string2, string3, "processElemPrefixNew");
            }
            this.declareNS(string3, string2, false);
        } else if (string2.length() > 0) {
            CData cData = this.fCursorFactory.data((CharSequence)string3, volatileCData.getQNameLocalPart(1), "");
            this.nsContext.setName(cData);
            this.declareNS(string3, "", false);
            if (LoggerUtil.isFinestLoggable(gLogger)) {
                gLogger.logp(Level.FINEST, gLogger.getName(), "processElemPrefixNew", "Trying to undeclare prefix {" + string2 + "} in XML 1.0");
            }
        }
    }

    private void processElemPrefixExisting(VolatileCData volatileCData, String string2, NamespaceMappings.MappingRecord mappingRecord) {
        boolean bl;
        String string3 = volatileCData.getQNameNamespaceURI(1);
        int n2 = string3 == null ? 0 : string3.length();
        String string4 = mappingRecord.get_uri();
        int n3 = string4.length();
        boolean bl2 = bl = !this.toAvoidDefaultNS || n2 == 0 || string2.length() > 0;
        if (n3 == n2 && string4.equals(string3) && bl) {
            return;
        }
        if (n2 > 0 || this.isXML11()) {
            int n4 = mappingRecord.getDeclarationDepth();
            if (n4 < this.currentElemDepth && bl) {
                if (LoggerUtil.isFinestLoggable(gLogger)) {
                    FixerNamespaces.logPrefixMapping2(gLogger, Level.FINEST, string2, string3, "processElemPrefixExisting");
                }
                this.declareNS(string3, string2, false);
            } else {
                String string5;
                mappingRecord = this.prefixMap.getMappingFromURI(string3, !bl);
                if (mappingRecord != null) {
                    string5 = mappingRecord.get_prefix();
                    if (LoggerUtil.isFinestLoggable(gLogger)) {
                        FixerNamespaces.logPrefixMapping3(gLogger, Level.FINEST, string5, string2, string3, "processElemPrefixExisting");
                    }
                } else {
                    string5 = this.prefixMap.generateUnusedPrefix();
                    if (LoggerUtil.isFinestLoggable(gLogger)) {
                        FixerNamespaces.logPrefixMapping4(gLogger, Level.FINEST, string5, string2, string3, "processElemPrefixExisting");
                    }
                    this.declareNS(string3, string5, false);
                }
                CData cData = this.fCursorFactory.data((CharSequence)string3, volatileCData.getQNameLocalPart(1), string5);
                this.nsContext.setName(cData);
            }
        } else {
            CData cData = this.fCursorFactory.data((CharSequence)string3, volatileCData.getQNameLocalPart(1), "");
            this.nsContext.setName(cData);
            this.declareNS(string3, "", false);
            if (LoggerUtil.isFinestLoggable(gLogger)) {
                gLogger.logp(Level.FINEST, gLogger.getName(), "processElemPrefixExisting", "Trying to undeclare prefix {" + string2 + "} in XML 1.0");
            }
        }
    }

    private void addEmptyXMLNS() {
        NamespaceMappings.MappingRecord mappingRecord = this.prefixMap.getMappingFromPrefix("");
        if (mappingRecord.getDeclarationDepth() < this.currentElemDepth) {
            this.fNamespaceURICData.setString("");
            this.fPrefixCData.setString("");
            this.fCursor.addNamespaceNode(this.fPrefixCData, this.fNamespaceURICData, false);
        }
        this.toIncludeEmptyXMLNS = false;
        this.extraOptions = false;
    }

    private void writeElemNamespaces(VolatileCData volatileCData) throws IOException {
        int n2 = this.nsContext.getNamespaceNodeFirst();
        if (0 <= n2) {
            int n3 = this.nsContext.getNamespaceNodeLast();
            for (int i = n2; i <= n3; ++i) {
                if (this.getOutputContext() == XOutputMethod.XHTML && volatileCData.getQNameLocalPart(1).equals("meta")) {
                    this.privateWriteAttrNSDeclForXHTMLNonTop(i, volatileCData);
                    continue;
                }
                this.privateWriteAttrNSDecl(i);
            }
        }
    }

    private void dumpInscopeNamespaces() {
        List<NamespaceMappings.MappingRecord> list = this.getInScopeNamespaces(this.currentElemDepth - 1);
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            NamespaceMappings.MappingRecord mappingRecord = list.get(i);
            String string2 = mappingRecord.get_prefix();
            String string3 = mappingRecord.get_uri();
            this.fNamespaceURICData.setString(string3);
            this.fPrefixCData.setString(string2);
            this.fCursor.addNamespaceNode(this.fPrefixCData, this.fNamespaceURICData, false);
        }
    }

    @Override
    public final List<NamespaceMappings.MappingRecord> getInScopeNamespaces(int n2) {
        List<NamespaceMappings.MappingRecord> list = this.prefixMap.getPrefixMappingsAtDepth(n2);
        return list;
    }

    @Override
    public int getElemDepth() {
        int n2 = this.currentElemDepth;
        return n2;
    }

    public final void ensureContentState(Cursor.Area area) throws IOException {
        if (this.mayAddElemAttr()) {
            this.privateElemStart();
            if (area == Cursor.Area.FOLLOWING_SIBLING) {
                this.popNamespaceContext();
            }
            this.nsContext.setState(XOutputElemContext.State.IN_CONTENT);
        }
    }

    @Override
    public final void addElement(Cursor.Area area, VolatileCData volatileCData, XSTypeDefinition xSTypeDefinition) {
        try {
            if (LoggerUtil.isFinerLoggable(gLogger)) {
                FixerNamespaces.logName(gLogger, Level.FINER, volatileCData, "addElement(" + area + ")");
            }
            this.ensureContentState(area);
            this.pushNamespaceContext();
            this.nsContext.setName(volatileCData.constant(false));
            this.nsContext.setWhere(area);
            this.nsContext.setType(xSTypeDefinition);
            this.nsContext.setState(XOutputElemContext.State.IN_START_TAG);
            this.nsContext.setHasBeenOutput(false);
            this.nsContext.setNamespaceNodeFirst(-1);
            this.nsContext.setNamespaceNodeLast(-1);
            ++this.currentElemDepth;
            if (this.forceNSList != null) {
                this.toAddInscopeNamespaces = this.matchForceNSElement(volatileCData);
                boolean bl = this.extraOptions = this.extraOptions || this.toAddInscopeNamespaces;
            }
            if (this.uri2RequiredPrefix != null) {
                this.enforceRequiredElemPrefix(volatileCData);
            }
        }
        catch (IOException iOException) {
            Messages.xciDynamicErrorException(iOException);
        }
    }

    private void enforceRequiredElemPrefix(VolatileCData volatileCData) {
        String string2 = volatileCData.getQNameNamespaceURI(1);
        String string3 = volatileCData.getQNamePrefix(1);
        String string4 = this.uri2RequiredPrefix.get(string2);
        if (string4 != null && !string4.equals(string3)) {
            if (LoggerUtil.isFinestLoggable(gLogger)) {
                FixerNamespaces.logRequiredPrefix(gLogger, Level.FINEST, string3, string4, "enforceRequiredElemPrefix");
            }
            CData cData = this.fCursorFactory.data((CharSequence)string2, volatileCData.getQNameLocalPart(1), string4);
            this.nsContext.setName(cData);
            this.fNamespaceURICData.setString(string2);
            this.fPrefixCData.setString(string4);
            this.addNamespaceNode(this.fPrefixCData, this.fNamespaceURICData, false);
        }
    }

    private boolean matchForceNSElement(VolatileCData volatileCData) {
        String string2 = volatileCData.getQNameLocalPart(1);
        String string3 = volatileCData.getQNameNamespaceURI(1);
        int n2 = this.forceNSList.size();
        for (int i = 0; i < n2; i += 2) {
            if (!string2.equals(this.forceNSList.get(i)) || !string3.equals(this.forceNSList.get(i + 1))) continue;
            return true;
        }
        return false;
    }

    @Override
    public final void closeMutation() {
        this.fCursor.closeMutation();
    }

    @Override
    public final boolean openMutation(Cursor.Area area) {
        return this.fCursor.openMutation(area);
    }

    @Override
    public final void release() {
        boolean bl = !this.nsContext.getHasBeenOutput();
        boolean bl2 = this.mayAddElemAttr();
        try {
            if (bl) {
                this.privateElemStart();
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        this.fCursor.release();
        if (bl || bl2) {
            this.popNamespaceContext();
        }
        if (this.currentElemDepth == 0) {
            XOutputElemContext.State state = this.nsContext.getState();
            switch (state) {
                case START_DOCUMENT: {
                    break;
                }
                case END_DOCUMENT: {
                    break;
                }
                default: {
                    this.nsContext.setState(XOutputElemContext.State.END_DOCUMENT);
                    break;
                }
            }
        } else {
            this.popNamespaceContext();
            this.nsContext.setState(XOutputElemContext.State.IN_CONTENT);
        }
        assert (this.decrementForkReleaseCounter());
    }

    @Override
    public final void addContent(Cursor.Area area, byte[] byArray, int n2, int n3) {
        try {
            this.ensureContentState(area);
            this.fCursor.addContent(area, byArray, n2, n3);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    @Override
    public final void addContent(Cursor.Area area, char[] cArray, int n2, int n3) {
        try {
            this.ensureContentState(area);
            this.fCursor.addContent(area, cArray, n2, n3);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    @Override
    public void addText(Cursor.Area area, VolatileCData volatileCData) {
        try {
            this.ensureContentState(area);
            this.nsContext.setState(XOutputElemContext.State.IN_TEXT_CONTENT);
            this.fCursor.addText(area, volatileCData);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    @Override
    public void addText(Cursor.Area area, Chars chars) {
        try {
            this.ensureContentState(area);
            this.nsContext.setState(XOutputElemContext.State.IN_TEXT_CONTENT);
            this.fCursor.addText(area, chars);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    @Override
    public void addProcessingInstruction(Cursor.Area area, VolatileCData volatileCData, VolatileCData volatileCData2) {
        String string2 = volatileCData.toString();
        if (string2.equals("javax.xml.transform.disable-output-escaping")) {
            this.fCursor.addProcessingInstruction(area, volatileCData, volatileCData2);
        } else if (string2.equals("javax.xml.transform.enable-output-escaping")) {
            this.fCursor.addProcessingInstruction(area, volatileCData, volatileCData2);
        } else {
            try {
                this.ensureContentState(area);
                this.fCursor.addProcessingInstruction(area, volatileCData, volatileCData2);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    @Override
    public void addProcessingInstruction(Cursor.Area area, VolatileCData volatileCData, Chars chars) {
        String string2 = volatileCData.toString();
        if (string2.equals("javax.xml.transform.disable-output-escaping")) {
            this.fCursor.addProcessingInstruction(area, volatileCData, chars);
        } else if (string2.equals("javax.xml.transform.enable-output-escaping")) {
            this.fCursor.addProcessingInstruction(area, volatileCData, chars);
        } else {
            try {
                this.ensureContentState(area);
                this.fCursor.addProcessingInstruction(area, volatileCData, chars);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    @Override
    public void addComment(Cursor.Area area, VolatileCData volatileCData) {
        try {
            this.ensureContentState(area);
            this.fCursor.addComment(area, volatileCData);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    @Override
    public void addComment(Cursor.Area area, Chars chars) {
        try {
            this.ensureContentState(area);
            this.fCursor.addComment(area, chars);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    @Override
    public void addCopy(Cursor.Area area, Cursor cursor2) {
        try {
            this.ensureContentState(area);
            this.fCursor.addCopy(area, cursor2);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    @Override
    public final Cursor fork(boolean bl, Cursor.Profile profile, Cursor.Profile profile2) {
        assert (this.incrementForkReleaseCounter());
        return this;
    }

    protected boolean mayAddNamespaceNode() {
        XOutputElemContext.State state = this.nsContext.getState();
        return state == XOutputElemContext.State.IN_START_TAG || state == XOutputElemContext.State.IN_NAMESPACES;
    }

    private boolean mayAddElemAttr() {
        XOutputElemContext.State state = this.nsContext.getState();
        return state == XOutputElemContext.State.IN_START_TAG || state == XOutputElemContext.State.IN_ATTRIBUTES || state == XOutputElemContext.State.IN_NAMESPACES;
    }

    @Override
    public final void addNamespaceNode(VolatileCData volatileCData, VolatileCData volatileCData2, boolean bl) {
        this.addNamespaceNode((Chars)volatileCData, (Chars)volatileCData2, bl);
    }

    @Override
    public void addNamespaceNode(Chars chars, Chars chars2, boolean bl) {
        String string2;
        String string3;
        if (!this.mayAddElemAttr()) {
            string3 = Messages.createMessage2("ER_SER_ATTR_NAMESPACE", null);
            Messages.xciDynamicErrorException(string3);
        }
        string3 = ((Object)chars2).toString();
        String string4 = string2 = chars == null ? "" : ((Object)chars).toString();
        if (string2.length() == 0 || string3.length() > 0 || this.toUndeclarePrefixes) {
            NamespaceMappings.MappingRecord mappingRecord = this.lookupPrefix(string2);
            if (mappingRecord != null && mappingRecord.get_uri().equals(string3)) {
                return;
            }
            int n2 = this.declareNS(string3, string2, false);
            if (this.nsContext.getState() == XOutputElemContext.State.IN_ATTRIBUTES && n2 >= 0) {
                try {
                    this.privateWriteAttrNSDecl(n2);
                }
                catch (IOException iOException) {
                    Messages.xciDynamicErrorException(iOException);
                }
            }
        }
    }

    private final void privateWriteAttrNSDeclForXHTMLNonTop(int n2, VolatileCData volatileCData) throws IOException {
        NamespaceMappings.MappingRecord mappingRecord = this.prefixMap.lookupNamespace(n2);
        String string2 = mappingRecord.get_uri();
        String string3 = mappingRecord.get_prefix();
        if (string2.equals("http://www.w3.org/1999/xhtml") && (string3 == null || "".equals(string3)) && !volatileCData.getQNameLocalPart(1).equals("html")) {
            return;
        }
        this.fNamespaceURICData.setString(string2);
        this.fPrefixCData.setString(string3);
        this.fCursor.addNamespaceNode(this.fPrefixCData, this.fNamespaceURICData, false);
    }

    private final void privateWriteAttrNSDecl(int n2) throws IOException {
        NamespaceMappings.MappingRecord mappingRecord = this.prefixMap.lookupNamespace(n2);
        String string2 = mappingRecord.get_uri();
        String string3 = mappingRecord.get_prefix();
        this.fNamespaceURICData.setString(string2);
        this.fPrefixCData.setString(string3);
        this.fCursor.addNamespaceNode(this.fPrefixCData, this.fNamespaceURICData, false);
    }

    @Override
    public void addAttribute(VolatileCData volatileCData, VolatileCData volatileCData2) {
        try {
            CharSequence charSequence;
            if (!this.mayAddElemAttr()) {
                charSequence = Messages.createMessage2("ER_SER_ATTR_NAMESPACE", null);
                Messages.xciDynamicErrorException(charSequence);
            }
            if (this.mayAddNamespaceNode()) {
                this.privateElemStart();
                this.nsContext.setState(XOutputElemContext.State.IN_ATTRIBUTES);
            }
            charSequence = this.getNonElemQName(volatileCData);
            if (FixerNamespaces.isQNameType(volatileCData2)) {
                volatileCData2 = this.getNonElemQName(volatileCData2);
            }
            this.fCursor.addAttribute((VolatileCData)charSequence, (Chars)volatileCData2);
        }
        catch (IOException iOException) {
            Messages.xciDynamicErrorException(iOException);
        }
    }

    @Override
    public void addAttribute(VolatileCData volatileCData, Chars chars) {
        try {
            CharSequence charSequence;
            if (!this.mayAddElemAttr()) {
                charSequence = Messages.createMessage2("ER_SER_ATTR_NAMESPACE", null);
                Messages.xciDynamicErrorException(charSequence);
            }
            if (this.mayAddNamespaceNode()) {
                this.privateElemStart();
                this.nsContext.setState(XOutputElemContext.State.IN_ATTRIBUTES);
            }
            charSequence = this.getNonElemQName(volatileCData);
            this.fCursor.addAttribute((VolatileCData)charSequence, chars);
        }
        catch (IOException iOException) {
            Messages.xciDynamicErrorException(iOException);
        }
    }

    private VolatileCData getNonElemQName(VolatileCData volatileCData) throws IOException {
        String string2;
        String string3 = volatileCData.getQNamePrefix(1);
        String string4 = this.processNonElemPrefix(string3, string2 = volatileCData.getQNameNamespaceURI(1));
        if (string4.equals(string3)) {
            return volatileCData;
        }
        return this.fCursorFactory.data((CharSequence)string2, volatileCData.getQNameLocalPart(1), string4);
    }

    protected final String processNonElemPrefix(String string2, String string3) throws IOException {
        if (string3 != null && string3.length() > 0) {
            if (this.uri2RequiredPrefix != null) {
                string2 = this.getNonElemPrefixRequired(string3, string2);
            }
            if (string2.length() > 0) {
                NamespaceMappings.MappingRecord mappingRecord = this.prefixMap.getMappingFromPrefix(string2);
                if (mappingRecord != null && mappingRecord.get_uri().equals(string3)) {
                    return string2;
                }
                return this.processNonElemPrefix(mappingRecord, string2, string3);
            }
            return this.processNonElemPrefix(string3);
        }
        return "";
    }

    private final String processNonElemPrefix(NamespaceMappings.MappingRecord mappingRecord, String string2, String string3) throws IOException {
        boolean bl;
        String string4 = string2;
        boolean bl2 = bl = mappingRecord != null && (mappingRecord.getDeclarationDepth() == this.currentElemDepth || this.toAddInscopeNamespaces);
        if (string4.length() == 0 || bl) {
            mappingRecord = this.prefixMap.getMappingFromURI(string3, true);
            if (mappingRecord != null) {
                return mappingRecord.get_prefix();
            }
            string4 = this.prefixMap.generateUnusedPrefix();
        }
        this.declareNS(string3, string4, false);
        this.fNamespaceURICData.setString(string3);
        this.fPrefixCData.setString(string4);
        this.fCursor.addNamespaceNode(this.fPrefixCData, this.fNamespaceURICData, false);
        return string4;
    }

    private final String processNonElemPrefix(String string2) throws IOException {
        NamespaceMappings.MappingRecord mappingRecord = this.prefixMap.getMappingFromURI(string2, true);
        if (mappingRecord != null) {
            return mappingRecord.get_prefix();
        }
        String string3 = this.prefixMap.generateUnusedPrefix();
        this.declareNS(string2, string3, false);
        this.fNamespaceURICData.setString(string2);
        this.fPrefixCData.setString(string3);
        this.fCursor.addNamespaceNode(this.fPrefixCData, this.fNamespaceURICData, false);
        return string3;
    }

    private final String getNonElemPrefixRequired(String string2, String string3) {
        String string4 = this.uri2RequiredPrefix.get(string2);
        if (string4 == null || string4.equals(string3)) {
            return string3;
        }
        if (string4.length() > 0) {
            return string4;
        }
        String string5 = this.getPrefix(string2);
        if (string5.length() == 0) {
            return this.getUnusedPrefix();
        }
        return string5;
    }

    @Override
    public AdditionalAPIs getCursorExtensions() {
        return this;
    }

    public final String getPrefixOfNSHandle(int n2) {
        NamespaceMappings.MappingRecord mappingRecord = this.prefixMap.lookupNamespace(n2);
        String string2 = mappingRecord.get_prefix();
        return string2;
    }

    final String getURIOfNSHandle(int n2) {
        NamespaceMappings.MappingRecord mappingRecord = this.prefixMap.lookupNamespace(n2);
        String string2 = mappingRecord.get_uri();
        return string2;
    }

    public final void pushNamespaceContext() {
        if (SerializerCursorFactory.TRACE_SER_API) {
            this.dbgTrace(".pushNamespaceContext(); called");
        }
    }

    public final void popNamespaceContext() {
        if (SerializerCursorFactory.TRACE_SER_API) {
            this.dbgTrace(".popNamespaceContext(); called");
        }
        int n2 = this.currentElemDepth--;
        this.nsContext.scrub();
        this.prefixMap.popNamespaces(n2, null);
    }

    protected int declareNS(String string2, String string3, boolean bl) {
        int n2;
        int n3;
        if (SerializerCursorFactory.TRACE_SER_API) {
            String string4 = ".declareNS('" + string2 + "', '" + string3 + "', " + bl + "); called";
            this.dbgTrace(string4);
        }
        if ((n3 = this.prefixMap.pushNamespace(string3, string2, n2 = this.currentElemDepth, bl)) >= 0) {
            this.nsContext.addNamespaceNode(n3);
        }
        if (SerializerCursorFactory.TRACE_SER_API) {
            String string5 = ".declareNS('" + string2 + "', '" + string3 + "', " + bl + "); returns index:" + n3;
            this.dbgTrace(string5);
        }
        return n3;
    }

    protected final int toHandle(String string2) {
        NamespaceMappings.MappingRecord mappingRecord = this.prefixMap.lookupPrefix(string2);
        int n2 = mappingRecord == null ? -1 : mappingRecord.get_index();
        if (SerializerCursorFactory.TRACE_SER_API) {
            String string3 = ".toHandle('" + string2 + "'); called, returns index: " + n2;
            this.dbgTrace(string3);
        }
        return n2;
    }

    protected final int toHandleFromPrefix(String string2) {
        NamespaceMappings.MappingRecord mappingRecord = this.prefixMap.getMappingFromPrefix(string2);
        int n2 = mappingRecord == null ? -1 : mappingRecord.get_index();
        return n2;
    }

    protected final NamespaceMappings.MappingRecord lookupPrefix(String string2) {
        return this.prefixMap.getMappingFromPrefix(string2);
    }

    protected void declarePrefix(int n2, String string2, boolean bl) {
    }

    protected void dbgTrace(String string2) {
        int n2 = this.currentElemDepth;
        for (int i = 1; i < n2; ++i) {
            System.err.print("  ");
        }
        System.err.println("TRACE_SER_API: XMLStreamCursor" + string2);
    }

    @Override
    public int getParentSerializationState() {
        return this.fCursor.getCursorExtensions().getParentSerializationState();
    }

    @Override
    public String getPrefix(String string2) {
        NamespaceMappings.MappingRecord mappingRecord = this.prefixMap.getMappingFromURI(string2, true);
        if (mappingRecord != null) {
            return mappingRecord.get_prefix();
        }
        return null;
    }

    @Override
    public void setAddInscopeNamespaces() {
        this.toAddInscopeNamespaces = true;
    }

    @Override
    public int getSerializationState() {
        return this.nsContext.getState().getExternalOrdinal();
    }

    @Override
    public String getUnusedPrefix() {
        String string2 = this.prefixMap.generateUnusedPrefix();
        return string2;
    }

    private final HtmlElemInfo.ElemDesc getElemDesc(String string2) {
        Object object2;
        XOutputMethod xOutputMethod = this.fCursor.getCursorExtensions().getOutputContext();
        if (xOutputMethod.elementFlags != null && null != (object2 = xOutputMethod.elementFlags.get(string2))) {
            return (HtmlElemInfo.ElemDesc)object2;
        }
        return HtmlElemInfo.s_elemNotFound;
    }

    private boolean isAnHTMLElemName(HtmlElemInfo.ElemDesc elemDesc) {
        return elemDesc != HtmlElemInfo.s_elemNotFound;
    }

    @Override
    public boolean isCurrentElemInline(VolatileCData volatileCData) {
        XOutputMethod xOutputMethod = this.fCursor.getCursorExtensions().getOutputContext();
        if (xOutputMethod.isHTMLNature) {
            String string2 = volatileCData.getQNameLocalPart(1);
            HtmlElemInfo.ElemDesc elemDesc = this.getElemDesc(string2);
            if (this.isAnHTMLElemName(elemDesc) && !string2.equalsIgnoreCase("ins") && !string2.equalsIgnoreCase("del")) {
                return elemDesc.is(512);
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean isPreviousElemInline() {
        return this.fCursor.getCursorExtensions().isPreviousElemInline();
    }

    @Override
    public boolean outputParamNeedsFixing(String string2, Object object2) {
        return this.fCursor.getCursorExtensions().outputParamNeedsFixing(string2, object2);
    }

    @Override
    public void resetInlineElem(boolean bl) {
        this.fCursor.getCursorExtensions().resetInlineElem(bl);
    }

    @Override
    public void writeAttribute(String string2, String string3) throws IOException {
        if (this.mayAddNamespaceNode()) {
            this.privateElemStart();
            this.nsContext.setState(XOutputElemContext.State.IN_ATTRIBUTES);
        }
        this.fCursor.getCursorExtensions().writeAttribute(string2, string3);
    }

    private static final void logName(Logger logger, Level level, VolatileCData volatileCData, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("QName [prefix: '");
        stringBuilder.append(volatileCData.getQNamePrefix(1));
        stringBuilder.append("' - localPart: '");
        stringBuilder.append(volatileCData.getQNameLocalPart(1));
        stringBuilder.append("' - uri: '");
        stringBuilder.append(volatileCData.getQNameNamespaceURI(1));
        stringBuilder.append("']\nStack trace= ");
        stringBuilder.append(XCIErrorHelper.getStackTrace(20));
        logger.logp(level, logger.getName(), string2, stringBuilder.toString());
    }

    private static final void logOriginalName(Logger logger, Level level, VolatileCData volatileCData, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Original QName [prefix: '");
        stringBuilder.append(volatileCData.getQNamePrefix(1));
        stringBuilder.append("' - localPart: '");
        stringBuilder.append(volatileCData.getQNameLocalPart(1));
        stringBuilder.append("' - uri: '");
        stringBuilder.append(volatileCData.getQNameNamespaceURI(1));
        stringBuilder.append("']");
        logger.logp(level, logger.getName(), string2, stringBuilder.toString());
    }

    private static final void logRequiredPrefix(Logger logger, Level level, String string2, String string3, String string4) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("replacing hinted prefix: '");
        stringBuilder.append(string2);
        stringBuilder.append("' with required prefix: '");
        stringBuilder.append(string3);
        stringBuilder.append("'");
        logger.logp(level, logger.getName(), string4, stringBuilder.toString());
    }

    private static final void logPrefixMapping1(Logger logger, Level level, String string2, String string3, String string4) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Adding a mapping for prefix: '");
        stringBuilder.append(string2);
        stringBuilder.append("' to uri: '");
        stringBuilder.append(string3);
        stringBuilder.append("' - no inscope namespace mapping was found");
        logger.logp(level, logger.getName(), string4, stringBuilder.toString());
    }

    private static final void logPrefixMapping2(Logger logger, Level level, String string2, String string3, String string4) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Adding a mapping for prefix: '");
        stringBuilder.append(string2);
        stringBuilder.append("' to uri: '");
        stringBuilder.append(string3);
        stringBuilder.append("' - prefix was declared at a higher element depth");
        logger.logp(level, logger.getName(), string4, stringBuilder.toString());
    }

    private static final void logPrefixMapping3(Logger logger, Level level, String string2, String string3, String string4, String string5) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Using existing in-scope prefix: '");
        stringBuilder.append(string2);
        stringBuilder.append("' to map to uri: '");
        stringBuilder.append(string4);
        stringBuilder.append("' - desired prefix '");
        stringBuilder.append(string3);
        stringBuilder.append("' is already mapped to a different uri");
        logger.logp(level, logger.getName(), string5, stringBuilder.toString());
    }

    private static final void logPrefixMapping4(Logger logger, Level level, String string2, String string3, String string4, String string5) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Adding a mapping for newly generated prefix: '");
        stringBuilder.append(string2);
        stringBuilder.append("' to map to uri: '");
        stringBuilder.append(string4);
        stringBuilder.append("' - desired prefix '");
        stringBuilder.append(string3);
        stringBuilder.append("' is already mapped to a different uri");
        logger.logp(level, logger.getName(), string5, stringBuilder.toString());
    }
}

