/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.serializer.fixer;

import com.ibm.xml.xci.CData;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.CursorFactory;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.values.chars.Chars;
import com.ibm.xml.xci.internal.cast.CastUtilities;
import com.ibm.xml.xci.serializer.AddContentInterface;
import com.ibm.xml.xci.serializer.AdditionalAPIs;
import com.ibm.xml.xci.serializer.CursorExtended;
import com.ibm.xml.xci.serializer.ElemContext;
import com.ibm.xml.xci.serializer.fixer.FixerBase;
import com.ibm.xml.xci.type.TypeRegistry;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import com.ibm.xml.xml4j.internal.s1.impl.dv.InvalidDatatypeValueException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;

public class FixerSmartPrefixes
extends FixerBase
implements CursorExtended,
AddContentInterface {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String[] prefixes = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"};
    final HashMap<String, String> fURI2Prefix = new HashMap();
    final HashMap<String, String> fPrefix2Prefix = new HashMap();
    final Vector<String> fSmartPrefixes = new Vector();
    private int[] fPrefixLevels = new int[3];
    private int fCurrentLevel = 0;
    private boolean fFirstChildExpected = false;
    private boolean fGenerateShort = false;
    private int fContextCount = 0;
    private int[] fPrefixContext = new int[8];
    final HashMap<String, Integer> fPrefix2Counter = new HashMap();
    final ArrayList<String> fNSList = new ArrayList();
    final CursorFactory fCursorFactory;

    public FixerSmartPrefixes(CursorFactory cursorFactory, Map map2, CursorExtended cursorExtended, boolean bl) {
        super(cursorExtended);
        this.fGenerateShort = bl;
        this.fCursorFactory = cursorFactory;
    }

    private final CData getStringValue(String string2) {
        CData cData = this.fCursorFactory.data((CharSequence)string2, null, false);
        return cData;
    }

    private final CData getQName(String string2, VolatileCData volatileCData) {
        String string3 = volatileCData.getQNameNamespaceURI(1);
        String string4 = volatileCData.getQNameLocalPart(1);
        QName qName = new QName(string3, string4, string2);
        CData cData = this.fCursorFactory.data(qName, TypeRegistry.XSQNAME, false);
        return cData;
    }

    private int numExtraNamespaceNodes() {
        int n2 = this.fNSList.size() / 2;
        return n2;
    }

    private void dumpNamespaceNodes() {
        if (this.startTagIsOpen()) {
            int n2 = this.numExtraNamespaceNodes();
            for (int i = 0; i < n2; i += 2) {
                String string2 = this.getGeneratedURI(i);
                String string3 = this.getGeneratedPrefix(i);
                CData cData = this.getStringValue(string3);
                CData cData2 = this.getStringValue(string2);
                this.fCursor.addNamespaceNode(cData, cData2, false);
            }
            this.clearNamepacesNodesToGenerate();
        }
    }

    private String getGeneratedURI(int n2) {
        String string2 = this.fNSList.get(n2);
        return string2;
    }

    private String prefixMapping(String string2) {
        return this.fURI2Prefix.get(string2);
    }

    private void addPrefixMapping(String string2, String string3) {
        this.fURI2Prefix.put(string3, string2);
        this.fSmartPrefixes.add(string2);
    }

    private void clearPrefixes() {
        this.fURI2Prefix.clear();
        this.fSmartPrefixes.clear();
        this.fPrefix2Counter.clear();
        this.fCurrentLevel = 0;
        this.fPrefixLevels[2] = 0;
        this.fPrefixLevels[1] = 0;
        this.fPrefixLevels[0] = 0;
    }

    private void clearPrefix2PrefixMapping() {
        this.fPrefix2Prefix.clear();
    }

    private String getGeneratedPrefix(int n2) {
        String string2 = this.fNSList.get(n2 + 1);
        return string2;
    }

    private void clearNamepacesNodesToGenerate() {
        this.fNSList.clear();
    }

    private void addNamespaceNodeToGenerate(String string2, String string3) {
        this.fNSList.add(string2);
        this.fNSList.add(string3);
    }

    private boolean startTagIsOpen() {
        int n2 = this.getCursorExtensions().getSerializationState();
        boolean bl = ElemContext.mayAddElemAttr(n2);
        return bl;
    }

    private String getMeaningfulPrefix(String string2, String string3) {
        String string4 = this.parsePrefix(string2);
        try {
            CastUtilities.validate(string4, TypeRegistry.XSNCNAME);
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            return string3;
        }
        Integer n2 = this.fPrefix2Counter.get(string4);
        if (n2 == null) {
            this.fPrefix2Counter.put(string4, 1);
        } else {
            n2 = n2 + 1;
            string4 = string4 + n2;
        }
        return string4;
    }

    private String parsePrefix(String string2) {
        int n2 = string2.length();
        int n3 = string2.lastIndexOf(47);
        if (n3 == n2) {
            string2 = string2.substring(0, --n2);
            n3 = string2.lastIndexOf(47);
        }
        if (n3 != -1) {
            return string2.substring(n3 + 1, n2);
        }
        return string2;
    }

    private String getShortPrefix(String string2) {
        if (this.fCurrentLevel >= 0) {
            string2 = prefixes[this.fPrefixLevels[0]];
            for (int i = 1; i <= this.fCurrentLevel; ++i) {
                string2 = string2 + prefixes[this.fPrefixLevels[i]];
            }
            int n2 = this.fCurrentLevel;
            this.fPrefixLevels[n2] = this.fPrefixLevels[n2] + 1;
            if (this.fPrefixLevels[this.fCurrentLevel] == prefixes.length) {
                this.fPrefixLevels[this.fCurrentLevel] = 0;
                if (this.fCurrentLevel == 2) {
                    this.fPrefixLevels[1] = this.fPrefixLevels[1] + 1;
                    if (this.fPrefixLevels[1] == prefixes.length) {
                        this.fPrefixLevels[0] = this.fPrefixLevels[0] + 1;
                        if (this.fPrefixLevels[0] == prefixes.length) {
                            this.fCurrentLevel = -1;
                        } else {
                            this.fPrefixLevels[1] = 0;
                        }
                    }
                } else if (this.fCurrentLevel == 1) {
                    this.fPrefixLevels[0] = this.fPrefixLevels[0] + 1;
                    if (this.fPrefixLevels[0] == prefixes.length) {
                        this.fPrefixLevels[0] = 0;
                        ++this.fCurrentLevel;
                    }
                } else {
                    ++this.fCurrentLevel;
                }
            }
        }
        return string2;
    }

    private VolatileCData enforceSmartPrefix(VolatileCData volatileCData) {
        String string2 = volatileCData.getQNameNamespaceURI(1);
        String string3 = volatileCData.getQNamePrefix(1);
        if (string3 == null || string3.length() == 0) {
            return volatileCData;
        }
        String string4 = this.prefixMapping(string2);
        boolean bl = false;
        if (string4 == null) {
            string4 = this.fGenerateShort ? this.getShortPrefix(string3) : this.getMeaningfulPrefix(string2, string3);
            if (string4 == string3) {
                return volatileCData;
            }
            this.addPrefixMapping(string4, string2);
            bl = true;
        } else {
            bl = !this.isPrefixInScope(string4);
        }
        volatileCData = this.getQName(string4, volatileCData);
        if (bl) {
            this.addNamespaceNodeToGenerate(string2, string4);
        }
        this.fPrefix2Prefix.put(string3, string4);
        return volatileCData;
    }

    public final void addElement(Cursor.Area area, VolatileCData volatileCData, XSTypeDefinition xSTypeDefinition) {
        this.clearNamepacesNodesToGenerate();
        this.clearPrefix2PrefixMapping();
        this.pushContext();
        volatileCData = this.enforceSmartPrefix(volatileCData);
        this.fFirstChildExpected = true;
        this.fCursor.addElement(area, volatileCData, xSTypeDefinition);
    }

    public final void addText(Cursor.Area area, VolatileCData volatileCData) {
        if (this.fFirstChildExpected) {
            this.checkForFirstChild(area);
        }
        this.dumpNamespaceNodes();
        this.fCursor.addText(area, volatileCData);
    }

    public final void addText(Cursor.Area area, Chars chars) {
        if (this.fFirstChildExpected) {
            this.checkForFirstChild(area);
        }
        this.dumpNamespaceNodes();
        this.fCursor.addText(area, chars);
    }

    public void addComment(Cursor.Area area, VolatileCData volatileCData) {
        if (this.fFirstChildExpected) {
            this.checkForFirstChild(area);
        }
        this.dumpNamespaceNodes();
        this.fCursor.addComment(area, volatileCData);
    }

    public void addComment(Cursor.Area area, Chars chars) {
        if (this.fFirstChildExpected) {
            this.checkForFirstChild(area);
        }
        this.dumpNamespaceNodes();
        this.fCursor.addComment(area, chars);
    }

    public final void addProcessingInstruction(Cursor.Area area, VolatileCData volatileCData, VolatileCData volatileCData2) {
        if (this.fFirstChildExpected) {
            this.checkForFirstChild(area);
        }
        this.dumpNamespaceNodes();
        this.fCursor.addProcessingInstruction(area, volatileCData, volatileCData2);
    }

    public final void addProcessingInstruction(Cursor.Area area, VolatileCData volatileCData, Chars chars) {
        if (this.fFirstChildExpected) {
            this.checkForFirstChild(area);
        }
        this.dumpNamespaceNodes();
        this.fCursor.addProcessingInstruction(area, volatileCData, chars);
    }

    public void addNamespaceNode(VolatileCData volatileCData, VolatileCData volatileCData2, boolean bl) {
        String string2;
        this.dumpNamespaceNodes();
        String string3 = string2 = volatileCData == null ? "" : volatileCData.toString();
        if (this.fPrefix2Prefix.get(string2) == null) {
            this.fCursor.addNamespaceNode(volatileCData, volatileCData2, bl);
        }
    }

    public void addAttribute(VolatileCData volatileCData, VolatileCData volatileCData2) {
        volatileCData = this.enforceSmartPrefix(volatileCData);
        volatileCData2 = this.enforceSmartPrefix(volatileCData2);
        this.dumpNamespaceNodes();
        this.fCursor.addAttribute(volatileCData, volatileCData2);
    }

    public void addAttribute(VolatileCData volatileCData, Chars chars) {
        volatileCData = this.enforceSmartPrefix(volatileCData);
        this.dumpNamespaceNodes();
        this.fCursor.addAttribute(volatileCData, chars);
    }

    public final void closeMutation() {
        this.clearPrefixes();
        this.fFirstChildExpected = false;
        this.fCursor.closeMutation();
    }

    public final boolean openMutation(Cursor.Area area) {
        this.clearPrefixes();
        return this.fCursor.openMutation(area);
    }

    public final Cursor fork(boolean bl, Cursor.Profile profile, Cursor.Profile profile2) {
        assert (this.incrementForkReleaseCounter());
        return this;
    }

    public final void release() {
        int n2 = this.getCursorExtensions().getSerializationState();
        switch (n2) {
            case 4: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                this.dumpNamespaceNodes();
                break;
            }
        }
        if (this.getCursorExtensions().getElemDepth() > 0) {
            this.popContext();
        }
        this.fCursor.release();
        assert (this.decrementForkReleaseCounter());
    }

    public final void addContent(Cursor.Area area, byte[] byArray, int n2, int n3) {
        if (this.fFirstChildExpected) {
            this.checkForFirstChild(area);
        }
        this.dumpNamespaceNodes();
        if (this.fCursor instanceof AddContentInterface) {
            this.fCursor.addContent(area, byArray, n2, n3);
        }
    }

    public AdditionalAPIs getCursorExtensions() {
        return this.fCursor.getCursorExtensions();
    }

    private void checkForFirstChild(Cursor.Area area) {
        if (area != Cursor.Area.FIRST_CHILD) {
            this.popContext();
        }
        this.fFirstChildExpected = false;
    }

    private boolean isPrefixInScope(String string2) {
        int n2 = this.fSmartPrefixes.size();
        for (int i = 0; i < n2; ++i) {
            if (string2 != this.fSmartPrefixes.get(i)) continue;
            return true;
        }
        return false;
    }

    private void pushContext() {
        if (this.fContextCount == this.fPrefixContext.length) {
            int n2 = this.fContextCount << 1;
            int[] nArray = new int[n2];
            System.arraycopy(this.fPrefixContext, 0, nArray, 0, this.fContextCount);
            this.fPrefixContext = nArray;
        }
        this.fPrefixContext[this.fContextCount++] = this.fSmartPrefixes.size();
    }

    public void popContext() {
        int n2;
        if ((n2 = this.fPrefixContext[--this.fContextCount]) != this.fSmartPrefixes.size()) {
            this.fSmartPrefixes.setSize(n2);
        }
    }
}

