/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.serializer.fixer;

import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.serializer.AdditionalAPIs;
import com.ibm.xml.xci.serializer.CursorExtended;
import com.ibm.xml.xci.serializer.GetCursorExtensionsInterface;
import com.ibm.xml.xci.serializer.fixer.FixerBase;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class FixerStateChecker
extends FixerBase
implements Cursor,
GetCursorExtensionsInterface {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00c3\u0192\u00e2\u20ac\u0161\u00c3\u201a\u00c2\u00a9 Copyright IBM Corp. 2008, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    final CursorExtended fCursor;
    int m_state;
    List<String> m_forkLocations = new ArrayList<String>();
    String m_openMutationLocation;
    String m_closeMutationLocation;
    String m_releaseLocation;
    private static final int STATE_BEGIN = 0;
    private static final int STATE_CLOSE_MUTATION = 1;
    private static final int STATE_OPEN_MUTATION = 2;

    public FixerStateChecker(CursorExtended cursorExtended) {
        super(cursorExtended);
        this.fCursor = cursorExtended;
        this.m_state = 0;
    }

    public void closeMutation() {
        this.fCursor.closeMutation();
        switch (this.m_state) {
            case 0: {
                System.err.println(FixerStateChecker.getStack("CLOSE MUTATION CALLED HERE"));
                System.err.flush();
                throw new IllegalStateException("Cursor.closeMutation() called, but openMutation() was not called.");
            }
            case 2: {
                this.m_state = 1;
                if (this.numForksPending() <= 0) break;
                System.err.println(this.m_openMutationLocation);
                System.err.flush();
                this.dumpForkLocations();
                System.err.println(FixerStateChecker.getStack("CLOSE MUTATION CALLED HERE"));
                System.err.flush();
                throw new IllegalStateException("Cursor.closeMutation() called, but some fork() calls did not have matching release() calls.");
            }
            case 1: {
                System.err.println(FixerStateChecker.getStack("CLOSE MUTATION CALLED HERE"));
                System.err.flush();
                throw new IllegalStateException("Cursor.closeMutation() called, but closeMutation() was previously called.");
            }
        }
        this.m_closeMutationLocation = FixerStateChecker.getStack("OLD CLOSE MUTATION CALLED HERE");
        this.m_state = 1;
    }

    public Cursor fork(boolean bl, Cursor.Profile profile, Cursor.Profile profile2) {
        switch (this.m_state) {
            case 0: {
                System.err.println(FixerStateChecker.getStack("FORK CALLED HERE"));
                System.err.flush();
                throw new IllegalStateException("Cursor.fork() called, but openMutation() was not called.");
            }
            case 2: {
                break;
            }
            case 1: {
                System.err.println(FixerStateChecker.getStack("FORK CALLED HERE"));
                System.err.flush();
                this.dumpForkLocations();
                throw new IllegalStateException("Cursor.fork() called, but closeMutation() was previously called.");
            }
        }
        this.recordFork();
        assert (this.incrementForkReleaseCounter());
        return this;
    }

    public Cursor fork(boolean bl) {
        switch (this.m_state) {
            case 0: {
                System.err.println(FixerStateChecker.getStack("FORK CALLED HERE"));
                System.err.flush();
                throw new IllegalStateException("Cursor.fork() called, but openMutation() was not called.");
            }
            case 2: {
                break;
            }
            case 1: {
                System.err.println(FixerStateChecker.getStack("FORK CALLED HERE"));
                System.err.flush();
                throw new IllegalStateException("Cursor.fork() called, but closeMutation() was previously called.");
            }
        }
        this.recordFork();
        return this;
    }

    public Cursor fork(Cursor.Profile profile, boolean bl) {
        switch (this.m_state) {
            case 0: {
                System.err.println(FixerStateChecker.getStack("FORK CALLED HERE"));
                System.err.flush();
                throw new IllegalStateException("Cursor.fork() called, but openMutation() was not called.");
            }
            case 2: {
                break;
            }
            case 1: {
                System.err.println(FixerStateChecker.getStack("FORK CALLED HERE"));
                System.err.flush();
                System.err.println(this.m_closeMutationLocation);
                System.err.flush();
                throw new IllegalStateException("Cursor.fork() called, but closeMutation() was previously called.");
            }
        }
        this.recordFork();
        return this;
    }

    private int numForksPending() {
        int n2 = this.m_forkLocations.size();
        return n2;
    }

    private void recordFork() {
        String string2 = FixerStateChecker.getStack("FORK CALLED HERE");
        this.m_forkLocations.add(string2);
    }

    private void recordRelease() {
        int n2 = this.m_forkLocations.size();
        if (n2 > 0) {
            String string2 = this.m_forkLocations.get(n2 - 1);
            this.m_forkLocations.remove(n2 - 1);
        }
    }

    private void dumpForkLocations() {
        System.err.println("FORK LOCATIONS STILL ON THE STACK (NEWEST TO OLDEST)");
        for (int i = this.m_forkLocations.size() - 1; 0 <= i; --i) {
            System.err.println(this.m_forkLocations.get(i));
        }
        System.err.flush();
    }

    public boolean openMutation(Cursor.Area area) {
        switch (this.m_state) {
            case 0: {
                break;
            }
            case 2: {
                System.err.println(FixerStateChecker.getStack("OPEN MUTATION CALLED HERE"));
                System.err.flush();
                System.err.println(this.m_openMutationLocation);
                System.err.flush();
                throw new IllegalStateException("Cursor.openMutation() called, but there was a previous openMutation() call.");
            }
            case 1: {
                System.err.println(FixerStateChecker.getStack("OPEN MUTATION CALLED HERE"));
                System.err.flush();
                System.err.println(this.m_closeMutationLocation);
                System.err.flush();
                throw new IllegalStateException("Cursor.openMutation() called, but closeMutation() was previously called.");
            }
        }
        this.m_state = 2;
        this.m_openMutationLocation = FixerStateChecker.getStack("OLD OPEN MUTATION CALLED HERE");
        return this.fCursor.openMutation(area);
    }

    public void release() {
        switch (this.m_state) {
            case 0: {
                System.err.println(FixerStateChecker.getStack("RELEASE CALLED HERE"));
                System.err.flush();
                System.err.println(this.m_closeMutationLocation);
                System.err.flush();
                throw new IllegalStateException("Cursor.release() called, but openMutation() was not called.");
            }
            case 2: {
                if (this.numForksPending() != 0) break;
                System.err.println(FixerStateChecker.getStack("RELEASE CALLED HERE"));
                System.err.flush();
                throw new IllegalStateException("Cursor.release() called, but there was no matching fork() call.");
            }
        }
        this.recordRelease();
        this.fCursor.release();
        assert (this.decrementForkReleaseCounter());
    }

    public AdditionalAPIs getCursorExtensions() {
        return this.fCursor.getCursorExtensions();
    }

    public static synchronized String getStack(String string2) {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("---- STACK TRACE -------------------------------------------\n");
        stringWriter.write(string2);
        stringWriter.write("\n");
        RuntimeException runtimeException = new RuntimeException();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        runtimeException.printStackTrace(printWriter);
        printWriter.flush();
        StringBuffer stringBuffer = stringWriter.getBuffer();
        String string3 = stringBuffer.toString();
        StringTokenizer stringTokenizer = new StringTokenizer(string3, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (0 <= string4.indexOf("java.lang.RuntimeException") || 0 <= string4.indexOf("DbgTrace.printStack")) continue;
            int n2 = string4.indexOf(13);
            if (0 <= n2) {
                string4 = string4.substring(0, n2);
            }
            stringWriter.write(string4);
        }
        return stringWriter.toString();
    }

    public boolean toIds(VolatileCData volatileCData, boolean bl) {
        if (bl) {
            String string2 = "Method unimplemented!!!";
            throw new RuntimeException(string2);
        }
        return false;
    }
}

