/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.type;

import com.ibm.xml.xapi.XSequenceType;
import com.ibm.xml.xci.type.SequenceType;
import com.ibm.xml.xml4j.api.s1.xs.XSAttributeDeclaration;
import com.ibm.xml.xml4j.api.s1.xs.XSElementDeclaration;
import com.ibm.xml.xml4j.api.s1.xs.XSSimpleTypeDefinition;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import javax.xml.namespace.QName;

public class SequenceTypeFactory {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";

    public static SequenceType emptySequence() {
        return new SequenceTypeImpl(XSequenceType.Kind.EMPTY, null, null, null, null, null, false, null);
    }

    public static SequenceType item(XSequenceType.OccurrenceIndicator occurrenceIndicator) {
        return new SequenceTypeImpl(XSequenceType.Kind.ITEM, null, null, null, null, null, false, occurrenceIndicator);
    }

    public static SequenceType atomic(XSSimpleTypeDefinition xSSimpleTypeDefinition, XSequenceType.OccurrenceIndicator occurrenceIndicator) {
        return new SequenceTypeImpl(XSequenceType.Kind.ATOMIC, null, null, null, xSSimpleTypeDefinition, null, false, occurrenceIndicator);
    }

    public static SequenceType documentNode(XSequenceType.OccurrenceIndicator occurrenceIndicator) {
        return new SequenceTypeImpl(XSequenceType.Kind.DOCUMENT, null, null, null, null, null, false, occurrenceIndicator);
    }

    public static SequenceType documentNodeWithElement(QName qName, XSTypeDefinition xSTypeDefinition, boolean bl, XSequenceType.OccurrenceIndicator occurrenceIndicator) {
        return new SequenceTypeImpl(XSequenceType.Kind.DOCUMENT_WITH_ELEMENT, qName, null, null, xSTypeDefinition, null, bl, occurrenceIndicator);
    }

    public static SequenceType documentNodeWithSchemaElement(XSElementDeclaration xSElementDeclaration, XSequenceType.OccurrenceIndicator occurrenceIndicator) {
        return new SequenceTypeImpl(XSequenceType.Kind.DOCUMENT_WITH_SCHEMA_ELEMENT, null, xSElementDeclaration, null, null, null, false, occurrenceIndicator);
    }

    public static SequenceType element(QName qName, XSTypeDefinition xSTypeDefinition, boolean bl, XSequenceType.OccurrenceIndicator occurrenceIndicator) {
        return new SequenceTypeImpl(XSequenceType.Kind.ELEMENT, qName, null, null, xSTypeDefinition, null, bl, occurrenceIndicator);
    }

    public static SequenceType attribute(QName qName, XSSimpleTypeDefinition xSSimpleTypeDefinition, XSequenceType.OccurrenceIndicator occurrenceIndicator) {
        return new SequenceTypeImpl(XSequenceType.Kind.ATTRIBUTE, qName, null, null, xSSimpleTypeDefinition, null, false, occurrenceIndicator);
    }

    public static SequenceType schemaElement(XSElementDeclaration xSElementDeclaration, XSequenceType.OccurrenceIndicator occurrenceIndicator) {
        return new SequenceTypeImpl(XSequenceType.Kind.SCHEMA_ELEMENT, null, xSElementDeclaration, null, null, null, false, occurrenceIndicator);
    }

    public static SequenceType schemaAttribute(XSAttributeDeclaration xSAttributeDeclaration, XSequenceType.OccurrenceIndicator occurrenceIndicator) {
        return new SequenceTypeImpl(XSequenceType.Kind.SCHEMA_ATTRIBUTE, null, null, xSAttributeDeclaration, null, null, false, occurrenceIndicator);
    }

    public static SequenceType processingInstruction(QName qName, XSequenceType.OccurrenceIndicator occurrenceIndicator) {
        return new SequenceTypeImpl(XSequenceType.Kind.PI, qName, null, null, null, null, false, occurrenceIndicator);
    }

    public static SequenceType comment(XSequenceType.OccurrenceIndicator occurrenceIndicator) {
        return new SequenceTypeImpl(XSequenceType.Kind.COMMENT, null, null, null, null, null, false, occurrenceIndicator);
    }

    public static SequenceType text(XSequenceType.OccurrenceIndicator occurrenceIndicator) {
        return new SequenceTypeImpl(XSequenceType.Kind.TEXT, null, null, null, null, null, false, occurrenceIndicator);
    }

    public static SequenceType node(XSequenceType.OccurrenceIndicator occurrenceIndicator) {
        return new SequenceTypeImpl(XSequenceType.Kind.NODE, null, null, null, null, null, false, occurrenceIndicator);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SequenceTypeImpl
    implements SequenceType {
        private XSequenceType.Kind kind;
        private QName name;
        private XSElementDeclaration elementDeclaration;
        private XSAttributeDeclaration attributeDeclaration;
        private XSTypeDefinition type;
        private Class<?> foreignClass;
        private boolean nillable;
        private XSequenceType.OccurrenceIndicator cardinality;

        SequenceTypeImpl(XSequenceType.Kind kind2, QName qName, XSElementDeclaration xSElementDeclaration, XSAttributeDeclaration xSAttributeDeclaration, XSTypeDefinition xSTypeDefinition, Class<?> clazz, boolean bl, XSequenceType.OccurrenceIndicator occurrenceIndicator) {
            this.kind = kind2;
            this.name = qName;
            this.elementDeclaration = xSElementDeclaration;
            this.attributeDeclaration = xSAttributeDeclaration;
            this.type = xSTypeDefinition;
            this.foreignClass = clazz;
            this.nillable = bl;
            this.cardinality = occurrenceIndicator;
        }

        @Override
        public XSequenceType.Kind getKind() {
            return this.kind;
        }

        @Override
        public QName getName() {
            switch (this.kind) {
                case SCHEMA_ELEMENT: 
                case DOCUMENT_WITH_SCHEMA_ELEMENT: {
                    return new QName(this.elementDeclaration.getNamespace(), this.elementDeclaration.getName());
                }
                case SCHEMA_ATTRIBUTE: {
                    return new QName(this.attributeDeclaration.getNamespace(), this.attributeDeclaration.getName());
                }
            }
            return this.name;
        }

        @Override
        public XSElementDeclaration getElementDeclaration() {
            return this.elementDeclaration;
        }

        @Override
        public XSAttributeDeclaration getAttributeDeclaration() {
            return this.attributeDeclaration;
        }

        @Override
        public XSTypeDefinition getType() {
            return this.type;
        }

        @Override
        public QName getTypeName() {
            return this.type == null ? null : new QName(this.type.getNamespace(), this.type.getName());
        }

        public Class<?> getForeignClass() {
            return this.foreignClass;
        }

        @Override
        public boolean getNillable() {
            return this.nillable;
        }

        @Override
        public XSequenceType.OccurrenceIndicator getOccurrenceIndicator() {
            return this.cardinality;
        }

        public String toString() {
            switch (this.kind) {
                case EMPTY: {
                    return "empty-sequence()";
                }
                case ATOMIC: {
                    return this.typeStr(this.type) + this.occurrenceStr(this.cardinality);
                }
                case DOCUMENT: {
                    return "document-node()" + this.occurrenceStr(this.cardinality);
                }
                case DOCUMENT_WITH_ELEMENT: {
                    return "document-node(" + this.elemStr() + ")" + this.occurrenceStr(this.cardinality);
                }
                case DOCUMENT_WITH_SCHEMA_ELEMENT: {
                    return "document-node(" + this.schemaElemStr() + ")" + this.occurrenceStr(this.cardinality);
                }
                case ELEMENT: {
                    return this.elemStr() + this.occurrenceStr(this.cardinality);
                }
                case SCHEMA_ELEMENT: {
                    return this.schemaElemStr() + this.occurrenceStr(this.cardinality);
                }
                case ATTRIBUTE: {
                    return this.attrStr() + this.occurrenceStr(this.cardinality);
                }
                case SCHEMA_ATTRIBUTE: {
                    return this.schemaAttrStr() + this.occurrenceStr(this.cardinality);
                }
                case COMMENT: {
                    return "comment()" + this.occurrenceStr(this.cardinality);
                }
                case PI: {
                    return this.piStr() + this.occurrenceStr(this.cardinality);
                }
                case TEXT: {
                    return "text()" + this.occurrenceStr(this.cardinality);
                }
                case NODE: {
                    return "node()" + this.occurrenceStr(this.cardinality);
                }
                case ITEM: {
                    return "item()" + this.occurrenceStr(this.cardinality);
                }
                case FOREIGN_OBJECT: {
                    return this.foreignClass.toString();
                }
            }
            return "";
        }

        private String nameStr(QName qName) {
            if (qName == null) {
                return "*";
            }
            return qName.toString();
        }

        private String nameStr(String string2, String string3) {
            if (string2 == null) {
                return "*";
            }
            StringBuilder stringBuilder = new StringBuilder();
            if (string3 != null) {
                stringBuilder.append("{");
                stringBuilder.append(string3);
                stringBuilder.append("}");
            }
            stringBuilder.append(string2);
            return stringBuilder.toString();
        }

        private String typeStr(XSTypeDefinition xSTypeDefinition) {
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = xSTypeDefinition.getNamespace();
            if (string2 != null && string2.length() > 0) {
                stringBuilder.append("{");
                stringBuilder.append(string2);
                stringBuilder.append("}");
            }
            stringBuilder.append(xSTypeDefinition.getName());
            return stringBuilder.toString();
        }

        private String occurrenceStr(XSequenceType.OccurrenceIndicator occurrenceIndicator) {
            switch (occurrenceIndicator) {
                case ONE: {
                    return "";
                }
                case ONE_OR_MORE: {
                    return "+";
                }
                case ZERO_OR_MORE: {
                    return "*";
                }
                case ZERO_OR_ONE: {
                    return "?";
                }
            }
            return "";
        }

        private String elemStr() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("element(");
            stringBuilder.append(this.nameStr(this.name));
            if (this.type != null) {
                stringBuilder.append(", ");
                stringBuilder.append(this.typeStr(this.type));
                if (this.nillable) {
                    stringBuilder.append("?");
                }
            }
            stringBuilder.append(")");
            return stringBuilder.toString();
        }

        private String schemaElemStr() {
            if (this.elementDeclaration == null) {
                return "";
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("schema-element(");
            stringBuilder.append(this.nameStr(this.elementDeclaration.getName(), this.elementDeclaration.getNamespace()));
            stringBuilder.append(", ");
            stringBuilder.append(this.typeStr(this.elementDeclaration.getTypeDefinition()));
            if (this.elementDeclaration.getNillable()) {
                stringBuilder.append("?");
            }
            stringBuilder.append(")");
            return stringBuilder.toString();
        }

        private String attrStr() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("attribute(");
            stringBuilder.append(this.nameStr(this.name));
            if (this.type != null) {
                stringBuilder.append(", ");
                stringBuilder.append(this.typeStr(this.type));
            }
            stringBuilder.append(")");
            return stringBuilder.toString();
        }

        private String schemaAttrStr() {
            if (this.attributeDeclaration == null) {
                return "";
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("schema-attribute(");
            stringBuilder.append(this.nameStr(this.attributeDeclaration.getName(), this.attributeDeclaration.getNamespace()));
            stringBuilder.append(", ");
            stringBuilder.append(this.typeStr(this.attributeDeclaration.getTypeDefinition()));
            stringBuilder.append(")");
            return stringBuilder.toString();
        }

        private String piStr() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("processing-instruction(");
            if (this.name != null) {
                stringBuilder.append(this.nameStr(this.name));
            }
            stringBuilder.append(")");
            return stringBuilder.toString();
        }
    }
}

