/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.util;

import com.ibm.xml.xci.Cursor;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMResult;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CursorNodeList
implements NodeList {
    private Cursor m_cursor;
    private Vector<Node> m_cachedNodes = new Vector();
    private int m_last = -1;

    private CursorNodeList() {
    }

    public CursorNodeList(Cursor cursor2) {
        if (cursor2 == null) {
            this.m_last = 0;
        }
        this.m_cursor = cursor2 == null ? null : cursor2.fork(false);
    }

    public Cursor getAxisCursor() {
        return this.m_cursor;
    }

    public Node item(int n2) {
        if (this.m_last == -1) {
            this.initCache();
        }
        if (n2 >= 0 && n2 < this.m_last) {
            Node node2 = this.m_cachedNodes.elementAt(n2);
            return node2;
        }
        return null;
    }

    public int getLength() {
        if (this.m_last == -1) {
            this.initCache();
        }
        return this.m_last;
    }

    private void initCache() {
        this.m_cursor.toPosition(1L);
        try {
            NodeList nodeList = (NodeList)this.m_cursor.exportAs("domNodeList2", true);
            this.m_cursor = null;
            if (nodeList != null) {
                int n2 = nodeList.getLength();
                for (int i = 0; i < n2; ++i) {
                    this.m_cachedNodes.addElement(nodeList.item(i));
                }
            }
        }
        catch (ClassCastException classCastException) {
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document2 = documentBuilder.newDocument();
                DocumentFragment documentFragment = document2.createDocumentFragment();
                DOMResult dOMResult = new DOMResult(documentFragment);
                short s = this.m_cursor.itemKind();
                this.m_cursor.copyToResult(dOMResult, null, false, true);
                this.m_cursor = null;
                Node node2 = dOMResult.getNode();
                short s2 = node2.getNodeType();
                if (s != 9 && (s2 == 11 || s2 == 9)) {
                    node2 = node2.getFirstChild();
                }
                do {
                    this.m_cachedNodes.addElement(node2);
                } while ((node2 = node2.getNextSibling()) != null);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                // empty catch block
            }
        }
        this.m_last = this.m_cachedNodes.size();
    }
}

