/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.util;

import com.ibm.xml.xci.errors.XCIIllegalArgumentException;
import com.ibm.xml.xci.res.XCIMessages;

public class IdentityToIntMap {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2009, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final int NULL = Integer.MIN_VALUE;
    private Object[] _keys;
    private int[] _next;
    private int _headerSize;
    private int _size;
    private int[] _values;

    public IdentityToIntMap(int n2) {
        this._headerSize = n2;
        int n3 = n2 * 3 / 2;
        this._keys = new Object[n3];
        this._next = new int[n3];
        this._values = new int[n3];
        this._size = this._headerSize;
    }

    public int get(Object object2) {
        if (object2 == null) {
            throw new XCIIllegalArgumentException(XCIMessages.createXCIMessage("ER_INVALID_KEY_VALUE", new String[]{"0"}));
        }
        int n2 = object2.hashCode();
        int n3 = Math.abs(n2 % this._headerSize);
        do {
            Object object3;
            if ((object3 = this._keys[n3]) == null) {
                return Integer.MIN_VALUE;
            }
            if (object3 != object2) continue;
            return this._values[n3];
        } while ((n3 = this._next[n3]) != 0);
        return Integer.MIN_VALUE;
    }

    public void put(Object object2, int n2) {
        if (object2 == null) {
            throw new XCIIllegalArgumentException(XCIMessages.createXCIMessage("ER_INVALID_KEY_VALUE", new String[]{"0"}));
        }
        int n3 = object2.hashCode();
        int n4 = Math.abs(n3 % this._headerSize);
        if (this._keys[n4] == null || this._keys[n4] == object2) {
            this._keys[n4] = object2;
            this._values[n4] = n2;
        } else {
            Object[] objectArray;
            int n5 = this._next[n4];
            while (n5 != 0) {
                objectArray = this._keys[n5];
                if (objectArray == object2) {
                    this._values[n5] = n2;
                    return;
                }
                n5 = this._next[n5];
            }
            if (this._size >= this._keys.length) {
                objectArray = new Object[this._keys.length * 2];
                System.arraycopy(this._keys, 0, objectArray, 0, this._keys.length);
                this._keys = objectArray;
                int[] nArray = new int[this._values.length * 2];
                System.arraycopy(this._values, 0, nArray, 0, this._values.length);
                this._values = nArray;
                int[] nArray2 = new int[this._next.length * 2];
                System.arraycopy(this._next, 0, nArray2, 0, this._next.length);
                this._next = nArray2;
            }
            this._keys[this._size] = object2;
            this._values[this._size] = n2;
            this._next[this._size] = this._next[n4];
            this._next[n4] = this._size++;
        }
    }

    public void clear() {
        int n2 = this._size = this._headerSize;
        while (--n2 >= 0) {
            this._keys[n2] = null;
            this._next[n2] = 0;
        }
    }

    public static void main(String[] stringArray) {
        int n2;
        IdentityToIntMap identityToIntMap = new IdentityToIntMap(17);
        Object[] objectArray = new Object[256];
        for (n2 = 0; n2 < 256; ++n2) {
            objectArray[n2] = new Integer(n2);
            identityToIntMap.put(objectArray[n2], n2 * 2);
        }
        for (n2 = 0; n2 < 256; ++n2) {
            identityToIntMap.put(objectArray[n2], n2 * 10 + 1);
        }
        for (n2 = 0; n2 < 256; ++n2) {
            if (identityToIntMap.get(objectArray[n2]) == n2 * 10 + 1) continue;
            System.out.println("wrong value back for1");
        }
        System.out.println("Done");
    }
}

